// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigEntityRef()
				CopyOrigEntityRef(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigEntityRef(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigEntityRefUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigEntityRef()
	UnmarshalJSONOrigEntityRef(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigEntityRef(), dest)
}

func TestMarshalAndUnmarshalJSONOrigEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigEntityRef(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigEntityRef()
				UnmarshalJSONOrigEntityRef(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigEntityRef(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigEntityRefFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigEntityRef()
			require.Error(t, UnmarshalProtoOrigEntityRef(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigEntityRefUnknown(t *testing.T) {
	dest := NewOrigEntityRef()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigEntityRef(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigEntityRef(), dest)
}

func TestMarshalAndUnmarshalProtoOrigEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigEntityRef(src))
				gotSize := MarshalProtoOrigEntityRef(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigEntityRef()
				require.NoError(t, UnmarshalProtoOrigEntityRef(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigEntityRef(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigEntityRef(src))
			gotSize := MarshalProtoOrigEntityRef(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.EntityRef{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigEntityRef()
			require.NoError(t, UnmarshalProtoOrigEntityRef(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesEntityRef() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"SchemaUrl/wrong_wire_type":       {0xc},
		"SchemaUrl/missing_value":         {0xa},
		"Type/wrong_wire_type":            {0x14},
		"Type/missing_value":              {0x12},
		"IdKeys/wrong_wire_type":          {0x1c},
		"IdKeys/missing_value":            {0x1a},
		"DescriptionKeys/wrong_wire_type": {0x24},
		"DescriptionKeys/missing_value":   {0x22},
	}
}

func genTestEncodingValuesEntityRef() map[string]*otlpcommon.EntityRef {
	return map[string]*otlpcommon.EntityRef{
		"empty":                            NewOrigEntityRef(),
		"SchemaUrl/test":                   {SchemaUrl: "test_schemaurl"},
		"Type/test":                        {Type: "test_type"},
		"IdKeys/default_and_test":          {IdKeys: []string{"", "test_idkeys"}},
		"DescriptionKeys/default_and_test": {DescriptionKeys: []string{"", "test_descriptionkeys"}},
	}
}
