// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigArrayValue()
				CopyOrigArrayValue(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigArrayValue(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigArrayValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigArrayValue()
	UnmarshalJSONOrigArrayValue(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigArrayValue(), dest)
}

func TestMarshalAndUnmarshalJSONOrigArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigArrayValue(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigArrayValue()
				UnmarshalJSONOrigArrayValue(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigArrayValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigArrayValueFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesArrayValue() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigArrayValue()
			require.Error(t, UnmarshalProtoOrigArrayValue(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigArrayValueUnknown(t *testing.T) {
	dest := NewOrigArrayValue()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigArrayValue(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigArrayValue(), dest)
}

func TestMarshalAndUnmarshalProtoOrigArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigArrayValue(src))
				gotSize := MarshalProtoOrigArrayValue(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigArrayValue()
				require.NoError(t, UnmarshalProtoOrigArrayValue(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigArrayValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigArrayValue(src))
			gotSize := MarshalProtoOrigArrayValue(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.ArrayValue{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigArrayValue()
			require.NoError(t, UnmarshalProtoOrigArrayValue(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesArrayValue() map[string][]byte {
	return map[string][]byte{
		"invalid_field":          {0x02},
		"Values/wrong_wire_type": {0xc},
		"Values/missing_value":   {0xa},
	}
}

func genTestEncodingValuesArrayValue() map[string]*otlpcommon.ArrayValue {
	return map[string]*otlpcommon.ArrayValue{
		"empty":                   NewOrigArrayValue(),
		"Values/default_and_test": {Values: []otlpcommon.AnyValue{{}, *GenTestOrigAnyValue()}},
	}
}
