// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1/cloud_sql_instances.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SqlInstanceType int32

const (
	// This is an unknown Cloud SQL instance type.
	SqlInstanceType_SQL_INSTANCE_TYPE_UNSPECIFIED SqlInstanceType = 0
	// A regular Cloud SQL instance.
	SqlInstanceType_CLOUD_SQL_INSTANCE SqlInstanceType = 1
	// An instance running on the customer's premises that is not managed by
	// Cloud SQL.
	SqlInstanceType_ON_PREMISES_INSTANCE SqlInstanceType = 2
	// A Cloud SQL instance acting as a read-replica.
	SqlInstanceType_READ_REPLICA_INSTANCE SqlInstanceType = 3
)

// Enum value maps for SqlInstanceType.
var (
	SqlInstanceType_name = map[int32]string{
		0: "SQL_INSTANCE_TYPE_UNSPECIFIED",
		1: "CLOUD_SQL_INSTANCE",
		2: "ON_PREMISES_INSTANCE",
		3: "READ_REPLICA_INSTANCE",
	}
	SqlInstanceType_value = map[string]int32{
		"SQL_INSTANCE_TYPE_UNSPECIFIED": 0,
		"CLOUD_SQL_INSTANCE":            1,
		"ON_PREMISES_INSTANCE":          2,
		"READ_REPLICA_INSTANCE":         3,
	}
)

func (x SqlInstanceType) Enum() *SqlInstanceType {
	p := new(SqlInstanceType)
	*p = x
	return p
}

func (x SqlInstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[0].Descriptor()
}

func (SqlInstanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[0]
}

func (x SqlInstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstanceType.Descriptor instead.
func (SqlInstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{0}
}

// The suspension reason of the database instance if the state is SUSPENDED.
type SqlSuspensionReason int32

const (
	// This is an unknown suspension reason.
	SqlSuspensionReason_SQL_SUSPENSION_REASON_UNSPECIFIED SqlSuspensionReason = 0
	// The instance is suspended due to billing issues (for example:, GCP account
	// issue)
	SqlSuspensionReason_BILLING_ISSUE SqlSuspensionReason = 2
	// The instance is suspended due to illegal content (for example:, child
	// pornography, copyrighted material, etc.).
	SqlSuspensionReason_LEGAL_ISSUE SqlSuspensionReason = 3
	// The instance is causing operational issues (for example:, causing the
	// database to crash).
	SqlSuspensionReason_OPERATIONAL_ISSUE SqlSuspensionReason = 4
	// The KMS key used by the instance is either revoked or denied access to
	SqlSuspensionReason_KMS_KEY_ISSUE SqlSuspensionReason = 5
)

// Enum value maps for SqlSuspensionReason.
var (
	SqlSuspensionReason_name = map[int32]string{
		0: "SQL_SUSPENSION_REASON_UNSPECIFIED",
		2: "BILLING_ISSUE",
		3: "LEGAL_ISSUE",
		4: "OPERATIONAL_ISSUE",
		5: "KMS_KEY_ISSUE",
	}
	SqlSuspensionReason_value = map[string]int32{
		"SQL_SUSPENSION_REASON_UNSPECIFIED": 0,
		"BILLING_ISSUE":                     2,
		"LEGAL_ISSUE":                       3,
		"OPERATIONAL_ISSUE":                 4,
		"KMS_KEY_ISSUE":                     5,
	}
)

func (x SqlSuspensionReason) Enum() *SqlSuspensionReason {
	p := new(SqlSuspensionReason)
	*p = x
	return p
}

func (x SqlSuspensionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSuspensionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[1].Descriptor()
}

func (SqlSuspensionReason) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[1]
}

func (x SqlSuspensionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSuspensionReason.Descriptor instead.
func (SqlSuspensionReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{1}
}

type SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode int32

const (
	// Unknown external sync mode, will be defaulted to ONLINE mode
	SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 0
	// Online external sync will set up replication after initial data external
	// sync
	SqlInstancesVerifyExternalSyncSettingsRequest_ONLINE SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 1
	// Offline external sync only dumps and loads a one-time snapshot of
	// the primary instance's data
	SqlInstancesVerifyExternalSyncSettingsRequest_OFFLINE SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 2
)

// Enum value maps for SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode.
var (
	SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode_name = map[int32]string{
		0: "EXTERNAL_SYNC_MODE_UNSPECIFIED",
		1: "ONLINE",
		2: "OFFLINE",
	}
	SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode_value = map[string]int32{
		"EXTERNAL_SYNC_MODE_UNSPECIFIED": 0,
		"ONLINE":                         1,
		"OFFLINE":                        2,
	}
)

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Enum() *SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	p := new(SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode)
	*p = x
	return p
}

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[2].Descriptor()
}

func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[2]
}

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode.Descriptor instead.
func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{22, 0}
}

// The current serving state of the database instance.
type DatabaseInstance_SqlInstanceState int32

const (
	// The state of the instance is unknown.
	DatabaseInstance_SQL_INSTANCE_STATE_UNSPECIFIED DatabaseInstance_SqlInstanceState = 0
	// The instance is running, or has been stopped by owner.
	DatabaseInstance_RUNNABLE DatabaseInstance_SqlInstanceState = 1
	// The instance is not available, for example due to problems with billing.
	DatabaseInstance_SUSPENDED DatabaseInstance_SqlInstanceState = 2
	// The instance is being deleted.
	DatabaseInstance_PENDING_DELETE DatabaseInstance_SqlInstanceState = 3
	// The instance is being created.
	DatabaseInstance_PENDING_CREATE DatabaseInstance_SqlInstanceState = 4
	// The instance is down for maintenance.
	DatabaseInstance_MAINTENANCE DatabaseInstance_SqlInstanceState = 5
	// The creation of the instance failed or a fatal error occurred during
	// maintenance.
	DatabaseInstance_FAILED DatabaseInstance_SqlInstanceState = 6
	// The instance is under maintenance operations and the database is
	// available.
	DatabaseInstance_ONLINE_MAINTENANCE DatabaseInstance_SqlInstanceState = 7
)

// Enum value maps for DatabaseInstance_SqlInstanceState.
var (
	DatabaseInstance_SqlInstanceState_name = map[int32]string{
		0: "SQL_INSTANCE_STATE_UNSPECIFIED",
		1: "RUNNABLE",
		2: "SUSPENDED",
		3: "PENDING_DELETE",
		4: "PENDING_CREATE",
		5: "MAINTENANCE",
		6: "FAILED",
		7: "ONLINE_MAINTENANCE",
	}
	DatabaseInstance_SqlInstanceState_value = map[string]int32{
		"SQL_INSTANCE_STATE_UNSPECIFIED": 0,
		"RUNNABLE":                       1,
		"SUSPENDED":                      2,
		"PENDING_DELETE":                 3,
		"PENDING_CREATE":                 4,
		"MAINTENANCE":                    5,
		"FAILED":                         6,
		"ONLINE_MAINTENANCE":             7,
	}
)

func (x DatabaseInstance_SqlInstanceState) Enum() *DatabaseInstance_SqlInstanceState {
	p := new(DatabaseInstance_SqlInstanceState)
	*p = x
	return p
}

func (x DatabaseInstance_SqlInstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseInstance_SqlInstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[3].Descriptor()
}

func (DatabaseInstance_SqlInstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[3]
}

func (x DatabaseInstance_SqlInstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseInstance_SqlInstanceState.Descriptor instead.
func (DatabaseInstance_SqlInstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39, 0}
}

// This enum lists all possible states regarding out-of-disk issues.
type DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState int32

const (
	// Unspecified state
	DatabaseInstance_SqlOutOfDiskReport_SQL_OUT_OF_DISK_STATE_UNSPECIFIED DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 0
	// The instance has plenty space on data disk
	DatabaseInstance_SqlOutOfDiskReport_NORMAL DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 1
	// Data disk is almost used up. It is shutdown to prevent data
	// corruption.
	DatabaseInstance_SqlOutOfDiskReport_SOFT_SHUTDOWN DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 2
)

// Enum value maps for DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState.
var (
	DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState_name = map[int32]string{
		0: "SQL_OUT_OF_DISK_STATE_UNSPECIFIED",
		1: "NORMAL",
		2: "SOFT_SHUTDOWN",
	}
	DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState_value = map[string]int32{
		"SQL_OUT_OF_DISK_STATE_UNSPECIFIED": 0,
		"NORMAL":                            1,
		"SOFT_SHUTDOWN":                     2,
	}
)

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Enum() *DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState {
	p := new(DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState)
	*p = x
	return p
}

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[4].Descriptor()
}

func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[4]
}

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState.Descriptor instead.
func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39, 2, 0}
}

type SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType int32

const (
	SqlInstancesRescheduleMaintenanceRequestBody_RESCHEDULE_TYPE_UNSPECIFIED SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 0
	// Reschedules maintenance to happen now (within 5 minutes).
	SqlInstancesRescheduleMaintenanceRequestBody_IMMEDIATE SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 1
	// Reschedules maintenance to occur within one week from the originally
	// scheduled day and time.
	SqlInstancesRescheduleMaintenanceRequestBody_NEXT_AVAILABLE_WINDOW SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 2
	// Reschedules maintenance to a specific time and day.
	SqlInstancesRescheduleMaintenanceRequestBody_SPECIFIC_TIME SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 3
)

// Enum value maps for SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType.
var (
	SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType_name = map[int32]string{
		0: "RESCHEDULE_TYPE_UNSPECIFIED",
		1: "IMMEDIATE",
		2: "NEXT_AVAILABLE_WINDOW",
		3: "SPECIFIC_TIME",
	}
	SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType_value = map[string]int32{
		"RESCHEDULE_TYPE_UNSPECIFIED": 0,
		"IMMEDIATE":                   1,
		"NEXT_AVAILABLE_WINDOW":       2,
		"SPECIFIC_TIME":               3,
	}
)

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Enum() *SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType {
	p := new(SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType)
	*p = x
	return p
}

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[5].Descriptor()
}

func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[5]
}

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType.Descriptor instead.
func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{40, 0}
}

type SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType int32

const (
	SqlExternalSyncSettingError_SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 0
	SqlExternalSyncSettingError_CONNECTION_FAILURE                               SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 1
	SqlExternalSyncSettingError_BINLOG_NOT_ENABLED                               SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 2
	SqlExternalSyncSettingError_INCOMPATIBLE_DATABASE_VERSION                    SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 3
	SqlExternalSyncSettingError_REPLICA_ALREADY_SETUP                            SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 4
	SqlExternalSyncSettingError_INSUFFICIENT_PRIVILEGE                           SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 5
	// Unsupported migration type.
	SqlExternalSyncSettingError_UNSUPPORTED_MIGRATION_TYPE SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 6
	// No pglogical extension installed on databases, applicable for postgres.
	SqlExternalSyncSettingError_NO_PGLOGICAL_INSTALLED SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 7
	// pglogical node already exists on databases, applicable for postgres.
	SqlExternalSyncSettingError_PGLOGICAL_NODE_ALREADY_EXISTS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 8
	// The value of parameter wal_level is not set to logical.
	SqlExternalSyncSettingError_INVALID_WAL_LEVEL SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 9
	// The value of parameter shared_preload_libraries does not include
	// pglogical.
	SqlExternalSyncSettingError_INVALID_SHARED_PRELOAD_LIBRARY SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 10
	// The value of parameter max_replication_slots is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_REPLICATION_SLOTS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 11
	// The value of parameter max_wal_senders is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_WAL_SENDERS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 12
	// The value of parameter max_worker_processes is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_WORKER_PROCESSES SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 13
	// Extensions installed are either not supported or having unsupported
	// versions
	SqlExternalSyncSettingError_UNSUPPORTED_EXTENSIONS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 14
	// The value of parameter rds.logical_replication is not set to 1.
	SqlExternalSyncSettingError_INVALID_RDS_LOGICAL_REPLICATION SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 15
	// The primary instance logging setup doesn't allow EM sync.
	SqlExternalSyncSettingError_INVALID_LOGGING_SETUP SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 16
	// The primary instance database parameter setup doesn't allow EM sync.
	SqlExternalSyncSettingError_INVALID_DB_PARAM SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 17
	// The gtid_mode is not supported, applicable for MySQL.
	SqlExternalSyncSettingError_UNSUPPORTED_GTID_MODE SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 18
	// SQL Server Agent is not running.
	SqlExternalSyncSettingError_SQLSERVER_AGENT_NOT_RUNNING SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 19
	// The table definition is not support due to missing primary key or replica
	// identity, applicable for postgres.
	SqlExternalSyncSettingError_UNSUPPORTED_TABLE_DEFINITION SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 20
	// The customer has a definer that will break EM setup.
	SqlExternalSyncSettingError_UNSUPPORTED_DEFINER SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 21
	// SQL Server @@SERVERNAME does not match actual host name
	SqlExternalSyncSettingError_SQLSERVER_SERVERNAME_MISMATCH SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 22
	// The primary instance has been setup and will fail the setup.
	SqlExternalSyncSettingError_PRIMARY_ALREADY_SETUP SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 23
	// The primary instance has unsupported binary log format.
	SqlExternalSyncSettingError_UNSUPPORTED_BINLOG_FORMAT SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 24
	// The primary instance's binary log retention setting.
	SqlExternalSyncSettingError_BINLOG_RETENTION_SETTING SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 25
)

// Enum value maps for SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType.
var (
	SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType_name = map[int32]string{
		0:  "SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED",
		1:  "CONNECTION_FAILURE",
		2:  "BINLOG_NOT_ENABLED",
		3:  "INCOMPATIBLE_DATABASE_VERSION",
		4:  "REPLICA_ALREADY_SETUP",
		5:  "INSUFFICIENT_PRIVILEGE",
		6:  "UNSUPPORTED_MIGRATION_TYPE",
		7:  "NO_PGLOGICAL_INSTALLED",
		8:  "PGLOGICAL_NODE_ALREADY_EXISTS",
		9:  "INVALID_WAL_LEVEL",
		10: "INVALID_SHARED_PRELOAD_LIBRARY",
		11: "INSUFFICIENT_MAX_REPLICATION_SLOTS",
		12: "INSUFFICIENT_MAX_WAL_SENDERS",
		13: "INSUFFICIENT_MAX_WORKER_PROCESSES",
		14: "UNSUPPORTED_EXTENSIONS",
		15: "INVALID_RDS_LOGICAL_REPLICATION",
		16: "INVALID_LOGGING_SETUP",
		17: "INVALID_DB_PARAM",
		18: "UNSUPPORTED_GTID_MODE",
		19: "SQLSERVER_AGENT_NOT_RUNNING",
		20: "UNSUPPORTED_TABLE_DEFINITION",
		21: "UNSUPPORTED_DEFINER",
		22: "SQLSERVER_SERVERNAME_MISMATCH",
		23: "PRIMARY_ALREADY_SETUP",
		24: "UNSUPPORTED_BINLOG_FORMAT",
		25: "BINLOG_RETENTION_SETTING",
	}
	SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType_value = map[string]int32{
		"SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED": 0,
		"CONNECTION_FAILURE":                 1,
		"BINLOG_NOT_ENABLED":                 2,
		"INCOMPATIBLE_DATABASE_VERSION":      3,
		"REPLICA_ALREADY_SETUP":              4,
		"INSUFFICIENT_PRIVILEGE":             5,
		"UNSUPPORTED_MIGRATION_TYPE":         6,
		"NO_PGLOGICAL_INSTALLED":             7,
		"PGLOGICAL_NODE_ALREADY_EXISTS":      8,
		"INVALID_WAL_LEVEL":                  9,
		"INVALID_SHARED_PRELOAD_LIBRARY":     10,
		"INSUFFICIENT_MAX_REPLICATION_SLOTS": 11,
		"INSUFFICIENT_MAX_WAL_SENDERS":       12,
		"INSUFFICIENT_MAX_WORKER_PROCESSES":  13,
		"UNSUPPORTED_EXTENSIONS":             14,
		"INVALID_RDS_LOGICAL_REPLICATION":    15,
		"INVALID_LOGGING_SETUP":              16,
		"INVALID_DB_PARAM":                   17,
		"UNSUPPORTED_GTID_MODE":              18,
		"SQLSERVER_AGENT_NOT_RUNNING":        19,
		"UNSUPPORTED_TABLE_DEFINITION":       20,
		"UNSUPPORTED_DEFINER":                21,
		"SQLSERVER_SERVERNAME_MISMATCH":      22,
		"PRIMARY_ALREADY_SETUP":              23,
		"UNSUPPORTED_BINLOG_FORMAT":          24,
		"BINLOG_RETENTION_SETTING":           25,
	}
)

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Enum() *SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType {
	p := new(SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType)
	*p = x
	return p
}

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[6].Descriptor()
}

func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes[6]
}

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType.Descriptor instead.
func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{46, 0}
}

// Instance add server CA request.
type SqlInstancesAddServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesAddServerCaRequest) Reset() {
	*x = SqlInstancesAddServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesAddServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesAddServerCaRequest) ProtoMessage() {}

func (x *SqlInstancesAddServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesAddServerCaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesAddServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{0}
}

func (x *SqlInstancesAddServerCaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesAddServerCaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance clone request.
type SqlInstancesCloneRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Cloud SQL instance to be cloned (source). This does not
	// include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the source as well as the clone Cloud SQL instance.
	Project string                 `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesCloneRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesCloneRequest) Reset() {
	*x = SqlInstancesCloneRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesCloneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesCloneRequest) ProtoMessage() {}

func (x *SqlInstancesCloneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesCloneRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesCloneRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{1}
}

func (x *SqlInstancesCloneRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesCloneRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesCloneRequest) GetBody() *InstancesCloneRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance delete request.
type SqlInstancesDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be deleted.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesDeleteRequest) Reset() {
	*x = SqlInstancesDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesDeleteRequest) ProtoMessage() {}

func (x *SqlInstancesDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{2}
}

func (x *SqlInstancesDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance demote master request.
type SqlInstancesDemoteMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string                        `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesDemoteMasterRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesDemoteMasterRequest) Reset() {
	*x = SqlInstancesDemoteMasterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesDemoteMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesDemoteMasterRequest) ProtoMessage() {}

func (x *SqlInstancesDemoteMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesDemoteMasterRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesDemoteMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{3}
}

func (x *SqlInstancesDemoteMasterRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesDemoteMasterRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesDemoteMasterRequest) GetBody() *InstancesDemoteMasterRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance export request.
type SqlInstancesExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be exported.
	Project string                  `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesExportRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesExportRequest) Reset() {
	*x = SqlInstancesExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesExportRequest) ProtoMessage() {}

func (x *SqlInstancesExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesExportRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{4}
}

func (x *SqlInstancesExportRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesExportRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesExportRequest) GetBody() *InstancesExportRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance failover request.
type SqlInstancesFailoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string                    `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesFailoverRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesFailoverRequest) Reset() {
	*x = SqlInstancesFailoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesFailoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesFailoverRequest) ProtoMessage() {}

func (x *SqlInstancesFailoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesFailoverRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesFailoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{5}
}

func (x *SqlInstancesFailoverRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesFailoverRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesFailoverRequest) GetBody() *InstancesFailoverRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance get request.
type SqlInstancesGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesGetRequest) Reset() {
	*x = SqlInstancesGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesGetRequest) ProtoMessage() {}

func (x *SqlInstancesGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesGetRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{6}
}

func (x *SqlInstancesGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance import request.
type SqlInstancesImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                  `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesImportRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesImportRequest) Reset() {
	*x = SqlInstancesImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesImportRequest) ProtoMessage() {}

func (x *SqlInstancesImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesImportRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{7}
}

func (x *SqlInstancesImportRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesImportRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesImportRequest) GetBody() *InstancesImportRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance insert request.
type SqlInstancesInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID of the project to which the newly created Cloud SQL instances
	// should belong.
	Project string            `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesInsertRequest) Reset() {
	*x = SqlInstancesInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesInsertRequest) ProtoMessage() {}

func (x *SqlInstancesInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{8}
}

func (x *SqlInstancesInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesInsertRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance list request.
type SqlInstancesListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response.
	// The expression is in the form of field:value. For example,
	// 'instanceType:CLOUD_SQL_INSTANCE'. Fields can be nested as needed as per
	// their JSON representation, such as 'settings.userLabels.auto_start:true'.
	//
	// Multiple filter queries are space-separated. For example.
	// 'state:RUNNABLE instanceType:CLOUD_SQL_INSTANCE'. By default, each
	// expression is an AND expression. However, you can include AND and OR
	// expressions explicitly.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of results to return per response.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Project ID of the project for which to list Cloud SQL instances.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesListRequest) Reset() {
	*x = SqlInstancesListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesListRequest) ProtoMessage() {}

func (x *SqlInstancesListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesListRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{9}
}

func (x *SqlInstancesListRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SqlInstancesListRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *SqlInstancesListRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SqlInstancesListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance list server CAs request.
type SqlInstancesListServerCasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesListServerCasRequest) Reset() {
	*x = SqlInstancesListServerCasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesListServerCasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesListServerCasRequest) ProtoMessage() {}

func (x *SqlInstancesListServerCasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesListServerCasRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesListServerCasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{10}
}

func (x *SqlInstancesListServerCasRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesListServerCasRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance patch request.
type SqlInstancesPatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string            `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesPatchRequest) Reset() {
	*x = SqlInstancesPatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesPatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesPatchRequest) ProtoMessage() {}

func (x *SqlInstancesPatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesPatchRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesPatchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{11}
}

func (x *SqlInstancesPatchRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesPatchRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesPatchRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance promote replica request.
type SqlInstancesPromoteReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesPromoteReplicaRequest) Reset() {
	*x = SqlInstancesPromoteReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesPromoteReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesPromoteReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesPromoteReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesPromoteReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesPromoteReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{12}
}

func (x *SqlInstancesPromoteReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesPromoteReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance reset SSL config request.
type SqlInstancesResetSslConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesResetSslConfigRequest) Reset() {
	*x = SqlInstancesResetSslConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesResetSslConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesResetSslConfigRequest) ProtoMessage() {}

func (x *SqlInstancesResetSslConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesResetSslConfigRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesResetSslConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{13}
}

func (x *SqlInstancesResetSslConfigRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesResetSslConfigRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance restart request.
type SqlInstancesRestartRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be restarted.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesRestartRequest) Reset() {
	*x = SqlInstancesRestartRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRestartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRestartRequest) ProtoMessage() {}

func (x *SqlInstancesRestartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRestartRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRestartRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{14}
}

func (x *SqlInstancesRestartRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRestartRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance restore backup request.
type SqlInstancesRestoreBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                         `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesRestoreBackupRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRestoreBackupRequest) Reset() {
	*x = SqlInstancesRestoreBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRestoreBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRestoreBackupRequest) ProtoMessage() {}

func (x *SqlInstancesRestoreBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRestoreBackupRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRestoreBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{15}
}

func (x *SqlInstancesRestoreBackupRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRestoreBackupRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRestoreBackupRequest) GetBody() *InstancesRestoreBackupRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance rotate server CA request.
type SqlInstancesRotateServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                          `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesRotateServerCaRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRotateServerCaRequest) Reset() {
	*x = SqlInstancesRotateServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRotateServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRotateServerCaRequest) ProtoMessage() {}

func (x *SqlInstancesRotateServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRotateServerCaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRotateServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{16}
}

func (x *SqlInstancesRotateServerCaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRotateServerCaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRotateServerCaRequest) GetBody() *InstancesRotateServerCaRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance start replica request.
type SqlInstancesStartReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesStartReplicaRequest) Reset() {
	*x = SqlInstancesStartReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStartReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStartReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesStartReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStartReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStartReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{17}
}

func (x *SqlInstancesStartReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStartReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance stop replica request.
type SqlInstancesStopReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesStopReplicaRequest) Reset() {
	*x = SqlInstancesStopReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStopReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStopReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesStopReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStopReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStopReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{18}
}

func (x *SqlInstancesStopReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStopReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance truncate log request.
type SqlInstancesTruncateLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the Cloud SQL project.
	Project string                       `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesTruncateLogRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesTruncateLogRequest) Reset() {
	*x = SqlInstancesTruncateLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesTruncateLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesTruncateLogRequest) ProtoMessage() {}

func (x *SqlInstancesTruncateLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesTruncateLogRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesTruncateLogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{19}
}

func (x *SqlInstancesTruncateLogRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesTruncateLogRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesTruncateLogRequest) GetBody() *InstancesTruncateLogRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance update request.
type SqlInstancesUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string            `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesUpdateRequest) Reset() {
	*x = SqlInstancesUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesUpdateRequest) ProtoMessage() {}

func (x *SqlInstancesUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesUpdateRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{20}
}

func (x *SqlInstancesUpdateRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesUpdateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesUpdateRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance reschedule maintenance request.
type SqlInstancesRescheduleMaintenanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string                                        `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SqlInstancesRescheduleMaintenanceRequestBody `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequest) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequest) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{21}
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetBody() *SqlInstancesRescheduleMaintenanceRequestBody {
	if x != nil {
		return x.Body
	}
	return nil
}

// Instance verify external sync settings request.
type SqlInstancesVerifyExternalSyncSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Flag to enable verifying connection only
	VerifyConnectionOnly bool `protobuf:"varint,3,opt,name=verify_connection_only,json=verifyConnectionOnly,proto3" json:"verify_connection_only,omitempty"`
	// External sync mode
	SyncMode SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode `protobuf:"varint,4,opt,name=sync_mode,json=syncMode,proto3,enum=google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode" json:"sync_mode,omitempty"`
	// Optional. Flag to verify settings required by replication setup only
	VerifyReplicationOnly bool `protobuf:"varint,5,opt,name=verify_replication_only,json=verifyReplicationOnly,proto3" json:"verify_replication_only,omitempty"`
	// Types that are assignable to SyncConfig:
	//	*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig
	SyncConfig isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig `protobuf_oneof:"sync_config"`
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) Reset() {
	*x = SqlInstancesVerifyExternalSyncSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesVerifyExternalSyncSettingsRequest) ProtoMessage() {}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesVerifyExternalSyncSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{22}
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetVerifyConnectionOnly() bool {
	if x != nil {
		return x.VerifyConnectionOnly
	}
	return false
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetSyncMode() SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	if x != nil {
		return x.SyncMode
	}
	return SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetVerifyReplicationOnly() bool {
	if x != nil {
		return x.VerifyReplicationOnly
	}
	return false
}

func (m *SqlInstancesVerifyExternalSyncSettingsRequest) GetSyncConfig() isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig {
	if m != nil {
		return m.SyncConfig
	}
	return nil
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetMysqlSyncConfig() *MySqlSyncConfig {
	if x, ok := x.GetSyncConfig().(*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig); ok {
		return x.MysqlSyncConfig
	}
	return nil
}

type isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig interface {
	isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig()
}

type SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig struct {
	// Optional. MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `protobuf:"bytes,6,opt,name=mysql_sync_config,json=mysqlSyncConfig,proto3,oneof"`
}

func (*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig) isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig() {
}

// Instance start external sync request.
type SqlInstancesStartExternalSyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// External sync mode.
	SyncMode SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode `protobuf:"varint,3,opt,name=sync_mode,json=syncMode,proto3,enum=google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode" json:"sync_mode,omitempty"`
	// Whether to skip the verification step (VESS).
	SkipVerification bool `protobuf:"varint,4,opt,name=skip_verification,json=skipVerification,proto3" json:"skip_verification,omitempty"`
	// Types that are assignable to SyncConfig:
	//	*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig
	SyncConfig isSqlInstancesStartExternalSyncRequest_SyncConfig `protobuf_oneof:"sync_config"`
}

func (x *SqlInstancesStartExternalSyncRequest) Reset() {
	*x = SqlInstancesStartExternalSyncRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStartExternalSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStartExternalSyncRequest) ProtoMessage() {}

func (x *SqlInstancesStartExternalSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStartExternalSyncRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStartExternalSyncRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{23}
}

func (x *SqlInstancesStartExternalSyncRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStartExternalSyncRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesStartExternalSyncRequest) GetSyncMode() SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	if x != nil {
		return x.SyncMode
	}
	return SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED
}

func (x *SqlInstancesStartExternalSyncRequest) GetSkipVerification() bool {
	if x != nil {
		return x.SkipVerification
	}
	return false
}

func (m *SqlInstancesStartExternalSyncRequest) GetSyncConfig() isSqlInstancesStartExternalSyncRequest_SyncConfig {
	if m != nil {
		return m.SyncConfig
	}
	return nil
}

func (x *SqlInstancesStartExternalSyncRequest) GetMysqlSyncConfig() *MySqlSyncConfig {
	if x, ok := x.GetSyncConfig().(*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig); ok {
		return x.MysqlSyncConfig
	}
	return nil
}

type isSqlInstancesStartExternalSyncRequest_SyncConfig interface {
	isSqlInstancesStartExternalSyncRequest_SyncConfig()
}

type SqlInstancesStartExternalSyncRequest_MysqlSyncConfig struct {
	// MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `protobuf:"bytes,6,opt,name=mysql_sync_config,json=mysqlSyncConfig,proto3,oneof"`
}

func (*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig) isSqlInstancesStartExternalSyncRequest_SyncConfig() {
}

// Instance create ephemeral certificate request.
type SqlInstancesCreateEphemeralCertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the Cloud SQL project.
	Project string                          `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SslCertsCreateEphemeralRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesCreateEphemeralCertRequest) Reset() {
	*x = SqlInstancesCreateEphemeralCertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesCreateEphemeralCertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesCreateEphemeralCertRequest) ProtoMessage() {}

func (x *SqlInstancesCreateEphemeralCertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesCreateEphemeralCertRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesCreateEphemeralCertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{24}
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetBody() *SslCertsCreateEphemeralRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

// Database instance clone request.
type InstancesCloneRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the clone operation.
	CloneContext *CloneContext `protobuf:"bytes,1,opt,name=clone_context,json=cloneContext,proto3" json:"clone_context,omitempty"`
}

func (x *InstancesCloneRequest) Reset() {
	*x = InstancesCloneRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesCloneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesCloneRequest) ProtoMessage() {}

func (x *InstancesCloneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesCloneRequest.ProtoReflect.Descriptor instead.
func (*InstancesCloneRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{25}
}

func (x *InstancesCloneRequest) GetCloneContext() *CloneContext {
	if x != nil {
		return x.CloneContext
	}
	return nil
}

// Database demote primary instance request.
type InstancesDemoteMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the demoteMaster operation.
	DemoteMasterContext *DemoteMasterContext `protobuf:"bytes,1,opt,name=demote_master_context,json=demoteMasterContext,proto3" json:"demote_master_context,omitempty"`
}

func (x *InstancesDemoteMasterRequest) Reset() {
	*x = InstancesDemoteMasterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesDemoteMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesDemoteMasterRequest) ProtoMessage() {}

func (x *InstancesDemoteMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesDemoteMasterRequest.ProtoReflect.Descriptor instead.
func (*InstancesDemoteMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{26}
}

func (x *InstancesDemoteMasterRequest) GetDemoteMasterContext() *DemoteMasterContext {
	if x != nil {
		return x.DemoteMasterContext
	}
	return nil
}

// Database instance export request.
type InstancesExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the export operation.
	ExportContext *ExportContext `protobuf:"bytes,1,opt,name=export_context,json=exportContext,proto3" json:"export_context,omitempty"`
}

func (x *InstancesExportRequest) Reset() {
	*x = InstancesExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesExportRequest) ProtoMessage() {}

func (x *InstancesExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesExportRequest.ProtoReflect.Descriptor instead.
func (*InstancesExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{27}
}

func (x *InstancesExportRequest) GetExportContext() *ExportContext {
	if x != nil {
		return x.ExportContext
	}
	return nil
}

// Instance failover request.
type InstancesFailoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Failover Context.
	FailoverContext *FailoverContext `protobuf:"bytes,1,opt,name=failover_context,json=failoverContext,proto3" json:"failover_context,omitempty"`
}

func (x *InstancesFailoverRequest) Reset() {
	*x = InstancesFailoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesFailoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesFailoverRequest) ProtoMessage() {}

func (x *InstancesFailoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesFailoverRequest.ProtoReflect.Descriptor instead.
func (*InstancesFailoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{28}
}

func (x *InstancesFailoverRequest) GetFailoverContext() *FailoverContext {
	if x != nil {
		return x.FailoverContext
	}
	return nil
}

// SslCerts create ephemeral certificate request.
type SslCertsCreateEphemeralRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM encoded public key to include in the signed certificate.
	PublicKey string `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Access token to include in the signed certificate.
	AccessToken string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
}

func (x *SslCertsCreateEphemeralRequest) Reset() {
	*x = SslCertsCreateEphemeralRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsCreateEphemeralRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsCreateEphemeralRequest) ProtoMessage() {}

func (x *SslCertsCreateEphemeralRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsCreateEphemeralRequest.ProtoReflect.Descriptor instead.
func (*SslCertsCreateEphemeralRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{29}
}

func (x *SslCertsCreateEphemeralRequest) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

func (x *SslCertsCreateEphemeralRequest) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// Database instance import request.
type InstancesImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the import operation.
	ImportContext *ImportContext `protobuf:"bytes,1,opt,name=import_context,json=importContext,proto3" json:"import_context,omitempty"`
}

func (x *InstancesImportRequest) Reset() {
	*x = InstancesImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesImportRequest) ProtoMessage() {}

func (x *InstancesImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesImportRequest.ProtoReflect.Descriptor instead.
func (*InstancesImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{30}
}

func (x *InstancesImportRequest) GetImportContext() *ImportContext {
	if x != nil {
		return x.ImportContext
	}
	return nil
}

// Database instances list response.
type InstancesListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#instancesList**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of warnings that occurred while handling the request.
	Warnings []*ApiWarning `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// List of database instance resources.
	Items []*DatabaseInstance `protobuf:"bytes,3,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,4,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *InstancesListResponse) Reset() {
	*x = InstancesListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesListResponse) ProtoMessage() {}

func (x *InstancesListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesListResponse.ProtoReflect.Descriptor instead.
func (*InstancesListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{31}
}

func (x *InstancesListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *InstancesListResponse) GetWarnings() []*ApiWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *InstancesListResponse) GetItems() []*DatabaseInstance {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *InstancesListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Instances ListServerCas response.
type InstancesListServerCasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of server CA certificates for the instance.
	Certs         []*SslCert `protobuf:"bytes,1,rep,name=certs,proto3" json:"certs,omitempty"`
	ActiveVersion string     `protobuf:"bytes,2,opt,name=active_version,json=activeVersion,proto3" json:"active_version,omitempty"`
	// This is always **sql#instancesListServerCas**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *InstancesListServerCasResponse) Reset() {
	*x = InstancesListServerCasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesListServerCasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesListServerCasResponse) ProtoMessage() {}

func (x *InstancesListServerCasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesListServerCasResponse.ProtoReflect.Descriptor instead.
func (*InstancesListServerCasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{32}
}

func (x *InstancesListServerCasResponse) GetCerts() []*SslCert {
	if x != nil {
		return x.Certs
	}
	return nil
}

func (x *InstancesListServerCasResponse) GetActiveVersion() string {
	if x != nil {
		return x.ActiveVersion
	}
	return ""
}

func (x *InstancesListServerCasResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Database instance restore backup request.
type InstancesRestoreBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters required to perform the restore backup operation.
	RestoreBackupContext *RestoreBackupContext `protobuf:"bytes,1,opt,name=restore_backup_context,json=restoreBackupContext,proto3" json:"restore_backup_context,omitempty"`
}

func (x *InstancesRestoreBackupRequest) Reset() {
	*x = InstancesRestoreBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesRestoreBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesRestoreBackupRequest) ProtoMessage() {}

func (x *InstancesRestoreBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesRestoreBackupRequest.ProtoReflect.Descriptor instead.
func (*InstancesRestoreBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{33}
}

func (x *InstancesRestoreBackupRequest) GetRestoreBackupContext() *RestoreBackupContext {
	if x != nil {
		return x.RestoreBackupContext
	}
	return nil
}

// Rotate server CA request.
type InstancesRotateServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the rotate server CA operation.
	RotateServerCaContext *RotateServerCaContext `protobuf:"bytes,1,opt,name=rotate_server_ca_context,json=rotateServerCaContext,proto3" json:"rotate_server_ca_context,omitempty"`
}

func (x *InstancesRotateServerCaRequest) Reset() {
	*x = InstancesRotateServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesRotateServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesRotateServerCaRequest) ProtoMessage() {}

func (x *InstancesRotateServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesRotateServerCaRequest.ProtoReflect.Descriptor instead.
func (*InstancesRotateServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{34}
}

func (x *InstancesRotateServerCaRequest) GetRotateServerCaContext() *RotateServerCaContext {
	if x != nil {
		return x.RotateServerCaContext
	}
	return nil
}

// Instance truncate log request.
type InstancesTruncateLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the truncate log operation.
	TruncateLogContext *TruncateLogContext `protobuf:"bytes,1,opt,name=truncate_log_context,json=truncateLogContext,proto3" json:"truncate_log_context,omitempty"`
}

func (x *InstancesTruncateLogRequest) Reset() {
	*x = InstancesTruncateLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesTruncateLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesTruncateLogRequest) ProtoMessage() {}

func (x *InstancesTruncateLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesTruncateLogRequest.ProtoReflect.Descriptor instead.
func (*InstancesTruncateLogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{35}
}

func (x *InstancesTruncateLogRequest) GetTruncateLogContext() *TruncateLogContext {
	if x != nil {
		return x.TruncateLogContext
	}
	return nil
}

// Instance verify external sync settings response.
type SqlInstancesVerifyExternalSyncSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#migrationSettingErrorList**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of migration violations.
	Errors []*SqlExternalSyncSettingError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	// List of migration warnings.
	Warnings []*SqlExternalSyncSettingError `protobuf:"bytes,3,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) Reset() {
	*x = SqlInstancesVerifyExternalSyncSettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesVerifyExternalSyncSettingsResponse) ProtoMessage() {}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsResponse.ProtoReflect.Descriptor instead.
func (*SqlInstancesVerifyExternalSyncSettingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{36}
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetErrors() []*SqlExternalSyncSettingError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetWarnings() []*SqlExternalSyncSettingError {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// Database instance clone context.
type CloneContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#cloneContext**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Reserved for future use.
	PitrTimestampMs int64 `protobuf:"varint,2,opt,name=pitr_timestamp_ms,json=pitrTimestampMs,proto3" json:"pitr_timestamp_ms,omitempty"`
	// Name of the Cloud SQL instance to be created as a clone.
	DestinationInstanceName string `protobuf:"bytes,3,opt,name=destination_instance_name,json=destinationInstanceName,proto3" json:"destination_instance_name,omitempty"`
	// Binary log coordinates, if specified, identify the position up to which the
	// source instance is cloned. If not specified, the source instance is
	// cloned up to the most recent binary log coordinates.
	BinLogCoordinates *BinLogCoordinates `protobuf:"bytes,4,opt,name=bin_log_coordinates,json=binLogCoordinates,proto3" json:"bin_log_coordinates,omitempty"`
	// Timestamp, if specified, identifies the time to which the source instance
	// is cloned.
	PointInTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=point_in_time,json=pointInTime,proto3" json:"point_in_time,omitempty"`
}

func (x *CloneContext) Reset() {
	*x = CloneContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloneContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneContext) ProtoMessage() {}

func (x *CloneContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneContext.ProtoReflect.Descriptor instead.
func (*CloneContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{37}
}

func (x *CloneContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *CloneContext) GetPitrTimestampMs() int64 {
	if x != nil {
		return x.PitrTimestampMs
	}
	return 0
}

func (x *CloneContext) GetDestinationInstanceName() string {
	if x != nil {
		return x.DestinationInstanceName
	}
	return ""
}

func (x *CloneContext) GetBinLogCoordinates() *BinLogCoordinates {
	if x != nil {
		return x.BinLogCoordinates
	}
	return nil
}

func (x *CloneContext) GetPointInTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PointInTime
	}
	return nil
}

// Binary log coordinates.
type BinLogCoordinates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the binary log file for a Cloud SQL instance.
	BinLogFileName string `protobuf:"bytes,1,opt,name=bin_log_file_name,json=binLogFileName,proto3" json:"bin_log_file_name,omitempty"`
	// Position (offset) within the binary log file.
	BinLogPosition int64 `protobuf:"varint,2,opt,name=bin_log_position,json=binLogPosition,proto3" json:"bin_log_position,omitempty"`
	// This is always **sql#binLogCoordinates**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *BinLogCoordinates) Reset() {
	*x = BinLogCoordinates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinLogCoordinates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinLogCoordinates) ProtoMessage() {}

func (x *BinLogCoordinates) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinLogCoordinates.ProtoReflect.Descriptor instead.
func (*BinLogCoordinates) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{38}
}

func (x *BinLogCoordinates) GetBinLogFileName() string {
	if x != nil {
		return x.BinLogFileName
	}
	return ""
}

func (x *BinLogCoordinates) GetBinLogPosition() int64 {
	if x != nil {
		return x.BinLogPosition
	}
	return 0
}

func (x *BinLogCoordinates) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// A Cloud SQL instance resource.
type DatabaseInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#instance**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The current serving state of the Cloud SQL instance. This can be one of the
	// following:
	// *  **SQL_INSTANCE_STATE_UNSPECIFIED**: The state of the instance is
	// unknown.
	// *  **RUNNABLE**: The instance is running, or has been stopped by owner.
	// *  **SUSPENDED**: The instance is not available, for example due to
	// problems with billing.
	// *  **PENDING_DELETE**: The instance is being deleted.
	// *  **PENDING_CREATE**: The instance is being created.
	// *  **MAINTENANCE**: The instance is down for maintenance.
	// *  **FAILED**: The instance creation failed.
	State DatabaseInstance_SqlInstanceState `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.sql.v1.DatabaseInstance_SqlInstanceState" json:"state,omitempty"`
	// The database engine type and version. The **databaseVersion** field cannot
	// be changed after instance creation.
	// *  **MySQL instances**: MYSQL_8_0, MYSQL_5_7 (default), or MYSQL_5_6.
	// *  **PostgreSQL instances**: POSTGRES_9_6, POSTGRES_10, POSTGRES_11,
	// POSTGRES_12, POSTGRES_13 (default).
	// *  **SQL Server instances**: SQLSERVER_2019_STANDARD,
	// SQLSERVER_2019_ENTERPRISE, SQLSERVER_2019_EXPRESS, or SQLSERVER_2019_WEB,
	// SQLSERVER_2017_STANDARD (default), SQLSERVER_2017_ENTERPRISE,
	// SQLSERVER_2017_EXPRESS, or SQLSERVER_2017_WEB.
	DatabaseVersion SqlDatabaseVersion `protobuf:"varint,3,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.sql.v1.SqlDatabaseVersion" json:"database_version,omitempty"`
	// The user settings.
	Settings *Settings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	// This field is deprecated and will be removed from a future version of the
	// API. Use the **settings.settingsVersion** field instead.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
	// The name and status of the failover replica.
	FailoverReplica *DatabaseInstance_SqlFailoverReplica `protobuf:"bytes,6,opt,name=failover_replica,json=failoverReplica,proto3" json:"failover_replica,omitempty"`
	// The name of the instance which will act as primary in the replication
	// setup.
	MasterInstanceName string `protobuf:"bytes,7,opt,name=master_instance_name,json=masterInstanceName,proto3" json:"master_instance_name,omitempty"`
	// The replicas of the instance.
	ReplicaNames []string `protobuf:"bytes,8,rep,name=replica_names,json=replicaNames,proto3" json:"replica_names,omitempty"`
	// The maximum disk size of the instance in bytes.
	//
	// Deprecated: Do not use.
	MaxDiskSize *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=max_disk_size,json=maxDiskSize,proto3" json:"max_disk_size,omitempty"`
	// The current disk usage of the instance in bytes. This property has been
	// deprecated. Use the
	// "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
	// Monitoring API instead. Please see [this
	// announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
	// for details.
	//
	// Deprecated: Do not use.
	CurrentDiskSize *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=current_disk_size,json=currentDiskSize,proto3" json:"current_disk_size,omitempty"`
	// The assigned IP addresses for the instance.
	IpAddresses []*IpMapping `protobuf:"bytes,11,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// SSL configuration.
	ServerCaCert *SslCert `protobuf:"bytes,12,opt,name=server_ca_cert,json=serverCaCert,proto3" json:"server_ca_cert,omitempty"`
	// The instance type. This can be one of the following:
	// *  **CLOUD_SQL_INSTANCE**: A Cloud SQL instance that is not replicating
	// from a primary instance.
	// *  **ON_PREMISES_INSTANCE**: An instance running on the customer's
	// premises.
	// *  **READ_REPLICA_INSTANCE**: A Cloud SQL instance configured as a
	// read-replica.
	InstanceType SqlInstanceType `protobuf:"varint,13,opt,name=instance_type,json=instanceType,proto3,enum=google.cloud.sql.v1.SqlInstanceType" json:"instance_type,omitempty"`
	// The project ID of the project containing the Cloud SQL instance. The Google
	// apps domain is prefixed if applicable.
	Project string `protobuf:"bytes,14,opt,name=project,proto3" json:"project,omitempty"`
	// The IPv6 address assigned to the instance.
	// (Deprecated) This property was applicable only
	// to First Generation instances.
	//
	// Deprecated: Do not use.
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3" json:"ipv6_address,omitempty"`
	// The service account email address assigned to the instance. <br>This
	// property is read-only.
	ServiceAccountEmailAddress string `protobuf:"bytes,16,opt,name=service_account_email_address,json=serviceAccountEmailAddress,proto3" json:"service_account_email_address,omitempty"`
	// Configuration specific to on-premises instances.
	OnPremisesConfiguration *OnPremisesConfiguration `protobuf:"bytes,17,opt,name=on_premises_configuration,json=onPremisesConfiguration,proto3" json:"on_premises_configuration,omitempty"`
	// Configuration specific to failover replicas and read replicas.
	ReplicaConfiguration *ReplicaConfiguration `protobuf:"bytes,18,opt,name=replica_configuration,json=replicaConfiguration,proto3" json:"replica_configuration,omitempty"`
	// The backend type.
	// **SECOND_GEN**: Cloud SQL database instance.
	// **EXTERNAL**: A database server that is not managed by Google.
	//
	// This property is read-only; use the **tier** property in the **settings**
	// object to determine the database type.
	BackendType SqlBackendType `protobuf:"varint,19,opt,name=backend_type,json=backendType,proto3,enum=google.cloud.sql.v1.SqlBackendType" json:"backend_type,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,20,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// If the instance state is SUSPENDED, the reason for the suspension.
	SuspensionReason []SqlSuspensionReason `protobuf:"varint,21,rep,packed,name=suspension_reason,json=suspensionReason,proto3,enum=google.cloud.sql.v1.SqlSuspensionReason" json:"suspension_reason,omitempty"`
	// Connection name of the Cloud SQL instance used in connection strings.
	ConnectionName string `protobuf:"bytes,22,opt,name=connection_name,json=connectionName,proto3" json:"connection_name,omitempty"`
	// Name of the Cloud SQL instance. This does not include the project ID.
	Name string `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// The geographical region. Can be:
	// *  **us-central** (**FIRST_GEN** instances only)
	// *  **us-central1** (**SECOND_GEN** instances only)
	// *  **asia-east1** or **europe-west1**.
	//
	// Defaults to **us-central** or **us-central1** depending on the instance
	// type. The region cannot be changed after instance creation.
	Region string `protobuf:"bytes,24,opt,name=region,proto3" json:"region,omitempty"`
	// The Compute Engine zone that the instance is currently serving from. This
	// value could be different from the zone that was specified when the instance
	// was created if the instance has failed over to its secondary zone.
	GceZone string `protobuf:"bytes,25,opt,name=gce_zone,json=gceZone,proto3" json:"gce_zone,omitempty"`
	// The Compute Engine zone that the failover instance is currently serving
	// from for a regional instance. This value could be different
	// from the zone that was specified when the instance
	// was created if the instance has failed over to its secondary/failover zone.
	// Reserved for future use.
	SecondaryGceZone string `protobuf:"bytes,34,opt,name=secondary_gce_zone,json=secondaryGceZone,proto3" json:"secondary_gce_zone,omitempty"`
	// Disk encryption configuration specific to an instance.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `protobuf:"bytes,26,opt,name=disk_encryption_configuration,json=diskEncryptionConfiguration,proto3" json:"disk_encryption_configuration,omitempty"`
	// Disk encryption status specific to an instance.
	DiskEncryptionStatus *DiskEncryptionStatus `protobuf:"bytes,27,opt,name=disk_encryption_status,json=diskEncryptionStatus,proto3" json:"disk_encryption_status,omitempty"`
	// Initial root password. Use only on creation.
	RootPassword string `protobuf:"bytes,29,opt,name=root_password,json=rootPassword,proto3" json:"root_password,omitempty"`
	// The start time of any upcoming scheduled maintenance for this instance.
	ScheduledMaintenance *DatabaseInstance_SqlScheduledMaintenance `protobuf:"bytes,30,opt,name=scheduled_maintenance,json=scheduledMaintenance,proto3" json:"scheduled_maintenance,omitempty"`
	// The status indicating if instance satisfiesPzs.
	// Reserved for future use.
	SatisfiesPzs *wrapperspb.BoolValue `protobuf:"bytes,35,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// This field represents the report generated by the proactive database
	// wellness job for OutOfDisk issues.
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	//   *  the proactive database wellness job
	OutOfDiskReport *DatabaseInstance_SqlOutOfDiskReport `protobuf:"bytes,38,opt,name=out_of_disk_report,json=outOfDiskReport,proto3,oneof" json:"out_of_disk_report,omitempty"`
	// Output only. The time when the instance was created in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,39,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *DatabaseInstance) Reset() {
	*x = DatabaseInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance) ProtoMessage() {}

func (x *DatabaseInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance.ProtoReflect.Descriptor instead.
func (*DatabaseInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39}
}

func (x *DatabaseInstance) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DatabaseInstance) GetState() DatabaseInstance_SqlInstanceState {
	if x != nil {
		return x.State
	}
	return DatabaseInstance_SQL_INSTANCE_STATE_UNSPECIFIED
}

func (x *DatabaseInstance) GetDatabaseVersion() SqlDatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return SqlDatabaseVersion_SQL_DATABASE_VERSION_UNSPECIFIED
}

func (x *DatabaseInstance) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *DatabaseInstance) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DatabaseInstance) GetFailoverReplica() *DatabaseInstance_SqlFailoverReplica {
	if x != nil {
		return x.FailoverReplica
	}
	return nil
}

func (x *DatabaseInstance) GetMasterInstanceName() string {
	if x != nil {
		return x.MasterInstanceName
	}
	return ""
}

func (x *DatabaseInstance) GetReplicaNames() []string {
	if x != nil {
		return x.ReplicaNames
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetMaxDiskSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxDiskSize
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetCurrentDiskSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.CurrentDiskSize
	}
	return nil
}

func (x *DatabaseInstance) GetIpAddresses() []*IpMapping {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *DatabaseInstance) GetServerCaCert() *SslCert {
	if x != nil {
		return x.ServerCaCert
	}
	return nil
}

func (x *DatabaseInstance) GetInstanceType() SqlInstanceType {
	if x != nil {
		return x.InstanceType
	}
	return SqlInstanceType_SQL_INSTANCE_TYPE_UNSPECIFIED
}

func (x *DatabaseInstance) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetIpv6Address() string {
	if x != nil {
		return x.Ipv6Address
	}
	return ""
}

func (x *DatabaseInstance) GetServiceAccountEmailAddress() string {
	if x != nil {
		return x.ServiceAccountEmailAddress
	}
	return ""
}

func (x *DatabaseInstance) GetOnPremisesConfiguration() *OnPremisesConfiguration {
	if x != nil {
		return x.OnPremisesConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetReplicaConfiguration() *ReplicaConfiguration {
	if x != nil {
		return x.ReplicaConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetBackendType() SqlBackendType {
	if x != nil {
		return x.BackendType
	}
	return SqlBackendType_SQL_BACKEND_TYPE_UNSPECIFIED
}

func (x *DatabaseInstance) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *DatabaseInstance) GetSuspensionReason() []SqlSuspensionReason {
	if x != nil {
		return x.SuspensionReason
	}
	return nil
}

func (x *DatabaseInstance) GetConnectionName() string {
	if x != nil {
		return x.ConnectionName
	}
	return ""
}

func (x *DatabaseInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseInstance) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DatabaseInstance) GetGceZone() string {
	if x != nil {
		return x.GceZone
	}
	return ""
}

func (x *DatabaseInstance) GetSecondaryGceZone() string {
	if x != nil {
		return x.SecondaryGceZone
	}
	return ""
}

func (x *DatabaseInstance) GetDiskEncryptionConfiguration() *DiskEncryptionConfiguration {
	if x != nil {
		return x.DiskEncryptionConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetDiskEncryptionStatus() *DiskEncryptionStatus {
	if x != nil {
		return x.DiskEncryptionStatus
	}
	return nil
}

func (x *DatabaseInstance) GetRootPassword() string {
	if x != nil {
		return x.RootPassword
	}
	return ""
}

func (x *DatabaseInstance) GetScheduledMaintenance() *DatabaseInstance_SqlScheduledMaintenance {
	if x != nil {
		return x.ScheduledMaintenance
	}
	return nil
}

func (x *DatabaseInstance) GetSatisfiesPzs() *wrapperspb.BoolValue {
	if x != nil {
		return x.SatisfiesPzs
	}
	return nil
}

func (x *DatabaseInstance) GetOutOfDiskReport() *DatabaseInstance_SqlOutOfDiskReport {
	if x != nil {
		return x.OutOfDiskReport
	}
	return nil
}

func (x *DatabaseInstance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Reschedule options for maintenance windows.
type SqlInstancesRescheduleMaintenanceRequestBody struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the reschedule the user wants.
	Reschedule *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule `protobuf:"bytes,3,opt,name=reschedule,proto3" json:"reschedule,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequestBody{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequestBody) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequestBody) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{40}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) GetReschedule() *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule {
	if x != nil {
		return x.Reschedule
	}
	return nil
}

// Database instance demote primary instance context.
type DemoteMasterContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#demoteMasterContext**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Verify GTID consistency for demote operation. Default value:
	// **True**. Setting this flag to false enables you to bypass GTID consistency
	// check between on-premises primary instance and Cloud SQL instance during
	// the demotion operation but also exposes you to the risk of future
	// replication failures. Change the value only if you know the reason for the
	// GTID divergence and are confident that doing so will not cause any
	// replication issues.
	VerifyGtidConsistency *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=verify_gtid_consistency,json=verifyGtidConsistency,proto3" json:"verify_gtid_consistency,omitempty"`
	// The name of the instance which will act as on-premises primary instance
	// in the replication setup.
	MasterInstanceName string `protobuf:"bytes,3,opt,name=master_instance_name,json=masterInstanceName,proto3" json:"master_instance_name,omitempty"`
	// Configuration specific to read-replicas replicating from the on-premises
	// primary instance.
	ReplicaConfiguration *DemoteMasterConfiguration `protobuf:"bytes,4,opt,name=replica_configuration,json=replicaConfiguration,proto3" json:"replica_configuration,omitempty"`
	// Flag to skip replication setup on the instance.
	SkipReplicationSetup bool `protobuf:"varint,5,opt,name=skip_replication_setup,json=skipReplicationSetup,proto3" json:"skip_replication_setup,omitempty"`
}

func (x *DemoteMasterContext) Reset() {
	*x = DemoteMasterContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterContext) ProtoMessage() {}

func (x *DemoteMasterContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterContext.ProtoReflect.Descriptor instead.
func (*DemoteMasterContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{41}
}

func (x *DemoteMasterContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterContext) GetVerifyGtidConsistency() *wrapperspb.BoolValue {
	if x != nil {
		return x.VerifyGtidConsistency
	}
	return nil
}

func (x *DemoteMasterContext) GetMasterInstanceName() string {
	if x != nil {
		return x.MasterInstanceName
	}
	return ""
}

func (x *DemoteMasterContext) GetReplicaConfiguration() *DemoteMasterConfiguration {
	if x != nil {
		return x.ReplicaConfiguration
	}
	return nil
}

func (x *DemoteMasterContext) GetSkipReplicationSetup() bool {
	if x != nil {
		return x.SkipReplicationSetup
	}
	return false
}

// Database instance failover context.
type FailoverContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current settings version of this instance. Request will be rejected if
	// this version doesn't match the current settings version.
	SettingsVersion int64 `protobuf:"varint,1,opt,name=settings_version,json=settingsVersion,proto3" json:"settings_version,omitempty"`
	// This is always **sql#failoverContext**.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *FailoverContext) Reset() {
	*x = FailoverContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailoverContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailoverContext) ProtoMessage() {}

func (x *FailoverContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailoverContext.ProtoReflect.Descriptor instead.
func (*FailoverContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{42}
}

func (x *FailoverContext) GetSettingsVersion() int64 {
	if x != nil {
		return x.SettingsVersion
	}
	return 0
}

func (x *FailoverContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Database instance restore from backup context.
// Backup context contains source instance id and project id.
type RestoreBackupContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#restoreBackupContext**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The ID of the backup run to restore from.
	BackupRunId int64 `protobuf:"varint,2,opt,name=backup_run_id,json=backupRunId,proto3" json:"backup_run_id,omitempty"`
	// The ID of the instance that the backup was taken from.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The full project ID of the source instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *RestoreBackupContext) Reset() {
	*x = RestoreBackupContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreBackupContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreBackupContext) ProtoMessage() {}

func (x *RestoreBackupContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreBackupContext.ProtoReflect.Descriptor instead.
func (*RestoreBackupContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{43}
}

func (x *RestoreBackupContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *RestoreBackupContext) GetBackupRunId() int64 {
	if x != nil {
		return x.BackupRunId
	}
	return 0
}

func (x *RestoreBackupContext) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *RestoreBackupContext) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance rotate server CA context.
type RotateServerCaContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#rotateServerCaContext**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The fingerprint of the next version to be rotated to. If left unspecified,
	// will be rotated to the most recently added server CA version.
	NextVersion string `protobuf:"bytes,2,opt,name=next_version,json=nextVersion,proto3" json:"next_version,omitempty"`
}

func (x *RotateServerCaContext) Reset() {
	*x = RotateServerCaContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RotateServerCaContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotateServerCaContext) ProtoMessage() {}

func (x *RotateServerCaContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotateServerCaContext.ProtoReflect.Descriptor instead.
func (*RotateServerCaContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{44}
}

func (x *RotateServerCaContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *RotateServerCaContext) GetNextVersion() string {
	if x != nil {
		return x.NextVersion
	}
	return ""
}

// Database Instance truncate log context.
type TruncateLogContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#truncateLogContext**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The type of log to truncate. Valid values are **MYSQL_GENERAL_TABLE** and
	// **MYSQL_SLOW_TABLE**.
	LogType string `protobuf:"bytes,2,opt,name=log_type,json=logType,proto3" json:"log_type,omitempty"`
}

func (x *TruncateLogContext) Reset() {
	*x = TruncateLogContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncateLogContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncateLogContext) ProtoMessage() {}

func (x *TruncateLogContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncateLogContext.ProtoReflect.Descriptor instead.
func (*TruncateLogContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{45}
}

func (x *TruncateLogContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *TruncateLogContext) GetLogType() string {
	if x != nil {
		return x.LogType
	}
	return ""
}

// External primary instance migration setting error/warning.
type SqlExternalSyncSettingError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Can be **sql#externalSyncSettingError** or
	// **sql#externalSyncSettingWarning**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Identifies the specific error that occurred.
	Type SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.sql.v1.SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType" json:"type,omitempty"`
	// Additional information about the error encountered.
	Detail string `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *SqlExternalSyncSettingError) Reset() {
	*x = SqlExternalSyncSettingError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlExternalSyncSettingError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlExternalSyncSettingError) ProtoMessage() {}

func (x *SqlExternalSyncSettingError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlExternalSyncSettingError.ProtoReflect.Descriptor instead.
func (*SqlExternalSyncSettingError) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{46}
}

func (x *SqlExternalSyncSettingError) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlExternalSyncSettingError) GetType() SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType {
	if x != nil {
		return x.Type
	}
	return SqlExternalSyncSettingError_SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED
}

func (x *SqlExternalSyncSettingError) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// On-premises instance configuration.
type OnPremisesConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The host and port of the on-premises instance in host:port format
	HostPort string `protobuf:"bytes,1,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// This is always **sql#onPremisesConfiguration**.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// The username for connecting to on-premises instance.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// The password for connecting to on-premises instance.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,5,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,6,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate.
	ClientKey string `protobuf:"bytes,7,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// The dump file to create the Cloud SQL replica.
	DumpFilePath string `protobuf:"bytes,8,opt,name=dump_file_path,json=dumpFilePath,proto3" json:"dump_file_path,omitempty"`
	// The reference to Cloud SQL instance if the source is Cloud SQL.
	SourceInstance *InstanceReference `protobuf:"bytes,15,opt,name=source_instance,json=sourceInstance,proto3" json:"source_instance,omitempty"`
}

func (x *OnPremisesConfiguration) Reset() {
	*x = OnPremisesConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnPremisesConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnPremisesConfiguration) ProtoMessage() {}

func (x *OnPremisesConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnPremisesConfiguration.ProtoReflect.Descriptor instead.
func (*OnPremisesConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{47}
}

func (x *OnPremisesConfiguration) GetHostPort() string {
	if x != nil {
		return x.HostPort
	}
	return ""
}

func (x *OnPremisesConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OnPremisesConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *OnPremisesConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *OnPremisesConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *OnPremisesConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *OnPremisesConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *OnPremisesConfiguration) GetDumpFilePath() string {
	if x != nil {
		return x.DumpFilePath
	}
	return ""
}

func (x *OnPremisesConfiguration) GetSourceInstance() *InstanceReference {
	if x != nil {
		return x.SourceInstance
	}
	return nil
}

// Read-replica configuration for connecting to the primary instance.
type ReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#replicaConfiguration**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// MySQL specific configuration when replicating from a MySQL on-premises
	// primary instance. Replication configuration information such as the
	// username, password, certificates, and keys are not stored in the instance
	// metadata. The configuration information is used only to set up the
	// replication connection and is stored by MySQL in a file named
	// **master.info** in the data directory.
	MysqlReplicaConfiguration *MySqlReplicaConfiguration `protobuf:"bytes,2,opt,name=mysql_replica_configuration,json=mysqlReplicaConfiguration,proto3" json:"mysql_replica_configuration,omitempty"`
	// Specifies if the replica is the failover target. If the field is set to
	// **true** the replica will be designated as a failover replica. In case the
	// primary instance fails, the replica instance will be promoted as the new
	// primary instance. Only one replica can be specified as failover target, and
	// the replica has to be in different zone with the primary instance.
	FailoverTarget *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=failover_target,json=failoverTarget,proto3" json:"failover_target,omitempty"`
}

func (x *ReplicaConfiguration) Reset() {
	*x = ReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaConfiguration) ProtoMessage() {}

func (x *ReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*ReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{48}
}

func (x *ReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ReplicaConfiguration) GetMysqlReplicaConfiguration() *MySqlReplicaConfiguration {
	if x != nil {
		return x.MysqlReplicaConfiguration
	}
	return nil
}

func (x *ReplicaConfiguration) GetFailoverTarget() *wrapperspb.BoolValue {
	if x != nil {
		return x.FailoverTarget
	}
	return nil
}

type DatabaseInstance_SqlFailoverReplica struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the failover replica. If specified at instance creation, a
	// failover replica is created for the instance. The name
	// doesn't include the project ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The availability status of the failover replica. A false status indicates
	// that the failover replica is out of sync. The primary instance can only
	// failover to the failover replica when the status is true.
	Available *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=available,proto3" json:"available,omitempty"`
}

func (x *DatabaseInstance_SqlFailoverReplica) Reset() {
	*x = DatabaseInstance_SqlFailoverReplica{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlFailoverReplica) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlFailoverReplica) ProtoMessage() {}

func (x *DatabaseInstance_SqlFailoverReplica) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlFailoverReplica.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlFailoverReplica) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39, 0}
}

func (x *DatabaseInstance_SqlFailoverReplica) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseInstance_SqlFailoverReplica) GetAvailable() *wrapperspb.BoolValue {
	if x != nil {
		return x.Available
	}
	return nil
}

// Any scheduled maintenancce for this instance.
type DatabaseInstance_SqlScheduledMaintenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of any upcoming scheduled maintenance for this instance.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Deprecated: Do not use.
	CanDefer bool `protobuf:"varint,2,opt,name=can_defer,json=canDefer,proto3" json:"can_defer,omitempty"`
	// If the scheduled maintenance can be rescheduled.
	CanReschedule bool `protobuf:"varint,3,opt,name=can_reschedule,json=canReschedule,proto3" json:"can_reschedule,omitempty"`
	// Maintenance cannot be rescheduled to start beyond this deadline.
	ScheduleDeadlineTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=schedule_deadline_time,json=scheduleDeadlineTime,proto3,oneof" json:"schedule_deadline_time,omitempty"`
}

func (x *DatabaseInstance_SqlScheduledMaintenance) Reset() {
	*x = DatabaseInstance_SqlScheduledMaintenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlScheduledMaintenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlScheduledMaintenance) ProtoMessage() {}

func (x *DatabaseInstance_SqlScheduledMaintenance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlScheduledMaintenance.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlScheduledMaintenance) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39, 1}
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance_SqlScheduledMaintenance) GetCanDefer() bool {
	if x != nil {
		return x.CanDefer
	}
	return false
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetCanReschedule() bool {
	if x != nil {
		return x.CanReschedule
	}
	return false
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetScheduleDeadlineTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduleDeadlineTime
	}
	return nil
}

// This message wraps up the information written by out-of-disk detection job.
type DatabaseInstance_SqlOutOfDiskReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field represents the state generated by the proactive database
	// wellness job for OutOfDisk issues.
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	//   *  the proactive database wellness job
	SqlOutOfDiskState *DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState `protobuf:"varint,1,opt,name=sql_out_of_disk_state,json=sqlOutOfDiskState,proto3,enum=google.cloud.sql.v1.DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState,oneof" json:"sql_out_of_disk_state,omitempty"`
	// The minimum recommended increase size in GigaBytes
	// This field is consumed by the frontend
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	SqlMinRecommendedIncreaseSizeGb *int32 `protobuf:"varint,2,opt,name=sql_min_recommended_increase_size_gb,json=sqlMinRecommendedIncreaseSizeGb,proto3,oneof" json:"sql_min_recommended_increase_size_gb,omitempty"`
}

func (x *DatabaseInstance_SqlOutOfDiskReport) Reset() {
	*x = DatabaseInstance_SqlOutOfDiskReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlOutOfDiskReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlOutOfDiskReport) ProtoMessage() {}

func (x *DatabaseInstance_SqlOutOfDiskReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlOutOfDiskReport.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlOutOfDiskReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{39, 2}
}

func (x *DatabaseInstance_SqlOutOfDiskReport) GetSqlOutOfDiskState() DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState {
	if x != nil && x.SqlOutOfDiskState != nil {
		return *x.SqlOutOfDiskState
	}
	return DatabaseInstance_SqlOutOfDiskReport_SQL_OUT_OF_DISK_STATE_UNSPECIFIED
}

func (x *DatabaseInstance_SqlOutOfDiskReport) GetSqlMinRecommendedIncreaseSizeGb() int32 {
	if x != nil && x.SqlMinRecommendedIncreaseSizeGb != nil {
		return *x.SqlMinRecommendedIncreaseSizeGb
	}
	return 0
}

type SqlInstancesRescheduleMaintenanceRequestBody_Reschedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the reschedule.
	RescheduleType SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType `protobuf:"varint,1,opt,name=reschedule_type,json=rescheduleType,proto3,enum=google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType" json:"reschedule_type,omitempty"`
	// Optional. Timestamp when the maintenance shall be rescheduled to if
	// reschedule_type=SPECIFIC_TIME, in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	ScheduleTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequestBody_Reschedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody_Reschedule.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP(), []int{40, 0}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) GetRescheduleType() SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType {
	if x != nil {
		return x.RescheduleType
	}
	return SqlInstancesRescheduleMaintenanceRequestBody_RESCHEDULE_TYPE_UNSPECIFIED
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) GetScheduleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduleTime
	}
	return nil
}

var File_google_cloud_sql_v1_cloud_sql_instances_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73,
	0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56, 0x0a, 0x1e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x64, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x51, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x9e, 0x01, 0x0a, 0x1f, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x92, 0x01, 0x0a, 0x19,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x22, 0x96, 0x01, 0x0a, 0x1b, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x4e, 0x0a, 0x16, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x92, 0x01, 0x0a, 0x19, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x70,
	0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x22, 0x8b, 0x01, 0x0a, 0x17, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x58,
	0x0a, 0x20, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x8b, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x59, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x22, 0x59, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x52, 0x0a, 0x1a,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x22, 0xa0, 0x01, 0x0a, 0x20, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x47, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x57, 0x0a, 0x1f, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x22, 0x56, 0x0a, 0x1e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x9c, 0x01, 0x0a, 0x1e, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x8c, 0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x39, 0x0a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0xb7, 0x01, 0x0a, 0x28, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x55, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x52, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x22, 0x83, 0x04, 0x0a, 0x2d, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x6c, 0x79, 0x12,
	0x70, 0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53,
	0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x3b, 0x0a, 0x17, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x57,
	0x0a, 0x11, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x79, 0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x79, 0x6e,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4f, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f,
	0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79, 0x6e, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xde, 0x02, 0x0a, 0x24, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x70, 0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08,
	0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70,
	0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x11, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x73,
	0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53,
	0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79, 0x6e,
	0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa7, 0x01, 0x0a, 0x26, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45,
	0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65,
	0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x22, 0x5f, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x0d, 0x63,
	0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x22, 0x7c, 0x0a, 0x1c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x15, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x13, 0x64, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x22, 0x63, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0e, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x6b, 0x0a, 0x18, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4f, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x22, 0x62, 0x0a, 0x1e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xcd, 0x01, 0x0a,
	0x15, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x3b, 0x0a, 0x08, 0x77, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x77,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a,
	0x1e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x32, 0x0a, 0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x05, 0x63, 0x65,
	0x72, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x80,
	0x01, 0x0a, 0x1d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5f, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x14, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x22, 0x85, 0x01, 0x0a, 0x1e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x18, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x15, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x78, 0x0a, 0x1b, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x14, 0x74, 0x72, 0x75, 0x6e,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x12, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x22, 0xdc, 0x01, 0x0a, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x48, 0x0a, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0xa2, 0x02, 0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x69, 0x74, 0x72, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x70, 0x69, 0x74, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x4d, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x56, 0x0a, 0x13, 0x62, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x11, 0x62, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x0d, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x11, 0x42, 0x69, 0x6e, 0x4c, 0x6f,
	0x67, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x11,
	0x62, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x69, 0x6e, 0x5f, 0x6c,
	0x6f, 0x67, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0e, 0x62, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x8a, 0x18, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x4c,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x10,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x63, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x53, 0x71, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x0d, 0x6d,
	0x61, 0x78, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x4b, 0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x41, 0x0a,
	0x0c, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x70, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x0b, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x42, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61,
	0x43, 0x65, 0x72, 0x74, 0x12, 0x49, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0c, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0b, 0x69, 0x70, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x41, 0x0a, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x68, 0x0a, 0x19, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x6d, 0x69, 0x73,
	0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x50,
	0x72, 0x65, 0x6d, 0x69, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x69, 0x73, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a,
	0x15, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x55, 0x0a, 0x11, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x10, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x19,
	0x0a, 0x08, 0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x67, 0x63, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x22, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x47, 0x63, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x74, 0x0a, 0x1d, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x1b, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a,
	0x16, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x14, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x6f, 0x6f, 0x74, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x12, 0x72, 0x0a, 0x15, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64,
	0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x5f,
	0x6f, 0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x26,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x4f,
	0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00,
	0x52, 0x0f, 0x6f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x62, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x38, 0x0a, 0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x8e, 0x02, 0x0a, 0x17, 0x53,
	0x71, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x09, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x63, 0x61, 0x6e, 0x44, 0x65, 0x66,
	0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x52,
	0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x16, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x65,
	0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x1a, 0x8a, 0x03, 0x0a, 0x12,
	0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x15, 0x73, 0x71, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x6f,
	0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74,
	0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x53, 0x71, 0x6c,
	0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00,
	0x52, 0x11, 0x73, 0x71, 0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x24, 0x73, 0x71, 0x6c, 0x5f, 0x6d, 0x69,
	0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e,
	0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x1f, 0x73, 0x71, 0x6c, 0x4d, 0x69, 0x6e, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x88, 0x01, 0x01, 0x22, 0x59, 0x0a, 0x11, 0x53, 0x71,
	0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x44, 0x49,
	0x53, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x46, 0x54, 0x5f, 0x53, 0x48, 0x55, 0x54, 0x44,
	0x4f, 0x57, 0x4e, 0x10, 0x02, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x6f, 0x75,
	0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x27, 0x0a, 0x25, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x22, 0xb0, 0x01, 0x0a, 0x10, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a,
	0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x55, 0x4e, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45,
	0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x07, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x22, 0xdc, 0x03, 0x0a, 0x2c, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x6f, 0x64, 0x79, 0x12, 0x6c, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x1a, 0xcd, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x79, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x2e, 0x52, 0x65, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x6e, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54,
	0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x41, 0x56, 0x41, 0x49,
	0x4c, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10,
	0x03, 0x22, 0xca, 0x02, 0x0a, 0x13, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x52, 0x0a,
	0x17, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x67, 0x74, 0x69, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x47, 0x74, 0x69, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x79, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x15, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x6b, 0x69, 0x70,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x73, 0x6b, 0x69, 0x70, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x22, 0x50,
	0x0a, 0x0f, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x22, 0x89, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x22, 0x0a,
	0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x49,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x4e, 0x0a, 0x15,
	0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6e, 0x65, 0x78, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x0a, 0x12,
	0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x82, 0x08, 0x0a, 0x1b, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x64, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x22, 0xd0, 0x06, 0x0a, 0x1f, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x30, 0x53, 0x51, 0x4c, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x53, 0x45, 0x54,
	0x54, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a,
	0x12, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x55, 0x52, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x49, 0x4e, 0x4c, 0x4f, 0x47, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x21, 0x0a,
	0x1d, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x03,
	0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x41, 0x4c, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x49,
	0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52, 0x49, 0x56,
	0x49, 0x4c, 0x45, 0x47, 0x45, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x4f, 0x5f, 0x50, 0x47,
	0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x47, 0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x45, 0x58,
	0x49, 0x53, 0x54, 0x53, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x57, 0x41, 0x4c, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x09, 0x12, 0x22, 0x0a,
	0x1e, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f,
	0x50, 0x52, 0x45, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x10,
	0x0a, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e,
	0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x53, 0x10, 0x0b, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x53,
	0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x57, 0x41,
	0x4c, 0x5f, 0x53, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x25, 0x0a, 0x21, 0x49,
	0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f,
	0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45, 0x53,
	0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x0e, 0x12, 0x23,
	0x0a, 0x1f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x44, 0x53, 0x5f, 0x4c, 0x4f,
	0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x0f, 0x12, 0x19, 0x0a, 0x15, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x4c,
	0x4f, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x10, 0x12, 0x14,
	0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x44, 0x42, 0x5f, 0x50, 0x41, 0x52,
	0x41, 0x4d, 0x10, 0x11, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x5f, 0x47, 0x54, 0x49, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x12, 0x12,
	0x1f, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x47, 0x45,
	0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x13,
	0x12, 0x20, 0x0a, 0x1c, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x14, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x15, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x4e,
	0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x16, 0x12, 0x19,
	0x0a, 0x15, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44,
	0x59, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x17, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x4e, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x49, 0x4e, 0x4c, 0x4f, 0x47, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x18, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x49, 0x4e, 0x4c,
	0x4f, 0x47, 0x5f, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x19, 0x22, 0xee, 0x02, 0x0a, 0x17, 0x4f, 0x6e, 0x50, 0x72, 0x65,
	0x6d, 0x69, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79,
	0x12, 0x24, 0x0a, 0x0e, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x75, 0x6d, 0x70, 0x46, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4f, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xdf, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x12, 0x6e, 0x0a, 0x1b, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x6d, 0x79, 0x73, 0x71, 0x6c,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2a, 0x81, 0x01, 0x0a, 0x0f, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a,
	0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x4e, 0x5f, 0x50,
	0x52, 0x45, 0x4d, 0x49, 0x53, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49,
	0x43, 0x41, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x2a, 0x8a, 0x01,
	0x0a, 0x13, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x53,
	0x50, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x03,
	0x12, 0x15, 0x0a, 0x11, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f,
	0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x4b, 0x4d, 0x53, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x05, 0x32, 0x97, 0x22, 0x0a, 0x13, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xa3, 0x01, 0x0a, 0x0b, 0x41, 0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x61, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x22,
	0x37, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x61, 0x64, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x12, 0x97, 0x01, 0x0a, 0x05, 0x43, 0x6c, 0x6f,
	0x6e, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x3a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x12, 0x8d, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x33, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x12, 0xac, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x40, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x12, 0x9a, 0x01, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa0,
	0x01, 0x0a, 0x08, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x46, 0x61,
	0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x3a, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x12, 0x8e, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x12, 0x9a, 0x01, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12,
	0x88, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x28, 0x22, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x8a, 0x01, 0x0a, 0x04, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x28, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xbe, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x05, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x32, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xac, 0x01, 0x0a,
	0x0e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22,
	0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0xac, 0x01, 0x0a, 0x0e,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x97, 0x01, 0x0a, 0x07, 0x52,
	0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x12, 0xaf, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xb2, 0x01, 0x0a, 0x0e, 0x52, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa6, 0x01, 0x0a, 0x0c,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x12, 0xa3, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73,
	0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0xa9, 0x01, 0x0a, 0x0b, 0x54,
	0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67,
	0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x93, 0x01, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x1a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xb7, 0x01, 0x0a,
	0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72,
	0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x22, 0x49, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x43, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c,
	0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xc7, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x12, 0xf8, 0x01, 0x0a, 0x1a, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b,
	0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xb8, 0x01, 0x0a, 0x11,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e,
	0x63, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53,
	0x79, 0x6e, 0x63, 0x3a, 0x01, 0x2a, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x42, 0x69, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x42,
	0x14, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x71, 0x6c, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescData = file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDesc
)

func file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescData)
	})
	return file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDescData
}

var file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes = make([]protoimpl.MessageInfo, 53)
var file_google_cloud_sql_v1_cloud_sql_instances_proto_goTypes = []interface{}{
	(SqlInstanceType)(0),     // 0: google.cloud.sql.v1.SqlInstanceType
	(SqlSuspensionReason)(0), // 1: google.cloud.sql.v1.SqlSuspensionReason
	(SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode)(0), // 2: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	(DatabaseInstance_SqlInstanceState)(0),                              // 3: google.cloud.sql.v1.DatabaseInstance.SqlInstanceState
	(DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState)(0),          // 4: google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport.SqlOutOfDiskState
	(SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType)(0),    // 5: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.RescheduleType
	(SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType)(0),    // 6: google.cloud.sql.v1.SqlExternalSyncSettingError.SqlExternalSyncSettingErrorType
	(*SqlInstancesAddServerCaRequest)(nil),                              // 7: google.cloud.sql.v1.SqlInstancesAddServerCaRequest
	(*SqlInstancesCloneRequest)(nil),                                    // 8: google.cloud.sql.v1.SqlInstancesCloneRequest
	(*SqlInstancesDeleteRequest)(nil),                                   // 9: google.cloud.sql.v1.SqlInstancesDeleteRequest
	(*SqlInstancesDemoteMasterRequest)(nil),                             // 10: google.cloud.sql.v1.SqlInstancesDemoteMasterRequest
	(*SqlInstancesExportRequest)(nil),                                   // 11: google.cloud.sql.v1.SqlInstancesExportRequest
	(*SqlInstancesFailoverRequest)(nil),                                 // 12: google.cloud.sql.v1.SqlInstancesFailoverRequest
	(*SqlInstancesGetRequest)(nil),                                      // 13: google.cloud.sql.v1.SqlInstancesGetRequest
	(*SqlInstancesImportRequest)(nil),                                   // 14: google.cloud.sql.v1.SqlInstancesImportRequest
	(*SqlInstancesInsertRequest)(nil),                                   // 15: google.cloud.sql.v1.SqlInstancesInsertRequest
	(*SqlInstancesListRequest)(nil),                                     // 16: google.cloud.sql.v1.SqlInstancesListRequest
	(*SqlInstancesListServerCasRequest)(nil),                            // 17: google.cloud.sql.v1.SqlInstancesListServerCasRequest
	(*SqlInstancesPatchRequest)(nil),                                    // 18: google.cloud.sql.v1.SqlInstancesPatchRequest
	(*SqlInstancesPromoteReplicaRequest)(nil),                           // 19: google.cloud.sql.v1.SqlInstancesPromoteReplicaRequest
	(*SqlInstancesResetSslConfigRequest)(nil),                           // 20: google.cloud.sql.v1.SqlInstancesResetSslConfigRequest
	(*SqlInstancesRestartRequest)(nil),                                  // 21: google.cloud.sql.v1.SqlInstancesRestartRequest
	(*SqlInstancesRestoreBackupRequest)(nil),                            // 22: google.cloud.sql.v1.SqlInstancesRestoreBackupRequest
	(*SqlInstancesRotateServerCaRequest)(nil),                           // 23: google.cloud.sql.v1.SqlInstancesRotateServerCaRequest
	(*SqlInstancesStartReplicaRequest)(nil),                             // 24: google.cloud.sql.v1.SqlInstancesStartReplicaRequest
	(*SqlInstancesStopReplicaRequest)(nil),                              // 25: google.cloud.sql.v1.SqlInstancesStopReplicaRequest
	(*SqlInstancesTruncateLogRequest)(nil),                              // 26: google.cloud.sql.v1.SqlInstancesTruncateLogRequest
	(*SqlInstancesUpdateRequest)(nil),                                   // 27: google.cloud.sql.v1.SqlInstancesUpdateRequest
	(*SqlInstancesRescheduleMaintenanceRequest)(nil),                    // 28: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequest
	(*SqlInstancesVerifyExternalSyncSettingsRequest)(nil),               // 29: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest
	(*SqlInstancesStartExternalSyncRequest)(nil),                        // 30: google.cloud.sql.v1.SqlInstancesStartExternalSyncRequest
	(*SqlInstancesCreateEphemeralCertRequest)(nil),                      // 31: google.cloud.sql.v1.SqlInstancesCreateEphemeralCertRequest
	(*InstancesCloneRequest)(nil),                                       // 32: google.cloud.sql.v1.InstancesCloneRequest
	(*InstancesDemoteMasterRequest)(nil),                                // 33: google.cloud.sql.v1.InstancesDemoteMasterRequest
	(*InstancesExportRequest)(nil),                                      // 34: google.cloud.sql.v1.InstancesExportRequest
	(*InstancesFailoverRequest)(nil),                                    // 35: google.cloud.sql.v1.InstancesFailoverRequest
	(*SslCertsCreateEphemeralRequest)(nil),                              // 36: google.cloud.sql.v1.SslCertsCreateEphemeralRequest
	(*InstancesImportRequest)(nil),                                      // 37: google.cloud.sql.v1.InstancesImportRequest
	(*InstancesListResponse)(nil),                                       // 38: google.cloud.sql.v1.InstancesListResponse
	(*InstancesListServerCasResponse)(nil),                              // 39: google.cloud.sql.v1.InstancesListServerCasResponse
	(*InstancesRestoreBackupRequest)(nil),                               // 40: google.cloud.sql.v1.InstancesRestoreBackupRequest
	(*InstancesRotateServerCaRequest)(nil),                              // 41: google.cloud.sql.v1.InstancesRotateServerCaRequest
	(*InstancesTruncateLogRequest)(nil),                                 // 42: google.cloud.sql.v1.InstancesTruncateLogRequest
	(*SqlInstancesVerifyExternalSyncSettingsResponse)(nil),              // 43: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsResponse
	(*CloneContext)(nil),                                                // 44: google.cloud.sql.v1.CloneContext
	(*BinLogCoordinates)(nil),                                           // 45: google.cloud.sql.v1.BinLogCoordinates
	(*DatabaseInstance)(nil),                                            // 46: google.cloud.sql.v1.DatabaseInstance
	(*SqlInstancesRescheduleMaintenanceRequestBody)(nil),                // 47: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody
	(*DemoteMasterContext)(nil),                                         // 48: google.cloud.sql.v1.DemoteMasterContext
	(*FailoverContext)(nil),                                             // 49: google.cloud.sql.v1.FailoverContext
	(*RestoreBackupContext)(nil),                                        // 50: google.cloud.sql.v1.RestoreBackupContext
	(*RotateServerCaContext)(nil),                                       // 51: google.cloud.sql.v1.RotateServerCaContext
	(*TruncateLogContext)(nil),                                          // 52: google.cloud.sql.v1.TruncateLogContext
	(*SqlExternalSyncSettingError)(nil),                                 // 53: google.cloud.sql.v1.SqlExternalSyncSettingError
	(*OnPremisesConfiguration)(nil),                                     // 54: google.cloud.sql.v1.OnPremisesConfiguration
	(*ReplicaConfiguration)(nil),                                        // 55: google.cloud.sql.v1.ReplicaConfiguration
	(*DatabaseInstance_SqlFailoverReplica)(nil),                         // 56: google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica
	(*DatabaseInstance_SqlScheduledMaintenance)(nil),                    // 57: google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance
	(*DatabaseInstance_SqlOutOfDiskReport)(nil),                         // 58: google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport
	(*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule)(nil),     // 59: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule
	(*MySqlSyncConfig)(nil),                                             // 60: google.cloud.sql.v1.MySqlSyncConfig
	(*ExportContext)(nil),                                               // 61: google.cloud.sql.v1.ExportContext
	(*ImportContext)(nil),                                               // 62: google.cloud.sql.v1.ImportContext
	(*ApiWarning)(nil),                                                  // 63: google.cloud.sql.v1.ApiWarning
	(*SslCert)(nil),                                                     // 64: google.cloud.sql.v1.SslCert
	(*timestamppb.Timestamp)(nil),                                       // 65: google.protobuf.Timestamp
	(SqlDatabaseVersion)(0),                                             // 66: google.cloud.sql.v1.SqlDatabaseVersion
	(*Settings)(nil),                                                    // 67: google.cloud.sql.v1.Settings
	(*wrapperspb.Int64Value)(nil),                                       // 68: google.protobuf.Int64Value
	(*IpMapping)(nil),                                                   // 69: google.cloud.sql.v1.IpMapping
	(SqlBackendType)(0),                                                 // 70: google.cloud.sql.v1.SqlBackendType
	(*DiskEncryptionConfiguration)(nil),                                 // 71: google.cloud.sql.v1.DiskEncryptionConfiguration
	(*DiskEncryptionStatus)(nil),                                        // 72: google.cloud.sql.v1.DiskEncryptionStatus
	(*wrapperspb.BoolValue)(nil),                                        // 73: google.protobuf.BoolValue
	(*DemoteMasterConfiguration)(nil),                                   // 74: google.cloud.sql.v1.DemoteMasterConfiguration
	(*InstanceReference)(nil),                                           // 75: google.cloud.sql.v1.InstanceReference
	(*MySqlReplicaConfiguration)(nil),                                   // 76: google.cloud.sql.v1.MySqlReplicaConfiguration
	(*Operation)(nil),                                                   // 77: google.cloud.sql.v1.Operation
}
var file_google_cloud_sql_v1_cloud_sql_instances_proto_depIdxs = []int32{
	32, // 0: google.cloud.sql.v1.SqlInstancesCloneRequest.body:type_name -> google.cloud.sql.v1.InstancesCloneRequest
	33, // 1: google.cloud.sql.v1.SqlInstancesDemoteMasterRequest.body:type_name -> google.cloud.sql.v1.InstancesDemoteMasterRequest
	34, // 2: google.cloud.sql.v1.SqlInstancesExportRequest.body:type_name -> google.cloud.sql.v1.InstancesExportRequest
	35, // 3: google.cloud.sql.v1.SqlInstancesFailoverRequest.body:type_name -> google.cloud.sql.v1.InstancesFailoverRequest
	37, // 4: google.cloud.sql.v1.SqlInstancesImportRequest.body:type_name -> google.cloud.sql.v1.InstancesImportRequest
	46, // 5: google.cloud.sql.v1.SqlInstancesInsertRequest.body:type_name -> google.cloud.sql.v1.DatabaseInstance
	46, // 6: google.cloud.sql.v1.SqlInstancesPatchRequest.body:type_name -> google.cloud.sql.v1.DatabaseInstance
	40, // 7: google.cloud.sql.v1.SqlInstancesRestoreBackupRequest.body:type_name -> google.cloud.sql.v1.InstancesRestoreBackupRequest
	41, // 8: google.cloud.sql.v1.SqlInstancesRotateServerCaRequest.body:type_name -> google.cloud.sql.v1.InstancesRotateServerCaRequest
	42, // 9: google.cloud.sql.v1.SqlInstancesTruncateLogRequest.body:type_name -> google.cloud.sql.v1.InstancesTruncateLogRequest
	46, // 10: google.cloud.sql.v1.SqlInstancesUpdateRequest.body:type_name -> google.cloud.sql.v1.DatabaseInstance
	47, // 11: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequest.body:type_name -> google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody
	2,  // 12: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest.sync_mode:type_name -> google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	60, // 13: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest.mysql_sync_config:type_name -> google.cloud.sql.v1.MySqlSyncConfig
	2,  // 14: google.cloud.sql.v1.SqlInstancesStartExternalSyncRequest.sync_mode:type_name -> google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	60, // 15: google.cloud.sql.v1.SqlInstancesStartExternalSyncRequest.mysql_sync_config:type_name -> google.cloud.sql.v1.MySqlSyncConfig
	36, // 16: google.cloud.sql.v1.SqlInstancesCreateEphemeralCertRequest.body:type_name -> google.cloud.sql.v1.SslCertsCreateEphemeralRequest
	44, // 17: google.cloud.sql.v1.InstancesCloneRequest.clone_context:type_name -> google.cloud.sql.v1.CloneContext
	48, // 18: google.cloud.sql.v1.InstancesDemoteMasterRequest.demote_master_context:type_name -> google.cloud.sql.v1.DemoteMasterContext
	61, // 19: google.cloud.sql.v1.InstancesExportRequest.export_context:type_name -> google.cloud.sql.v1.ExportContext
	49, // 20: google.cloud.sql.v1.InstancesFailoverRequest.failover_context:type_name -> google.cloud.sql.v1.FailoverContext
	62, // 21: google.cloud.sql.v1.InstancesImportRequest.import_context:type_name -> google.cloud.sql.v1.ImportContext
	63, // 22: google.cloud.sql.v1.InstancesListResponse.warnings:type_name -> google.cloud.sql.v1.ApiWarning
	46, // 23: google.cloud.sql.v1.InstancesListResponse.items:type_name -> google.cloud.sql.v1.DatabaseInstance
	64, // 24: google.cloud.sql.v1.InstancesListServerCasResponse.certs:type_name -> google.cloud.sql.v1.SslCert
	50, // 25: google.cloud.sql.v1.InstancesRestoreBackupRequest.restore_backup_context:type_name -> google.cloud.sql.v1.RestoreBackupContext
	51, // 26: google.cloud.sql.v1.InstancesRotateServerCaRequest.rotate_server_ca_context:type_name -> google.cloud.sql.v1.RotateServerCaContext
	52, // 27: google.cloud.sql.v1.InstancesTruncateLogRequest.truncate_log_context:type_name -> google.cloud.sql.v1.TruncateLogContext
	53, // 28: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsResponse.errors:type_name -> google.cloud.sql.v1.SqlExternalSyncSettingError
	53, // 29: google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsResponse.warnings:type_name -> google.cloud.sql.v1.SqlExternalSyncSettingError
	45, // 30: google.cloud.sql.v1.CloneContext.bin_log_coordinates:type_name -> google.cloud.sql.v1.BinLogCoordinates
	65, // 31: google.cloud.sql.v1.CloneContext.point_in_time:type_name -> google.protobuf.Timestamp
	3,  // 32: google.cloud.sql.v1.DatabaseInstance.state:type_name -> google.cloud.sql.v1.DatabaseInstance.SqlInstanceState
	66, // 33: google.cloud.sql.v1.DatabaseInstance.database_version:type_name -> google.cloud.sql.v1.SqlDatabaseVersion
	67, // 34: google.cloud.sql.v1.DatabaseInstance.settings:type_name -> google.cloud.sql.v1.Settings
	56, // 35: google.cloud.sql.v1.DatabaseInstance.failover_replica:type_name -> google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica
	68, // 36: google.cloud.sql.v1.DatabaseInstance.max_disk_size:type_name -> google.protobuf.Int64Value
	68, // 37: google.cloud.sql.v1.DatabaseInstance.current_disk_size:type_name -> google.protobuf.Int64Value
	69, // 38: google.cloud.sql.v1.DatabaseInstance.ip_addresses:type_name -> google.cloud.sql.v1.IpMapping
	64, // 39: google.cloud.sql.v1.DatabaseInstance.server_ca_cert:type_name -> google.cloud.sql.v1.SslCert
	0,  // 40: google.cloud.sql.v1.DatabaseInstance.instance_type:type_name -> google.cloud.sql.v1.SqlInstanceType
	54, // 41: google.cloud.sql.v1.DatabaseInstance.on_premises_configuration:type_name -> google.cloud.sql.v1.OnPremisesConfiguration
	55, // 42: google.cloud.sql.v1.DatabaseInstance.replica_configuration:type_name -> google.cloud.sql.v1.ReplicaConfiguration
	70, // 43: google.cloud.sql.v1.DatabaseInstance.backend_type:type_name -> google.cloud.sql.v1.SqlBackendType
	1,  // 44: google.cloud.sql.v1.DatabaseInstance.suspension_reason:type_name -> google.cloud.sql.v1.SqlSuspensionReason
	71, // 45: google.cloud.sql.v1.DatabaseInstance.disk_encryption_configuration:type_name -> google.cloud.sql.v1.DiskEncryptionConfiguration
	72, // 46: google.cloud.sql.v1.DatabaseInstance.disk_encryption_status:type_name -> google.cloud.sql.v1.DiskEncryptionStatus
	57, // 47: google.cloud.sql.v1.DatabaseInstance.scheduled_maintenance:type_name -> google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance
	73, // 48: google.cloud.sql.v1.DatabaseInstance.satisfies_pzs:type_name -> google.protobuf.BoolValue
	58, // 49: google.cloud.sql.v1.DatabaseInstance.out_of_disk_report:type_name -> google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport
	65, // 50: google.cloud.sql.v1.DatabaseInstance.create_time:type_name -> google.protobuf.Timestamp
	59, // 51: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.reschedule:type_name -> google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule
	73, // 52: google.cloud.sql.v1.DemoteMasterContext.verify_gtid_consistency:type_name -> google.protobuf.BoolValue
	74, // 53: google.cloud.sql.v1.DemoteMasterContext.replica_configuration:type_name -> google.cloud.sql.v1.DemoteMasterConfiguration
	6,  // 54: google.cloud.sql.v1.SqlExternalSyncSettingError.type:type_name -> google.cloud.sql.v1.SqlExternalSyncSettingError.SqlExternalSyncSettingErrorType
	75, // 55: google.cloud.sql.v1.OnPremisesConfiguration.source_instance:type_name -> google.cloud.sql.v1.InstanceReference
	76, // 56: google.cloud.sql.v1.ReplicaConfiguration.mysql_replica_configuration:type_name -> google.cloud.sql.v1.MySqlReplicaConfiguration
	73, // 57: google.cloud.sql.v1.ReplicaConfiguration.failover_target:type_name -> google.protobuf.BoolValue
	73, // 58: google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica.available:type_name -> google.protobuf.BoolValue
	65, // 59: google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance.start_time:type_name -> google.protobuf.Timestamp
	65, // 60: google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance.schedule_deadline_time:type_name -> google.protobuf.Timestamp
	4,  // 61: google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport.sql_out_of_disk_state:type_name -> google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport.SqlOutOfDiskState
	5,  // 62: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule.reschedule_type:type_name -> google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.RescheduleType
	65, // 63: google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule.schedule_time:type_name -> google.protobuf.Timestamp
	7,  // 64: google.cloud.sql.v1.SqlInstancesService.AddServerCa:input_type -> google.cloud.sql.v1.SqlInstancesAddServerCaRequest
	8,  // 65: google.cloud.sql.v1.SqlInstancesService.Clone:input_type -> google.cloud.sql.v1.SqlInstancesCloneRequest
	9,  // 66: google.cloud.sql.v1.SqlInstancesService.Delete:input_type -> google.cloud.sql.v1.SqlInstancesDeleteRequest
	10, // 67: google.cloud.sql.v1.SqlInstancesService.DemoteMaster:input_type -> google.cloud.sql.v1.SqlInstancesDemoteMasterRequest
	11, // 68: google.cloud.sql.v1.SqlInstancesService.Export:input_type -> google.cloud.sql.v1.SqlInstancesExportRequest
	12, // 69: google.cloud.sql.v1.SqlInstancesService.Failover:input_type -> google.cloud.sql.v1.SqlInstancesFailoverRequest
	13, // 70: google.cloud.sql.v1.SqlInstancesService.Get:input_type -> google.cloud.sql.v1.SqlInstancesGetRequest
	14, // 71: google.cloud.sql.v1.SqlInstancesService.Import:input_type -> google.cloud.sql.v1.SqlInstancesImportRequest
	15, // 72: google.cloud.sql.v1.SqlInstancesService.Insert:input_type -> google.cloud.sql.v1.SqlInstancesInsertRequest
	16, // 73: google.cloud.sql.v1.SqlInstancesService.List:input_type -> google.cloud.sql.v1.SqlInstancesListRequest
	17, // 74: google.cloud.sql.v1.SqlInstancesService.ListServerCas:input_type -> google.cloud.sql.v1.SqlInstancesListServerCasRequest
	18, // 75: google.cloud.sql.v1.SqlInstancesService.Patch:input_type -> google.cloud.sql.v1.SqlInstancesPatchRequest
	19, // 76: google.cloud.sql.v1.SqlInstancesService.PromoteReplica:input_type -> google.cloud.sql.v1.SqlInstancesPromoteReplicaRequest
	20, // 77: google.cloud.sql.v1.SqlInstancesService.ResetSslConfig:input_type -> google.cloud.sql.v1.SqlInstancesResetSslConfigRequest
	21, // 78: google.cloud.sql.v1.SqlInstancesService.Restart:input_type -> google.cloud.sql.v1.SqlInstancesRestartRequest
	22, // 79: google.cloud.sql.v1.SqlInstancesService.RestoreBackup:input_type -> google.cloud.sql.v1.SqlInstancesRestoreBackupRequest
	23, // 80: google.cloud.sql.v1.SqlInstancesService.RotateServerCa:input_type -> google.cloud.sql.v1.SqlInstancesRotateServerCaRequest
	24, // 81: google.cloud.sql.v1.SqlInstancesService.StartReplica:input_type -> google.cloud.sql.v1.SqlInstancesStartReplicaRequest
	25, // 82: google.cloud.sql.v1.SqlInstancesService.StopReplica:input_type -> google.cloud.sql.v1.SqlInstancesStopReplicaRequest
	26, // 83: google.cloud.sql.v1.SqlInstancesService.TruncateLog:input_type -> google.cloud.sql.v1.SqlInstancesTruncateLogRequest
	27, // 84: google.cloud.sql.v1.SqlInstancesService.Update:input_type -> google.cloud.sql.v1.SqlInstancesUpdateRequest
	31, // 85: google.cloud.sql.v1.SqlInstancesService.CreateEphemeral:input_type -> google.cloud.sql.v1.SqlInstancesCreateEphemeralCertRequest
	28, // 86: google.cloud.sql.v1.SqlInstancesService.RescheduleMaintenance:input_type -> google.cloud.sql.v1.SqlInstancesRescheduleMaintenanceRequest
	29, // 87: google.cloud.sql.v1.SqlInstancesService.VerifyExternalSyncSettings:input_type -> google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsRequest
	30, // 88: google.cloud.sql.v1.SqlInstancesService.StartExternalSync:input_type -> google.cloud.sql.v1.SqlInstancesStartExternalSyncRequest
	77, // 89: google.cloud.sql.v1.SqlInstancesService.AddServerCa:output_type -> google.cloud.sql.v1.Operation
	77, // 90: google.cloud.sql.v1.SqlInstancesService.Clone:output_type -> google.cloud.sql.v1.Operation
	77, // 91: google.cloud.sql.v1.SqlInstancesService.Delete:output_type -> google.cloud.sql.v1.Operation
	77, // 92: google.cloud.sql.v1.SqlInstancesService.DemoteMaster:output_type -> google.cloud.sql.v1.Operation
	77, // 93: google.cloud.sql.v1.SqlInstancesService.Export:output_type -> google.cloud.sql.v1.Operation
	77, // 94: google.cloud.sql.v1.SqlInstancesService.Failover:output_type -> google.cloud.sql.v1.Operation
	46, // 95: google.cloud.sql.v1.SqlInstancesService.Get:output_type -> google.cloud.sql.v1.DatabaseInstance
	77, // 96: google.cloud.sql.v1.SqlInstancesService.Import:output_type -> google.cloud.sql.v1.Operation
	77, // 97: google.cloud.sql.v1.SqlInstancesService.Insert:output_type -> google.cloud.sql.v1.Operation
	38, // 98: google.cloud.sql.v1.SqlInstancesService.List:output_type -> google.cloud.sql.v1.InstancesListResponse
	39, // 99: google.cloud.sql.v1.SqlInstancesService.ListServerCas:output_type -> google.cloud.sql.v1.InstancesListServerCasResponse
	77, // 100: google.cloud.sql.v1.SqlInstancesService.Patch:output_type -> google.cloud.sql.v1.Operation
	77, // 101: google.cloud.sql.v1.SqlInstancesService.PromoteReplica:output_type -> google.cloud.sql.v1.Operation
	77, // 102: google.cloud.sql.v1.SqlInstancesService.ResetSslConfig:output_type -> google.cloud.sql.v1.Operation
	77, // 103: google.cloud.sql.v1.SqlInstancesService.Restart:output_type -> google.cloud.sql.v1.Operation
	77, // 104: google.cloud.sql.v1.SqlInstancesService.RestoreBackup:output_type -> google.cloud.sql.v1.Operation
	77, // 105: google.cloud.sql.v1.SqlInstancesService.RotateServerCa:output_type -> google.cloud.sql.v1.Operation
	77, // 106: google.cloud.sql.v1.SqlInstancesService.StartReplica:output_type -> google.cloud.sql.v1.Operation
	77, // 107: google.cloud.sql.v1.SqlInstancesService.StopReplica:output_type -> google.cloud.sql.v1.Operation
	77, // 108: google.cloud.sql.v1.SqlInstancesService.TruncateLog:output_type -> google.cloud.sql.v1.Operation
	77, // 109: google.cloud.sql.v1.SqlInstancesService.Update:output_type -> google.cloud.sql.v1.Operation
	64, // 110: google.cloud.sql.v1.SqlInstancesService.CreateEphemeral:output_type -> google.cloud.sql.v1.SslCert
	77, // 111: google.cloud.sql.v1.SqlInstancesService.RescheduleMaintenance:output_type -> google.cloud.sql.v1.Operation
	43, // 112: google.cloud.sql.v1.SqlInstancesService.VerifyExternalSyncSettings:output_type -> google.cloud.sql.v1.SqlInstancesVerifyExternalSyncSettingsResponse
	77, // 113: google.cloud.sql.v1.SqlInstancesService.StartExternalSync:output_type -> google.cloud.sql.v1.Operation
	89, // [89:114] is the sub-list for method output_type
	64, // [64:89] is the sub-list for method input_type
	64, // [64:64] is the sub-list for extension type_name
	64, // [64:64] is the sub-list for extension extendee
	0,  // [0:64] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1_cloud_sql_instances_proto_init() }
func file_google_cloud_sql_v1_cloud_sql_instances_proto_init() {
	if File_google_cloud_sql_v1_cloud_sql_instances_proto != nil {
		return
	}
	file_google_cloud_sql_v1_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesAddServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesCloneRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesDemoteMasterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesFailoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesListServerCasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesPatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesPromoteReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesResetSslConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRestartRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRestoreBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRotateServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStartReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStopReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesTruncateLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesVerifyExternalSyncSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStartExternalSyncRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesCreateEphemeralCertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesCloneRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesDemoteMasterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesFailoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsCreateEphemeralRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesListServerCasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesRestoreBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesRotateServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesTruncateLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesVerifyExternalSyncSettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloneContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinLogCoordinates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequestBody); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailoverContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreBackupContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RotateServerCaContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncateLogContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlExternalSyncSettingError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnPremisesConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlFailoverReplica); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlScheduledMaintenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlOutOfDiskReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig)(nil),
	}
	file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig)(nil),
	}
	file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[39].OneofWrappers = []interface{}{}
	file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[50].OneofWrappers = []interface{}{}
	file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes[51].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   53,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1_cloud_sql_instances_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1_cloud_sql_instances_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1_cloud_sql_instances_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1_cloud_sql_instances_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1_cloud_sql_instances_proto = out.File
	file_google_cloud_sql_v1_cloud_sql_instances_proto_rawDesc = nil
	file_google_cloud_sql_v1_cloud_sql_instances_proto_goTypes = nil
	file_google_cloud_sql_v1_cloud_sql_instances_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlInstancesServiceClient is the client API for SqlInstancesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlInstancesServiceClient interface {
	// Adds a new trusted Certificate Authority (CA) version for the specified
	// instance. Required to prepare for a certificate rotation. If a CA version
	// was previously added but never used in a certificate rotation, this
	// operation replaces that version. There cannot be more than one CA version
	// waiting to be rotated in.
	AddServerCa(ctx context.Context, in *SqlInstancesAddServerCaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a Cloud SQL instance as a clone of the source instance. Using this
	// operation might cause your instance to restart.
	Clone(ctx context.Context, in *SqlInstancesCloneRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a Cloud SQL instance.
	Delete(ctx context.Context, in *SqlInstancesDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Demotes the stand-alone instance to be a Cloud SQL read replica for an
	// external database server.
	DemoteMaster(ctx context.Context, in *SqlInstancesDemoteMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL
	// dump or CSV file.
	Export(ctx context.Context, in *SqlInstancesExportRequest, opts ...grpc.CallOption) (*Operation, error)
	// Initiates a manual failover of a high availability (HA) primary instance
	// to a standby instance, which becomes the primary instance. Users are
	// then rerouted to the new primary. For more information, see the
	// [Overview of high
	// availability](https://cloud.google.com/sql/docs/mysql/high-availability)
	// page in the Cloud SQL documentation.
	// If using Legacy HA (MySQL only), this causes the instance to failover to
	// its failover replica instance.
	Failover(ctx context.Context, in *SqlInstancesFailoverRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a Cloud SQL instance.
	Get(ctx context.Context, in *SqlInstancesGetRequest, opts ...grpc.CallOption) (*DatabaseInstance, error)
	// Imports data into a Cloud SQL instance from a SQL dump  or CSV file in
	// Cloud Storage.
	Import(ctx context.Context, in *SqlInstancesImportRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a new Cloud SQL instance.
	Insert(ctx context.Context, in *SqlInstancesInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists instances under a given project.
	List(ctx context.Context, in *SqlInstancesListRequest, opts ...grpc.CallOption) (*InstancesListResponse, error)
	// Lists all of the trusted Certificate Authorities (CAs) for the specified
	// instance. There can be up to three CAs listed: the CA that was used to sign
	// the certificate that is currently in use, a CA that has been added but not
	// yet used to sign a certificate, and a CA used to sign a certificate that
	// has previously rotated out.
	ListServerCas(ctx context.Context, in *SqlInstancesListServerCasRequest, opts ...grpc.CallOption) (*InstancesListServerCasResponse, error)
	// Updates settings of a Cloud SQL instance.
	// This method supports patch semantics.
	Patch(ctx context.Context, in *SqlInstancesPatchRequest, opts ...grpc.CallOption) (*Operation, error)
	// Promotes the read replica instance to be a stand-alone Cloud SQL instance.
	// Using this operation might cause your instance to restart.
	PromoteReplica(ctx context.Context, in *SqlInstancesPromoteReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes all client certificates and generates a new server SSL certificate
	// for the instance.
	ResetSslConfig(ctx context.Context, in *SqlInstancesResetSslConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Restarts a Cloud SQL instance.
	Restart(ctx context.Context, in *SqlInstancesRestartRequest, opts ...grpc.CallOption) (*Operation, error)
	// Restores a backup of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	RestoreBackup(ctx context.Context, in *SqlInstancesRestoreBackupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Rotates the server certificate to one signed by the Certificate Authority
	// (CA) version previously added with the addServerCA method.
	RotateServerCa(ctx context.Context, in *SqlInstancesRotateServerCaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts the replication in the read replica instance.
	StartReplica(ctx context.Context, in *SqlInstancesStartReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Stops the replication in the read replica instance.
	StopReplica(ctx context.Context, in *SqlInstancesStopReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Truncate MySQL general and slow query log tables
	// MySQL only.
	TruncateLog(ctx context.Context, in *SqlInstancesTruncateLogRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates settings of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	Update(ctx context.Context, in *SqlInstancesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	CreateEphemeral(ctx context.Context, in *SqlInstancesCreateEphemeralCertRequest, opts ...grpc.CallOption) (*SslCert, error)
	// Reschedules the maintenance on the given instance.
	RescheduleMaintenance(ctx context.Context, in *SqlInstancesRescheduleMaintenanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Verify External primary instance external sync settings.
	VerifyExternalSyncSettings(ctx context.Context, in *SqlInstancesVerifyExternalSyncSettingsRequest, opts ...grpc.CallOption) (*SqlInstancesVerifyExternalSyncSettingsResponse, error)
	// Start External primary instance migration.
	StartExternalSync(ctx context.Context, in *SqlInstancesStartExternalSyncRequest, opts ...grpc.CallOption) (*Operation, error)
}

type sqlInstancesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlInstancesServiceClient(cc grpc.ClientConnInterface) SqlInstancesServiceClient {
	return &sqlInstancesServiceClient{cc}
}

func (c *sqlInstancesServiceClient) AddServerCa(ctx context.Context, in *SqlInstancesAddServerCaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/AddServerCa", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Clone(ctx context.Context, in *SqlInstancesCloneRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Clone", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Delete(ctx context.Context, in *SqlInstancesDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) DemoteMaster(ctx context.Context, in *SqlInstancesDemoteMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/DemoteMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Export(ctx context.Context, in *SqlInstancesExportRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Export", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Failover(ctx context.Context, in *SqlInstancesFailoverRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Failover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Get(ctx context.Context, in *SqlInstancesGetRequest, opts ...grpc.CallOption) (*DatabaseInstance, error) {
	out := new(DatabaseInstance)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Import(ctx context.Context, in *SqlInstancesImportRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Import", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Insert(ctx context.Context, in *SqlInstancesInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) List(ctx context.Context, in *SqlInstancesListRequest, opts ...grpc.CallOption) (*InstancesListResponse, error) {
	out := new(InstancesListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) ListServerCas(ctx context.Context, in *SqlInstancesListServerCasRequest, opts ...grpc.CallOption) (*InstancesListServerCasResponse, error) {
	out := new(InstancesListServerCasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/ListServerCas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Patch(ctx context.Context, in *SqlInstancesPatchRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Patch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) PromoteReplica(ctx context.Context, in *SqlInstancesPromoteReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/PromoteReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) ResetSslConfig(ctx context.Context, in *SqlInstancesResetSslConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/ResetSslConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Restart(ctx context.Context, in *SqlInstancesRestartRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Restart", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RestoreBackup(ctx context.Context, in *SqlInstancesRestoreBackupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/RestoreBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RotateServerCa(ctx context.Context, in *SqlInstancesRotateServerCaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/RotateServerCa", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StartReplica(ctx context.Context, in *SqlInstancesStartReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/StartReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StopReplica(ctx context.Context, in *SqlInstancesStopReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/StopReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) TruncateLog(ctx context.Context, in *SqlInstancesTruncateLogRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/TruncateLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Update(ctx context.Context, in *SqlInstancesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) CreateEphemeral(ctx context.Context, in *SqlInstancesCreateEphemeralCertRequest, opts ...grpc.CallOption) (*SslCert, error) {
	out := new(SslCert)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/CreateEphemeral", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RescheduleMaintenance(ctx context.Context, in *SqlInstancesRescheduleMaintenanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/RescheduleMaintenance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) VerifyExternalSyncSettings(ctx context.Context, in *SqlInstancesVerifyExternalSyncSettingsRequest, opts ...grpc.CallOption) (*SqlInstancesVerifyExternalSyncSettingsResponse, error) {
	out := new(SqlInstancesVerifyExternalSyncSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/VerifyExternalSyncSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StartExternalSync(ctx context.Context, in *SqlInstancesStartExternalSyncRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlInstancesService/StartExternalSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlInstancesServiceServer is the server API for SqlInstancesService service.
type SqlInstancesServiceServer interface {
	// Adds a new trusted Certificate Authority (CA) version for the specified
	// instance. Required to prepare for a certificate rotation. If a CA version
	// was previously added but never used in a certificate rotation, this
	// operation replaces that version. There cannot be more than one CA version
	// waiting to be rotated in.
	AddServerCa(context.Context, *SqlInstancesAddServerCaRequest) (*Operation, error)
	// Creates a Cloud SQL instance as a clone of the source instance. Using this
	// operation might cause your instance to restart.
	Clone(context.Context, *SqlInstancesCloneRequest) (*Operation, error)
	// Deletes a Cloud SQL instance.
	Delete(context.Context, *SqlInstancesDeleteRequest) (*Operation, error)
	// Demotes the stand-alone instance to be a Cloud SQL read replica for an
	// external database server.
	DemoteMaster(context.Context, *SqlInstancesDemoteMasterRequest) (*Operation, error)
	// Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL
	// dump or CSV file.
	Export(context.Context, *SqlInstancesExportRequest) (*Operation, error)
	// Initiates a manual failover of a high availability (HA) primary instance
	// to a standby instance, which becomes the primary instance. Users are
	// then rerouted to the new primary. For more information, see the
	// [Overview of high
	// availability](https://cloud.google.com/sql/docs/mysql/high-availability)
	// page in the Cloud SQL documentation.
	// If using Legacy HA (MySQL only), this causes the instance to failover to
	// its failover replica instance.
	Failover(context.Context, *SqlInstancesFailoverRequest) (*Operation, error)
	// Retrieves a resource containing information about a Cloud SQL instance.
	Get(context.Context, *SqlInstancesGetRequest) (*DatabaseInstance, error)
	// Imports data into a Cloud SQL instance from a SQL dump  or CSV file in
	// Cloud Storage.
	Import(context.Context, *SqlInstancesImportRequest) (*Operation, error)
	// Creates a new Cloud SQL instance.
	Insert(context.Context, *SqlInstancesInsertRequest) (*Operation, error)
	// Lists instances under a given project.
	List(context.Context, *SqlInstancesListRequest) (*InstancesListResponse, error)
	// Lists all of the trusted Certificate Authorities (CAs) for the specified
	// instance. There can be up to three CAs listed: the CA that was used to sign
	// the certificate that is currently in use, a CA that has been added but not
	// yet used to sign a certificate, and a CA used to sign a certificate that
	// has previously rotated out.
	ListServerCas(context.Context, *SqlInstancesListServerCasRequest) (*InstancesListServerCasResponse, error)
	// Updates settings of a Cloud SQL instance.
	// This method supports patch semantics.
	Patch(context.Context, *SqlInstancesPatchRequest) (*Operation, error)
	// Promotes the read replica instance to be a stand-alone Cloud SQL instance.
	// Using this operation might cause your instance to restart.
	PromoteReplica(context.Context, *SqlInstancesPromoteReplicaRequest) (*Operation, error)
	// Deletes all client certificates and generates a new server SSL certificate
	// for the instance.
	ResetSslConfig(context.Context, *SqlInstancesResetSslConfigRequest) (*Operation, error)
	// Restarts a Cloud SQL instance.
	Restart(context.Context, *SqlInstancesRestartRequest) (*Operation, error)
	// Restores a backup of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	RestoreBackup(context.Context, *SqlInstancesRestoreBackupRequest) (*Operation, error)
	// Rotates the server certificate to one signed by the Certificate Authority
	// (CA) version previously added with the addServerCA method.
	RotateServerCa(context.Context, *SqlInstancesRotateServerCaRequest) (*Operation, error)
	// Starts the replication in the read replica instance.
	StartReplica(context.Context, *SqlInstancesStartReplicaRequest) (*Operation, error)
	// Stops the replication in the read replica instance.
	StopReplica(context.Context, *SqlInstancesStopReplicaRequest) (*Operation, error)
	// Truncate MySQL general and slow query log tables
	// MySQL only.
	TruncateLog(context.Context, *SqlInstancesTruncateLogRequest) (*Operation, error)
	// Updates settings of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	Update(context.Context, *SqlInstancesUpdateRequest) (*Operation, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	CreateEphemeral(context.Context, *SqlInstancesCreateEphemeralCertRequest) (*SslCert, error)
	// Reschedules the maintenance on the given instance.
	RescheduleMaintenance(context.Context, *SqlInstancesRescheduleMaintenanceRequest) (*Operation, error)
	// Verify External primary instance external sync settings.
	VerifyExternalSyncSettings(context.Context, *SqlInstancesVerifyExternalSyncSettingsRequest) (*SqlInstancesVerifyExternalSyncSettingsResponse, error)
	// Start External primary instance migration.
	StartExternalSync(context.Context, *SqlInstancesStartExternalSyncRequest) (*Operation, error)
}

// UnimplementedSqlInstancesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlInstancesServiceServer struct {
}

func (*UnimplementedSqlInstancesServiceServer) AddServerCa(context.Context, *SqlInstancesAddServerCaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddServerCa not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Clone(context.Context, *SqlInstancesCloneRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Clone not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Delete(context.Context, *SqlInstancesDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) DemoteMaster(context.Context, *SqlInstancesDemoteMasterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DemoteMaster not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Export(context.Context, *SqlInstancesExportRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Export not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Failover(context.Context, *SqlInstancesFailoverRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Failover not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Get(context.Context, *SqlInstancesGetRequest) (*DatabaseInstance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Import(context.Context, *SqlInstancesImportRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Import not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Insert(context.Context, *SqlInstancesInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) List(context.Context, *SqlInstancesListRequest) (*InstancesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) ListServerCas(context.Context, *SqlInstancesListServerCasRequest) (*InstancesListServerCasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServerCas not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Patch(context.Context, *SqlInstancesPatchRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) PromoteReplica(context.Context, *SqlInstancesPromoteReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) ResetSslConfig(context.Context, *SqlInstancesResetSslConfigRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetSslConfig not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Restart(context.Context, *SqlInstancesRestartRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restart not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RestoreBackup(context.Context, *SqlInstancesRestoreBackupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreBackup not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RotateServerCa(context.Context, *SqlInstancesRotateServerCaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RotateServerCa not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StartReplica(context.Context, *SqlInstancesStartReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StopReplica(context.Context, *SqlInstancesStopReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) TruncateLog(context.Context, *SqlInstancesTruncateLogRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TruncateLog not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Update(context.Context, *SqlInstancesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) CreateEphemeral(context.Context, *SqlInstancesCreateEphemeralCertRequest) (*SslCert, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEphemeral not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RescheduleMaintenance(context.Context, *SqlInstancesRescheduleMaintenanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RescheduleMaintenance not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) VerifyExternalSyncSettings(context.Context, *SqlInstancesVerifyExternalSyncSettingsRequest) (*SqlInstancesVerifyExternalSyncSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyExternalSyncSettings not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StartExternalSync(context.Context, *SqlInstancesStartExternalSyncRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartExternalSync not implemented")
}

func RegisterSqlInstancesServiceServer(s *grpc.Server, srv SqlInstancesServiceServer) {
	s.RegisterService(&_SqlInstancesService_serviceDesc, srv)
}

func _SqlInstancesService_AddServerCa_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesAddServerCaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).AddServerCa(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/AddServerCa",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).AddServerCa(ctx, req.(*SqlInstancesAddServerCaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Clone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesCloneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Clone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Clone",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Clone(ctx, req.(*SqlInstancesCloneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Delete(ctx, req.(*SqlInstancesDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_DemoteMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesDemoteMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).DemoteMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/DemoteMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).DemoteMaster(ctx, req.(*SqlInstancesDemoteMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Export_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Export(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Export",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Export(ctx, req.(*SqlInstancesExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Failover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Failover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Failover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Failover(ctx, req.(*SqlInstancesFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Get(ctx, req.(*SqlInstancesGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Import_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Import(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Import",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Import(ctx, req.(*SqlInstancesImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Insert(ctx, req.(*SqlInstancesInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).List(ctx, req.(*SqlInstancesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_ListServerCas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesListServerCasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).ListServerCas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/ListServerCas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).ListServerCas(ctx, req.(*SqlInstancesListServerCasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesPatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Patch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Patch(ctx, req.(*SqlInstancesPatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_PromoteReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesPromoteReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).PromoteReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/PromoteReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).PromoteReplica(ctx, req.(*SqlInstancesPromoteReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_ResetSslConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesResetSslConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).ResetSslConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/ResetSslConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).ResetSslConfig(ctx, req.(*SqlInstancesResetSslConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Restart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRestartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Restart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Restart",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Restart(ctx, req.(*SqlInstancesRestartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RestoreBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRestoreBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RestoreBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/RestoreBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RestoreBackup(ctx, req.(*SqlInstancesRestoreBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RotateServerCa_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRotateServerCaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RotateServerCa(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/RotateServerCa",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RotateServerCa(ctx, req.(*SqlInstancesRotateServerCaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StartReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStartReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StartReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/StartReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StartReplica(ctx, req.(*SqlInstancesStartReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StopReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStopReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StopReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/StopReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StopReplica(ctx, req.(*SqlInstancesStopReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_TruncateLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesTruncateLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).TruncateLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/TruncateLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).TruncateLog(ctx, req.(*SqlInstancesTruncateLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Update(ctx, req.(*SqlInstancesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_CreateEphemeral_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesCreateEphemeralCertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).CreateEphemeral(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/CreateEphemeral",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).CreateEphemeral(ctx, req.(*SqlInstancesCreateEphemeralCertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RescheduleMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRescheduleMaintenanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RescheduleMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/RescheduleMaintenance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RescheduleMaintenance(ctx, req.(*SqlInstancesRescheduleMaintenanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_VerifyExternalSyncSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesVerifyExternalSyncSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).VerifyExternalSyncSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/VerifyExternalSyncSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).VerifyExternalSyncSettings(ctx, req.(*SqlInstancesVerifyExternalSyncSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StartExternalSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStartExternalSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StartExternalSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlInstancesService/StartExternalSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StartExternalSync(ctx, req.(*SqlInstancesStartExternalSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlInstancesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1.SqlInstancesService",
	HandlerType: (*SqlInstancesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddServerCa",
			Handler:    _SqlInstancesService_AddServerCa_Handler,
		},
		{
			MethodName: "Clone",
			Handler:    _SqlInstancesService_Clone_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SqlInstancesService_Delete_Handler,
		},
		{
			MethodName: "DemoteMaster",
			Handler:    _SqlInstancesService_DemoteMaster_Handler,
		},
		{
			MethodName: "Export",
			Handler:    _SqlInstancesService_Export_Handler,
		},
		{
			MethodName: "Failover",
			Handler:    _SqlInstancesService_Failover_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlInstancesService_Get_Handler,
		},
		{
			MethodName: "Import",
			Handler:    _SqlInstancesService_Import_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlInstancesService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlInstancesService_List_Handler,
		},
		{
			MethodName: "ListServerCas",
			Handler:    _SqlInstancesService_ListServerCas_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _SqlInstancesService_Patch_Handler,
		},
		{
			MethodName: "PromoteReplica",
			Handler:    _SqlInstancesService_PromoteReplica_Handler,
		},
		{
			MethodName: "ResetSslConfig",
			Handler:    _SqlInstancesService_ResetSslConfig_Handler,
		},
		{
			MethodName: "Restart",
			Handler:    _SqlInstancesService_Restart_Handler,
		},
		{
			MethodName: "RestoreBackup",
			Handler:    _SqlInstancesService_RestoreBackup_Handler,
		},
		{
			MethodName: "RotateServerCa",
			Handler:    _SqlInstancesService_RotateServerCa_Handler,
		},
		{
			MethodName: "StartReplica",
			Handler:    _SqlInstancesService_StartReplica_Handler,
		},
		{
			MethodName: "StopReplica",
			Handler:    _SqlInstancesService_StopReplica_Handler,
		},
		{
			MethodName: "TruncateLog",
			Handler:    _SqlInstancesService_TruncateLog_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SqlInstancesService_Update_Handler,
		},
		{
			MethodName: "CreateEphemeral",
			Handler:    _SqlInstancesService_CreateEphemeral_Handler,
		},
		{
			MethodName: "RescheduleMaintenance",
			Handler:    _SqlInstancesService_RescheduleMaintenance_Handler,
		},
		{
			MethodName: "VerifyExternalSyncSettings",
			Handler:    _SqlInstancesService_VerifyExternalSyncSettings_Handler,
		},
		{
			MethodName: "StartExternalSync",
			Handler:    _SqlInstancesService_StartExternalSync_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1/cloud_sql_instances.proto",
}
