// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/thumbnail_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ThumbnailService_Get_FullMethodName                       = "/yandex.cloud.video.v1.ThumbnailService/Get"
	ThumbnailService_List_FullMethodName                      = "/yandex.cloud.video.v1.ThumbnailService/List"
	ThumbnailService_Create_FullMethodName                    = "/yandex.cloud.video.v1.ThumbnailService/Create"
	ThumbnailService_BatchGenerateDownloadURLs_FullMethodName = "/yandex.cloud.video.v1.ThumbnailService/BatchGenerateDownloadURLs"
	ThumbnailService_GenerateUploadURL_FullMethodName         = "/yandex.cloud.video.v1.ThumbnailService/GenerateUploadURL"
	ThumbnailService_Delete_FullMethodName                    = "/yandex.cloud.video.v1.ThumbnailService/Delete"
)

// ThumbnailServiceClient is the client API for ThumbnailService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Thumbnail management service.
// Provides methods for creating, retrieving, and managing thumbnail images
// that can be associated with various resources such as videos, streams, episodes, and channels.
type ThumbnailServiceClient interface {
	// Retrieves detailed information about a specific thumbnail by its ID.
	// Returns all thumbnail metadata and related information.
	Get(ctx context.Context, in *GetThumbnailRequest, opts ...grpc.CallOption) (*Thumbnail, error)
	// Lists all thumbnails associated with a specific resource (channel, stream, video, etc.)
	// with pagination support.
	List(ctx context.Context, in *ListThumbnailRequest, opts ...grpc.CallOption) (*ListThumbnailResponse, error)
	// Creates a new thumbnail record for a specific resource.
	// This method only creates the metadata record; the actual image must be uploaded
	// using the URL obtained from the GenerateUploadURL method.
	Create(ctx context.Context, in *CreateThumbnailRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates download URLs for multiple thumbnails in a single request.
	// The response includes URLs for both original and scaled versions of each thumbnail.
	// This is useful for efficiently retrieving multiple thumbnails at once.
	BatchGenerateDownloadURLs(ctx context.Context, in *BatchGenerateDownloadURLsRequest, opts ...grpc.CallOption) (*BatchGenerateDownloadURLsResponse, error)
	// Generates a URL for uploading an image to an existing thumbnail record.
	// This URL can be used to upload the actual image file using an HTTP PUT request.
	// The URL is pre-signed and has a limited validity period.
	GenerateUploadURL(ctx context.Context, in *GenerateThumbnailUploadURLRequest, opts ...grpc.CallOption) (*GenerateThumbnailUploadURLResponse, error)
	// Deletes a specific thumbnail by its ID.
	// This removes both the metadata record and the associated image file.
	Delete(ctx context.Context, in *DeleteThumbnailRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type thumbnailServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewThumbnailServiceClient(cc grpc.ClientConnInterface) ThumbnailServiceClient {
	return &thumbnailServiceClient{cc}
}

func (c *thumbnailServiceClient) Get(ctx context.Context, in *GetThumbnailRequest, opts ...grpc.CallOption) (*Thumbnail, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Thumbnail)
	err := c.cc.Invoke(ctx, ThumbnailService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *thumbnailServiceClient) List(ctx context.Context, in *ListThumbnailRequest, opts ...grpc.CallOption) (*ListThumbnailResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListThumbnailResponse)
	err := c.cc.Invoke(ctx, ThumbnailService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *thumbnailServiceClient) Create(ctx context.Context, in *CreateThumbnailRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ThumbnailService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *thumbnailServiceClient) BatchGenerateDownloadURLs(ctx context.Context, in *BatchGenerateDownloadURLsRequest, opts ...grpc.CallOption) (*BatchGenerateDownloadURLsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGenerateDownloadURLsResponse)
	err := c.cc.Invoke(ctx, ThumbnailService_BatchGenerateDownloadURLs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *thumbnailServiceClient) GenerateUploadURL(ctx context.Context, in *GenerateThumbnailUploadURLRequest, opts ...grpc.CallOption) (*GenerateThumbnailUploadURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GenerateThumbnailUploadURLResponse)
	err := c.cc.Invoke(ctx, ThumbnailService_GenerateUploadURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *thumbnailServiceClient) Delete(ctx context.Context, in *DeleteThumbnailRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ThumbnailService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ThumbnailServiceServer is the server API for ThumbnailService service.
// All implementations should embed UnimplementedThumbnailServiceServer
// for forward compatibility.
//
// Thumbnail management service.
// Provides methods for creating, retrieving, and managing thumbnail images
// that can be associated with various resources such as videos, streams, episodes, and channels.
type ThumbnailServiceServer interface {
	// Retrieves detailed information about a specific thumbnail by its ID.
	// Returns all thumbnail metadata and related information.
	Get(context.Context, *GetThumbnailRequest) (*Thumbnail, error)
	// Lists all thumbnails associated with a specific resource (channel, stream, video, etc.)
	// with pagination support.
	List(context.Context, *ListThumbnailRequest) (*ListThumbnailResponse, error)
	// Creates a new thumbnail record for a specific resource.
	// This method only creates the metadata record; the actual image must be uploaded
	// using the URL obtained from the GenerateUploadURL method.
	Create(context.Context, *CreateThumbnailRequest) (*operation.Operation, error)
	// Generates download URLs for multiple thumbnails in a single request.
	// The response includes URLs for both original and scaled versions of each thumbnail.
	// This is useful for efficiently retrieving multiple thumbnails at once.
	BatchGenerateDownloadURLs(context.Context, *BatchGenerateDownloadURLsRequest) (*BatchGenerateDownloadURLsResponse, error)
	// Generates a URL for uploading an image to an existing thumbnail record.
	// This URL can be used to upload the actual image file using an HTTP PUT request.
	// The URL is pre-signed and has a limited validity period.
	GenerateUploadURL(context.Context, *GenerateThumbnailUploadURLRequest) (*GenerateThumbnailUploadURLResponse, error)
	// Deletes a specific thumbnail by its ID.
	// This removes both the metadata record and the associated image file.
	Delete(context.Context, *DeleteThumbnailRequest) (*operation.Operation, error)
}

// UnimplementedThumbnailServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedThumbnailServiceServer struct{}

func (UnimplementedThumbnailServiceServer) Get(context.Context, *GetThumbnailRequest) (*Thumbnail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedThumbnailServiceServer) List(context.Context, *ListThumbnailRequest) (*ListThumbnailResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedThumbnailServiceServer) Create(context.Context, *CreateThumbnailRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedThumbnailServiceServer) BatchGenerateDownloadURLs(context.Context, *BatchGenerateDownloadURLsRequest) (*BatchGenerateDownloadURLsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGenerateDownloadURLs not implemented")
}
func (UnimplementedThumbnailServiceServer) GenerateUploadURL(context.Context, *GenerateThumbnailUploadURLRequest) (*GenerateThumbnailUploadURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadURL not implemented")
}
func (UnimplementedThumbnailServiceServer) Delete(context.Context, *DeleteThumbnailRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedThumbnailServiceServer) testEmbeddedByValue() {}

// UnsafeThumbnailServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ThumbnailServiceServer will
// result in compilation errors.
type UnsafeThumbnailServiceServer interface {
	mustEmbedUnimplementedThumbnailServiceServer()
}

func RegisterThumbnailServiceServer(s grpc.ServiceRegistrar, srv ThumbnailServiceServer) {
	// If the following call pancis, it indicates UnimplementedThumbnailServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ThumbnailService_ServiceDesc, srv)
}

func _ThumbnailService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetThumbnailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).Get(ctx, req.(*GetThumbnailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ThumbnailService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListThumbnailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).List(ctx, req.(*ListThumbnailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ThumbnailService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateThumbnailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).Create(ctx, req.(*CreateThumbnailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ThumbnailService_BatchGenerateDownloadURLs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGenerateDownloadURLsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).BatchGenerateDownloadURLs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_BatchGenerateDownloadURLs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).BatchGenerateDownloadURLs(ctx, req.(*BatchGenerateDownloadURLsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ThumbnailService_GenerateUploadURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateThumbnailUploadURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).GenerateUploadURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_GenerateUploadURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).GenerateUploadURL(ctx, req.(*GenerateThumbnailUploadURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ThumbnailService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteThumbnailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ThumbnailServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ThumbnailService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ThumbnailServiceServer).Delete(ctx, req.(*DeleteThumbnailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ThumbnailService_ServiceDesc is the grpc.ServiceDesc for ThumbnailService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ThumbnailService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.ThumbnailService",
	HandlerType: (*ThumbnailServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ThumbnailService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ThumbnailService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ThumbnailService_Create_Handler,
		},
		{
			MethodName: "BatchGenerateDownloadURLs",
			Handler:    _ThumbnailService_BatchGenerateDownloadURLs_Handler,
		},
		{
			MethodName: "GenerateUploadURL",
			Handler:    _ThumbnailService_GenerateUploadURL_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ThumbnailService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/thumbnail_service.proto",
}
