// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/serverless/eventrouter/v1/rule.proto

package eventrouter

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Rule_Status int32

const (
	Rule_STATUS_UNSPECIFIED Rule_Status = 0
	// Rule creation in progress, rule is not enabled yet
	Rule_CREATING Rule_Status = 1
	// Rule is operating
	Rule_ENABLED Rule_Status = 2
	// Rule update in progress, rule is disabled during update
	Rule_UPDATING Rule_Status = 3
	// Rule is explicitly disabled by the user
	Rule_DISABLED Rule_Status = 4
	// Rule deletion in progress
	Rule_DELETING Rule_Status = 5
)

// Enum value maps for Rule_Status.
var (
	Rule_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "ENABLED",
		3: "UPDATING",
		4: "DISABLED",
		5: "DELETING",
	}
	Rule_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"ENABLED":            2,
		"UPDATING":           3,
		"DISABLED":           4,
		"DELETING":           5,
	}
)

func (x Rule_Status) Enum() *Rule_Status {
	p := new(Rule_Status)
	*p = x
	return p
}

func (x Rule_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rule_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes[0].Descriptor()
}

func (Rule_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes[0]
}

func (x Rule_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rule_Status.Descriptor instead.
func (Rule_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{0, 0}
}

// Status of the target.
type Target_Status int32

const (
	Target_STATUS_UNSPECIFIED Target_Status = 0
	// Target is enabled.
	Target_ENABLED Target_Status = 1
	// Target is disabled.
	Target_DISABLED Target_Status = 2
	// Target does not exist.
	Target_RESOURCE_NOT_FOUND Target_Status = 3
	// Service account does not have read permission on source.
	Target_PERMISSION_DENIED Target_Status = 4
	// Service account not found.
	Target_SUBJECT_NOT_FOUND Target_Status = 5
)

// Enum value maps for Target_Status.
var (
	Target_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "RESOURCE_NOT_FOUND",
		4: "PERMISSION_DENIED",
		5: "SUBJECT_NOT_FOUND",
	}
	Target_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"ENABLED":            1,
		"DISABLED":           2,
		"RESOURCE_NOT_FOUND": 3,
		"PERMISSION_DENIED":  4,
		"SUBJECT_NOT_FOUND":  5,
	}
)

func (x Target_Status) Enum() *Target_Status {
	p := new(Target_Status)
	*p = x
	return p
}

func (x Target_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Target_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes[1].Descriptor()
}

func (Target_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes[1]
}

func (x Target_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Target_Status.Descriptor instead.
func (Target_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{3, 0}
}

type Rule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the rule.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the bus that the rule belongs to.
	BusId string `protobuf:"bytes,2,opt,name=bus_id,json=busId,proto3" json:"bus_id,omitempty"`
	// ID of the folder that the rule resides in.
	FolderId string `protobuf:"bytes,3,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// ID of the cloud that the rule resides in.
	CloudId string `protobuf:"bytes,4,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the rule.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the rule.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Filter for the rule.
	Filter *Filter `protobuf:"bytes,11,opt,name=filter,proto3" json:"filter,omitempty"`
	// Targets of the rule.
	Targets []*Target `protobuf:"bytes,12,rep,name=targets,proto3" json:"targets,omitempty"`
	// Flag that disallow deletion of the rule.
	DeletionProtection bool `protobuf:"varint,13,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Rule status
	Status        Rule_Status `protobuf:"varint,14,opt,name=status,proto3,enum=yandex.cloud.serverless.eventrouter.v1.Rule_Status" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rule) Reset() {
	*x = Rule{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{0}
}

func (x *Rule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Rule) GetBusId() string {
	if x != nil {
		return x.BusId
	}
	return ""
}

func (x *Rule) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Rule) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *Rule) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Rule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Rule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Rule) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Rule) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *Rule) GetTargets() []*Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *Rule) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Rule) GetStatus() Rule_Status {
	if x != nil {
		return x.Status
	}
	return Rule_STATUS_UNSPECIFIED
}

type Filter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Condition:
	//
	//	*Filter_JqFilter
	Condition     isFilter_Condition `protobuf_oneof:"condition"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Filter) Reset() {
	*x = Filter{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{1}
}

func (x *Filter) GetCondition() isFilter_Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Filter) GetJqFilter() string {
	if x != nil {
		if x, ok := x.Condition.(*Filter_JqFilter); ok {
			return x.JqFilter
		}
	}
	return ""
}

type isFilter_Condition interface {
	isFilter_Condition()
}

type Filter_JqFilter struct {
	// JQ filter for matching events.
	JqFilter string `protobuf:"bytes,1,opt,name=jq_filter,json=jqFilter,proto3,oneof"`
}

func (*Filter_JqFilter) isFilter_Condition() {}

type Transformer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Transformer:
	//
	//	*Transformer_JqTransformer
	Transformer   isTransformer_Transformer `protobuf_oneof:"transformer"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Transformer) Reset() {
	*x = Transformer{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Transformer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transformer) ProtoMessage() {}

func (x *Transformer) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transformer.ProtoReflect.Descriptor instead.
func (*Transformer) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{2}
}

func (x *Transformer) GetTransformer() isTransformer_Transformer {
	if x != nil {
		return x.Transformer
	}
	return nil
}

func (x *Transformer) GetJqTransformer() string {
	if x != nil {
		if x, ok := x.Transformer.(*Transformer_JqTransformer); ok {
			return x.JqTransformer
		}
	}
	return ""
}

type isTransformer_Transformer interface {
	isTransformer_Transformer()
}

type Transformer_JqTransformer struct {
	// JQ string inrerpolation expression for changing event format.
	JqTransformer string `protobuf:"bytes,1,opt,name=jq_transformer,json=jqTransformer,proto3,oneof"`
}

func (*Transformer_JqTransformer) isTransformer_Transformer() {}

type Target struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Target:
	//
	//	*Target_Yds
	//	*Target_Ymq
	//	*Target_Function
	//	*Target_Container
	//	*Target_GatewayWsBroadcast
	//	*Target_Logging
	//	*Target_Workflow
	Target isTarget_Target `protobuf_oneof:"target"`
	// Transformer of the target.
	Transformer *Transformer `protobuf:"bytes,50,opt,name=transformer,proto3" json:"transformer,omitempty"`
	// Retry settings of the target.
	RetrySettings *RetrySettings `protobuf:"bytes,51,opt,name=retry_settings,json=retrySettings,proto3" json:"retry_settings,omitempty"`
	// Dead letter settings of the target.
	//
	// Types that are valid to be assigned to DeadLetter:
	//
	//	*Target_DeadLetterQueue
	DeadLetter isTarget_DeadLetter `protobuf_oneof:"dead_letter"`
	// Status of the target.
	Status        Target_Status `protobuf:"varint,54,opt,name=status,proto3,enum=yandex.cloud.serverless.eventrouter.v1.Target_Status" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Target) Reset() {
	*x = Target{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{3}
}

func (x *Target) GetTarget() isTarget_Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *Target) GetYds() *YdsTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Yds); ok {
			return x.Yds
		}
	}
	return nil
}

func (x *Target) GetYmq() *YmqTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Ymq); ok {
			return x.Ymq
		}
	}
	return nil
}

func (x *Target) GetFunction() *FunctionTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Function); ok {
			return x.Function
		}
	}
	return nil
}

func (x *Target) GetContainer() *ContainerTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Container); ok {
			return x.Container
		}
	}
	return nil
}

func (x *Target) GetGatewayWsBroadcast() *GatewayWebsocketBroadcastTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_GatewayWsBroadcast); ok {
			return x.GatewayWsBroadcast
		}
	}
	return nil
}

func (x *Target) GetLogging() *LoggingTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Logging); ok {
			return x.Logging
		}
	}
	return nil
}

func (x *Target) GetWorkflow() *WorkflowTarget {
	if x != nil {
		if x, ok := x.Target.(*Target_Workflow); ok {
			return x.Workflow
		}
	}
	return nil
}

func (x *Target) GetTransformer() *Transformer {
	if x != nil {
		return x.Transformer
	}
	return nil
}

func (x *Target) GetRetrySettings() *RetrySettings {
	if x != nil {
		return x.RetrySettings
	}
	return nil
}

func (x *Target) GetDeadLetter() isTarget_DeadLetter {
	if x != nil {
		return x.DeadLetter
	}
	return nil
}

func (x *Target) GetDeadLetterQueue() *PutQueueMessage {
	if x != nil {
		if x, ok := x.DeadLetter.(*Target_DeadLetterQueue); ok {
			return x.DeadLetterQueue
		}
	}
	return nil
}

func (x *Target) GetStatus() Target_Status {
	if x != nil {
		return x.Status
	}
	return Target_STATUS_UNSPECIFIED
}

type isTarget_Target interface {
	isTarget_Target()
}

type Target_Yds struct {
	Yds *YdsTarget `protobuf:"bytes,1,opt,name=yds,proto3,oneof"`
}

type Target_Ymq struct {
	Ymq *YmqTarget `protobuf:"bytes,2,opt,name=ymq,proto3,oneof"`
}

type Target_Function struct {
	Function *FunctionTarget `protobuf:"bytes,3,opt,name=function,proto3,oneof"`
}

type Target_Container struct {
	Container *ContainerTarget `protobuf:"bytes,4,opt,name=container,proto3,oneof"`
}

type Target_GatewayWsBroadcast struct {
	GatewayWsBroadcast *GatewayWebsocketBroadcastTarget `protobuf:"bytes,5,opt,name=gateway_ws_broadcast,json=gatewayWsBroadcast,proto3,oneof"`
}

type Target_Logging struct {
	Logging *LoggingTarget `protobuf:"bytes,6,opt,name=logging,proto3,oneof"`
}

type Target_Workflow struct {
	Workflow *WorkflowTarget `protobuf:"bytes,7,opt,name=workflow,proto3,oneof"`
}

func (*Target_Yds) isTarget_Target() {}

func (*Target_Ymq) isTarget_Target() {}

func (*Target_Function) isTarget_Target() {}

func (*Target_Container) isTarget_Target() {}

func (*Target_GatewayWsBroadcast) isTarget_Target() {}

func (*Target_Logging) isTarget_Target() {}

func (*Target_Workflow) isTarget_Target() {}

type isTarget_DeadLetter interface {
	isTarget_DeadLetter()
}

type Target_DeadLetterQueue struct {
	// Dead letter queue.
	DeadLetterQueue *PutQueueMessage `protobuf:"bytes,52,opt,name=dead_letter_queue,json=deadLetterQueue,proto3,oneof"`
}

func (*Target_DeadLetterQueue) isTarget_DeadLetter() {}

type YdsTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Stream database.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Full stream name, like /ru-central1/aoegtvhtp8ob********/cc8004q4lbo6********/test.
	StreamName string `protobuf:"bytes,2,opt,name=stream_name,json=streamName,proto3" json:"stream_name,omitempty"`
	// Service account, which has write permission on the stream.
	ServiceAccountId string `protobuf:"bytes,3,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *YdsTarget) Reset() {
	*x = YdsTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *YdsTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YdsTarget) ProtoMessage() {}

func (x *YdsTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YdsTarget.ProtoReflect.Descriptor instead.
func (*YdsTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{4}
}

func (x *YdsTarget) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *YdsTarget) GetStreamName() string {
	if x != nil {
		return x.StreamName
	}
	return ""
}

func (x *YdsTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

type YmqTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Queue ARN.
	// Example: yrn:yc:ymq:ru-central1:aoe***:test
	QueueArn string `protobuf:"bytes,1,opt,name=queue_arn,json=queueArn,proto3" json:"queue_arn,omitempty"`
	// Service account which has write access to the queue.
	ServiceAccountId string `protobuf:"bytes,2,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *YmqTarget) Reset() {
	*x = YmqTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *YmqTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*YmqTarget) ProtoMessage() {}

func (x *YmqTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use YmqTarget.ProtoReflect.Descriptor instead.
func (*YmqTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{5}
}

func (x *YmqTarget) GetQueueArn() string {
	if x != nil {
		return x.QueueArn
	}
	return ""
}

func (x *YmqTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

type FunctionTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Function ID.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// Function tag, optional.
	FunctionTag string `protobuf:"bytes,2,opt,name=function_tag,json=functionTag,proto3" json:"function_tag,omitempty"`
	// Service account which has call permission on the function, optional.
	ServiceAccountId string `protobuf:"bytes,3,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Batch settings.
	BatchSettings *BatchSettings `protobuf:"bytes,4,opt,name=batch_settings,json=batchSettings,proto3" json:"batch_settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FunctionTarget) Reset() {
	*x = FunctionTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionTarget) ProtoMessage() {}

func (x *FunctionTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionTarget.ProtoReflect.Descriptor instead.
func (*FunctionTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{6}
}

func (x *FunctionTarget) GetFunctionId() string {
	if x != nil {
		return x.FunctionId
	}
	return ""
}

func (x *FunctionTarget) GetFunctionTag() string {
	if x != nil {
		return x.FunctionTag
	}
	return ""
}

func (x *FunctionTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *FunctionTarget) GetBatchSettings() *BatchSettings {
	if x != nil {
		return x.BatchSettings
	}
	return nil
}

type ContainerTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Container ID.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Container revision ID.
	ContainerRevisionId string `protobuf:"bytes,2,opt,name=container_revision_id,json=containerRevisionId,proto3" json:"container_revision_id,omitempty"`
	// Endpoint HTTP path to invoke.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Service account which should be used to call a container, optional.
	ServiceAccountId string `protobuf:"bytes,4,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Batch settings.
	BatchSettings *BatchSettings `protobuf:"bytes,5,opt,name=batch_settings,json=batchSettings,proto3" json:"batch_settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerTarget) Reset() {
	*x = ContainerTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerTarget) ProtoMessage() {}

func (x *ContainerTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerTarget.ProtoReflect.Descriptor instead.
func (*ContainerTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{7}
}

func (x *ContainerTarget) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *ContainerTarget) GetContainerRevisionId() string {
	if x != nil {
		return x.ContainerRevisionId
	}
	return ""
}

func (x *ContainerTarget) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ContainerTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *ContainerTarget) GetBatchSettings() *BatchSettings {
	if x != nil {
		return x.BatchSettings
	}
	return nil
}

type GatewayWebsocketBroadcastTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Path.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Service account which has permission for writing to websockets.
	ServiceAccountId string `protobuf:"bytes,3,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Batch settings.
	BatchSettings *BatchSettings `protobuf:"bytes,4,opt,name=batch_settings,json=batchSettings,proto3" json:"batch_settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GatewayWebsocketBroadcastTarget) Reset() {
	*x = GatewayWebsocketBroadcastTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayWebsocketBroadcastTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayWebsocketBroadcastTarget) ProtoMessage() {}

func (x *GatewayWebsocketBroadcastTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayWebsocketBroadcastTarget.ProtoReflect.Descriptor instead.
func (*GatewayWebsocketBroadcastTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{8}
}

func (x *GatewayWebsocketBroadcastTarget) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *GatewayWebsocketBroadcastTarget) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *GatewayWebsocketBroadcastTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *GatewayWebsocketBroadcastTarget) GetBatchSettings() *BatchSettings {
	if x != nil {
		return x.BatchSettings
	}
	return nil
}

type LoggingTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Log group ID or folder ID.
	//
	// Types that are valid to be assigned to Destination:
	//
	//	*LoggingTarget_LogGroupId
	//	*LoggingTarget_FolderId
	Destination isLoggingTarget_Destination `protobuf_oneof:"destination"`
	// Service account which has permission for writing logs.
	ServiceAccountId string `protobuf:"bytes,3,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LoggingTarget) Reset() {
	*x = LoggingTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingTarget) ProtoMessage() {}

func (x *LoggingTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingTarget.ProtoReflect.Descriptor instead.
func (*LoggingTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{9}
}

func (x *LoggingTarget) GetDestination() isLoggingTarget_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *LoggingTarget) GetLogGroupId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingTarget_LogGroupId); ok {
			return x.LogGroupId
		}
	}
	return ""
}

func (x *LoggingTarget) GetFolderId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingTarget_FolderId); ok {
			return x.FolderId
		}
	}
	return ""
}

func (x *LoggingTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

type isLoggingTarget_Destination interface {
	isLoggingTarget_Destination()
}

type LoggingTarget_LogGroupId struct {
	LogGroupId string `protobuf:"bytes,1,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

type LoggingTarget_FolderId struct {
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

func (*LoggingTarget_LogGroupId) isLoggingTarget_Destination() {}

func (*LoggingTarget_FolderId) isLoggingTarget_Destination() {}

type WorkflowTarget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Workflow ID.
	WorkflowId string `protobuf:"bytes,1,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	// SA which should be used to start workflow.
	ServiceAccountId string `protobuf:"bytes,4,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Batch settings.
	BatchSettings *BatchSettings `protobuf:"bytes,5,opt,name=batch_settings,json=batchSettings,proto3" json:"batch_settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkflowTarget) Reset() {
	*x = WorkflowTarget{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkflowTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowTarget) ProtoMessage() {}

func (x *WorkflowTarget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowTarget.ProtoReflect.Descriptor instead.
func (*WorkflowTarget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{10}
}

func (x *WorkflowTarget) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *WorkflowTarget) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *WorkflowTarget) GetBatchSettings() *BatchSettings {
	if x != nil {
		return x.BatchSettings
	}
	return nil
}

type RetrySettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of retries (extra calls) before an action fails.
	RetryAttempts int64 `protobuf:"varint,1,opt,name=retry_attempts,json=retryAttempts,proto3" json:"retry_attempts,omitempty"`
	// Event goes to dlq when its age exceeds this value. Default is 24h.
	MaximumAge    *durationpb.Duration `protobuf:"bytes,2,opt,name=maximum_age,json=maximumAge,proto3" json:"maximum_age,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RetrySettings) Reset() {
	*x = RetrySettings{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrySettings) ProtoMessage() {}

func (x *RetrySettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrySettings.ProtoReflect.Descriptor instead.
func (*RetrySettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{11}
}

func (x *RetrySettings) GetRetryAttempts() int64 {
	if x != nil {
		return x.RetryAttempts
	}
	return 0
}

func (x *RetrySettings) GetMaximumAge() *durationpb.Duration {
	if x != nil {
		return x.MaximumAge
	}
	return nil
}

type PutQueueMessage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the queue.
	QueueArn string `protobuf:"bytes,1,opt,name=queue_arn,json=queueArn,proto3" json:"queue_arn,omitempty"`
	// Service account which has write permission on the queue.
	ServiceAccountId string `protobuf:"bytes,2,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PutQueueMessage) Reset() {
	*x = PutQueueMessage{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PutQueueMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutQueueMessage) ProtoMessage() {}

func (x *PutQueueMessage) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutQueueMessage.ProtoReflect.Descriptor instead.
func (*PutQueueMessage) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{12}
}

func (x *PutQueueMessage) GetQueueArn() string {
	if x != nil {
		return x.QueueArn
	}
	return ""
}

func (x *PutQueueMessage) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

type BatchSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum batch size: trigger will send a batch if number of events exceeds this value.
	MaxCount int64 `protobuf:"varint,1,opt,name=max_count,json=maxCount,proto3" json:"max_count,omitempty"`
	// Maximum batch size: trigger will send a batch if total size of events exceeds this value.
	MaxBytes int64 `protobuf:"varint,2,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Maximum batch size: trigger will send a batch if its lifetime exceeds this value.
	Cutoff        *durationpb.Duration `protobuf:"bytes,3,opt,name=cutoff,proto3" json:"cutoff,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BatchSettings) Reset() {
	*x = BatchSettings{}
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchSettings) ProtoMessage() {}

func (x *BatchSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchSettings.ProtoReflect.Descriptor instead.
func (*BatchSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP(), []int{13}
}

func (x *BatchSettings) GetMaxCount() int64 {
	if x != nil {
		return x.MaxCount
	}
	return 0
}

func (x *BatchSettings) GetMaxBytes() int64 {
	if x != nil {
		return x.MaxBytes
	}
	return 0
}

func (x *BatchSettings) GetCutoff() *durationpb.Duration {
	if x != nil {
		return x.Cutoff
	}
	return nil
}

var File_yandex_cloud_serverless_eventrouter_v1_rule_proto protoreflect.FileDescriptor

const file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDesc = "" +
	"\n" +
	"1yandex/cloud/serverless/eventrouter/v1/rule.proto\x12&yandex.cloud.serverless.eventrouter.v1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1dyandex/cloud/validation.proto\"\xef\x05\n" +
	"\x04Rule\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x15\n" +
	"\x06bus_id\x18\x02 \x01(\tR\x05busId\x12\x1b\n" +
	"\tfolder_id\x18\x03 \x01(\tR\bfolderId\x12\x19\n" +
	"\bcloud_id\x18\x04 \x01(\tR\acloudId\x129\n" +
	"\n" +
	"created_at\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\a \x01(\tR\vdescription\x12P\n" +
	"\x06labels\x18\b \x03(\v28.yandex.cloud.serverless.eventrouter.v1.Rule.LabelsEntryR\x06labels\x12F\n" +
	"\x06filter\x18\v \x01(\v2..yandex.cloud.serverless.eventrouter.v1.FilterR\x06filter\x12Q\n" +
	"\atargets\x18\f \x03(\v2..yandex.cloud.serverless.eventrouter.v1.TargetB\a\x82\xc81\x031-5R\atargets\x12/\n" +
	"\x13deletion_protection\x18\r \x01(\bR\x12deletionProtection\x12K\n" +
	"\x06status\x18\x0e \x01(\x0e23.yandex.cloud.serverless.eventrouter.v1.Rule.StatusR\x06status\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"e\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aENABLED\x10\x02\x12\f\n" +
	"\bUPDATING\x10\x03\x12\f\n" +
	"\bDISABLED\x10\x04\x12\f\n" +
	"\bDELETING\x10\x05J\x04\b\t\x10\n" +
	"J\x04\b\n" +
	"\x10\v\"F\n" +
	"\x06Filter\x12)\n" +
	"\tjq_filter\x18\x01 \x01(\tB\n" +
	"\x8a\xc81\x06<=1024H\x00R\bjqFilterB\x11\n" +
	"\tcondition\x12\x04\xc0\xc11\x01\"X\n" +
	"\vTransformer\x124\n" +
	"\x0ejq_transformer\x18\x01 \x01(\tB\v\x8a\xc81\a<=65536H\x00R\rjqTransformerB\x13\n" +
	"\vtransformer\x12\x04\xc0\xc11\x01\"\x85\t\n" +
	"\x06Target\x12E\n" +
	"\x03yds\x18\x01 \x01(\v21.yandex.cloud.serverless.eventrouter.v1.YdsTargetH\x00R\x03yds\x12E\n" +
	"\x03ymq\x18\x02 \x01(\v21.yandex.cloud.serverless.eventrouter.v1.YmqTargetH\x00R\x03ymq\x12T\n" +
	"\bfunction\x18\x03 \x01(\v26.yandex.cloud.serverless.eventrouter.v1.FunctionTargetH\x00R\bfunction\x12W\n" +
	"\tcontainer\x18\x04 \x01(\v27.yandex.cloud.serverless.eventrouter.v1.ContainerTargetH\x00R\tcontainer\x12{\n" +
	"\x14gateway_ws_broadcast\x18\x05 \x01(\v2G.yandex.cloud.serverless.eventrouter.v1.GatewayWebsocketBroadcastTargetH\x00R\x12gatewayWsBroadcast\x12Q\n" +
	"\alogging\x18\x06 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.LoggingTargetH\x00R\alogging\x12T\n" +
	"\bworkflow\x18\a \x01(\v26.yandex.cloud.serverless.eventrouter.v1.WorkflowTargetH\x00R\bworkflow\x12U\n" +
	"\vtransformer\x182 \x01(\v23.yandex.cloud.serverless.eventrouter.v1.TransformerR\vtransformer\x12\\\n" +
	"\x0eretry_settings\x183 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.RetrySettingsR\rretrySettings\x12e\n" +
	"\x11dead_letter_queue\x184 \x01(\v27.yandex.cloud.serverless.eventrouter.v1.PutQueueMessageH\x01R\x0fdeadLetterQueue\x12M\n" +
	"\x06status\x186 \x01(\x0e25.yandex.cloud.serverless.eventrouter.v1.Target.StatusR\x06status\"\x81\x01\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aENABLED\x10\x01\x12\f\n" +
	"\bDISABLED\x10\x02\x12\x16\n" +
	"\x12RESOURCE_NOT_FOUND\x10\x03\x12\x15\n" +
	"\x11PERMISSION_DENIED\x10\x04\x12\x15\n" +
	"\x11SUBJECT_NOT_FOUND\x10\x05B\x0e\n" +
	"\x06target\x12\x04\xc0\xc11\x01B\r\n" +
	"\vdead_letterJ\x04\b\b\x102J\x04\b5\x106\"\x90\x01\n" +
	"\tYdsTarget\x12 \n" +
	"\bdatabase\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\bdatabase\x12%\n" +
	"\vstream_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\n" +
	"streamName\x12:\n" +
	"\x12service_account_id\x18\x03 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountId\"j\n" +
	"\tYmqTarget\x12!\n" +
	"\tqueue_arn\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\bqueueArn\x12:\n" +
	"\x12service_account_id\x18\x02 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountId\"\xf8\x01\n" +
	"\x0eFunctionTarget\x12-\n" +
	"\vfunction_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"functionId\x12!\n" +
	"\ffunction_tag\x18\x02 \x01(\tR\vfunctionTag\x126\n" +
	"\x12service_account_id\x18\x03 \x01(\tB\b\x8a\xc81\x04<=50R\x10serviceAccountId\x12\\\n" +
	"\x0ebatch_settings\x18\x04 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.BatchSettingsR\rbatchSettings\"\xa0\x02\n" +
	"\x0fContainerTarget\x12/\n" +
	"\fcontainer_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\vcontainerId\x122\n" +
	"\x15container_revision_id\x18\x02 \x01(\tR\x13containerRevisionId\x12\x12\n" +
	"\x04path\x18\x03 \x01(\tR\x04path\x126\n" +
	"\x12service_account_id\x18\x04 \x01(\tB\b\x8a\xc81\x04<=50R\x10serviceAccountId\x12\\\n" +
	"\x0ebatch_settings\x18\x05 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.BatchSettingsR\rbatchSettings\"\x82\x02\n" +
	"\x1fGatewayWebsocketBroadcastTarget\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\x12\x18\n" +
	"\x04path\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\x04path\x12:\n" +
	"\x12service_account_id\x18\x03 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountId\x12\\\n" +
	"\x0ebatch_settings\x18\x04 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.BatchSettingsR\rbatchSettings\"\xb7\x01\n" +
	"\rLoggingTarget\x12,\n" +
	"\flog_group_id\x18\x01 \x01(\tB\b\x8a\xc81\x04<=63H\x00R\n" +
	"logGroupId\x12'\n" +
	"\tfolder_id\x18\x02 \x01(\tB\b\x8a\xc81\x04<=63H\x00R\bfolderId\x12:\n" +
	"\x12service_account_id\x18\x03 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountIdB\x13\n" +
	"\vdestination\x12\x04\xc0\xc11\x01\"\xe5\x01\n" +
	"\x0eWorkflowTarget\x12-\n" +
	"\vworkflow_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"workflowId\x12:\n" +
	"\x12service_account_id\x18\x04 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountId\x12\\\n" +
	"\x0ebatch_settings\x18\x05 \x01(\v25.yandex.cloud.serverless.eventrouter.v1.BatchSettingsR\rbatchSettingsJ\x04\b\x02\x10\x03J\x04\b\x03\x10\x04\"\x87\x01\n" +
	"\rRetrySettings\x12/\n" +
	"\x0eretry_attempts\x18\x01 \x01(\x03B\b\xfa\xc71\x040-10R\rretryAttempts\x12E\n" +
	"\vmaximum_age\x18\x02 \x01(\v2\x19.google.protobuf.DurationB\t\xfa\xc71\x05<=24hR\n" +
	"maximumAge\"j\n" +
	"\x0fPutQueueMessage\x12\x1b\n" +
	"\tqueue_arn\x18\x01 \x01(\tR\bqueueArn\x12:\n" +
	"\x12service_account_id\x18\x02 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x10serviceAccountId\"\xa4\x01\n" +
	"\rBatchSettings\x12'\n" +
	"\tmax_count\x18\x01 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bmaxCount\x12)\n" +
	"\tmax_bytes\x18\x02 \x01(\x03B\f\xfa\xc71\b0-262144R\bmaxBytes\x12?\n" +
	"\x06cutoff\x18\x03 \x01(\v2\x19.google.protobuf.DurationB\f\xe8\xc71\x01\xfa\xc71\x04<=1mR\x06cutoffB\x8a\x01\n" +
	"*yandex.cloud.api.serverless.eventrouter.v1B\x04PERRZVgithub.com/yandex-cloud/go-genproto/yandex/cloud/serverless/eventrouter/v1;eventrouterb\x06proto3"

var (
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescOnce sync.Once
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescData []byte
)

func file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescGZIP() []byte {
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDesc), len(file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDesc)))
	})
	return file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDescData
}

var file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_yandex_cloud_serverless_eventrouter_v1_rule_proto_goTypes = []any{
	(Rule_Status)(0),                        // 0: yandex.cloud.serverless.eventrouter.v1.Rule.Status
	(Target_Status)(0),                      // 1: yandex.cloud.serverless.eventrouter.v1.Target.Status
	(*Rule)(nil),                            // 2: yandex.cloud.serverless.eventrouter.v1.Rule
	(*Filter)(nil),                          // 3: yandex.cloud.serverless.eventrouter.v1.Filter
	(*Transformer)(nil),                     // 4: yandex.cloud.serverless.eventrouter.v1.Transformer
	(*Target)(nil),                          // 5: yandex.cloud.serverless.eventrouter.v1.Target
	(*YdsTarget)(nil),                       // 6: yandex.cloud.serverless.eventrouter.v1.YdsTarget
	(*YmqTarget)(nil),                       // 7: yandex.cloud.serverless.eventrouter.v1.YmqTarget
	(*FunctionTarget)(nil),                  // 8: yandex.cloud.serverless.eventrouter.v1.FunctionTarget
	(*ContainerTarget)(nil),                 // 9: yandex.cloud.serverless.eventrouter.v1.ContainerTarget
	(*GatewayWebsocketBroadcastTarget)(nil), // 10: yandex.cloud.serverless.eventrouter.v1.GatewayWebsocketBroadcastTarget
	(*LoggingTarget)(nil),                   // 11: yandex.cloud.serverless.eventrouter.v1.LoggingTarget
	(*WorkflowTarget)(nil),                  // 12: yandex.cloud.serverless.eventrouter.v1.WorkflowTarget
	(*RetrySettings)(nil),                   // 13: yandex.cloud.serverless.eventrouter.v1.RetrySettings
	(*PutQueueMessage)(nil),                 // 14: yandex.cloud.serverless.eventrouter.v1.PutQueueMessage
	(*BatchSettings)(nil),                   // 15: yandex.cloud.serverless.eventrouter.v1.BatchSettings
	nil,                                     // 16: yandex.cloud.serverless.eventrouter.v1.Rule.LabelsEntry
	(*timestamppb.Timestamp)(nil),           // 17: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),             // 18: google.protobuf.Duration
}
var file_yandex_cloud_serverless_eventrouter_v1_rule_proto_depIdxs = []int32{
	17, // 0: yandex.cloud.serverless.eventrouter.v1.Rule.created_at:type_name -> google.protobuf.Timestamp
	16, // 1: yandex.cloud.serverless.eventrouter.v1.Rule.labels:type_name -> yandex.cloud.serverless.eventrouter.v1.Rule.LabelsEntry
	3,  // 2: yandex.cloud.serverless.eventrouter.v1.Rule.filter:type_name -> yandex.cloud.serverless.eventrouter.v1.Filter
	5,  // 3: yandex.cloud.serverless.eventrouter.v1.Rule.targets:type_name -> yandex.cloud.serverless.eventrouter.v1.Target
	0,  // 4: yandex.cloud.serverless.eventrouter.v1.Rule.status:type_name -> yandex.cloud.serverless.eventrouter.v1.Rule.Status
	6,  // 5: yandex.cloud.serverless.eventrouter.v1.Target.yds:type_name -> yandex.cloud.serverless.eventrouter.v1.YdsTarget
	7,  // 6: yandex.cloud.serverless.eventrouter.v1.Target.ymq:type_name -> yandex.cloud.serverless.eventrouter.v1.YmqTarget
	8,  // 7: yandex.cloud.serverless.eventrouter.v1.Target.function:type_name -> yandex.cloud.serverless.eventrouter.v1.FunctionTarget
	9,  // 8: yandex.cloud.serverless.eventrouter.v1.Target.container:type_name -> yandex.cloud.serverless.eventrouter.v1.ContainerTarget
	10, // 9: yandex.cloud.serverless.eventrouter.v1.Target.gateway_ws_broadcast:type_name -> yandex.cloud.serverless.eventrouter.v1.GatewayWebsocketBroadcastTarget
	11, // 10: yandex.cloud.serverless.eventrouter.v1.Target.logging:type_name -> yandex.cloud.serverless.eventrouter.v1.LoggingTarget
	12, // 11: yandex.cloud.serverless.eventrouter.v1.Target.workflow:type_name -> yandex.cloud.serverless.eventrouter.v1.WorkflowTarget
	4,  // 12: yandex.cloud.serverless.eventrouter.v1.Target.transformer:type_name -> yandex.cloud.serverless.eventrouter.v1.Transformer
	13, // 13: yandex.cloud.serverless.eventrouter.v1.Target.retry_settings:type_name -> yandex.cloud.serverless.eventrouter.v1.RetrySettings
	14, // 14: yandex.cloud.serverless.eventrouter.v1.Target.dead_letter_queue:type_name -> yandex.cloud.serverless.eventrouter.v1.PutQueueMessage
	1,  // 15: yandex.cloud.serverless.eventrouter.v1.Target.status:type_name -> yandex.cloud.serverless.eventrouter.v1.Target.Status
	15, // 16: yandex.cloud.serverless.eventrouter.v1.FunctionTarget.batch_settings:type_name -> yandex.cloud.serverless.eventrouter.v1.BatchSettings
	15, // 17: yandex.cloud.serverless.eventrouter.v1.ContainerTarget.batch_settings:type_name -> yandex.cloud.serverless.eventrouter.v1.BatchSettings
	15, // 18: yandex.cloud.serverless.eventrouter.v1.GatewayWebsocketBroadcastTarget.batch_settings:type_name -> yandex.cloud.serverless.eventrouter.v1.BatchSettings
	15, // 19: yandex.cloud.serverless.eventrouter.v1.WorkflowTarget.batch_settings:type_name -> yandex.cloud.serverless.eventrouter.v1.BatchSettings
	18, // 20: yandex.cloud.serverless.eventrouter.v1.RetrySettings.maximum_age:type_name -> google.protobuf.Duration
	18, // 21: yandex.cloud.serverless.eventrouter.v1.BatchSettings.cutoff:type_name -> google.protobuf.Duration
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_yandex_cloud_serverless_eventrouter_v1_rule_proto_init() }
func file_yandex_cloud_serverless_eventrouter_v1_rule_proto_init() {
	if File_yandex_cloud_serverless_eventrouter_v1_rule_proto != nil {
		return
	}
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[1].OneofWrappers = []any{
		(*Filter_JqFilter)(nil),
	}
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[2].OneofWrappers = []any{
		(*Transformer_JqTransformer)(nil),
	}
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[3].OneofWrappers = []any{
		(*Target_Yds)(nil),
		(*Target_Ymq)(nil),
		(*Target_Function)(nil),
		(*Target_Container)(nil),
		(*Target_GatewayWsBroadcast)(nil),
		(*Target_Logging)(nil),
		(*Target_Workflow)(nil),
		(*Target_DeadLetterQueue)(nil),
	}
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes[9].OneofWrappers = []any{
		(*LoggingTarget_LogGroupId)(nil),
		(*LoggingTarget_FolderId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDesc), len(file_yandex_cloud_serverless_eventrouter_v1_rule_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_serverless_eventrouter_v1_rule_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_serverless_eventrouter_v1_rule_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_serverless_eventrouter_v1_rule_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_serverless_eventrouter_v1_rule_proto_msgTypes,
	}.Build()
	File_yandex_cloud_serverless_eventrouter_v1_rule_proto = out.File
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_goTypes = nil
	file_yandex_cloud_serverless_eventrouter_v1_rule_proto_depIdxs = nil
}
