// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/connectionmanager/v1/connection_service.proto

package connectionmanager

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ConnectionService_Get_FullMethodName            = "/yandex.cloud.connectionmanager.v1.ConnectionService/Get"
	ConnectionService_ResolveCluster_FullMethodName = "/yandex.cloud.connectionmanager.v1.ConnectionService/ResolveCluster"
	ConnectionService_List_FullMethodName           = "/yandex.cloud.connectionmanager.v1.ConnectionService/List"
	ConnectionService_Create_FullMethodName         = "/yandex.cloud.connectionmanager.v1.ConnectionService/Create"
	ConnectionService_Update_FullMethodName         = "/yandex.cloud.connectionmanager.v1.ConnectionService/Update"
	ConnectionService_Delete_FullMethodName         = "/yandex.cloud.connectionmanager.v1.ConnectionService/Delete"
	ConnectionService_ListOperations_FullMethodName = "/yandex.cloud.connectionmanager.v1.ConnectionService/ListOperations"
)

// ConnectionServiceClient is the client API for ConnectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Connection resources.
type ConnectionServiceClient interface {
	// Returns connection.
	Get(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns the connection with the resolved cluster; that is,
	//   - for connections to the on-premise clusters is identical to the Get RPC;
	//   - for connections to the managed clusters, resolves the cluster topology
	//     and returns it in the `on_premise` field of the connection parameters.
	//
	// Requires `connection-manager.connections.resolveCluster` permission.
	ResolveCluster(ctx context.Context, in *ResolveClusterRequest, opts ...grpc.CallOption) (*Connection, error)
	// List connections in specified folder.
	List(ctx context.Context, in *ListConnectionRequest, opts ...grpc.CallOption) (*ListConnectionResponse, error)
	// Creates connection.
	Create(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates specified connection.
	Update(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Delete specified connection.
	Delete(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of Operation resources for the specified connection.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
}

type connectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConnectionServiceClient(cc grpc.ClientConnInterface) ConnectionServiceClient {
	return &connectionServiceClient{cc}
}

func (c *connectionServiceClient) Get(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Connection)
	err := c.cc.Invoke(ctx, ConnectionService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) ResolveCluster(ctx context.Context, in *ResolveClusterRequest, opts ...grpc.CallOption) (*Connection, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Connection)
	err := c.cc.Invoke(ctx, ConnectionService_ResolveCluster_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) List(ctx context.Context, in *ListConnectionRequest, opts ...grpc.CallOption) (*ListConnectionResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListConnectionResponse)
	err := c.cc.Invoke(ctx, ConnectionService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) Create(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ConnectionService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) Update(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ConnectionService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) Delete(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ConnectionService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListOperationsResponse)
	err := c.cc.Invoke(ctx, ConnectionService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConnectionServiceServer is the server API for ConnectionService service.
// All implementations should embed UnimplementedConnectionServiceServer
// for forward compatibility.
//
// A set of methods for managing Connection resources.
type ConnectionServiceServer interface {
	// Returns connection.
	Get(context.Context, *GetConnectionRequest) (*Connection, error)
	// Returns the connection with the resolved cluster; that is,
	//   - for connections to the on-premise clusters is identical to the Get RPC;
	//   - for connections to the managed clusters, resolves the cluster topology
	//     and returns it in the `on_premise` field of the connection parameters.
	//
	// Requires `connection-manager.connections.resolveCluster` permission.
	ResolveCluster(context.Context, *ResolveClusterRequest) (*Connection, error)
	// List connections in specified folder.
	List(context.Context, *ListConnectionRequest) (*ListConnectionResponse, error)
	// Creates connection.
	Create(context.Context, *CreateConnectionRequest) (*operation.Operation, error)
	// Updates specified connection.
	Update(context.Context, *UpdateConnectionRequest) (*operation.Operation, error)
	// Delete specified connection.
	Delete(context.Context, *DeleteConnectionRequest) (*operation.Operation, error)
	// Retrieves the list of Operation resources for the specified connection.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
}

// UnimplementedConnectionServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedConnectionServiceServer struct{}

func (UnimplementedConnectionServiceServer) Get(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedConnectionServiceServer) ResolveCluster(context.Context, *ResolveClusterRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveCluster not implemented")
}
func (UnimplementedConnectionServiceServer) List(context.Context, *ListConnectionRequest) (*ListConnectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedConnectionServiceServer) Create(context.Context, *CreateConnectionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedConnectionServiceServer) Update(context.Context, *UpdateConnectionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedConnectionServiceServer) Delete(context.Context, *DeleteConnectionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedConnectionServiceServer) ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedConnectionServiceServer) testEmbeddedByValue() {}

// UnsafeConnectionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConnectionServiceServer will
// result in compilation errors.
type UnsafeConnectionServiceServer interface {
	mustEmbedUnimplementedConnectionServiceServer()
}

func RegisterConnectionServiceServer(s grpc.ServiceRegistrar, srv ConnectionServiceServer) {
	// If the following call pancis, it indicates UnimplementedConnectionServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ConnectionService_ServiceDesc, srv)
}

func _ConnectionService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).Get(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_ResolveCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).ResolveCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_ResolveCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).ResolveCluster(ctx, req.(*ResolveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).List(ctx, req.(*ListConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).Create(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).Update(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).Delete(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConnectionService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConnectionService_ServiceDesc is the grpc.ServiceDesc for ConnectionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConnectionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.connectionmanager.v1.ConnectionService",
	HandlerType: (*ConnectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ConnectionService_Get_Handler,
		},
		{
			MethodName: "ResolveCluster",
			Handler:    _ConnectionService_ResolveCluster_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ConnectionService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ConnectionService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ConnectionService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ConnectionService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ConnectionService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/connectionmanager/v1/connection_service.proto",
}
