// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/ai/stt/v3/stt_service.proto

package stt

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Recognizer_RecognizeStreaming_FullMethodName = "/speechkit.stt.v3.Recognizer/RecognizeStreaming"
)

// RecognizerClient is the client API for Recognizer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for streaming speech recognition.
type RecognizerClient interface {
	// Performs bidirectional streaming speech recognition receiving results while sending audio.
	RecognizeStreaming(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[StreamingRequest, StreamingResponse], error)
}

type recognizerClient struct {
	cc grpc.ClientConnInterface
}

func NewRecognizerClient(cc grpc.ClientConnInterface) RecognizerClient {
	return &recognizerClient{cc}
}

func (c *recognizerClient) RecognizeStreaming(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[StreamingRequest, StreamingResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Recognizer_ServiceDesc.Streams[0], Recognizer_RecognizeStreaming_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[StreamingRequest, StreamingResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Recognizer_RecognizeStreamingClient = grpc.BidiStreamingClient[StreamingRequest, StreamingResponse]

// RecognizerServer is the server API for Recognizer service.
// All implementations should embed UnimplementedRecognizerServer
// for forward compatibility.
//
// A set of methods for streaming speech recognition.
type RecognizerServer interface {
	// Performs bidirectional streaming speech recognition receiving results while sending audio.
	RecognizeStreaming(grpc.BidiStreamingServer[StreamingRequest, StreamingResponse]) error
}

// UnimplementedRecognizerServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRecognizerServer struct{}

func (UnimplementedRecognizerServer) RecognizeStreaming(grpc.BidiStreamingServer[StreamingRequest, StreamingResponse]) error {
	return status.Errorf(codes.Unimplemented, "method RecognizeStreaming not implemented")
}
func (UnimplementedRecognizerServer) testEmbeddedByValue() {}

// UnsafeRecognizerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RecognizerServer will
// result in compilation errors.
type UnsafeRecognizerServer interface {
	mustEmbedUnimplementedRecognizerServer()
}

func RegisterRecognizerServer(s grpc.ServiceRegistrar, srv RecognizerServer) {
	// If the following call pancis, it indicates UnimplementedRecognizerServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Recognizer_ServiceDesc, srv)
}

func _Recognizer_RecognizeStreaming_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RecognizerServer).RecognizeStreaming(&grpc.GenericServerStream[StreamingRequest, StreamingResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Recognizer_RecognizeStreamingServer = grpc.BidiStreamingServer[StreamingRequest, StreamingResponse]

// Recognizer_ServiceDesc is the grpc.ServiceDesc for Recognizer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Recognizer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "speechkit.stt.v3.Recognizer",
	HandlerType: (*RecognizerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RecognizeStreaming",
			Handler:       _Recognizer_RecognizeStreaming_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "yandex/cloud/ai/stt/v3/stt_service.proto",
}

const (
	AsyncRecognizer_RecognizeFile_FullMethodName     = "/speechkit.stt.v3.AsyncRecognizer/RecognizeFile"
	AsyncRecognizer_GetRecognition_FullMethodName    = "/speechkit.stt.v3.AsyncRecognizer/GetRecognition"
	AsyncRecognizer_DeleteRecognition_FullMethodName = "/speechkit.stt.v3.AsyncRecognizer/DeleteRecognition"
)

// AsyncRecognizerClient is the client API for AsyncRecognizer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for asynchronous speech recognition: recognize pre-recorded audio and receive results by request.
type AsyncRecognizerClient interface {
	// Performs asynchronous speech recognition.
	RecognizeFile(ctx context.Context, in *RecognizeFileRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Gets results of asynchronous recognition after finishing the operation.
	GetRecognition(ctx context.Context, in *GetRecognitionRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[StreamingResponse], error)
	// Deletes results of asynchronous recognition by operation ID.
	DeleteRecognition(ctx context.Context, in *DeleteRecognitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type asyncRecognizerClient struct {
	cc grpc.ClientConnInterface
}

func NewAsyncRecognizerClient(cc grpc.ClientConnInterface) AsyncRecognizerClient {
	return &asyncRecognizerClient{cc}
}

func (c *asyncRecognizerClient) RecognizeFile(ctx context.Context, in *RecognizeFileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, AsyncRecognizer_RecognizeFile_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *asyncRecognizerClient) GetRecognition(ctx context.Context, in *GetRecognitionRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[StreamingResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &AsyncRecognizer_ServiceDesc.Streams[0], AsyncRecognizer_GetRecognition_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetRecognitionRequest, StreamingResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type AsyncRecognizer_GetRecognitionClient = grpc.ServerStreamingClient[StreamingResponse]

func (c *asyncRecognizerClient) DeleteRecognition(ctx context.Context, in *DeleteRecognitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AsyncRecognizer_DeleteRecognition_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AsyncRecognizerServer is the server API for AsyncRecognizer service.
// All implementations should embed UnimplementedAsyncRecognizerServer
// for forward compatibility.
//
// A set of methods for asynchronous speech recognition: recognize pre-recorded audio and receive results by request.
type AsyncRecognizerServer interface {
	// Performs asynchronous speech recognition.
	RecognizeFile(context.Context, *RecognizeFileRequest) (*operation.Operation, error)
	// Gets results of asynchronous recognition after finishing the operation.
	GetRecognition(*GetRecognitionRequest, grpc.ServerStreamingServer[StreamingResponse]) error
	// Deletes results of asynchronous recognition by operation ID.
	DeleteRecognition(context.Context, *DeleteRecognitionRequest) (*emptypb.Empty, error)
}

// UnimplementedAsyncRecognizerServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedAsyncRecognizerServer struct{}

func (UnimplementedAsyncRecognizerServer) RecognizeFile(context.Context, *RecognizeFileRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecognizeFile not implemented")
}
func (UnimplementedAsyncRecognizerServer) GetRecognition(*GetRecognitionRequest, grpc.ServerStreamingServer[StreamingResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetRecognition not implemented")
}
func (UnimplementedAsyncRecognizerServer) DeleteRecognition(context.Context, *DeleteRecognitionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRecognition not implemented")
}
func (UnimplementedAsyncRecognizerServer) testEmbeddedByValue() {}

// UnsafeAsyncRecognizerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AsyncRecognizerServer will
// result in compilation errors.
type UnsafeAsyncRecognizerServer interface {
	mustEmbedUnimplementedAsyncRecognizerServer()
}

func RegisterAsyncRecognizerServer(s grpc.ServiceRegistrar, srv AsyncRecognizerServer) {
	// If the following call pancis, it indicates UnimplementedAsyncRecognizerServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&AsyncRecognizer_ServiceDesc, srv)
}

func _AsyncRecognizer_RecognizeFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsyncRecognizerServer).RecognizeFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsyncRecognizer_RecognizeFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsyncRecognizerServer).RecognizeFile(ctx, req.(*RecognizeFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AsyncRecognizer_GetRecognition_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetRecognitionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AsyncRecognizerServer).GetRecognition(m, &grpc.GenericServerStream[GetRecognitionRequest, StreamingResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type AsyncRecognizer_GetRecognitionServer = grpc.ServerStreamingServer[StreamingResponse]

func _AsyncRecognizer_DeleteRecognition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRecognitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AsyncRecognizerServer).DeleteRecognition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AsyncRecognizer_DeleteRecognition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AsyncRecognizerServer).DeleteRecognition(ctx, req.(*DeleteRecognitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AsyncRecognizer_ServiceDesc is the grpc.ServiceDesc for AsyncRecognizer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AsyncRecognizer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "speechkit.stt.v3.AsyncRecognizer",
	HandlerType: (*AsyncRecognizerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RecognizeFile",
			Handler:    _AsyncRecognizer_RecognizeFile_Handler,
		},
		{
			MethodName: "DeleteRecognition",
			Handler:    _AsyncRecognizer_DeleteRecognition_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetRecognition",
			Handler:       _AsyncRecognizer_GetRecognition_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "yandex/cloud/ai/stt/v3/stt_service.proto",
}
