// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networkmanagement/v1/vpc_flow_logs.proto

package networkmanagementpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for the `ListVpcFlowLogsConfigs` method.
type ListVpcFlowLogsConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VpcFlowLogsConfig,
	// in one of the following formats:
	//
	// - For project-level resourcs: `projects/{project_id}/locations/global`
	//
	// - For organization-level resources:
	// `organizations/{organization_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Number of `VpcFlowLogsConfigs` to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token from an earlier query, as returned in
	// `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the `VpcFlowLogsConfigs` that match the filter expression.
	// A filter expression must use the supported [CEL logic operators]
	// (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVpcFlowLogsConfigsRequest) Reset() {
	*x = ListVpcFlowLogsConfigsRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVpcFlowLogsConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVpcFlowLogsConfigsRequest) ProtoMessage() {}

func (x *ListVpcFlowLogsConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVpcFlowLogsConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListVpcFlowLogsConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{0}
}

func (x *ListVpcFlowLogsConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVpcFlowLogsConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListVpcFlowLogsConfigs` method.
type ListVpcFlowLogsConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of VPC Flow Log configurations.
	VpcFlowLogsConfigs []*VpcFlowLogsConfig `protobuf:"bytes,1,rep,name=vpc_flow_logs_configs,json=vpcFlowLogsConfigs,proto3" json:"vpc_flow_logs_configs,omitempty"`
	// Page token to fetch the next set of configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached (when querying all locations with `-`).
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVpcFlowLogsConfigsResponse) Reset() {
	*x = ListVpcFlowLogsConfigsResponse{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVpcFlowLogsConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVpcFlowLogsConfigsResponse) ProtoMessage() {}

func (x *ListVpcFlowLogsConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVpcFlowLogsConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListVpcFlowLogsConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{1}
}

func (x *ListVpcFlowLogsConfigsResponse) GetVpcFlowLogsConfigs() []*VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfigs
	}
	return nil
}

func (x *ListVpcFlowLogsConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVpcFlowLogsConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetVpcFlowLogsConfig` method.
type GetVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VpcFlowLogsConfig,
	// in one of the following formats:
	//
	// - For project-level resources:
	// `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	//
	// - For organization-level resources:
	// `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVpcFlowLogsConfigRequest) Reset() {
	*x = GetVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *GetVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*GetVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{2}
}

func (x *GetVpcFlowLogsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateVpcFlowLogsConfig` method.
type CreateVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VpcFlowLogsConfig to create,
	// in one of the following formats:
	//
	// - For project-level resources: `projects/{project_id}/locations/global`
	//
	// - For organization-level resources:
	// `organizations/{organization_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the `VpcFlowLogsConfig`.
	VpcFlowLogsConfigId string `protobuf:"bytes,2,opt,name=vpc_flow_logs_config_id,json=vpcFlowLogsConfigId,proto3" json:"vpc_flow_logs_config_id,omitempty"`
	// Required. A `VpcFlowLogsConfig` resource
	VpcFlowLogsConfig *VpcFlowLogsConfig `protobuf:"bytes,3,opt,name=vpc_flow_logs_config,json=vpcFlowLogsConfig,proto3" json:"vpc_flow_logs_config,omitempty"`
}

func (x *CreateVpcFlowLogsConfigRequest) Reset() {
	*x = CreateVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *CreateVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{3}
}

func (x *CreateVpcFlowLogsConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfigId() string {
	if x != nil {
		return x.VpcFlowLogsConfigId
	}
	return ""
}

func (x *CreateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfig() *VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfig
	}
	return nil
}

// Request for the `UpdateVpcFlowLogsConfig` method.
type UpdateVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field.
	// For example, to change the state of the configuration to ENABLED, specify
	//
	//	`update_mask` = `"state"`, and the `vpc_flow_logs_config` would be:
	//	`vpc_flow_logs_config = {
	//	  name =
	//	  "projects/my-project/locations/global/vpcFlowLogsConfigs/my-config"
	//	  state = "ENABLED" }`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Only fields specified in update_mask are updated.
	VpcFlowLogsConfig *VpcFlowLogsConfig `protobuf:"bytes,2,opt,name=vpc_flow_logs_config,json=vpcFlowLogsConfig,proto3" json:"vpc_flow_logs_config,omitempty"`
}

func (x *UpdateVpcFlowLogsConfigRequest) Reset() {
	*x = UpdateVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *UpdateVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateVpcFlowLogsConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateVpcFlowLogsConfigRequest) GetVpcFlowLogsConfig() *VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfig
	}
	return nil
}

// Request for the `DeleteVpcFlowLogsConfig` method.
type DeleteVpcFlowLogsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VpcFlowLogsConfig,
	// in one of the following formats:
	//
	// - For a project-level resource:
	// `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	//
	// - For an organization-level resource:
	// `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteVpcFlowLogsConfigRequest) Reset() {
	*x = DeleteVpcFlowLogsConfigRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVpcFlowLogsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVpcFlowLogsConfigRequest) ProtoMessage() {}

func (x *DeleteVpcFlowLogsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVpcFlowLogsConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteVpcFlowLogsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteVpcFlowLogsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `QueryOrgVpcFlowLogsConfigs` method.
type QueryOrgVpcFlowLogsConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VpcFlowLogsConfig, specified in
	// the following format: `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Number of `VpcFlowLogsConfigs` to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token from an earlier query, as returned in
	// `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the `VpcFlowLogsConfigs` that match the filter expression.
	// A filter expression must use the supported [CEL logic operators]
	// (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) Reset() {
	*x = QueryOrgVpcFlowLogsConfigsRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryOrgVpcFlowLogsConfigsRequest) ProtoMessage() {}

func (x *QueryOrgVpcFlowLogsConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryOrgVpcFlowLogsConfigsRequest.ProtoReflect.Descriptor instead.
func (*QueryOrgVpcFlowLogsConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{6}
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *QueryOrgVpcFlowLogsConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response for the `QueryVpcFlowLogsConfigs` method.
type QueryOrgVpcFlowLogsConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of VPC Flow Log configurations.
	VpcFlowLogsConfigs []*VpcFlowLogsConfig `protobuf:"bytes,1,rep,name=vpc_flow_logs_configs,json=vpcFlowLogsConfigs,proto3" json:"vpc_flow_logs_configs,omitempty"`
	// Page token to fetch the next set of configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached (when querying all locations with `-`).
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *QueryOrgVpcFlowLogsConfigsResponse) Reset() {
	*x = QueryOrgVpcFlowLogsConfigsResponse{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryOrgVpcFlowLogsConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryOrgVpcFlowLogsConfigsResponse) ProtoMessage() {}

func (x *QueryOrgVpcFlowLogsConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryOrgVpcFlowLogsConfigsResponse.ProtoReflect.Descriptor instead.
func (*QueryOrgVpcFlowLogsConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{7}
}

func (x *QueryOrgVpcFlowLogsConfigsResponse) GetVpcFlowLogsConfigs() []*VpcFlowLogsConfig {
	if x != nil {
		return x.VpcFlowLogsConfigs
	}
	return nil
}

func (x *QueryOrgVpcFlowLogsConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *QueryOrgVpcFlowLogsConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `ShowEffectiveFlowLogsConfigs` method.
type ShowEffectiveFlowLogsConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the VpcFlowLogsConfig, specified in
	// the following format: `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource to get the effective VPC Flow Logs configuration
	// for. The resource must belong to the same project as the parent. The
	// resource must be a network, subnetwork, interconnect attachment, VPN
	// tunnel, or a project.
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Optional. Number of `EffectiveVpcFlowLogsConfigs` to return. Default is 30.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token from an earlier query, as returned in
	// `next_page_token`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the `EffectiveVpcFlowLogsConfigs` that match the filter
	// expression. A filter expression must use the supported [CEL logic
	// operators]
	// (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ShowEffectiveFlowLogsConfigsRequest) Reset() {
	*x = ShowEffectiveFlowLogsConfigsRequest{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShowEffectiveFlowLogsConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowEffectiveFlowLogsConfigsRequest) ProtoMessage() {}

func (x *ShowEffectiveFlowLogsConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowEffectiveFlowLogsConfigsRequest.ProtoReflect.Descriptor instead.
func (*ShowEffectiveFlowLogsConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{8}
}

func (x *ShowEffectiveFlowLogsConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ShowEffectiveFlowLogsConfigsRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *ShowEffectiveFlowLogsConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ShowEffectiveFlowLogsConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ShowEffectiveFlowLogsConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response for the `ShowEffectiveFlowLogsConfigs` method.
type ShowEffectiveFlowLogsConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Effective Vpc Flow Logs configurations.
	EffectiveFlowLogsConfigs []*EffectiveVpcFlowLogsConfig `protobuf:"bytes,1,rep,name=effective_flow_logs_configs,json=effectiveFlowLogsConfigs,proto3" json:"effective_flow_logs_configs,omitempty"`
	// Page token to fetch the next set of configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached (when querying all locations with `-`).
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ShowEffectiveFlowLogsConfigsResponse) Reset() {
	*x = ShowEffectiveFlowLogsConfigsResponse{}
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShowEffectiveFlowLogsConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowEffectiveFlowLogsConfigsResponse) ProtoMessage() {}

func (x *ShowEffectiveFlowLogsConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowEffectiveFlowLogsConfigsResponse.ProtoReflect.Descriptor instead.
func (*ShowEffectiveFlowLogsConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP(), []int{9}
}

func (x *ShowEffectiveFlowLogsConfigsResponse) GetEffectiveFlowLogsConfigs() []*EffectiveVpcFlowLogsConfig {
	if x != nil {
		return x.EffectiveFlowLogsConfigs
	}
	return nil
}

func (x *ShowEffectiveFlowLogsConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ShowEffectiveFlowLogsConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

var File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f,
	0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12,
	0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd3,
	0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x67, 0x0a, 0x15, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f,
	0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x6d, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd2, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x17, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x6a, 0x0a, 0x14,
	0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xce, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x6a, 0x0a,
	0x14, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x70, 0x0a, 0x1e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01, 0x0a, 0x21,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x72, 0x67, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46,
	0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd7, 0x01, 0x0a, 0x22, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x4f, 0x72, 0x67, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x67, 0x0a, 0x15, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x23, 0x53, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x34, 0x12, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1f,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xee, 0x01, 0x0a, 0x24, 0x53, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7c, 0x0a, 0x1b, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f,
	0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x18, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x32, 0x82, 0x10, 0x0a, 0x12, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x02, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd5, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x11, 0x56,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76,
	0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2c, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x14, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0xd5, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd7, 0x01,
	0xca, 0x41, 0x48, 0x0a, 0x11, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x63, 0x3a, 0x14, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c,
	0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x92, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0xca, 0x41, 0x4c, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x84, 0x02, 0x0a,
	0x1a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x72, 0x67, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x72, 0x67, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x72, 0x67, 0x56, 0x70,
	0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x12, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x72,
	0x67, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x8c, 0x02, 0x0a, 0x1c, 0x53, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x73, 0x68, 0x6f, 0x77, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0x91, 0x0c, 0x0a, 0x1e, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77,
	0x4c, 0x6f, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xeb, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xd8, 0x01, 0x0a, 0x14, 0x47, 0x65,
	0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd8, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56,
	0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c,
	0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xda, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x11, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x76,
	0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x14, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x70, 0x63,
	0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0xda, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f,
	0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x01,
	0xca, 0x41, 0x48, 0x0a, 0x11, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x76, 0x70,
	0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x68, 0x3a, 0x14, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c,
	0x6f, 0x67, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x50, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x76, 0x70, 0x63, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f,
	0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x4c,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x76, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c, 0x6f, 0x67, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xff, 0x01, 0x0a,
	0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x56, 0x70, 0x63, 0x46, 0x6c, 0x6f, 0x77, 0x4c,
	0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData = file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes = []any{
	(*ListVpcFlowLogsConfigsRequest)(nil),        // 0: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest
	(*ListVpcFlowLogsConfigsResponse)(nil),       // 1: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse
	(*GetVpcFlowLogsConfigRequest)(nil),          // 2: google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest
	(*CreateVpcFlowLogsConfigRequest)(nil),       // 3: google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest
	(*UpdateVpcFlowLogsConfigRequest)(nil),       // 4: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest
	(*DeleteVpcFlowLogsConfigRequest)(nil),       // 5: google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest
	(*QueryOrgVpcFlowLogsConfigsRequest)(nil),    // 6: google.cloud.networkmanagement.v1.QueryOrgVpcFlowLogsConfigsRequest
	(*QueryOrgVpcFlowLogsConfigsResponse)(nil),   // 7: google.cloud.networkmanagement.v1.QueryOrgVpcFlowLogsConfigsResponse
	(*ShowEffectiveFlowLogsConfigsRequest)(nil),  // 8: google.cloud.networkmanagement.v1.ShowEffectiveFlowLogsConfigsRequest
	(*ShowEffectiveFlowLogsConfigsResponse)(nil), // 9: google.cloud.networkmanagement.v1.ShowEffectiveFlowLogsConfigsResponse
	(*VpcFlowLogsConfig)(nil),                    // 10: google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	(*fieldmaskpb.FieldMask)(nil),                // 11: google.protobuf.FieldMask
	(*EffectiveVpcFlowLogsConfig)(nil),           // 12: google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig
	(*longrunningpb.Operation)(nil),              // 13: google.longrunning.Operation
}
var file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs = []int32{
	10, // 0: google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse.vpc_flow_logs_configs:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	10, // 1: google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest.vpc_flow_logs_config:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	11, // 2: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 3: google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest.vpc_flow_logs_config:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	10, // 4: google.cloud.networkmanagement.v1.QueryOrgVpcFlowLogsConfigsResponse.vpc_flow_logs_configs:type_name -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	12, // 5: google.cloud.networkmanagement.v1.ShowEffectiveFlowLogsConfigsResponse.effective_flow_logs_configs:type_name -> google.cloud.networkmanagement.v1.EffectiveVpcFlowLogsConfig
	0,  // 6: google.cloud.networkmanagement.v1.VpcFlowLogsService.ListVpcFlowLogsConfigs:input_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest
	2,  // 7: google.cloud.networkmanagement.v1.VpcFlowLogsService.GetVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest
	3,  // 8: google.cloud.networkmanagement.v1.VpcFlowLogsService.CreateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest
	4,  // 9: google.cloud.networkmanagement.v1.VpcFlowLogsService.UpdateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest
	5,  // 10: google.cloud.networkmanagement.v1.VpcFlowLogsService.DeleteVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest
	6,  // 11: google.cloud.networkmanagement.v1.VpcFlowLogsService.QueryOrgVpcFlowLogsConfigs:input_type -> google.cloud.networkmanagement.v1.QueryOrgVpcFlowLogsConfigsRequest
	8,  // 12: google.cloud.networkmanagement.v1.VpcFlowLogsService.ShowEffectiveFlowLogsConfigs:input_type -> google.cloud.networkmanagement.v1.ShowEffectiveFlowLogsConfigsRequest
	0,  // 13: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.ListVpcFlowLogsConfigs:input_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsRequest
	2,  // 14: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.GetVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.GetVpcFlowLogsConfigRequest
	3,  // 15: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.CreateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.CreateVpcFlowLogsConfigRequest
	4,  // 16: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.UpdateVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.UpdateVpcFlowLogsConfigRequest
	5,  // 17: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.DeleteVpcFlowLogsConfig:input_type -> google.cloud.networkmanagement.v1.DeleteVpcFlowLogsConfigRequest
	1,  // 18: google.cloud.networkmanagement.v1.VpcFlowLogsService.ListVpcFlowLogsConfigs:output_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse
	10, // 19: google.cloud.networkmanagement.v1.VpcFlowLogsService.GetVpcFlowLogsConfig:output_type -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	13, // 20: google.cloud.networkmanagement.v1.VpcFlowLogsService.CreateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	13, // 21: google.cloud.networkmanagement.v1.VpcFlowLogsService.UpdateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	13, // 22: google.cloud.networkmanagement.v1.VpcFlowLogsService.DeleteVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	7,  // 23: google.cloud.networkmanagement.v1.VpcFlowLogsService.QueryOrgVpcFlowLogsConfigs:output_type -> google.cloud.networkmanagement.v1.QueryOrgVpcFlowLogsConfigsResponse
	9,  // 24: google.cloud.networkmanagement.v1.VpcFlowLogsService.ShowEffectiveFlowLogsConfigs:output_type -> google.cloud.networkmanagement.v1.ShowEffectiveFlowLogsConfigsResponse
	1,  // 25: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.ListVpcFlowLogsConfigs:output_type -> google.cloud.networkmanagement.v1.ListVpcFlowLogsConfigsResponse
	10, // 26: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.GetVpcFlowLogsConfig:output_type -> google.cloud.networkmanagement.v1.VpcFlowLogsConfig
	13, // 27: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.CreateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	13, // 28: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.UpdateVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	13, // 29: google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService.DeleteVpcFlowLogsConfig:output_type -> google.longrunning.Operation
	18, // [18:30] is the sub-list for method output_type
	6,  // [6:18] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_init() }
func file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_init() {
	if File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto != nil {
		return
	}
	file_google_cloud_networkmanagement_v1_reachability_proto_init()
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_config_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs,
		MessageInfos:      file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_vpc_flow_logs_proto = out.File
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_vpc_flow_logs_proto_depIdxs = nil
}
