// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package tnb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelSolNetworkOperation = "CancelSolNetworkOperation"

// CancelSolNetworkOperationRequest generates a "aws/request.Request" representing the
// client's request for the CancelSolNetworkOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSolNetworkOperation for more information on using the CancelSolNetworkOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelSolNetworkOperationRequest method.
//	req, resp := client.CancelSolNetworkOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation
func (c *Tnb) CancelSolNetworkOperationRequest(input *CancelSolNetworkOperationInput) (req *request.Request, output *CancelSolNetworkOperationOutput) {
	op := &request.Operation{
		Name:       opCancelSolNetworkOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nslcm/v1/ns_lcm_op_occs/{nsLcmOpOccId}/cancel",
	}

	if input == nil {
		input = &CancelSolNetworkOperationInput{}
	}

	output = &CancelSolNetworkOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSolNetworkOperation API operation for AWS Telco Network Builder.
//
// Cancels a network operation.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation CancelSolNetworkOperation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation
func (c *Tnb) CancelSolNetworkOperation(input *CancelSolNetworkOperationInput) (*CancelSolNetworkOperationOutput, error) {
	req, out := c.CancelSolNetworkOperationRequest(input)
	return out, req.Send()
}

// CancelSolNetworkOperationWithContext is the same as CancelSolNetworkOperation with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSolNetworkOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) CancelSolNetworkOperationWithContext(ctx aws.Context, input *CancelSolNetworkOperationInput, opts ...request.Option) (*CancelSolNetworkOperationOutput, error) {
	req, out := c.CancelSolNetworkOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolFunctionPackage = "CreateSolFunctionPackage"

// CreateSolFunctionPackageRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolFunctionPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolFunctionPackage for more information on using the CreateSolFunctionPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSolFunctionPackageRequest method.
//	req, resp := client.CreateSolFunctionPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage
func (c *Tnb) CreateSolFunctionPackageRequest(input *CreateSolFunctionPackageInput) (req *request.Request, output *CreateSolFunctionPackageOutput) {
	op := &request.Operation{
		Name:       opCreateSolFunctionPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages",
	}

	if input == nil {
		input = &CreateSolFunctionPackageInput{}
	}

	output = &CreateSolFunctionPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolFunctionPackage API operation for AWS Telco Network Builder.
//
// Creates a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network. For more information,
// see Function packages (https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html)
// in the Amazon Web Services Telco Network Builder User Guide.
//
// Creating a function package is the first step for creating a network in AWS
// TNB. This request creates an empty container with an ID. The next step is
// to upload the actual CSAR zip file into that empty container. To upload function
// package content, see PutSolFunctionPackageContent (https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation CreateSolFunctionPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage
func (c *Tnb) CreateSolFunctionPackage(input *CreateSolFunctionPackageInput) (*CreateSolFunctionPackageOutput, error) {
	req, out := c.CreateSolFunctionPackageRequest(input)
	return out, req.Send()
}

// CreateSolFunctionPackageWithContext is the same as CreateSolFunctionPackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolFunctionPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) CreateSolFunctionPackageWithContext(ctx aws.Context, input *CreateSolFunctionPackageInput, opts ...request.Option) (*CreateSolFunctionPackageOutput, error) {
	req, out := c.CreateSolFunctionPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolNetworkInstance = "CreateSolNetworkInstance"

// CreateSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolNetworkInstance for more information on using the CreateSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSolNetworkInstanceRequest method.
//	req, resp := client.CreateSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance
func (c *Tnb) CreateSolNetworkInstanceRequest(input *CreateSolNetworkInstanceInput) (req *request.Request, output *CreateSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateSolNetworkInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nslcm/v1/ns_instances",
	}

	if input == nil {
		input = &CreateSolNetworkInstanceInput{}
	}

	output = &CreateSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Creates a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed. Creating a network instance is the
// third step after creating a network package. For more information about network
// instances, Network instances (https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html)
// in the Amazon Web Services Telco Network Builder User Guide.
//
// Once you create a network instance, you can instantiate it. To instantiate
// a network, see InstantiateSolNetworkInstance (https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation CreateSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance
func (c *Tnb) CreateSolNetworkInstance(input *CreateSolNetworkInstanceInput) (*CreateSolNetworkInstanceOutput, error) {
	req, out := c.CreateSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// CreateSolNetworkInstanceWithContext is the same as CreateSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) CreateSolNetworkInstanceWithContext(ctx aws.Context, input *CreateSolNetworkInstanceInput, opts ...request.Option) (*CreateSolNetworkInstanceOutput, error) {
	req, out := c.CreateSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolNetworkPackage = "CreateSolNetworkPackage"

// CreateSolNetworkPackageRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolNetworkPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolNetworkPackage for more information on using the CreateSolNetworkPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSolNetworkPackageRequest method.
//	req, resp := client.CreateSolNetworkPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage
func (c *Tnb) CreateSolNetworkPackageRequest(input *CreateSolNetworkPackageInput) (req *request.Request, output *CreateSolNetworkPackageOutput) {
	op := &request.Operation{
		Name:       opCreateSolNetworkPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors",
	}

	if input == nil {
		input = &CreateSolNetworkPackageInput{}
	}

	output = &CreateSolNetworkPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolNetworkPackage API operation for AWS Telco Network Builder.
//
// Creates a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on. For more information, see Network instances (https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html)
// in the Amazon Web Services Telco Network Builder User Guide.
//
// A network package consists of a network service descriptor (NSD) file (required)
// and any additional files (optional), such as scripts specific to your needs.
// For example, if you have multiple function packages in your network package,
// you can use the NSD to define which network functions should run in certain
// VPCs, subnets, or EKS clusters.
//
// This request creates an empty network package container with an ID. Once
// you create a network package, you can upload the network package content
// using PutSolNetworkPackageContent (https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation CreateSolNetworkPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage
func (c *Tnb) CreateSolNetworkPackage(input *CreateSolNetworkPackageInput) (*CreateSolNetworkPackageOutput, error) {
	req, out := c.CreateSolNetworkPackageRequest(input)
	return out, req.Send()
}

// CreateSolNetworkPackageWithContext is the same as CreateSolNetworkPackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolNetworkPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) CreateSolNetworkPackageWithContext(ctx aws.Context, input *CreateSolNetworkPackageInput, opts ...request.Option) (*CreateSolNetworkPackageOutput, error) {
	req, out := c.CreateSolNetworkPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSolFunctionPackage = "DeleteSolFunctionPackage"

// DeleteSolFunctionPackageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSolFunctionPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSolFunctionPackage for more information on using the DeleteSolFunctionPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSolFunctionPackageRequest method.
//	req, resp := client.DeleteSolFunctionPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage
func (c *Tnb) DeleteSolFunctionPackageRequest(input *DeleteSolFunctionPackageInput) (req *request.Request, output *DeleteSolFunctionPackageOutput) {
	op := &request.Operation{
		Name:       opDeleteSolFunctionPackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
	}

	if input == nil {
		input = &DeleteSolFunctionPackageInput{}
	}

	output = &DeleteSolFunctionPackageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSolFunctionPackage API operation for AWS Telco Network Builder.
//
// Deletes a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// To delete a function package, the package must be in a disabled state. To
// disable a function package, see UpdateSolFunctionPackage (https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation DeleteSolFunctionPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage
func (c *Tnb) DeleteSolFunctionPackage(input *DeleteSolFunctionPackageInput) (*DeleteSolFunctionPackageOutput, error) {
	req, out := c.DeleteSolFunctionPackageRequest(input)
	return out, req.Send()
}

// DeleteSolFunctionPackageWithContext is the same as DeleteSolFunctionPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSolFunctionPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) DeleteSolFunctionPackageWithContext(ctx aws.Context, input *DeleteSolFunctionPackageInput, opts ...request.Option) (*DeleteSolFunctionPackageOutput, error) {
	req, out := c.DeleteSolFunctionPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSolNetworkInstance = "DeleteSolNetworkInstance"

// DeleteSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSolNetworkInstance for more information on using the DeleteSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSolNetworkInstanceRequest method.
//	req, resp := client.DeleteSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance
func (c *Tnb) DeleteSolNetworkInstanceRequest(input *DeleteSolNetworkInstanceInput) (req *request.Request, output *DeleteSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteSolNetworkInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sol/nslcm/v1/ns_instances/{nsInstanceId}",
	}

	if input == nil {
		input = &DeleteSolNetworkInstanceInput{}
	}

	output = &DeleteSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Deletes a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// To delete a network instance, the instance must be in a stopped or terminated
// state. To terminate a network instance, see TerminateSolNetworkInstance (https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation DeleteSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance
func (c *Tnb) DeleteSolNetworkInstance(input *DeleteSolNetworkInstanceInput) (*DeleteSolNetworkInstanceOutput, error) {
	req, out := c.DeleteSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// DeleteSolNetworkInstanceWithContext is the same as DeleteSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) DeleteSolNetworkInstanceWithContext(ctx aws.Context, input *DeleteSolNetworkInstanceInput, opts ...request.Option) (*DeleteSolNetworkInstanceOutput, error) {
	req, out := c.DeleteSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSolNetworkPackage = "DeleteSolNetworkPackage"

// DeleteSolNetworkPackageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSolNetworkPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSolNetworkPackage for more information on using the DeleteSolNetworkPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSolNetworkPackageRequest method.
//	req, resp := client.DeleteSolNetworkPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage
func (c *Tnb) DeleteSolNetworkPackageRequest(input *DeleteSolNetworkPackageInput) (req *request.Request, output *DeleteSolNetworkPackageOutput) {
	op := &request.Operation{
		Name:       opDeleteSolNetworkPackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
	}

	if input == nil {
		input = &DeleteSolNetworkPackageInput{}
	}

	output = &DeleteSolNetworkPackageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSolNetworkPackage API operation for AWS Telco Network Builder.
//
// Deletes network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// To delete a network package, the package must be in a disable state. To disable
// a network package, see UpdateSolNetworkPackage (https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation DeleteSolNetworkPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage
func (c *Tnb) DeleteSolNetworkPackage(input *DeleteSolNetworkPackageInput) (*DeleteSolNetworkPackageOutput, error) {
	req, out := c.DeleteSolNetworkPackageRequest(input)
	return out, req.Send()
}

// DeleteSolNetworkPackageWithContext is the same as DeleteSolNetworkPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSolNetworkPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) DeleteSolNetworkPackageWithContext(ctx aws.Context, input *DeleteSolNetworkPackageInput, opts ...request.Option) (*DeleteSolNetworkPackageOutput, error) {
	req, out := c.DeleteSolNetworkPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolFunctionInstance = "GetSolFunctionInstance"

// GetSolFunctionInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetSolFunctionInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolFunctionInstance for more information on using the GetSolFunctionInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolFunctionInstanceRequest method.
//	req, resp := client.GetSolFunctionInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance
func (c *Tnb) GetSolFunctionInstanceRequest(input *GetSolFunctionInstanceInput) (req *request.Request, output *GetSolFunctionInstanceOutput) {
	op := &request.Operation{
		Name:       opGetSolFunctionInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnflcm/v1/vnf_instances/{vnfInstanceId}",
	}

	if input == nil {
		input = &GetSolFunctionInstanceInput{}
	}

	output = &GetSolFunctionInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolFunctionInstance API operation for AWS Telco Network Builder.
//
// Gets the details of a network function instance, including the instantation
// state and metadata from the function package descriptor in the network function
// package.
//
// A network function instance is a function in a function package .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolFunctionInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance
func (c *Tnb) GetSolFunctionInstance(input *GetSolFunctionInstanceInput) (*GetSolFunctionInstanceOutput, error) {
	req, out := c.GetSolFunctionInstanceRequest(input)
	return out, req.Send()
}

// GetSolFunctionInstanceWithContext is the same as GetSolFunctionInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolFunctionInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolFunctionInstanceWithContext(ctx aws.Context, input *GetSolFunctionInstanceInput, opts ...request.Option) (*GetSolFunctionInstanceOutput, error) {
	req, out := c.GetSolFunctionInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolFunctionPackage = "GetSolFunctionPackage"

// GetSolFunctionPackageRequest generates a "aws/request.Request" representing the
// client's request for the GetSolFunctionPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolFunctionPackage for more information on using the GetSolFunctionPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolFunctionPackageRequest method.
//	req, resp := client.GetSolFunctionPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage
func (c *Tnb) GetSolFunctionPackageRequest(input *GetSolFunctionPackageInput) (req *request.Request, output *GetSolFunctionPackageOutput) {
	op := &request.Operation{
		Name:       opGetSolFunctionPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
	}

	if input == nil {
		input = &GetSolFunctionPackageInput{}
	}

	output = &GetSolFunctionPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolFunctionPackage API operation for AWS Telco Network Builder.
//
// Gets the details of an individual function package, such as the operational
// state and whether the package is in use.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolFunctionPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage
func (c *Tnb) GetSolFunctionPackage(input *GetSolFunctionPackageInput) (*GetSolFunctionPackageOutput, error) {
	req, out := c.GetSolFunctionPackageRequest(input)
	return out, req.Send()
}

// GetSolFunctionPackageWithContext is the same as GetSolFunctionPackage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolFunctionPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolFunctionPackageWithContext(ctx aws.Context, input *GetSolFunctionPackageInput, opts ...request.Option) (*GetSolFunctionPackageOutput, error) {
	req, out := c.GetSolFunctionPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolFunctionPackageContent = "GetSolFunctionPackageContent"

// GetSolFunctionPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the GetSolFunctionPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolFunctionPackageContent for more information on using the GetSolFunctionPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolFunctionPackageContentRequest method.
//	req, resp := client.GetSolFunctionPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent
func (c *Tnb) GetSolFunctionPackageContentRequest(input *GetSolFunctionPackageContentInput) (req *request.Request, output *GetSolFunctionPackageContentOutput) {
	op := &request.Operation{
		Name:       opGetSolFunctionPackageContent,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content",
	}

	if input == nil {
		input = &GetSolFunctionPackageContentInput{}
	}

	output = &GetSolFunctionPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolFunctionPackageContent API operation for AWS Telco Network Builder.
//
// Gets the contents of a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolFunctionPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent
func (c *Tnb) GetSolFunctionPackageContent(input *GetSolFunctionPackageContentInput) (*GetSolFunctionPackageContentOutput, error) {
	req, out := c.GetSolFunctionPackageContentRequest(input)
	return out, req.Send()
}

// GetSolFunctionPackageContentWithContext is the same as GetSolFunctionPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolFunctionPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolFunctionPackageContentWithContext(ctx aws.Context, input *GetSolFunctionPackageContentInput, opts ...request.Option) (*GetSolFunctionPackageContentOutput, error) {
	req, out := c.GetSolFunctionPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolFunctionPackageDescriptor = "GetSolFunctionPackageDescriptor"

// GetSolFunctionPackageDescriptorRequest generates a "aws/request.Request" representing the
// client's request for the GetSolFunctionPackageDescriptor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolFunctionPackageDescriptor for more information on using the GetSolFunctionPackageDescriptor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolFunctionPackageDescriptorRequest method.
//	req, resp := client.GetSolFunctionPackageDescriptorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor
func (c *Tnb) GetSolFunctionPackageDescriptorRequest(input *GetSolFunctionPackageDescriptorInput) (req *request.Request, output *GetSolFunctionPackageDescriptorOutput) {
	op := &request.Operation{
		Name:       opGetSolFunctionPackageDescriptor,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/vnfd",
	}

	if input == nil {
		input = &GetSolFunctionPackageDescriptorInput{}
	}

	output = &GetSolFunctionPackageDescriptorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolFunctionPackageDescriptor API operation for AWS Telco Network Builder.
//
// Gets a function package descriptor in a function package.
//
// A function package descriptor is a .yaml file in a function package that
// uses the TOSCA standard to describe how the network function in the function
// package should run on your network.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolFunctionPackageDescriptor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor
func (c *Tnb) GetSolFunctionPackageDescriptor(input *GetSolFunctionPackageDescriptorInput) (*GetSolFunctionPackageDescriptorOutput, error) {
	req, out := c.GetSolFunctionPackageDescriptorRequest(input)
	return out, req.Send()
}

// GetSolFunctionPackageDescriptorWithContext is the same as GetSolFunctionPackageDescriptor with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolFunctionPackageDescriptor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolFunctionPackageDescriptorWithContext(ctx aws.Context, input *GetSolFunctionPackageDescriptorInput, opts ...request.Option) (*GetSolFunctionPackageDescriptorOutput, error) {
	req, out := c.GetSolFunctionPackageDescriptorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolNetworkInstance = "GetSolNetworkInstance"

// GetSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolNetworkInstance for more information on using the GetSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolNetworkInstanceRequest method.
//	req, resp := client.GetSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance
func (c *Tnb) GetSolNetworkInstanceRequest(input *GetSolNetworkInstanceInput) (req *request.Request, output *GetSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opGetSolNetworkInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nslcm/v1/ns_instances/{nsInstanceId}",
	}

	if input == nil {
		input = &GetSolNetworkInstanceInput{}
	}

	output = &GetSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Gets the details of the network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance
func (c *Tnb) GetSolNetworkInstance(input *GetSolNetworkInstanceInput) (*GetSolNetworkInstanceOutput, error) {
	req, out := c.GetSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// GetSolNetworkInstanceWithContext is the same as GetSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolNetworkInstanceWithContext(ctx aws.Context, input *GetSolNetworkInstanceInput, opts ...request.Option) (*GetSolNetworkInstanceOutput, error) {
	req, out := c.GetSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolNetworkOperation = "GetSolNetworkOperation"

// GetSolNetworkOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetSolNetworkOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolNetworkOperation for more information on using the GetSolNetworkOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolNetworkOperationRequest method.
//	req, resp := client.GetSolNetworkOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation
func (c *Tnb) GetSolNetworkOperationRequest(input *GetSolNetworkOperationInput) (req *request.Request, output *GetSolNetworkOperationOutput) {
	op := &request.Operation{
		Name:       opGetSolNetworkOperation,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nslcm/v1/ns_lcm_op_occs/{nsLcmOpOccId}",
	}

	if input == nil {
		input = &GetSolNetworkOperationInput{}
	}

	output = &GetSolNetworkOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolNetworkOperation API operation for AWS Telco Network Builder.
//
// Gets the details of a network operation, including the tasks involved in
// the network operation and the status of the tasks.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolNetworkOperation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation
func (c *Tnb) GetSolNetworkOperation(input *GetSolNetworkOperationInput) (*GetSolNetworkOperationOutput, error) {
	req, out := c.GetSolNetworkOperationRequest(input)
	return out, req.Send()
}

// GetSolNetworkOperationWithContext is the same as GetSolNetworkOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolNetworkOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolNetworkOperationWithContext(ctx aws.Context, input *GetSolNetworkOperationInput, opts ...request.Option) (*GetSolNetworkOperationOutput, error) {
	req, out := c.GetSolNetworkOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolNetworkPackage = "GetSolNetworkPackage"

// GetSolNetworkPackageRequest generates a "aws/request.Request" representing the
// client's request for the GetSolNetworkPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolNetworkPackage for more information on using the GetSolNetworkPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolNetworkPackageRequest method.
//	req, resp := client.GetSolNetworkPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage
func (c *Tnb) GetSolNetworkPackageRequest(input *GetSolNetworkPackageInput) (req *request.Request, output *GetSolNetworkPackageOutput) {
	op := &request.Operation{
		Name:       opGetSolNetworkPackage,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
	}

	if input == nil {
		input = &GetSolNetworkPackageInput{}
	}

	output = &GetSolNetworkPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolNetworkPackage API operation for AWS Telco Network Builder.
//
// Gets the details of a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolNetworkPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage
func (c *Tnb) GetSolNetworkPackage(input *GetSolNetworkPackageInput) (*GetSolNetworkPackageOutput, error) {
	req, out := c.GetSolNetworkPackageRequest(input)
	return out, req.Send()
}

// GetSolNetworkPackageWithContext is the same as GetSolNetworkPackage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolNetworkPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolNetworkPackageWithContext(ctx aws.Context, input *GetSolNetworkPackageInput, opts ...request.Option) (*GetSolNetworkPackageOutput, error) {
	req, out := c.GetSolNetworkPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolNetworkPackageContent = "GetSolNetworkPackageContent"

// GetSolNetworkPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the GetSolNetworkPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolNetworkPackageContent for more information on using the GetSolNetworkPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolNetworkPackageContentRequest method.
//	req, resp := client.GetSolNetworkPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent
func (c *Tnb) GetSolNetworkPackageContentRequest(input *GetSolNetworkPackageContentInput) (req *request.Request, output *GetSolNetworkPackageContentOutput) {
	op := &request.Operation{
		Name:       opGetSolNetworkPackageContent,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content",
	}

	if input == nil {
		input = &GetSolNetworkPackageContentInput{}
	}

	output = &GetSolNetworkPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolNetworkPackageContent API operation for AWS Telco Network Builder.
//
// Gets the contents of a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolNetworkPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent
func (c *Tnb) GetSolNetworkPackageContent(input *GetSolNetworkPackageContentInput) (*GetSolNetworkPackageContentOutput, error) {
	req, out := c.GetSolNetworkPackageContentRequest(input)
	return out, req.Send()
}

// GetSolNetworkPackageContentWithContext is the same as GetSolNetworkPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolNetworkPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolNetworkPackageContentWithContext(ctx aws.Context, input *GetSolNetworkPackageContentInput, opts ...request.Option) (*GetSolNetworkPackageContentOutput, error) {
	req, out := c.GetSolNetworkPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolNetworkPackageDescriptor = "GetSolNetworkPackageDescriptor"

// GetSolNetworkPackageDescriptorRequest generates a "aws/request.Request" representing the
// client's request for the GetSolNetworkPackageDescriptor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolNetworkPackageDescriptor for more information on using the GetSolNetworkPackageDescriptor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolNetworkPackageDescriptorRequest method.
//	req, resp := client.GetSolNetworkPackageDescriptorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor
func (c *Tnb) GetSolNetworkPackageDescriptorRequest(input *GetSolNetworkPackageDescriptorInput) (req *request.Request, output *GetSolNetworkPackageDescriptorOutput) {
	op := &request.Operation{
		Name:       opGetSolNetworkPackageDescriptor,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd",
	}

	if input == nil {
		input = &GetSolNetworkPackageDescriptorInput{}
	}

	output = &GetSolNetworkPackageDescriptorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolNetworkPackageDescriptor API operation for AWS Telco Network Builder.
//
// Gets the content of the network service descriptor.
//
// A network service descriptor is a .yaml file in a network package that uses
// the TOSCA standard to describe the network functions you want to deploy and
// the Amazon Web Services infrastructure you want to deploy the network functions
// on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation GetSolNetworkPackageDescriptor for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor
func (c *Tnb) GetSolNetworkPackageDescriptor(input *GetSolNetworkPackageDescriptorInput) (*GetSolNetworkPackageDescriptorOutput, error) {
	req, out := c.GetSolNetworkPackageDescriptorRequest(input)
	return out, req.Send()
}

// GetSolNetworkPackageDescriptorWithContext is the same as GetSolNetworkPackageDescriptor with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolNetworkPackageDescriptor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) GetSolNetworkPackageDescriptorWithContext(ctx aws.Context, input *GetSolNetworkPackageDescriptorInput, opts ...request.Option) (*GetSolNetworkPackageDescriptorOutput, error) {
	req, out := c.GetSolNetworkPackageDescriptorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInstantiateSolNetworkInstance = "InstantiateSolNetworkInstance"

// InstantiateSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the InstantiateSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InstantiateSolNetworkInstance for more information on using the InstantiateSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InstantiateSolNetworkInstanceRequest method.
//	req, resp := client.InstantiateSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance
func (c *Tnb) InstantiateSolNetworkInstanceRequest(input *InstantiateSolNetworkInstanceInput) (req *request.Request, output *InstantiateSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opInstantiateSolNetworkInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nslcm/v1/ns_instances/{nsInstanceId}/instantiate",
	}

	if input == nil {
		input = &InstantiateSolNetworkInstanceInput{}
	}

	output = &InstantiateSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InstantiateSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Instantiates a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// Before you can instantiate a network instance, you have to create a network
// instance. For more information, see CreateSolNetworkInstance (https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation InstantiateSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance
func (c *Tnb) InstantiateSolNetworkInstance(input *InstantiateSolNetworkInstanceInput) (*InstantiateSolNetworkInstanceOutput, error) {
	req, out := c.InstantiateSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// InstantiateSolNetworkInstanceWithContext is the same as InstantiateSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See InstantiateSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) InstantiateSolNetworkInstanceWithContext(ctx aws.Context, input *InstantiateSolNetworkInstanceInput, opts ...request.Option) (*InstantiateSolNetworkInstanceOutput, error) {
	req, out := c.InstantiateSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSolFunctionInstances = "ListSolFunctionInstances"

// ListSolFunctionInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListSolFunctionInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolFunctionInstances for more information on using the ListSolFunctionInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolFunctionInstancesRequest method.
//	req, resp := client.ListSolFunctionInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances
func (c *Tnb) ListSolFunctionInstancesRequest(input *ListSolFunctionInstancesInput) (req *request.Request, output *ListSolFunctionInstancesOutput) {
	op := &request.Operation{
		Name:       opListSolFunctionInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnflcm/v1/vnf_instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolFunctionInstancesInput{}
	}

	output = &ListSolFunctionInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolFunctionInstances API operation for AWS Telco Network Builder.
//
// Lists network function instances.
//
// A network function instance is a function in a function package .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListSolFunctionInstances for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances
func (c *Tnb) ListSolFunctionInstances(input *ListSolFunctionInstancesInput) (*ListSolFunctionInstancesOutput, error) {
	req, out := c.ListSolFunctionInstancesRequest(input)
	return out, req.Send()
}

// ListSolFunctionInstancesWithContext is the same as ListSolFunctionInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolFunctionInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolFunctionInstancesWithContext(ctx aws.Context, input *ListSolFunctionInstancesInput, opts ...request.Option) (*ListSolFunctionInstancesOutput, error) {
	req, out := c.ListSolFunctionInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolFunctionInstancesPages iterates over the pages of a ListSolFunctionInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolFunctionInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolFunctionInstances operation.
//	pageNum := 0
//	err := client.ListSolFunctionInstancesPages(params,
//	    func(page *tnb.ListSolFunctionInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Tnb) ListSolFunctionInstancesPages(input *ListSolFunctionInstancesInput, fn func(*ListSolFunctionInstancesOutput, bool) bool) error {
	return c.ListSolFunctionInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolFunctionInstancesPagesWithContext same as ListSolFunctionInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolFunctionInstancesPagesWithContext(ctx aws.Context, input *ListSolFunctionInstancesInput, fn func(*ListSolFunctionInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolFunctionInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolFunctionInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolFunctionInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolFunctionPackages = "ListSolFunctionPackages"

// ListSolFunctionPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListSolFunctionPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolFunctionPackages for more information on using the ListSolFunctionPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolFunctionPackagesRequest method.
//	req, resp := client.ListSolFunctionPackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages
func (c *Tnb) ListSolFunctionPackagesRequest(input *ListSolFunctionPackagesInput) (req *request.Request, output *ListSolFunctionPackagesOutput) {
	op := &request.Operation{
		Name:       opListSolFunctionPackages,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolFunctionPackagesInput{}
	}

	output = &ListSolFunctionPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolFunctionPackages API operation for AWS Telco Network Builder.
//
// Lists information about function packages.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListSolFunctionPackages for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages
func (c *Tnb) ListSolFunctionPackages(input *ListSolFunctionPackagesInput) (*ListSolFunctionPackagesOutput, error) {
	req, out := c.ListSolFunctionPackagesRequest(input)
	return out, req.Send()
}

// ListSolFunctionPackagesWithContext is the same as ListSolFunctionPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolFunctionPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolFunctionPackagesWithContext(ctx aws.Context, input *ListSolFunctionPackagesInput, opts ...request.Option) (*ListSolFunctionPackagesOutput, error) {
	req, out := c.ListSolFunctionPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolFunctionPackagesPages iterates over the pages of a ListSolFunctionPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolFunctionPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolFunctionPackages operation.
//	pageNum := 0
//	err := client.ListSolFunctionPackagesPages(params,
//	    func(page *tnb.ListSolFunctionPackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Tnb) ListSolFunctionPackagesPages(input *ListSolFunctionPackagesInput, fn func(*ListSolFunctionPackagesOutput, bool) bool) error {
	return c.ListSolFunctionPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolFunctionPackagesPagesWithContext same as ListSolFunctionPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolFunctionPackagesPagesWithContext(ctx aws.Context, input *ListSolFunctionPackagesInput, fn func(*ListSolFunctionPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolFunctionPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolFunctionPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolFunctionPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolNetworkInstances = "ListSolNetworkInstances"

// ListSolNetworkInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListSolNetworkInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolNetworkInstances for more information on using the ListSolNetworkInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolNetworkInstancesRequest method.
//	req, resp := client.ListSolNetworkInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances
func (c *Tnb) ListSolNetworkInstancesRequest(input *ListSolNetworkInstancesInput) (req *request.Request, output *ListSolNetworkInstancesOutput) {
	op := &request.Operation{
		Name:       opListSolNetworkInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nslcm/v1/ns_instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolNetworkInstancesInput{}
	}

	output = &ListSolNetworkInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolNetworkInstances API operation for AWS Telco Network Builder.
//
// Lists your network instances.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListSolNetworkInstances for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances
func (c *Tnb) ListSolNetworkInstances(input *ListSolNetworkInstancesInput) (*ListSolNetworkInstancesOutput, error) {
	req, out := c.ListSolNetworkInstancesRequest(input)
	return out, req.Send()
}

// ListSolNetworkInstancesWithContext is the same as ListSolNetworkInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolNetworkInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkInstancesWithContext(ctx aws.Context, input *ListSolNetworkInstancesInput, opts ...request.Option) (*ListSolNetworkInstancesOutput, error) {
	req, out := c.ListSolNetworkInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolNetworkInstancesPages iterates over the pages of a ListSolNetworkInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolNetworkInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolNetworkInstances operation.
//	pageNum := 0
//	err := client.ListSolNetworkInstancesPages(params,
//	    func(page *tnb.ListSolNetworkInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Tnb) ListSolNetworkInstancesPages(input *ListSolNetworkInstancesInput, fn func(*ListSolNetworkInstancesOutput, bool) bool) error {
	return c.ListSolNetworkInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolNetworkInstancesPagesWithContext same as ListSolNetworkInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkInstancesPagesWithContext(ctx aws.Context, input *ListSolNetworkInstancesInput, fn func(*ListSolNetworkInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolNetworkInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolNetworkInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolNetworkInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolNetworkOperations = "ListSolNetworkOperations"

// ListSolNetworkOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSolNetworkOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolNetworkOperations for more information on using the ListSolNetworkOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolNetworkOperationsRequest method.
//	req, resp := client.ListSolNetworkOperationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations
func (c *Tnb) ListSolNetworkOperationsRequest(input *ListSolNetworkOperationsInput) (req *request.Request, output *ListSolNetworkOperationsOutput) {
	op := &request.Operation{
		Name:       opListSolNetworkOperations,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nslcm/v1/ns_lcm_op_occs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolNetworkOperationsInput{}
	}

	output = &ListSolNetworkOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolNetworkOperations API operation for AWS Telco Network Builder.
//
// Lists details for a network operation, including when the operation started
// and the status of the operation.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListSolNetworkOperations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations
func (c *Tnb) ListSolNetworkOperations(input *ListSolNetworkOperationsInput) (*ListSolNetworkOperationsOutput, error) {
	req, out := c.ListSolNetworkOperationsRequest(input)
	return out, req.Send()
}

// ListSolNetworkOperationsWithContext is the same as ListSolNetworkOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolNetworkOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkOperationsWithContext(ctx aws.Context, input *ListSolNetworkOperationsInput, opts ...request.Option) (*ListSolNetworkOperationsOutput, error) {
	req, out := c.ListSolNetworkOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolNetworkOperationsPages iterates over the pages of a ListSolNetworkOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolNetworkOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolNetworkOperations operation.
//	pageNum := 0
//	err := client.ListSolNetworkOperationsPages(params,
//	    func(page *tnb.ListSolNetworkOperationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Tnb) ListSolNetworkOperationsPages(input *ListSolNetworkOperationsInput, fn func(*ListSolNetworkOperationsOutput, bool) bool) error {
	return c.ListSolNetworkOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolNetworkOperationsPagesWithContext same as ListSolNetworkOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkOperationsPagesWithContext(ctx aws.Context, input *ListSolNetworkOperationsInput, fn func(*ListSolNetworkOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolNetworkOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolNetworkOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolNetworkOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolNetworkPackages = "ListSolNetworkPackages"

// ListSolNetworkPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListSolNetworkPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolNetworkPackages for more information on using the ListSolNetworkPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolNetworkPackagesRequest method.
//	req, resp := client.ListSolNetworkPackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages
func (c *Tnb) ListSolNetworkPackagesRequest(input *ListSolNetworkPackagesInput) (req *request.Request, output *ListSolNetworkPackagesOutput) {
	op := &request.Operation{
		Name:       opListSolNetworkPackages,
		HTTPMethod: "GET",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolNetworkPackagesInput{}
	}

	output = &ListSolNetworkPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolNetworkPackages API operation for AWS Telco Network Builder.
//
// Lists network packages.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListSolNetworkPackages for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages
func (c *Tnb) ListSolNetworkPackages(input *ListSolNetworkPackagesInput) (*ListSolNetworkPackagesOutput, error) {
	req, out := c.ListSolNetworkPackagesRequest(input)
	return out, req.Send()
}

// ListSolNetworkPackagesWithContext is the same as ListSolNetworkPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolNetworkPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkPackagesWithContext(ctx aws.Context, input *ListSolNetworkPackagesInput, opts ...request.Option) (*ListSolNetworkPackagesOutput, error) {
	req, out := c.ListSolNetworkPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolNetworkPackagesPages iterates over the pages of a ListSolNetworkPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolNetworkPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolNetworkPackages operation.
//	pageNum := 0
//	err := client.ListSolNetworkPackagesPages(params,
//	    func(page *tnb.ListSolNetworkPackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Tnb) ListSolNetworkPackagesPages(input *ListSolNetworkPackagesInput, fn func(*ListSolNetworkPackagesOutput, bool) bool) error {
	return c.ListSolNetworkPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolNetworkPackagesPagesWithContext same as ListSolNetworkPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListSolNetworkPackagesPagesWithContext(ctx aws.Context, input *ListSolNetworkPackagesInput, fn func(*ListSolNetworkPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolNetworkPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolNetworkPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolNetworkPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource
func (c *Tnb) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Telco Network Builder.
//
// Lists tags for AWS TNB resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource
func (c *Tnb) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSolFunctionPackageContent = "PutSolFunctionPackageContent"

// PutSolFunctionPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the PutSolFunctionPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSolFunctionPackageContent for more information on using the PutSolFunctionPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSolFunctionPackageContentRequest method.
//	req, resp := client.PutSolFunctionPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent
func (c *Tnb) PutSolFunctionPackageContentRequest(input *PutSolFunctionPackageContentInput) (req *request.Request, output *PutSolFunctionPackageContentOutput) {
	op := &request.Operation{
		Name:       opPutSolFunctionPackageContent,
		HTTPMethod: "PUT",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content",
	}

	if input == nil {
		input = &PutSolFunctionPackageContentInput{}
	}

	output = &PutSolFunctionPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSolFunctionPackageContent API operation for AWS Telco Network Builder.
//
// Uploads the contents of a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation PutSolFunctionPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent
func (c *Tnb) PutSolFunctionPackageContent(input *PutSolFunctionPackageContentInput) (*PutSolFunctionPackageContentOutput, error) {
	req, out := c.PutSolFunctionPackageContentRequest(input)
	return out, req.Send()
}

// PutSolFunctionPackageContentWithContext is the same as PutSolFunctionPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See PutSolFunctionPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) PutSolFunctionPackageContentWithContext(ctx aws.Context, input *PutSolFunctionPackageContentInput, opts ...request.Option) (*PutSolFunctionPackageContentOutput, error) {
	req, out := c.PutSolFunctionPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSolNetworkPackageContent = "PutSolNetworkPackageContent"

// PutSolNetworkPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the PutSolNetworkPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSolNetworkPackageContent for more information on using the PutSolNetworkPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSolNetworkPackageContentRequest method.
//	req, resp := client.PutSolNetworkPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent
func (c *Tnb) PutSolNetworkPackageContentRequest(input *PutSolNetworkPackageContentInput) (req *request.Request, output *PutSolNetworkPackageContentOutput) {
	op := &request.Operation{
		Name:       opPutSolNetworkPackageContent,
		HTTPMethod: "PUT",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content",
	}

	if input == nil {
		input = &PutSolNetworkPackageContentInput{}
	}

	output = &PutSolNetworkPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSolNetworkPackageContent API operation for AWS Telco Network Builder.
//
// Uploads the contents of a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation PutSolNetworkPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent
func (c *Tnb) PutSolNetworkPackageContent(input *PutSolNetworkPackageContentInput) (*PutSolNetworkPackageContentOutput, error) {
	req, out := c.PutSolNetworkPackageContentRequest(input)
	return out, req.Send()
}

// PutSolNetworkPackageContentWithContext is the same as PutSolNetworkPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See PutSolNetworkPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) PutSolNetworkPackageContentWithContext(ctx aws.Context, input *PutSolNetworkPackageContentInput, opts ...request.Option) (*PutSolNetworkPackageContentOutput, error) {
	req, out := c.PutSolNetworkPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource
func (c *Tnb) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Telco Network Builder.
//
// Tags an AWS TNB resource.
//
// A tag is a label that you assign to an Amazon Web Services resource. Each
// tag consists of a key and an optional value. You can use tags to search and
// filter your resources or track your Amazon Web Services costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource
func (c *Tnb) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateSolNetworkInstance = "TerminateSolNetworkInstance"

// TerminateSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the TerminateSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateSolNetworkInstance for more information on using the TerminateSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateSolNetworkInstanceRequest method.
//	req, resp := client.TerminateSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance
func (c *Tnb) TerminateSolNetworkInstanceRequest(input *TerminateSolNetworkInstanceInput) (req *request.Request, output *TerminateSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opTerminateSolNetworkInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nslcm/v1/ns_instances/{nsInstanceId}/terminate",
	}

	if input == nil {
		input = &TerminateSolNetworkInstanceInput{}
	}

	output = &TerminateSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Terminates a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// You must terminate a network instance before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation TerminateSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance
func (c *Tnb) TerminateSolNetworkInstance(input *TerminateSolNetworkInstanceInput) (*TerminateSolNetworkInstanceOutput, error) {
	req, out := c.TerminateSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// TerminateSolNetworkInstanceWithContext is the same as TerminateSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) TerminateSolNetworkInstanceWithContext(ctx aws.Context, input *TerminateSolNetworkInstanceInput, opts ...request.Option) (*TerminateSolNetworkInstanceOutput, error) {
	req, out := c.TerminateSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource
func (c *Tnb) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Telco Network Builder.
//
// Untags an AWS TNB resource.
//
// A tag is a label that you assign to an Amazon Web Services resource. Each
// tag consists of a key and an optional value. You can use tags to search and
// filter your resources or track your Amazon Web Services costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource
func (c *Tnb) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSolFunctionPackage = "UpdateSolFunctionPackage"

// UpdateSolFunctionPackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSolFunctionPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSolFunctionPackage for more information on using the UpdateSolFunctionPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSolFunctionPackageRequest method.
//	req, resp := client.UpdateSolFunctionPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage
func (c *Tnb) UpdateSolFunctionPackageRequest(input *UpdateSolFunctionPackageInput) (req *request.Request, output *UpdateSolFunctionPackageOutput) {
	op := &request.Operation{
		Name:       opUpdateSolFunctionPackage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
	}

	if input == nil {
		input = &UpdateSolFunctionPackageInput{}
	}

	output = &UpdateSolFunctionPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSolFunctionPackage API operation for AWS Telco Network Builder.
//
// Updates the operational state of function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation UpdateSolFunctionPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage
func (c *Tnb) UpdateSolFunctionPackage(input *UpdateSolFunctionPackageInput) (*UpdateSolFunctionPackageOutput, error) {
	req, out := c.UpdateSolFunctionPackageRequest(input)
	return out, req.Send()
}

// UpdateSolFunctionPackageWithContext is the same as UpdateSolFunctionPackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSolFunctionPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) UpdateSolFunctionPackageWithContext(ctx aws.Context, input *UpdateSolFunctionPackageInput, opts ...request.Option) (*UpdateSolFunctionPackageOutput, error) {
	req, out := c.UpdateSolFunctionPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSolNetworkInstance = "UpdateSolNetworkInstance"

// UpdateSolNetworkInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSolNetworkInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSolNetworkInstance for more information on using the UpdateSolNetworkInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSolNetworkInstanceRequest method.
//	req, resp := client.UpdateSolNetworkInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance
func (c *Tnb) UpdateSolNetworkInstanceRequest(input *UpdateSolNetworkInstanceInput) (req *request.Request, output *UpdateSolNetworkInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateSolNetworkInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/sol/nslcm/v1/ns_instances/{nsInstanceId}/update",
	}

	if input == nil {
		input = &UpdateSolNetworkInstanceInput{}
	}

	output = &UpdateSolNetworkInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSolNetworkInstance API operation for AWS Telco Network Builder.
//
// Update a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation UpdateSolNetworkInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ServiceQuotaExceededException
//     Service quotas have been exceeded.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance
func (c *Tnb) UpdateSolNetworkInstance(input *UpdateSolNetworkInstanceInput) (*UpdateSolNetworkInstanceOutput, error) {
	req, out := c.UpdateSolNetworkInstanceRequest(input)
	return out, req.Send()
}

// UpdateSolNetworkInstanceWithContext is the same as UpdateSolNetworkInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSolNetworkInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) UpdateSolNetworkInstanceWithContext(ctx aws.Context, input *UpdateSolNetworkInstanceInput, opts ...request.Option) (*UpdateSolNetworkInstanceOutput, error) {
	req, out := c.UpdateSolNetworkInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSolNetworkPackage = "UpdateSolNetworkPackage"

// UpdateSolNetworkPackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSolNetworkPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSolNetworkPackage for more information on using the UpdateSolNetworkPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSolNetworkPackageRequest method.
//	req, resp := client.UpdateSolNetworkPackageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage
func (c *Tnb) UpdateSolNetworkPackageRequest(input *UpdateSolNetworkPackageInput) (req *request.Request, output *UpdateSolNetworkPackageOutput) {
	op := &request.Operation{
		Name:       opUpdateSolNetworkPackage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
	}

	if input == nil {
		input = &UpdateSolNetworkPackageInput{}
	}

	output = &UpdateSolNetworkPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSolNetworkPackage API operation for AWS Telco Network Builder.
//
// Updates the operational state of a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// A network service descriptor is a .yaml file in a network package that uses
// the TOSCA standard to describe the network functions you want to deploy and
// the Amazon Web Services infrastructure you want to deploy the network functions
// on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation UpdateSolNetworkPackage for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage
func (c *Tnb) UpdateSolNetworkPackage(input *UpdateSolNetworkPackageInput) (*UpdateSolNetworkPackageOutput, error) {
	req, out := c.UpdateSolNetworkPackageRequest(input)
	return out, req.Send()
}

// UpdateSolNetworkPackageWithContext is the same as UpdateSolNetworkPackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSolNetworkPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) UpdateSolNetworkPackageWithContext(ctx aws.Context, input *UpdateSolNetworkPackageInput, opts ...request.Option) (*UpdateSolNetworkPackageOutput, error) {
	req, out := c.UpdateSolNetworkPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateSolFunctionPackageContent = "ValidateSolFunctionPackageContent"

// ValidateSolFunctionPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the ValidateSolFunctionPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateSolFunctionPackageContent for more information on using the ValidateSolFunctionPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateSolFunctionPackageContentRequest method.
//	req, resp := client.ValidateSolFunctionPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent
func (c *Tnb) ValidateSolFunctionPackageContentRequest(input *ValidateSolFunctionPackageContentInput) (req *request.Request, output *ValidateSolFunctionPackageContentOutput) {
	op := &request.Operation{
		Name:       opValidateSolFunctionPackageContent,
		HTTPMethod: "PUT",
		HTTPPath:   "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content/validate",
	}

	if input == nil {
		input = &ValidateSolFunctionPackageContentInput{}
	}

	output = &ValidateSolFunctionPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateSolFunctionPackageContent API operation for AWS Telco Network Builder.
//
// Validates function package content. This can be used as a dry run before
// uploading function package content with PutSolFunctionPackageContent (https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ValidateSolFunctionPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent
func (c *Tnb) ValidateSolFunctionPackageContent(input *ValidateSolFunctionPackageContentInput) (*ValidateSolFunctionPackageContentOutput, error) {
	req, out := c.ValidateSolFunctionPackageContentRequest(input)
	return out, req.Send()
}

// ValidateSolFunctionPackageContentWithContext is the same as ValidateSolFunctionPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateSolFunctionPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ValidateSolFunctionPackageContentWithContext(ctx aws.Context, input *ValidateSolFunctionPackageContentInput, opts ...request.Option) (*ValidateSolFunctionPackageContentOutput, error) {
	req, out := c.ValidateSolFunctionPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateSolNetworkPackageContent = "ValidateSolNetworkPackageContent"

// ValidateSolNetworkPackageContentRequest generates a "aws/request.Request" representing the
// client's request for the ValidateSolNetworkPackageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateSolNetworkPackageContent for more information on using the ValidateSolNetworkPackageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateSolNetworkPackageContentRequest method.
//	req, resp := client.ValidateSolNetworkPackageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent
func (c *Tnb) ValidateSolNetworkPackageContentRequest(input *ValidateSolNetworkPackageContentInput) (req *request.Request, output *ValidateSolNetworkPackageContentOutput) {
	op := &request.Operation{
		Name:       opValidateSolNetworkPackageContent,
		HTTPMethod: "PUT",
		HTTPPath:   "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content/validate",
	}

	if input == nil {
		input = &ValidateSolNetworkPackageContentInput{}
	}

	output = &ValidateSolNetworkPackageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateSolNetworkPackageContent API operation for AWS Telco Network Builder.
//
// Validates network package content. This can be used as a dry run before uploading
// network package content with PutSolNetworkPackageContent (https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Telco Network Builder's
// API operation ValidateSolNetworkPackageContent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Unexpected error occurred. Problem on the server.
//
//   - ThrottlingException
//     Exception caused by throttling.
//
//   - ValidationException
//     Unable to process the request because the client provided input failed to
//     satisfy request constraints.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - AccessDeniedException
//     Insufficient permissions to make request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent
func (c *Tnb) ValidateSolNetworkPackageContent(input *ValidateSolNetworkPackageContentInput) (*ValidateSolNetworkPackageContentOutput, error) {
	req, out := c.ValidateSolNetworkPackageContentRequest(input)
	return out, req.Send()
}

// ValidateSolNetworkPackageContentWithContext is the same as ValidateSolNetworkPackageContent with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateSolNetworkPackageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Tnb) ValidateSolNetworkPackageContentWithContext(ctx aws.Context, input *ValidateSolNetworkPackageContentInput, opts ...request.Option) (*ValidateSolNetworkPackageContentOutput, error) {
	req, out := c.ValidateSolNetworkPackageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Insufficient permissions to make request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelSolNetworkOperationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the network operation.
	//
	// NsLcmOpOccId is a required field
	NsLcmOpOccId *string `location:"uri" locationName:"nsLcmOpOccId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSolNetworkOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSolNetworkOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSolNetworkOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSolNetworkOperationInput"}
	if s.NsLcmOpOccId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsLcmOpOccId"))
	}
	if s.NsLcmOpOccId != nil && len(*s.NsLcmOpOccId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsLcmOpOccId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *CancelSolNetworkOperationInput) SetNsLcmOpOccId(v string) *CancelSolNetworkOperationInput {
	s.NsLcmOpOccId = &v
	return s
}

type CancelSolNetworkOperationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSolNetworkOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSolNetworkOperationOutput) GoString() string {
	return s.String()
}

type CreateSolFunctionPackageInput struct {
	_ struct{} `type:"structure"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolFunctionPackageInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolFunctionPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolFunctionPackageInput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *CreateSolFunctionPackageInput) SetTags(v map[string]*string) *CreateSolFunctionPackageInput {
	s.Tags = v
	return s
}

type CreateSolFunctionPackageOutput struct {
	_ struct{} `type:"structure"`

	// Function package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// ID of the function package.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Onboarding state of the function package.
	//
	// OnboardingState is a required field
	OnboardingState *string `locationName:"onboardingState" type:"string" required:"true" enum:"OnboardingState"`

	// Operational state of the function package.
	//
	// OperationalState is a required field
	OperationalState *string `locationName:"operationalState" type:"string" required:"true" enum:"OperationalState"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolFunctionPackageOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Usage state of the function package.
	//
	// UsageState is a required field
	UsageState *string `locationName:"usageState" type:"string" required:"true" enum:"UsageState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolFunctionPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolFunctionPackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSolFunctionPackageOutput) SetArn(v string) *CreateSolFunctionPackageOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSolFunctionPackageOutput) SetId(v string) *CreateSolFunctionPackageOutput {
	s.Id = &v
	return s
}

// SetOnboardingState sets the OnboardingState field's value.
func (s *CreateSolFunctionPackageOutput) SetOnboardingState(v string) *CreateSolFunctionPackageOutput {
	s.OnboardingState = &v
	return s
}

// SetOperationalState sets the OperationalState field's value.
func (s *CreateSolFunctionPackageOutput) SetOperationalState(v string) *CreateSolFunctionPackageOutput {
	s.OperationalState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolFunctionPackageOutput) SetTags(v map[string]*string) *CreateSolFunctionPackageOutput {
	s.Tags = v
	return s
}

// SetUsageState sets the UsageState field's value.
func (s *CreateSolFunctionPackageOutput) SetUsageState(v string) *CreateSolFunctionPackageOutput {
	s.UsageState = &v
	return s
}

type CreateSolNetworkInstanceInput struct {
	_ struct{} `type:"structure"`

	// Network instance description.
	NsDescription *string `locationName:"nsDescription" type:"string"`

	// Network instance name.
	//
	// NsName is a required field
	NsName *string `locationName:"nsName" min:"1" type:"string" required:"true"`

	// ID for network service descriptor.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `locationName:"nsdInfoId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolNetworkInstanceInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSolNetworkInstanceInput"}
	if s.NsName == nil {
		invalidParams.Add(request.NewErrParamRequired("NsName"))
	}
	if s.NsName != nil && len(*s.NsName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsName", 1))
	}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsDescription sets the NsDescription field's value.
func (s *CreateSolNetworkInstanceInput) SetNsDescription(v string) *CreateSolNetworkInstanceInput {
	s.NsDescription = &v
	return s
}

// SetNsName sets the NsName field's value.
func (s *CreateSolNetworkInstanceInput) SetNsName(v string) *CreateSolNetworkInstanceInput {
	s.NsName = &v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *CreateSolNetworkInstanceInput) SetNsdInfoId(v string) *CreateSolNetworkInstanceInput {
	s.NsdInfoId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolNetworkInstanceInput) SetTags(v map[string]*string) *CreateSolNetworkInstanceInput {
	s.Tags = v
	return s
}

type CreateSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Network instance ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network instance ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Network instance name.
	//
	// NsInstanceName is a required field
	NsInstanceName *string `locationName:"nsInstanceName" type:"string" required:"true"`

	// Network service descriptor ID.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `locationName:"nsdInfoId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolNetworkInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSolNetworkInstanceOutput) SetArn(v string) *CreateSolNetworkInstanceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSolNetworkInstanceOutput) SetId(v string) *CreateSolNetworkInstanceOutput {
	s.Id = &v
	return s
}

// SetNsInstanceName sets the NsInstanceName field's value.
func (s *CreateSolNetworkInstanceOutput) SetNsInstanceName(v string) *CreateSolNetworkInstanceOutput {
	s.NsInstanceName = &v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *CreateSolNetworkInstanceOutput) SetNsdInfoId(v string) *CreateSolNetworkInstanceOutput {
	s.NsdInfoId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolNetworkInstanceOutput) SetTags(v map[string]*string) *CreateSolNetworkInstanceOutput {
	s.Tags = v
	return s
}

type CreateSolNetworkPackageInput struct {
	_ struct{} `type:"structure"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolNetworkPackageInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkPackageInput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *CreateSolNetworkPackageInput) SetTags(v map[string]*string) *CreateSolNetworkPackageInput {
	s.Tags = v
	return s
}

type CreateSolNetworkPackageOutput struct {
	_ struct{} `type:"structure"`

	// Network package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// ID of the network package.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Onboarding state of the network service descriptor in the network package.
	//
	// NsdOnboardingState is a required field
	NsdOnboardingState *string `locationName:"nsdOnboardingState" type:"string" required:"true" enum:"NsdOnboardingState"`

	// Operational state of the network service descriptor in the network package.
	//
	// NsdOperationalState is a required field
	NsdOperationalState *string `locationName:"nsdOperationalState" type:"string" required:"true" enum:"NsdOperationalState"`

	// Usage state of the network service descriptor in the network package.
	//
	// NsdUsageState is a required field
	NsdUsageState *string `locationName:"nsdUsageState" type:"string" required:"true" enum:"NsdUsageState"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSolNetworkPackageOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolNetworkPackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSolNetworkPackageOutput) SetArn(v string) *CreateSolNetworkPackageOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSolNetworkPackageOutput) SetId(v string) *CreateSolNetworkPackageOutput {
	s.Id = &v
	return s
}

// SetNsdOnboardingState sets the NsdOnboardingState field's value.
func (s *CreateSolNetworkPackageOutput) SetNsdOnboardingState(v string) *CreateSolNetworkPackageOutput {
	s.NsdOnboardingState = &v
	return s
}

// SetNsdOperationalState sets the NsdOperationalState field's value.
func (s *CreateSolNetworkPackageOutput) SetNsdOperationalState(v string) *CreateSolNetworkPackageOutput {
	s.NsdOperationalState = &v
	return s
}

// SetNsdUsageState sets the NsdUsageState field's value.
func (s *CreateSolNetworkPackageOutput) SetNsdUsageState(v string) *CreateSolNetworkPackageOutput {
	s.NsdUsageState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolNetworkPackageOutput) SetTags(v map[string]*string) *CreateSolNetworkPackageOutput {
	s.Tags = v
	return s
}

type DeleteSolFunctionPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the function package.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolFunctionPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolFunctionPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolFunctionPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSolFunctionPackageInput"}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *DeleteSolFunctionPackageInput) SetVnfPkgId(v string) *DeleteSolFunctionPackageInput {
	s.VnfPkgId = &v
	return s
}

type DeleteSolFunctionPackageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolFunctionPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolFunctionPackageOutput) GoString() string {
	return s.String()
}

type DeleteSolNetworkInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Network instance ID.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `location:"uri" locationName:"nsInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSolNetworkInstanceInput"}
	if s.NsInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsInstanceId"))
	}
	if s.NsInstanceId != nil && len(*s.NsInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *DeleteSolNetworkInstanceInput) SetNsInstanceId(v string) *DeleteSolNetworkInstanceInput {
	s.NsInstanceId = &v
	return s
}

type DeleteSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

type DeleteSolNetworkPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolNetworkPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSolNetworkPackageInput"}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *DeleteSolNetworkPackageInput) SetNsdInfoId(v string) *DeleteSolNetworkPackageInput {
	s.NsdInfoId = &v
	return s
}

type DeleteSolNetworkPackageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolNetworkPackageOutput) GoString() string {
	return s.String()
}

// Provides error information.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error cause.
	Cause *string `locationName:"cause" min:"1" type:"string"`

	// Error details.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ErrorInfo) SetCause(v string) *ErrorInfo {
	s.Cause = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ErrorInfo) SetDetails(v string) *ErrorInfo {
	s.Details = &v
	return s
}

// Metadata for function package artifacts.
//
// Artifacts are the contents of the package descriptor file and the state of
// the package.
type FunctionArtifactMeta struct {
	_ struct{} `type:"structure"`

	// Lists of function package overrides.
	Overrides []*ToscaOverride `locationName:"overrides" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionArtifactMeta) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionArtifactMeta) GoString() string {
	return s.String()
}

// SetOverrides sets the Overrides field's value.
func (s *FunctionArtifactMeta) SetOverrides(v []*ToscaOverride) *FunctionArtifactMeta {
	s.Overrides = v
	return s
}

type GetSolFunctionInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the network function.
	//
	// VnfInstanceId is a required field
	VnfInstanceId *string `location:"uri" locationName:"vnfInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolFunctionInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolFunctionInstanceInput"}
	if s.VnfInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfInstanceId"))
	}
	if s.VnfInstanceId != nil && len(*s.VnfInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVnfInstanceId sets the VnfInstanceId field's value.
func (s *GetSolFunctionInstanceInput) SetVnfInstanceId(v string) *GetSolFunctionInstanceInput {
	s.VnfInstanceId = &v
	return s
}

// The metadata of a network function instance.
//
// A network function instance is a function in a function package .
type GetSolFunctionInstanceMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSolFunctionInstanceMetadata) SetCreatedAt(v time.Time) *GetSolFunctionInstanceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetSolFunctionInstanceMetadata) SetLastModified(v time.Time) *GetSolFunctionInstanceMetadata {
	s.LastModified = &v
	return s
}

type GetSolFunctionInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Network function instance ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network function instance ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Information about the network function.
	//
	// A network function instance is a function in a function package .
	InstantiatedVnfInfo *GetSolVnfInfo `locationName:"instantiatedVnfInfo" type:"structure"`

	// Network function instantiation state.
	//
	// InstantiationState is a required field
	InstantiationState *string `locationName:"instantiationState" type:"string" required:"true" enum:"VnfInstantiationState"`

	// The metadata of a network function instance.
	//
	// A network function instance is a function in a function package .
	//
	// Metadata is a required field
	Metadata *GetSolFunctionInstanceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network instance ID.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `locationName:"nsInstanceId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSolFunctionInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Function package ID.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `locationName:"vnfPkgId" type:"string" required:"true"`

	// Network function product name.
	VnfProductName *string `locationName:"vnfProductName" type:"string"`

	// Network function provider.
	VnfProvider *string `locationName:"vnfProvider" type:"string"`

	// Function package descriptor ID.
	//
	// VnfdId is a required field
	VnfdId *string `locationName:"vnfdId" type:"string" required:"true"`

	// Function package descriptor version.
	VnfdVersion *string `locationName:"vnfdVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionInstanceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSolFunctionInstanceOutput) SetArn(v string) *GetSolFunctionInstanceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSolFunctionInstanceOutput) SetId(v string) *GetSolFunctionInstanceOutput {
	s.Id = &v
	return s
}

// SetInstantiatedVnfInfo sets the InstantiatedVnfInfo field's value.
func (s *GetSolFunctionInstanceOutput) SetInstantiatedVnfInfo(v *GetSolVnfInfo) *GetSolFunctionInstanceOutput {
	s.InstantiatedVnfInfo = v
	return s
}

// SetInstantiationState sets the InstantiationState field's value.
func (s *GetSolFunctionInstanceOutput) SetInstantiationState(v string) *GetSolFunctionInstanceOutput {
	s.InstantiationState = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolFunctionInstanceOutput) SetMetadata(v *GetSolFunctionInstanceMetadata) *GetSolFunctionInstanceOutput {
	s.Metadata = v
	return s
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *GetSolFunctionInstanceOutput) SetNsInstanceId(v string) *GetSolFunctionInstanceOutput {
	s.NsInstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSolFunctionInstanceOutput) SetTags(v map[string]*string) *GetSolFunctionInstanceOutput {
	s.Tags = v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *GetSolFunctionInstanceOutput) SetVnfPkgId(v string) *GetSolFunctionInstanceOutput {
	s.VnfPkgId = &v
	return s
}

// SetVnfProductName sets the VnfProductName field's value.
func (s *GetSolFunctionInstanceOutput) SetVnfProductName(v string) *GetSolFunctionInstanceOutput {
	s.VnfProductName = &v
	return s
}

// SetVnfProvider sets the VnfProvider field's value.
func (s *GetSolFunctionInstanceOutput) SetVnfProvider(v string) *GetSolFunctionInstanceOutput {
	s.VnfProvider = &v
	return s
}

// SetVnfdId sets the VnfdId field's value.
func (s *GetSolFunctionInstanceOutput) SetVnfdId(v string) *GetSolFunctionInstanceOutput {
	s.VnfdId = &v
	return s
}

// SetVnfdVersion sets the VnfdVersion field's value.
func (s *GetSolFunctionInstanceOutput) SetVnfdVersion(v string) *GetSolFunctionInstanceOutput {
	s.VnfdVersion = &v
	return s
}

type GetSolFunctionPackageContentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The format of the package that you want to download from the function packages.
	//
	// Accept is a required field
	Accept *string `location:"header" locationName:"Accept" type:"string" required:"true" enum:"PackageContentType"`

	// ID of the function package.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolFunctionPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolFunctionPackageContentInput"}
	if s.Accept == nil {
		invalidParams.Add(request.NewErrParamRequired("Accept"))
	}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *GetSolFunctionPackageContentInput) SetAccept(v string) *GetSolFunctionPackageContentInput {
	s.Accept = &v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *GetSolFunctionPackageContentInput) SetVnfPkgId(v string) *GetSolFunctionPackageContentInput {
	s.VnfPkgId = &v
	return s
}

type GetSolFunctionPackageContentOutput struct {
	_ struct{} `type:"structure" payload:"PackageContent"`

	// Indicates the media type of the resource.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Contents of the function package.
	PackageContent []byte `locationName:"packageContent" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageContentOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetSolFunctionPackageContentOutput) SetContentType(v string) *GetSolFunctionPackageContentOutput {
	s.ContentType = &v
	return s
}

// SetPackageContent sets the PackageContent field's value.
func (s *GetSolFunctionPackageContentOutput) SetPackageContent(v []byte) *GetSolFunctionPackageContentOutput {
	s.PackageContent = v
	return s
}

type GetSolFunctionPackageDescriptorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Indicates which content types, expressed as MIME types, the client is able
	// to understand.
	//
	// Accept is a required field
	Accept *string `location:"header" locationName:"Accept" type:"string" required:"true" enum:"DescriptorContentType"`

	// ID of the function package.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageDescriptorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageDescriptorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolFunctionPackageDescriptorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolFunctionPackageDescriptorInput"}
	if s.Accept == nil {
		invalidParams.Add(request.NewErrParamRequired("Accept"))
	}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *GetSolFunctionPackageDescriptorInput) SetAccept(v string) *GetSolFunctionPackageDescriptorInput {
	s.Accept = &v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *GetSolFunctionPackageDescriptorInput) SetVnfPkgId(v string) *GetSolFunctionPackageDescriptorInput {
	s.VnfPkgId = &v
	return s
}

type GetSolFunctionPackageDescriptorOutput struct {
	_ struct{} `type:"structure" payload:"Vnfd"`

	// Indicates the media type of the resource.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"DescriptorContentType"`

	// Contents of the function package descriptor.
	Vnfd []byte `locationName:"vnfd" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageDescriptorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageDescriptorOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetSolFunctionPackageDescriptorOutput) SetContentType(v string) *GetSolFunctionPackageDescriptorOutput {
	s.ContentType = &v
	return s
}

// SetVnfd sets the Vnfd field's value.
func (s *GetSolFunctionPackageDescriptorOutput) SetVnfd(v []byte) *GetSolFunctionPackageDescriptorOutput {
	s.Vnfd = v
	return s
}

type GetSolFunctionPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the function package.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolFunctionPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolFunctionPackageInput"}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *GetSolFunctionPackageInput) SetVnfPkgId(v string) *GetSolFunctionPackageInput {
	s.VnfPkgId = &v
	return s
}

// Metadata related to the function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
type GetSolFunctionPackageMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Metadata related to the function package descriptor of the function package.
	Vnfd *FunctionArtifactMeta `locationName:"vnfd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSolFunctionPackageMetadata) SetCreatedAt(v time.Time) *GetSolFunctionPackageMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetSolFunctionPackageMetadata) SetLastModified(v time.Time) *GetSolFunctionPackageMetadata {
	s.LastModified = &v
	return s
}

// SetVnfd sets the Vnfd field's value.
func (s *GetSolFunctionPackageMetadata) SetVnfd(v *FunctionArtifactMeta) *GetSolFunctionPackageMetadata {
	s.Vnfd = v
	return s
}

type GetSolFunctionPackageOutput struct {
	_ struct{} `type:"structure"`

	// Function package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Function package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Metadata related to the function package.
	//
	// A function package is a .zip file in CSAR (Cloud Service Archive) format
	// that contains a network function (an ETSI standard telecommunication application)
	// and function package descriptor that uses the TOSCA standard to describe
	// how the network functions should run on your network.
	Metadata *GetSolFunctionPackageMetadata `locationName:"metadata" type:"structure"`

	// Function package onboarding state.
	//
	// OnboardingState is a required field
	OnboardingState *string `locationName:"onboardingState" type:"string" required:"true" enum:"OnboardingState"`

	// Function package operational state.
	//
	// OperationalState is a required field
	OperationalState *string `locationName:"operationalState" type:"string" required:"true" enum:"OperationalState"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSolFunctionPackageOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Function package usage state.
	//
	// UsageState is a required field
	UsageState *string `locationName:"usageState" type:"string" required:"true" enum:"UsageState"`

	// Network function product name.
	VnfProductName *string `locationName:"vnfProductName" type:"string"`

	// Network function provider.
	VnfProvider *string `locationName:"vnfProvider" type:"string"`

	// Function package descriptor ID.
	VnfdId *string `locationName:"vnfdId" type:"string"`

	// Function package descriptor version.
	VnfdVersion *string `locationName:"vnfdVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolFunctionPackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSolFunctionPackageOutput) SetArn(v string) *GetSolFunctionPackageOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSolFunctionPackageOutput) SetId(v string) *GetSolFunctionPackageOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolFunctionPackageOutput) SetMetadata(v *GetSolFunctionPackageMetadata) *GetSolFunctionPackageOutput {
	s.Metadata = v
	return s
}

// SetOnboardingState sets the OnboardingState field's value.
func (s *GetSolFunctionPackageOutput) SetOnboardingState(v string) *GetSolFunctionPackageOutput {
	s.OnboardingState = &v
	return s
}

// SetOperationalState sets the OperationalState field's value.
func (s *GetSolFunctionPackageOutput) SetOperationalState(v string) *GetSolFunctionPackageOutput {
	s.OperationalState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSolFunctionPackageOutput) SetTags(v map[string]*string) *GetSolFunctionPackageOutput {
	s.Tags = v
	return s
}

// SetUsageState sets the UsageState field's value.
func (s *GetSolFunctionPackageOutput) SetUsageState(v string) *GetSolFunctionPackageOutput {
	s.UsageState = &v
	return s
}

// SetVnfProductName sets the VnfProductName field's value.
func (s *GetSolFunctionPackageOutput) SetVnfProductName(v string) *GetSolFunctionPackageOutput {
	s.VnfProductName = &v
	return s
}

// SetVnfProvider sets the VnfProvider field's value.
func (s *GetSolFunctionPackageOutput) SetVnfProvider(v string) *GetSolFunctionPackageOutput {
	s.VnfProvider = &v
	return s
}

// SetVnfdId sets the VnfdId field's value.
func (s *GetSolFunctionPackageOutput) SetVnfdId(v string) *GetSolFunctionPackageOutput {
	s.VnfdId = &v
	return s
}

// SetVnfdVersion sets the VnfdVersion field's value.
func (s *GetSolFunctionPackageOutput) SetVnfdVersion(v string) *GetSolFunctionPackageOutput {
	s.VnfdVersion = &v
	return s
}

// Information about a network function.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type GetSolInstantiatedVnfInfo struct {
	_ struct{} `type:"structure"`

	// State of the network function.
	VnfState *string `locationName:"vnfState" type:"string" enum:"VnfOperationalState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolInstantiatedVnfInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolInstantiatedVnfInfo) GoString() string {
	return s.String()
}

// SetVnfState sets the VnfState field's value.
func (s *GetSolInstantiatedVnfInfo) SetVnfState(v string) *GetSolInstantiatedVnfInfo {
	s.VnfState = &v
	return s
}

type GetSolNetworkInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the network instance.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `location:"uri" locationName:"nsInstanceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolNetworkInstanceInput"}
	if s.NsInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsInstanceId"))
	}
	if s.NsInstanceId != nil && len(*s.NsInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *GetSolNetworkInstanceInput) SetNsInstanceId(v string) *GetSolNetworkInstanceInput {
	s.NsInstanceId = &v
	return s
}

// The metadata of a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type GetSolNetworkInstanceMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSolNetworkInstanceMetadata) SetCreatedAt(v time.Time) *GetSolNetworkInstanceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetSolNetworkInstanceMetadata) SetLastModified(v time.Time) *GetSolNetworkInstanceMetadata {
	s.LastModified = &v
	return s
}

type GetSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Network instance ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network instance ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Lifecycle management operation details on the network instance.
	//
	// Lifecycle management operations are deploy, update, or delete operations.
	LcmOpInfo *LcmOperationInfo `locationName:"lcmOpInfo" type:"structure"`

	// The metadata of a network instance.
	//
	// A network instance is a single network created in Amazon Web Services TNB
	// that can be deployed and on which life-cycle operations (like terminate,
	// update, and delete) can be performed.
	//
	// Metadata is a required field
	Metadata *GetSolNetworkInstanceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network instance description.
	//
	// NsInstanceDescription is a required field
	NsInstanceDescription *string `locationName:"nsInstanceDescription" type:"string" required:"true"`

	// Network instance name.
	//
	// NsInstanceName is a required field
	NsInstanceName *string `locationName:"nsInstanceName" type:"string" required:"true"`

	// Network instance state.
	NsState *string `locationName:"nsState" type:"string" enum:"NsState"`

	// Network service descriptor ID.
	//
	// NsdId is a required field
	NsdId *string `locationName:"nsdId" type:"string" required:"true"`

	// Network service descriptor info ID.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `locationName:"nsdInfoId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSolNetworkInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSolNetworkInstanceOutput) SetArn(v string) *GetSolNetworkInstanceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSolNetworkInstanceOutput) SetId(v string) *GetSolNetworkInstanceOutput {
	s.Id = &v
	return s
}

// SetLcmOpInfo sets the LcmOpInfo field's value.
func (s *GetSolNetworkInstanceOutput) SetLcmOpInfo(v *LcmOperationInfo) *GetSolNetworkInstanceOutput {
	s.LcmOpInfo = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolNetworkInstanceOutput) SetMetadata(v *GetSolNetworkInstanceMetadata) *GetSolNetworkInstanceOutput {
	s.Metadata = v
	return s
}

// SetNsInstanceDescription sets the NsInstanceDescription field's value.
func (s *GetSolNetworkInstanceOutput) SetNsInstanceDescription(v string) *GetSolNetworkInstanceOutput {
	s.NsInstanceDescription = &v
	return s
}

// SetNsInstanceName sets the NsInstanceName field's value.
func (s *GetSolNetworkInstanceOutput) SetNsInstanceName(v string) *GetSolNetworkInstanceOutput {
	s.NsInstanceName = &v
	return s
}

// SetNsState sets the NsState field's value.
func (s *GetSolNetworkInstanceOutput) SetNsState(v string) *GetSolNetworkInstanceOutput {
	s.NsState = &v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *GetSolNetworkInstanceOutput) SetNsdId(v string) *GetSolNetworkInstanceOutput {
	s.NsdId = &v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *GetSolNetworkInstanceOutput) SetNsdInfoId(v string) *GetSolNetworkInstanceOutput {
	s.NsdInfoId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSolNetworkInstanceOutput) SetTags(v map[string]*string) *GetSolNetworkInstanceOutput {
	s.Tags = v
	return s
}

type GetSolNetworkOperationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the network operation.
	//
	// NsLcmOpOccId is a required field
	NsLcmOpOccId *string `location:"uri" locationName:"nsLcmOpOccId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolNetworkOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolNetworkOperationInput"}
	if s.NsLcmOpOccId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsLcmOpOccId"))
	}
	if s.NsLcmOpOccId != nil && len(*s.NsLcmOpOccId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsLcmOpOccId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *GetSolNetworkOperationInput) SetNsLcmOpOccId(v string) *GetSolNetworkOperationInput {
	s.NsLcmOpOccId = &v
	return s
}

// Metadata related to a network operation occurrence.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
type GetSolNetworkOperationMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSolNetworkOperationMetadata) SetCreatedAt(v time.Time) *GetSolNetworkOperationMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetSolNetworkOperationMetadata) SetLastModified(v time.Time) *GetSolNetworkOperationMetadata {
	s.LastModified = &v
	return s
}

type GetSolNetworkOperationOutput struct {
	_ struct{} `type:"structure"`

	// Network operation ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Error related to this specific network operation occurrence.
	Error *ProblemDetails `locationName:"error" type:"structure"`

	// ID of this network operation occurrence.
	Id *string `locationName:"id" type:"string"`

	// Type of the operation represented by this occurrence.
	LcmOperationType *string `locationName:"lcmOperationType" type:"string" enum:"LcmOperationType"`

	// Metadata of this network operation occurrence.
	Metadata *GetSolNetworkOperationMetadata `locationName:"metadata" type:"structure"`

	// ID of the network operation instance.
	NsInstanceId *string `locationName:"nsInstanceId" type:"string"`

	// The state of the network operation.
	OperationState *string `locationName:"operationState" type:"string" enum:"NsLcmOperationState"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSolNetworkOperationOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// All tasks associated with this operation occurrence.
	Tasks []*GetSolNetworkOperationTaskDetails `locationName:"tasks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSolNetworkOperationOutput) SetArn(v string) *GetSolNetworkOperationOutput {
	s.Arn = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetSolNetworkOperationOutput) SetError(v *ProblemDetails) *GetSolNetworkOperationOutput {
	s.Error = v
	return s
}

// SetId sets the Id field's value.
func (s *GetSolNetworkOperationOutput) SetId(v string) *GetSolNetworkOperationOutput {
	s.Id = &v
	return s
}

// SetLcmOperationType sets the LcmOperationType field's value.
func (s *GetSolNetworkOperationOutput) SetLcmOperationType(v string) *GetSolNetworkOperationOutput {
	s.LcmOperationType = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolNetworkOperationOutput) SetMetadata(v *GetSolNetworkOperationMetadata) *GetSolNetworkOperationOutput {
	s.Metadata = v
	return s
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *GetSolNetworkOperationOutput) SetNsInstanceId(v string) *GetSolNetworkOperationOutput {
	s.NsInstanceId = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *GetSolNetworkOperationOutput) SetOperationState(v string) *GetSolNetworkOperationOutput {
	s.OperationState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSolNetworkOperationOutput) SetTags(v map[string]*string) *GetSolNetworkOperationOutput {
	s.Tags = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *GetSolNetworkOperationOutput) SetTasks(v []*GetSolNetworkOperationTaskDetails) *GetSolNetworkOperationOutput {
	s.Tasks = v
	return s
}

// Gets the details of a network operation.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
type GetSolNetworkOperationTaskDetails struct {
	_ struct{} `type:"structure"`

	// Context for the network operation task.
	TaskContext map[string]*string `locationName:"taskContext" type:"map"`

	// Task end time.
	TaskEndTime *time.Time `locationName:"taskEndTime" type:"timestamp" timestampFormat:"iso8601"`

	// Task error details.
	TaskErrorDetails *ErrorInfo `locationName:"taskErrorDetails" type:"structure"`

	// Task name.
	TaskName *string `locationName:"taskName" type:"string"`

	// Task start time.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// Task status.
	TaskStatus *string `locationName:"taskStatus" type:"string" enum:"TaskStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationTaskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkOperationTaskDetails) GoString() string {
	return s.String()
}

// SetTaskContext sets the TaskContext field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskContext(v map[string]*string) *GetSolNetworkOperationTaskDetails {
	s.TaskContext = v
	return s
}

// SetTaskEndTime sets the TaskEndTime field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskEndTime(v time.Time) *GetSolNetworkOperationTaskDetails {
	s.TaskEndTime = &v
	return s
}

// SetTaskErrorDetails sets the TaskErrorDetails field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskErrorDetails(v *ErrorInfo) *GetSolNetworkOperationTaskDetails {
	s.TaskErrorDetails = v
	return s
}

// SetTaskName sets the TaskName field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskName(v string) *GetSolNetworkOperationTaskDetails {
	s.TaskName = &v
	return s
}

// SetTaskStartTime sets the TaskStartTime field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskStartTime(v time.Time) *GetSolNetworkOperationTaskDetails {
	s.TaskStartTime = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *GetSolNetworkOperationTaskDetails) SetTaskStatus(v string) *GetSolNetworkOperationTaskDetails {
	s.TaskStatus = &v
	return s
}

type GetSolNetworkPackageContentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The format of the package you want to download from the network package.
	//
	// Accept is a required field
	Accept *string `location:"header" locationName:"Accept" type:"string" required:"true" enum:"PackageContentType"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolNetworkPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolNetworkPackageContentInput"}
	if s.Accept == nil {
		invalidParams.Add(request.NewErrParamRequired("Accept"))
	}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *GetSolNetworkPackageContentInput) SetAccept(v string) *GetSolNetworkPackageContentInput {
	s.Accept = &v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *GetSolNetworkPackageContentInput) SetNsdInfoId(v string) *GetSolNetworkPackageContentInput {
	s.NsdInfoId = &v
	return s
}

type GetSolNetworkPackageContentOutput struct {
	_ struct{} `type:"structure" payload:"NsdContent"`

	// Indicates the media type of the resource.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Content of the network service descriptor in the network package.
	NsdContent []byte `locationName:"nsdContent" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageContentOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetSolNetworkPackageContentOutput) SetContentType(v string) *GetSolNetworkPackageContentOutput {
	s.ContentType = &v
	return s
}

// SetNsdContent sets the NsdContent field's value.
func (s *GetSolNetworkPackageContentOutput) SetNsdContent(v []byte) *GetSolNetworkPackageContentOutput {
	s.NsdContent = v
	return s
}

type GetSolNetworkPackageDescriptorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageDescriptorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageDescriptorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolNetworkPackageDescriptorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolNetworkPackageDescriptorInput"}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *GetSolNetworkPackageDescriptorInput) SetNsdInfoId(v string) *GetSolNetworkPackageDescriptorInput {
	s.NsdInfoId = &v
	return s
}

type GetSolNetworkPackageDescriptorOutput struct {
	_ struct{} `type:"structure" payload:"Nsd"`

	// Indicates the media type of the resource.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"DescriptorContentType"`

	// Contents of the network service descriptor in the network package.
	Nsd []byte `locationName:"nsd" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageDescriptorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageDescriptorOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetSolNetworkPackageDescriptorOutput) SetContentType(v string) *GetSolNetworkPackageDescriptorOutput {
	s.ContentType = &v
	return s
}

// SetNsd sets the Nsd field's value.
func (s *GetSolNetworkPackageDescriptorOutput) SetNsd(v []byte) *GetSolNetworkPackageDescriptorOutput {
	s.Nsd = v
	return s
}

type GetSolNetworkPackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolNetworkPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolNetworkPackageInput"}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *GetSolNetworkPackageInput) SetNsdInfoId(v string) *GetSolNetworkPackageInput {
	s.NsdInfoId = &v
	return s
}

// Metadata associated with a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
type GetSolNetworkPackageMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Metadata related to the onboarded network service descriptor in the network
	// package.
	Nsd *NetworkArtifactMeta `locationName:"nsd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSolNetworkPackageMetadata) SetCreatedAt(v time.Time) *GetSolNetworkPackageMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetSolNetworkPackageMetadata) SetLastModified(v time.Time) *GetSolNetworkPackageMetadata {
	s.LastModified = &v
	return s
}

// SetNsd sets the Nsd field's value.
func (s *GetSolNetworkPackageMetadata) SetNsd(v *NetworkArtifactMeta) *GetSolNetworkPackageMetadata {
	s.Nsd = v
	return s
}

type GetSolNetworkPackageOutput struct {
	_ struct{} `type:"structure"`

	// Network package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Metadata associated with a network package.
	//
	// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
	// the function packages you want to deploy and the Amazon Web Services infrastructure
	// you want to deploy them on.
	//
	// Metadata is a required field
	Metadata *GetSolNetworkPackageMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network service descriptor ID.
	//
	// NsdId is a required field
	NsdId *string `locationName:"nsdId" type:"string" required:"true"`

	// Network service descriptor name.
	//
	// NsdName is a required field
	NsdName *string `locationName:"nsdName" type:"string" required:"true"`

	// Network service descriptor onboarding state.
	//
	// NsdOnboardingState is a required field
	NsdOnboardingState *string `locationName:"nsdOnboardingState" type:"string" required:"true" enum:"NsdOnboardingState"`

	// Network service descriptor operational state.
	//
	// NsdOperationalState is a required field
	NsdOperationalState *string `locationName:"nsdOperationalState" type:"string" required:"true" enum:"NsdOperationalState"`

	// Network service descriptor usage state.
	//
	// NsdUsageState is a required field
	NsdUsageState *string `locationName:"nsdUsageState" type:"string" required:"true" enum:"NsdUsageState"`

	// Network service descriptor version.
	//
	// NsdVersion is a required field
	NsdVersion *string `locationName:"nsdVersion" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSolNetworkPackageOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Identifies the function package for the function package descriptor referenced
	// by the onboarded network package.
	//
	// VnfPkgIds is a required field
	VnfPkgIds []*string `locationName:"vnfPkgIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolNetworkPackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSolNetworkPackageOutput) SetArn(v string) *GetSolNetworkPackageOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSolNetworkPackageOutput) SetId(v string) *GetSolNetworkPackageOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolNetworkPackageOutput) SetMetadata(v *GetSolNetworkPackageMetadata) *GetSolNetworkPackageOutput {
	s.Metadata = v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *GetSolNetworkPackageOutput) SetNsdId(v string) *GetSolNetworkPackageOutput {
	s.NsdId = &v
	return s
}

// SetNsdName sets the NsdName field's value.
func (s *GetSolNetworkPackageOutput) SetNsdName(v string) *GetSolNetworkPackageOutput {
	s.NsdName = &v
	return s
}

// SetNsdOnboardingState sets the NsdOnboardingState field's value.
func (s *GetSolNetworkPackageOutput) SetNsdOnboardingState(v string) *GetSolNetworkPackageOutput {
	s.NsdOnboardingState = &v
	return s
}

// SetNsdOperationalState sets the NsdOperationalState field's value.
func (s *GetSolNetworkPackageOutput) SetNsdOperationalState(v string) *GetSolNetworkPackageOutput {
	s.NsdOperationalState = &v
	return s
}

// SetNsdUsageState sets the NsdUsageState field's value.
func (s *GetSolNetworkPackageOutput) SetNsdUsageState(v string) *GetSolNetworkPackageOutput {
	s.NsdUsageState = &v
	return s
}

// SetNsdVersion sets the NsdVersion field's value.
func (s *GetSolNetworkPackageOutput) SetNsdVersion(v string) *GetSolNetworkPackageOutput {
	s.NsdVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSolNetworkPackageOutput) SetTags(v map[string]*string) *GetSolNetworkPackageOutput {
	s.Tags = v
	return s
}

// SetVnfPkgIds sets the VnfPkgIds field's value.
func (s *GetSolNetworkPackageOutput) SetVnfPkgIds(v []*string) *GetSolNetworkPackageOutput {
	s.VnfPkgIds = v
	return s
}

// Information about the network function.
//
// A network function instance is a function in a function package .
type GetSolVnfInfo struct {
	_ struct{} `type:"structure"`

	// State of the network function instance.
	VnfState *string `locationName:"vnfState" type:"string" enum:"VnfOperationalState"`

	// Compute info used by the network function instance.
	VnfcResourceInfo []*GetSolVnfcResourceInfo `locationName:"vnfcResourceInfo" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfInfo) GoString() string {
	return s.String()
}

// SetVnfState sets the VnfState field's value.
func (s *GetSolVnfInfo) SetVnfState(v string) *GetSolVnfInfo {
	s.VnfState = &v
	return s
}

// SetVnfcResourceInfo sets the VnfcResourceInfo field's value.
func (s *GetSolVnfInfo) SetVnfcResourceInfo(v []*GetSolVnfcResourceInfo) *GetSolVnfInfo {
	s.VnfcResourceInfo = v
	return s
}

// Details of resource associated with a network function.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type GetSolVnfcResourceInfo struct {
	_ struct{} `type:"structure"`

	// The metadata of the network function compute.
	Metadata *GetSolVnfcResourceInfoMetadata `locationName:"metadata" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfcResourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfcResourceInfo) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetSolVnfcResourceInfo) SetMetadata(v *GetSolVnfcResourceInfoMetadata) *GetSolVnfcResourceInfo {
	s.Metadata = v
	return s
}

// The metadata of a network function.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type GetSolVnfcResourceInfoMetadata struct {
	_ struct{} `type:"structure"`

	// Information about the cluster.
	Cluster *string `locationName:"cluster" type:"string"`

	// Information about the helm chart.
	HelmChart *string `locationName:"helmChart" type:"string"`

	// Information about the node group.
	NodeGroup *string `locationName:"nodeGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfcResourceInfoMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolVnfcResourceInfoMetadata) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *GetSolVnfcResourceInfoMetadata) SetCluster(v string) *GetSolVnfcResourceInfoMetadata {
	s.Cluster = &v
	return s
}

// SetHelmChart sets the HelmChart field's value.
func (s *GetSolVnfcResourceInfoMetadata) SetHelmChart(v string) *GetSolVnfcResourceInfoMetadata {
	s.HelmChart = &v
	return s
}

// SetNodeGroup sets the NodeGroup field's value.
func (s *GetSolVnfcResourceInfoMetadata) SetNodeGroup(v string) *GetSolVnfcResourceInfoMetadata {
	s.NodeGroup = &v
	return s
}

type InstantiateSolNetworkInstanceInput struct {
	_ struct{} `type:"structure"`

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it
	// is UnauthorizedOperation.
	DryRun *bool `location:"querystring" locationName:"dry_run" type:"boolean"`

	// ID of the network instance.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `location:"uri" locationName:"nsInstanceId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InstantiateSolNetworkInstanceInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantiateSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantiateSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstantiateSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstantiateSolNetworkInstanceInput"}
	if s.NsInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsInstanceId"))
	}
	if s.NsInstanceId != nil && len(*s.NsInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *InstantiateSolNetworkInstanceInput) SetDryRun(v bool) *InstantiateSolNetworkInstanceInput {
	s.DryRun = &v
	return s
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *InstantiateSolNetworkInstanceInput) SetNsInstanceId(v string) *InstantiateSolNetworkInstanceInput {
	s.NsInstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstantiateSolNetworkInstanceInput) SetTags(v map[string]*string) *InstantiateSolNetworkInstanceInput {
	s.Tags = v
	return s
}

type InstantiateSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the network operation.
	//
	// NsLcmOpOccId is a required field
	NsLcmOpOccId *string `locationName:"nsLcmOpOccId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InstantiateSolNetworkInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantiateSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantiateSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *InstantiateSolNetworkInstanceOutput) SetNsLcmOpOccId(v string) *InstantiateSolNetworkInstanceOutput {
	s.NsLcmOpOccId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstantiateSolNetworkInstanceOutput) SetTags(v map[string]*string) *InstantiateSolNetworkInstanceOutput {
	s.Tags = v
	return s
}

// Unexpected error occurred. Problem on the server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lifecycle management operation details on the network instance.
//
// Lifecycle management operations are deploy, update, or delete operations.
type LcmOperationInfo struct {
	_ struct{} `type:"structure"`

	// The identifier of the network operation.
	//
	// NsLcmOpOccId is a required field
	NsLcmOpOccId *string `locationName:"nsLcmOpOccId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LcmOperationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LcmOperationInfo) GoString() string {
	return s.String()
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *LcmOperationInfo) SetNsLcmOpOccId(v string) *LcmOperationInfo {
	s.NsLcmOpOccId = &v
	return s
}

// Lists information about a network function instance.
//
// A network function instance is a function in a function package .
type ListSolFunctionInstanceInfo struct {
	_ struct{} `type:"structure"`

	// Network function instance ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network function instance ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Information about a network function.
	//
	// A network instance is a single network created in Amazon Web Services TNB
	// that can be deployed and on which life-cycle operations (like terminate,
	// update, and delete) can be performed.
	InstantiatedVnfInfo *GetSolInstantiatedVnfInfo `locationName:"instantiatedVnfInfo" type:"structure"`

	// Network function instance instantiation state.
	//
	// InstantiationState is a required field
	InstantiationState *string `locationName:"instantiationState" type:"string" required:"true" enum:"VnfInstantiationState"`

	// Network function instance metadata.
	//
	// Metadata is a required field
	Metadata *ListSolFunctionInstanceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network instance ID.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `locationName:"nsInstanceId" type:"string" required:"true"`

	// Function package ID.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `locationName:"vnfPkgId" type:"string" required:"true"`

	// Function package name.
	VnfPkgName *string `locationName:"vnfPkgName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstanceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstanceInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSolFunctionInstanceInfo) SetArn(v string) *ListSolFunctionInstanceInfo {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListSolFunctionInstanceInfo) SetId(v string) *ListSolFunctionInstanceInfo {
	s.Id = &v
	return s
}

// SetInstantiatedVnfInfo sets the InstantiatedVnfInfo field's value.
func (s *ListSolFunctionInstanceInfo) SetInstantiatedVnfInfo(v *GetSolInstantiatedVnfInfo) *ListSolFunctionInstanceInfo {
	s.InstantiatedVnfInfo = v
	return s
}

// SetInstantiationState sets the InstantiationState field's value.
func (s *ListSolFunctionInstanceInfo) SetInstantiationState(v string) *ListSolFunctionInstanceInfo {
	s.InstantiationState = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ListSolFunctionInstanceInfo) SetMetadata(v *ListSolFunctionInstanceMetadata) *ListSolFunctionInstanceInfo {
	s.Metadata = v
	return s
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *ListSolFunctionInstanceInfo) SetNsInstanceId(v string) *ListSolFunctionInstanceInfo {
	s.NsInstanceId = &v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *ListSolFunctionInstanceInfo) SetVnfPkgId(v string) *ListSolFunctionInstanceInfo {
	s.VnfPkgId = &v
	return s
}

// SetVnfPkgName sets the VnfPkgName field's value.
func (s *ListSolFunctionInstanceInfo) SetVnfPkgName(v string) *ListSolFunctionInstanceInfo {
	s.VnfPkgName = &v
	return s
}

// Lists network function instance metadata.
//
// A network function instance is a function in a function package .
type ListSolFunctionInstanceMetadata struct {
	_ struct{} `type:"structure"`

	// When the network function instance was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// When the network function instance was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstanceMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListSolFunctionInstanceMetadata) SetCreatedAt(v time.Time) *ListSolFunctionInstanceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ListSolFunctionInstanceMetadata) SetLastModified(v time.Time) *ListSolFunctionInstanceMetadata {
	s.LastModified = &v
	return s
}

type ListSolFunctionInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextpage_opaque_marker" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolFunctionInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolFunctionInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolFunctionInstancesInput) SetMaxResults(v int64) *ListSolFunctionInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolFunctionInstancesInput) SetNextToken(v string) *ListSolFunctionInstancesInput {
	s.NextToken = &v
	return s
}

type ListSolFunctionInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Network function instances.
	FunctionInstances []*ListSolFunctionInstanceInfo `locationName:"functionInstances" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionInstancesOutput) GoString() string {
	return s.String()
}

// SetFunctionInstances sets the FunctionInstances field's value.
func (s *ListSolFunctionInstancesOutput) SetFunctionInstances(v []*ListSolFunctionInstanceInfo) *ListSolFunctionInstancesOutput {
	s.FunctionInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolFunctionInstancesOutput) SetNextToken(v string) *ListSolFunctionInstancesOutput {
	s.NextToken = &v
	return s
}

// Information about a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
type ListSolFunctionPackageInfo struct {
	_ struct{} `type:"structure"`

	// Function package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// ID of the function package.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The metadata of the function package.
	Metadata *ListSolFunctionPackageMetadata `locationName:"metadata" type:"structure"`

	// Onboarding state of the function package.
	//
	// OnboardingState is a required field
	OnboardingState *string `locationName:"onboardingState" type:"string" required:"true" enum:"OnboardingState"`

	// Operational state of the function package.
	//
	// OperationalState is a required field
	OperationalState *string `locationName:"operationalState" type:"string" required:"true" enum:"OperationalState"`

	// Usage state of the function package.
	//
	// UsageState is a required field
	UsageState *string `locationName:"usageState" type:"string" required:"true" enum:"UsageState"`

	// The product name for the network function.
	VnfProductName *string `locationName:"vnfProductName" type:"string"`

	// Provider of the function package and the function package descriptor.
	VnfProvider *string `locationName:"vnfProvider" type:"string"`

	// Identifies the function package and the function package descriptor.
	VnfdId *string `locationName:"vnfdId" type:"string"`

	// Identifies the version of the function package descriptor.
	VnfdVersion *string `locationName:"vnfdVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackageInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSolFunctionPackageInfo) SetArn(v string) *ListSolFunctionPackageInfo {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListSolFunctionPackageInfo) SetId(v string) *ListSolFunctionPackageInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ListSolFunctionPackageInfo) SetMetadata(v *ListSolFunctionPackageMetadata) *ListSolFunctionPackageInfo {
	s.Metadata = v
	return s
}

// SetOnboardingState sets the OnboardingState field's value.
func (s *ListSolFunctionPackageInfo) SetOnboardingState(v string) *ListSolFunctionPackageInfo {
	s.OnboardingState = &v
	return s
}

// SetOperationalState sets the OperationalState field's value.
func (s *ListSolFunctionPackageInfo) SetOperationalState(v string) *ListSolFunctionPackageInfo {
	s.OperationalState = &v
	return s
}

// SetUsageState sets the UsageState field's value.
func (s *ListSolFunctionPackageInfo) SetUsageState(v string) *ListSolFunctionPackageInfo {
	s.UsageState = &v
	return s
}

// SetVnfProductName sets the VnfProductName field's value.
func (s *ListSolFunctionPackageInfo) SetVnfProductName(v string) *ListSolFunctionPackageInfo {
	s.VnfProductName = &v
	return s
}

// SetVnfProvider sets the VnfProvider field's value.
func (s *ListSolFunctionPackageInfo) SetVnfProvider(v string) *ListSolFunctionPackageInfo {
	s.VnfProvider = &v
	return s
}

// SetVnfdId sets the VnfdId field's value.
func (s *ListSolFunctionPackageInfo) SetVnfdId(v string) *ListSolFunctionPackageInfo {
	s.VnfdId = &v
	return s
}

// SetVnfdVersion sets the VnfdVersion field's value.
func (s *ListSolFunctionPackageInfo) SetVnfdVersion(v string) *ListSolFunctionPackageInfo {
	s.VnfdVersion = &v
	return s
}

// Details for the function package metadata.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
type ListSolFunctionPackageMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackageMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListSolFunctionPackageMetadata) SetCreatedAt(v time.Time) *ListSolFunctionPackageMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ListSolFunctionPackageMetadata) SetLastModified(v time.Time) *ListSolFunctionPackageMetadata {
	s.LastModified = &v
	return s
}

type ListSolFunctionPackagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextpage_opaque_marker" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolFunctionPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolFunctionPackagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolFunctionPackagesInput) SetMaxResults(v int64) *ListSolFunctionPackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolFunctionPackagesInput) SetNextToken(v string) *ListSolFunctionPackagesInput {
	s.NextToken = &v
	return s
}

type ListSolFunctionPackagesOutput struct {
	_ struct{} `type:"structure"`

	// Function packages. A function package is a .zip file in CSAR (Cloud Service
	// Archive) format that contains a network function (an ETSI standard telecommunication
	// application) and function package descriptor that uses the TOSCA standard
	// to describe how the network functions should run on your network.
	//
	// FunctionPackages is a required field
	FunctionPackages []*ListSolFunctionPackageInfo `locationName:"functionPackages" type:"list" required:"true"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolFunctionPackagesOutput) GoString() string {
	return s.String()
}

// SetFunctionPackages sets the FunctionPackages field's value.
func (s *ListSolFunctionPackagesOutput) SetFunctionPackages(v []*ListSolFunctionPackageInfo) *ListSolFunctionPackagesOutput {
	s.FunctionPackages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolFunctionPackagesOutput) SetNextToken(v string) *ListSolFunctionPackagesOutput {
	s.NextToken = &v
	return s
}

// Info about the specific network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type ListSolNetworkInstanceInfo struct {
	_ struct{} `type:"structure"`

	// Network instance ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// ID of the network instance.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The metadata of the network instance.
	//
	// Metadata is a required field
	Metadata *ListSolNetworkInstanceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Human-readable description of the network instance.
	//
	// NsInstanceDescription is a required field
	NsInstanceDescription *string `locationName:"nsInstanceDescription" type:"string" required:"true"`

	// Human-readable name of the network instance.
	//
	// NsInstanceName is a required field
	NsInstanceName *string `locationName:"nsInstanceName" type:"string" required:"true"`

	// The state of the network instance.
	//
	// NsState is a required field
	NsState *string `locationName:"nsState" type:"string" required:"true" enum:"NsState"`

	// ID of the network service descriptor in the network package.
	//
	// NsdId is a required field
	NsdId *string `locationName:"nsdId" type:"string" required:"true"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstanceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstanceInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSolNetworkInstanceInfo) SetArn(v string) *ListSolNetworkInstanceInfo {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListSolNetworkInstanceInfo) SetId(v string) *ListSolNetworkInstanceInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ListSolNetworkInstanceInfo) SetMetadata(v *ListSolNetworkInstanceMetadata) *ListSolNetworkInstanceInfo {
	s.Metadata = v
	return s
}

// SetNsInstanceDescription sets the NsInstanceDescription field's value.
func (s *ListSolNetworkInstanceInfo) SetNsInstanceDescription(v string) *ListSolNetworkInstanceInfo {
	s.NsInstanceDescription = &v
	return s
}

// SetNsInstanceName sets the NsInstanceName field's value.
func (s *ListSolNetworkInstanceInfo) SetNsInstanceName(v string) *ListSolNetworkInstanceInfo {
	s.NsInstanceName = &v
	return s
}

// SetNsState sets the NsState field's value.
func (s *ListSolNetworkInstanceInfo) SetNsState(v string) *ListSolNetworkInstanceInfo {
	s.NsState = &v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *ListSolNetworkInstanceInfo) SetNsdId(v string) *ListSolNetworkInstanceInfo {
	s.NsdId = &v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *ListSolNetworkInstanceInfo) SetNsdInfoId(v string) *ListSolNetworkInstanceInfo {
	s.NsdInfoId = &v
	return s
}

// Metadata details for a network instance.
//
// A network instance is a single network created in Amazon Web Services TNB
// that can be deployed and on which life-cycle operations (like terminate,
// update, and delete) can be performed.
type ListSolNetworkInstanceMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstanceMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListSolNetworkInstanceMetadata) SetCreatedAt(v time.Time) *ListSolNetworkInstanceMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ListSolNetworkInstanceMetadata) SetLastModified(v time.Time) *ListSolNetworkInstanceMetadata {
	s.LastModified = &v
	return s
}

type ListSolNetworkInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextpage_opaque_marker" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolNetworkInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolNetworkInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolNetworkInstancesInput) SetMaxResults(v int64) *ListSolNetworkInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkInstancesInput) SetNextToken(v string) *ListSolNetworkInstancesInput {
	s.NextToken = &v
	return s
}

type ListSolNetworkInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Lists network instances.
	NetworkInstances []*ListSolNetworkInstanceInfo `locationName:"networkInstances" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkInstancesOutput) GoString() string {
	return s.String()
}

// SetNetworkInstances sets the NetworkInstances field's value.
func (s *ListSolNetworkInstancesOutput) SetNetworkInstances(v []*ListSolNetworkInstanceInfo) *ListSolNetworkInstancesOutput {
	s.NetworkInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkInstancesOutput) SetNextToken(v string) *ListSolNetworkInstancesOutput {
	s.NextToken = &v
	return s
}

// Information parameters for a network operation.
type ListSolNetworkOperationsInfo struct {
	_ struct{} `type:"structure"`

	// Network operation ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Error related to this specific network operation.
	Error *ProblemDetails `locationName:"error" type:"structure"`

	// ID of this network operation.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Type of lifecycle management network operation.
	//
	// LcmOperationType is a required field
	LcmOperationType *string `locationName:"lcmOperationType" type:"string" required:"true" enum:"LcmOperationType"`

	// Metadata related to this network operation.
	Metadata *ListSolNetworkOperationsMetadata `locationName:"metadata" type:"structure"`

	// ID of the network instance related to this operation.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `locationName:"nsInstanceId" type:"string" required:"true"`

	// The state of the network operation.
	//
	// OperationState is a required field
	OperationState *string `locationName:"operationState" type:"string" required:"true" enum:"NsLcmOperationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSolNetworkOperationsInfo) SetArn(v string) *ListSolNetworkOperationsInfo {
	s.Arn = &v
	return s
}

// SetError sets the Error field's value.
func (s *ListSolNetworkOperationsInfo) SetError(v *ProblemDetails) *ListSolNetworkOperationsInfo {
	s.Error = v
	return s
}

// SetId sets the Id field's value.
func (s *ListSolNetworkOperationsInfo) SetId(v string) *ListSolNetworkOperationsInfo {
	s.Id = &v
	return s
}

// SetLcmOperationType sets the LcmOperationType field's value.
func (s *ListSolNetworkOperationsInfo) SetLcmOperationType(v string) *ListSolNetworkOperationsInfo {
	s.LcmOperationType = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ListSolNetworkOperationsInfo) SetMetadata(v *ListSolNetworkOperationsMetadata) *ListSolNetworkOperationsInfo {
	s.Metadata = v
	return s
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *ListSolNetworkOperationsInfo) SetNsInstanceId(v string) *ListSolNetworkOperationsInfo {
	s.NsInstanceId = &v
	return s
}

// SetOperationState sets the OperationState field's value.
func (s *ListSolNetworkOperationsInfo) SetOperationState(v string) *ListSolNetworkOperationsInfo {
	s.OperationState = &v
	return s
}

type ListSolNetworkOperationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextpage_opaque_marker" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolNetworkOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolNetworkOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolNetworkOperationsInput) SetMaxResults(v int64) *ListSolNetworkOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkOperationsInput) SetNextToken(v string) *ListSolNetworkOperationsInput {
	s.NextToken = &v
	return s
}

// Metadata related to a network operation.
//
// A network operation is any operation that is done to your network, such as
// network instance instantiation or termination.
type ListSolNetworkOperationsMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListSolNetworkOperationsMetadata) SetCreatedAt(v time.Time) *ListSolNetworkOperationsMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ListSolNetworkOperationsMetadata) SetLastModified(v time.Time) *ListSolNetworkOperationsMetadata {
	s.LastModified = &v
	return s
}

type ListSolNetworkOperationsOutput struct {
	_ struct{} `type:"structure"`

	// Lists network operation occurrences. Lifecycle management operations are
	// deploy, update, or delete operations.
	NetworkOperations []*ListSolNetworkOperationsInfo `locationName:"networkOperations" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkOperationsOutput) GoString() string {
	return s.String()
}

// SetNetworkOperations sets the NetworkOperations field's value.
func (s *ListSolNetworkOperationsOutput) SetNetworkOperations(v []*ListSolNetworkOperationsInfo) *ListSolNetworkOperationsOutput {
	s.NetworkOperations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkOperationsOutput) SetNextToken(v string) *ListSolNetworkOperationsOutput {
	s.NextToken = &v
	return s
}

// Details of a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
type ListSolNetworkPackageInfo struct {
	_ struct{} `type:"structure"`

	// Network package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// ID of the individual network package.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The metadata of the network package.
	//
	// Metadata is a required field
	Metadata *ListSolNetworkPackageMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Designer of the onboarded network service descriptor in the network package.
	NsdDesigner *string `locationName:"nsdDesigner" type:"string"`

	// ID of the network service descriptor on which the network package is based.
	NsdId *string `locationName:"nsdId" type:"string"`

	// Identifies a network service descriptor in a version independent manner.
	NsdInvariantId *string `locationName:"nsdInvariantId" type:"string"`

	// Name of the onboarded network service descriptor in the network package.
	NsdName *string `locationName:"nsdName" type:"string"`

	// Onboarding state of the network service descriptor in the network package.
	//
	// NsdOnboardingState is a required field
	NsdOnboardingState *string `locationName:"nsdOnboardingState" type:"string" required:"true" enum:"NsdOnboardingState"`

	// Operational state of the network service descriptor in the network package.
	//
	// NsdOperationalState is a required field
	NsdOperationalState *string `locationName:"nsdOperationalState" type:"string" required:"true" enum:"NsdOperationalState"`

	// Usage state of the network service descriptor in the network package.
	//
	// NsdUsageState is a required field
	NsdUsageState *string `locationName:"nsdUsageState" type:"string" required:"true" enum:"NsdUsageState"`

	// Version of the onboarded network service descriptor in the network package.
	NsdVersion *string `locationName:"nsdVersion" type:"string"`

	// Identifies the function package for the function package descriptor referenced
	// by the onboarded network package.
	VnfPkgIds []*string `locationName:"vnfPkgIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackageInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSolNetworkPackageInfo) SetArn(v string) *ListSolNetworkPackageInfo {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListSolNetworkPackageInfo) SetId(v string) *ListSolNetworkPackageInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ListSolNetworkPackageInfo) SetMetadata(v *ListSolNetworkPackageMetadata) *ListSolNetworkPackageInfo {
	s.Metadata = v
	return s
}

// SetNsdDesigner sets the NsdDesigner field's value.
func (s *ListSolNetworkPackageInfo) SetNsdDesigner(v string) *ListSolNetworkPackageInfo {
	s.NsdDesigner = &v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *ListSolNetworkPackageInfo) SetNsdId(v string) *ListSolNetworkPackageInfo {
	s.NsdId = &v
	return s
}

// SetNsdInvariantId sets the NsdInvariantId field's value.
func (s *ListSolNetworkPackageInfo) SetNsdInvariantId(v string) *ListSolNetworkPackageInfo {
	s.NsdInvariantId = &v
	return s
}

// SetNsdName sets the NsdName field's value.
func (s *ListSolNetworkPackageInfo) SetNsdName(v string) *ListSolNetworkPackageInfo {
	s.NsdName = &v
	return s
}

// SetNsdOnboardingState sets the NsdOnboardingState field's value.
func (s *ListSolNetworkPackageInfo) SetNsdOnboardingState(v string) *ListSolNetworkPackageInfo {
	s.NsdOnboardingState = &v
	return s
}

// SetNsdOperationalState sets the NsdOperationalState field's value.
func (s *ListSolNetworkPackageInfo) SetNsdOperationalState(v string) *ListSolNetworkPackageInfo {
	s.NsdOperationalState = &v
	return s
}

// SetNsdUsageState sets the NsdUsageState field's value.
func (s *ListSolNetworkPackageInfo) SetNsdUsageState(v string) *ListSolNetworkPackageInfo {
	s.NsdUsageState = &v
	return s
}

// SetNsdVersion sets the NsdVersion field's value.
func (s *ListSolNetworkPackageInfo) SetNsdVersion(v string) *ListSolNetworkPackageInfo {
	s.NsdVersion = &v
	return s
}

// SetVnfPkgIds sets the VnfPkgIds field's value.
func (s *ListSolNetworkPackageInfo) SetVnfPkgIds(v []*string) *ListSolNetworkPackageInfo {
	s.VnfPkgIds = v
	return s
}

// Metadata related to a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
type ListSolNetworkPackageMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date that the resource was last modified.
	//
	// LastModified is a required field
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackageMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListSolNetworkPackageMetadata) SetCreatedAt(v time.Time) *ListSolNetworkPackageMetadata {
	s.CreatedAt = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ListSolNetworkPackageMetadata) SetLastModified(v time.Time) *ListSolNetworkPackageMetadata {
	s.LastModified = &v
	return s
}

type ListSolNetworkPackagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextpage_opaque_marker" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolNetworkPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolNetworkPackagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolNetworkPackagesInput) SetMaxResults(v int64) *ListSolNetworkPackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkPackagesInput) SetNextToken(v string) *ListSolNetworkPackagesInput {
	s.NextToken = &v
	return s
}

type ListSolNetworkPackagesOutput struct {
	_ struct{} `type:"structure"`

	// Network packages. A network package is a .zip file in CSAR (Cloud Service
	// Archive) format defines the function packages you want to deploy and the
	// Amazon Web Services infrastructure you want to deploy them on.
	//
	// NetworkPackages is a required field
	NetworkPackages []*ListSolNetworkPackageInfo `locationName:"networkPackages" type:"list" required:"true"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolNetworkPackagesOutput) GoString() string {
	return s.String()
}

// SetNetworkPackages sets the NetworkPackages field's value.
func (s *ListSolNetworkPackagesOutput) SetNetworkPackages(v []*ListSolNetworkPackageInfo) *ListSolNetworkPackagesOutput {
	s.NetworkPackages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolNetworkPackagesOutput) SetNextToken(v string) *ListSolNetworkPackagesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Metadata for network package artifacts.
//
// Artifacts are the contents of the package descriptor file and the state of
// the package.
type NetworkArtifactMeta struct {
	_ struct{} `type:"structure"`

	// Lists network package overrides.
	Overrides []*ToscaOverride `locationName:"overrides" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkArtifactMeta) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkArtifactMeta) GoString() string {
	return s.String()
}

// SetOverrides sets the Overrides field's value.
func (s *NetworkArtifactMeta) SetOverrides(v []*ToscaOverride) *NetworkArtifactMeta {
	s.Overrides = v
	return s
}

// Details related to problems with AWS TNB resources.
type ProblemDetails struct {
	_ struct{} `type:"structure"`

	// A human-readable explanation specific to this occurrence of the problem.
	//
	// Detail is a required field
	Detail *string `locationName:"detail" type:"string" required:"true"`

	// A human-readable title of the problem type.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProblemDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProblemDetails) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *ProblemDetails) SetDetail(v string) *ProblemDetails {
	s.Detail = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ProblemDetails) SetTitle(v string) *ProblemDetails {
	s.Title = &v
	return s
}

type PutSolFunctionPackageContentInput struct {
	_ struct{} `type:"structure" payload:"File"`

	// Function package content type.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Function package file.
	//
	// File is a required field
	File []byte `locationName:"file" type:"blob" required:"true"`

	// Function package ID.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSolFunctionPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSolFunctionPackageContentInput"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *PutSolFunctionPackageContentInput) SetContentType(v string) *PutSolFunctionPackageContentInput {
	s.ContentType = &v
	return s
}

// SetFile sets the File field's value.
func (s *PutSolFunctionPackageContentInput) SetFile(v []byte) *PutSolFunctionPackageContentInput {
	s.File = v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *PutSolFunctionPackageContentInput) SetVnfPkgId(v string) *PutSolFunctionPackageContentInput {
	s.VnfPkgId = &v
	return s
}

// Update metadata in a function package.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
type PutSolFunctionPackageContentMetadata struct {
	_ struct{} `type:"structure"`

	// Metadata for function package artifacts.
	//
	// Artifacts are the contents of the package descriptor file and the state of
	// the package.
	Vnfd *FunctionArtifactMeta `locationName:"vnfd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentMetadata) GoString() string {
	return s.String()
}

// SetVnfd sets the Vnfd field's value.
func (s *PutSolFunctionPackageContentMetadata) SetVnfd(v *FunctionArtifactMeta) *PutSolFunctionPackageContentMetadata {
	s.Vnfd = v
	return s
}

type PutSolFunctionPackageContentOutput struct {
	_ struct{} `type:"structure"`

	// Function package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Function package metadata.
	//
	// Metadata is a required field
	Metadata *PutSolFunctionPackageContentMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Function product name.
	//
	// VnfProductName is a required field
	VnfProductName *string `locationName:"vnfProductName" type:"string" required:"true"`

	// Function provider.
	//
	// VnfProvider is a required field
	VnfProvider *string `locationName:"vnfProvider" type:"string" required:"true"`

	// Function package descriptor ID.
	//
	// VnfdId is a required field
	VnfdId *string `locationName:"vnfdId" type:"string" required:"true"`

	// Function package descriptor version.
	//
	// VnfdVersion is a required field
	VnfdVersion *string `locationName:"vnfdVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolFunctionPackageContentOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *PutSolFunctionPackageContentOutput) SetId(v string) *PutSolFunctionPackageContentOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutSolFunctionPackageContentOutput) SetMetadata(v *PutSolFunctionPackageContentMetadata) *PutSolFunctionPackageContentOutput {
	s.Metadata = v
	return s
}

// SetVnfProductName sets the VnfProductName field's value.
func (s *PutSolFunctionPackageContentOutput) SetVnfProductName(v string) *PutSolFunctionPackageContentOutput {
	s.VnfProductName = &v
	return s
}

// SetVnfProvider sets the VnfProvider field's value.
func (s *PutSolFunctionPackageContentOutput) SetVnfProvider(v string) *PutSolFunctionPackageContentOutput {
	s.VnfProvider = &v
	return s
}

// SetVnfdId sets the VnfdId field's value.
func (s *PutSolFunctionPackageContentOutput) SetVnfdId(v string) *PutSolFunctionPackageContentOutput {
	s.VnfdId = &v
	return s
}

// SetVnfdVersion sets the VnfdVersion field's value.
func (s *PutSolFunctionPackageContentOutput) SetVnfdVersion(v string) *PutSolFunctionPackageContentOutput {
	s.VnfdVersion = &v
	return s
}

type PutSolNetworkPackageContentInput struct {
	_ struct{} `type:"structure" payload:"File"`

	// Network package content type.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Network package file.
	//
	// File is a required field
	File []byte `locationName:"file" type:"blob" required:"true"`

	// Network service descriptor info ID.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSolNetworkPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSolNetworkPackageContentInput"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *PutSolNetworkPackageContentInput) SetContentType(v string) *PutSolNetworkPackageContentInput {
	s.ContentType = &v
	return s
}

// SetFile sets the File field's value.
func (s *PutSolNetworkPackageContentInput) SetFile(v []byte) *PutSolNetworkPackageContentInput {
	s.File = v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *PutSolNetworkPackageContentInput) SetNsdInfoId(v string) *PutSolNetworkPackageContentInput {
	s.NsdInfoId = &v
	return s
}

// Update metadata in a network package.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
type PutSolNetworkPackageContentMetadata struct {
	_ struct{} `type:"structure"`

	// Metadata for network package artifacts.
	//
	// Artifacts are the contents of the package descriptor file and the state of
	// the package.
	Nsd *NetworkArtifactMeta `locationName:"nsd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentMetadata) GoString() string {
	return s.String()
}

// SetNsd sets the Nsd field's value.
func (s *PutSolNetworkPackageContentMetadata) SetNsd(v *NetworkArtifactMeta) *PutSolNetworkPackageContentMetadata {
	s.Nsd = v
	return s
}

type PutSolNetworkPackageContentOutput struct {
	_ struct{} `type:"structure"`

	// Network package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Network package metadata.
	//
	// Metadata is a required field
	Metadata *PutSolNetworkPackageContentMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network service descriptor ID.
	//
	// NsdId is a required field
	NsdId *string `locationName:"nsdId" type:"string" required:"true"`

	// Network service descriptor name.
	//
	// NsdName is a required field
	NsdName *string `locationName:"nsdName" type:"string" required:"true"`

	// Network service descriptor version.
	//
	// NsdVersion is a required field
	NsdVersion *string `locationName:"nsdVersion" type:"string" required:"true"`

	// Function package IDs.
	//
	// VnfPkgIds is a required field
	VnfPkgIds []*string `locationName:"vnfPkgIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSolNetworkPackageContentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutSolNetworkPackageContentOutput) SetArn(v string) *PutSolNetworkPackageContentOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *PutSolNetworkPackageContentOutput) SetId(v string) *PutSolNetworkPackageContentOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutSolNetworkPackageContentOutput) SetMetadata(v *PutSolNetworkPackageContentMetadata) *PutSolNetworkPackageContentOutput {
	s.Metadata = v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *PutSolNetworkPackageContentOutput) SetNsdId(v string) *PutSolNetworkPackageContentOutput {
	s.NsdId = &v
	return s
}

// SetNsdName sets the NsdName field's value.
func (s *PutSolNetworkPackageContentOutput) SetNsdName(v string) *PutSolNetworkPackageContentOutput {
	s.NsdName = &v
	return s
}

// SetNsdVersion sets the NsdVersion field's value.
func (s *PutSolNetworkPackageContentOutput) SetNsdVersion(v string) *PutSolNetworkPackageContentOutput {
	s.NsdVersion = &v
	return s
}

// SetVnfPkgIds sets the VnfPkgIds field's value.
func (s *PutSolNetworkPackageContentOutput) SetVnfPkgIds(v []*string) *PutSolNetworkPackageContentOutput {
	s.VnfPkgIds = v
	return s
}

// Request references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Service quotas have been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. You can use tags to search and
	// filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TerminateSolNetworkInstanceInput struct {
	_ struct{} `type:"structure"`

	// ID of the network instance.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `location:"uri" locationName:"nsInstanceId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TerminateSolNetworkInstanceInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateSolNetworkInstanceInput"}
	if s.NsInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsInstanceId"))
	}
	if s.NsInstanceId != nil && len(*s.NsInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *TerminateSolNetworkInstanceInput) SetNsInstanceId(v string) *TerminateSolNetworkInstanceInput {
	s.NsInstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TerminateSolNetworkInstanceInput) SetTags(v map[string]*string) *TerminateSolNetworkInstanceInput {
	s.Tags = v
	return s
}

type TerminateSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the network operation.
	NsLcmOpOccId *string `locationName:"nsLcmOpOccId" type:"string"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TerminateSolNetworkInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *TerminateSolNetworkInstanceOutput) SetNsLcmOpOccId(v string) *TerminateSolNetworkInstanceOutput {
	s.NsLcmOpOccId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TerminateSolNetworkInstanceOutput) SetTags(v map[string]*string) *TerminateSolNetworkInstanceOutput {
	s.Tags = v
	return s
}

// Exception caused by throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Overrides of the TOSCA node.
type ToscaOverride struct {
	_ struct{} `type:"structure"`

	// Default value for the override.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// Name of the TOSCA override.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ToscaOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ToscaOverride) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ToscaOverride) SetDefaultValue(v string) *ToscaOverride {
	s.DefaultValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ToscaOverride) SetName(v string) *ToscaOverride {
	s.Name = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateSolFunctionPackageInput struct {
	_ struct{} `type:"structure"`

	// Operational state of the function package.
	//
	// OperationalState is a required field
	OperationalState *string `locationName:"operationalState" type:"string" required:"true" enum:"OperationalState"`

	// ID of the function package.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolFunctionPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolFunctionPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSolFunctionPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSolFunctionPackageInput"}
	if s.OperationalState == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationalState"))
	}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationalState sets the OperationalState field's value.
func (s *UpdateSolFunctionPackageInput) SetOperationalState(v string) *UpdateSolFunctionPackageInput {
	s.OperationalState = &v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *UpdateSolFunctionPackageInput) SetVnfPkgId(v string) *UpdateSolFunctionPackageInput {
	s.VnfPkgId = &v
	return s
}

type UpdateSolFunctionPackageOutput struct {
	_ struct{} `type:"structure"`

	// Operational state of the function package.
	//
	// OperationalState is a required field
	OperationalState *string `locationName:"operationalState" type:"string" required:"true" enum:"OperationalState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolFunctionPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolFunctionPackageOutput) GoString() string {
	return s.String()
}

// SetOperationalState sets the OperationalState field's value.
func (s *UpdateSolFunctionPackageOutput) SetOperationalState(v string) *UpdateSolFunctionPackageOutput {
	s.OperationalState = &v
	return s
}

type UpdateSolNetworkInstanceInput struct {
	_ struct{} `type:"structure"`

	// ID of the network instance.
	//
	// NsInstanceId is a required field
	NsInstanceId *string `location:"uri" locationName:"nsInstanceId" type:"string" required:"true"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSolNetworkInstanceInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// The type of update.
	//
	// UpdateType is a required field
	UpdateType *string `locationName:"updateType" type:"string" required:"true" enum:"UpdateSolNetworkType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSolNetworkInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSolNetworkInstanceInput"}
	if s.NsInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsInstanceId"))
	}
	if s.NsInstanceId != nil && len(*s.NsInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsInstanceId", 1))
	}
	if s.UpdateType == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsInstanceId sets the NsInstanceId field's value.
func (s *UpdateSolNetworkInstanceInput) SetNsInstanceId(v string) *UpdateSolNetworkInstanceInput {
	s.NsInstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSolNetworkInstanceInput) SetTags(v map[string]*string) *UpdateSolNetworkInstanceInput {
	s.Tags = v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *UpdateSolNetworkInstanceInput) SetUpdateType(v string) *UpdateSolNetworkInstanceInput {
	s.UpdateType = &v
	return s
}

type UpdateSolNetworkInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the network operation.
	NsLcmOpOccId *string `locationName:"nsLcmOpOccId" type:"string"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value. When you use this API, the tags
	// are transferred to the network operation that is created. Use tags to search
	// and filter your resources or track your Amazon Web Services costs.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSolNetworkInstanceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkInstanceOutput) GoString() string {
	return s.String()
}

// SetNsLcmOpOccId sets the NsLcmOpOccId field's value.
func (s *UpdateSolNetworkInstanceOutput) SetNsLcmOpOccId(v string) *UpdateSolNetworkInstanceOutput {
	s.NsLcmOpOccId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSolNetworkInstanceOutput) SetTags(v map[string]*string) *UpdateSolNetworkInstanceOutput {
	s.Tags = v
	return s
}

type UpdateSolNetworkPackageInput struct {
	_ struct{} `type:"structure"`

	// ID of the network service descriptor in the network package.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`

	// Operational state of the network service descriptor in the network package.
	//
	// NsdOperationalState is a required field
	NsdOperationalState *string `locationName:"nsdOperationalState" type:"string" required:"true" enum:"NsdOperationalState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkPackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSolNetworkPackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSolNetworkPackageInput"}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}
	if s.NsdOperationalState == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdOperationalState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *UpdateSolNetworkPackageInput) SetNsdInfoId(v string) *UpdateSolNetworkPackageInput {
	s.NsdInfoId = &v
	return s
}

// SetNsdOperationalState sets the NsdOperationalState field's value.
func (s *UpdateSolNetworkPackageInput) SetNsdOperationalState(v string) *UpdateSolNetworkPackageInput {
	s.NsdOperationalState = &v
	return s
}

type UpdateSolNetworkPackageOutput struct {
	_ struct{} `type:"structure"`

	// Operational state of the network service descriptor in the network package.
	//
	// NsdOperationalState is a required field
	NsdOperationalState *string `locationName:"nsdOperationalState" type:"string" required:"true" enum:"NsdOperationalState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSolNetworkPackageOutput) GoString() string {
	return s.String()
}

// SetNsdOperationalState sets the NsdOperationalState field's value.
func (s *UpdateSolNetworkPackageOutput) SetNsdOperationalState(v string) *UpdateSolNetworkPackageOutput {
	s.NsdOperationalState = &v
	return s
}

type ValidateSolFunctionPackageContentInput struct {
	_ struct{} `type:"structure" payload:"File"`

	// Function package content type.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Function package file.
	//
	// File is a required field
	File []byte `locationName:"file" type:"blob" required:"true"`

	// Function package ID.
	//
	// VnfPkgId is a required field
	VnfPkgId *string `location:"uri" locationName:"vnfPkgId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateSolFunctionPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateSolFunctionPackageContentInput"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.VnfPkgId == nil {
		invalidParams.Add(request.NewErrParamRequired("VnfPkgId"))
	}
	if s.VnfPkgId != nil && len(*s.VnfPkgId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VnfPkgId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ValidateSolFunctionPackageContentInput) SetContentType(v string) *ValidateSolFunctionPackageContentInput {
	s.ContentType = &v
	return s
}

// SetFile sets the File field's value.
func (s *ValidateSolFunctionPackageContentInput) SetFile(v []byte) *ValidateSolFunctionPackageContentInput {
	s.File = v
	return s
}

// SetVnfPkgId sets the VnfPkgId field's value.
func (s *ValidateSolFunctionPackageContentInput) SetVnfPkgId(v string) *ValidateSolFunctionPackageContentInput {
	s.VnfPkgId = &v
	return s
}

// Validates function package content metadata.
//
// A function package is a .zip file in CSAR (Cloud Service Archive) format
// that contains a network function (an ETSI standard telecommunication application)
// and function package descriptor that uses the TOSCA standard to describe
// how the network functions should run on your network.
type ValidateSolFunctionPackageContentMetadata struct {
	_ struct{} `type:"structure"`

	// Metadata for function package artifacts.
	//
	// Artifacts are the contents of the package descriptor file and the state of
	// the package.
	Vnfd *FunctionArtifactMeta `locationName:"vnfd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentMetadata) GoString() string {
	return s.String()
}

// SetVnfd sets the Vnfd field's value.
func (s *ValidateSolFunctionPackageContentMetadata) SetVnfd(v *FunctionArtifactMeta) *ValidateSolFunctionPackageContentMetadata {
	s.Vnfd = v
	return s
}

type ValidateSolFunctionPackageContentOutput struct {
	_ struct{} `type:"structure"`

	// Function package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Function package metadata.
	//
	// Metadata is a required field
	Metadata *ValidateSolFunctionPackageContentMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network function product name.
	//
	// VnfProductName is a required field
	VnfProductName *string `locationName:"vnfProductName" type:"string" required:"true"`

	// Network function provider.
	//
	// VnfProvider is a required field
	VnfProvider *string `locationName:"vnfProvider" type:"string" required:"true"`

	// Function package descriptor ID.
	//
	// VnfdId is a required field
	VnfdId *string `locationName:"vnfdId" type:"string" required:"true"`

	// Function package descriptor version.
	//
	// VnfdVersion is a required field
	VnfdVersion *string `locationName:"vnfdVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolFunctionPackageContentOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetId(v string) *ValidateSolFunctionPackageContentOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetMetadata(v *ValidateSolFunctionPackageContentMetadata) *ValidateSolFunctionPackageContentOutput {
	s.Metadata = v
	return s
}

// SetVnfProductName sets the VnfProductName field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetVnfProductName(v string) *ValidateSolFunctionPackageContentOutput {
	s.VnfProductName = &v
	return s
}

// SetVnfProvider sets the VnfProvider field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetVnfProvider(v string) *ValidateSolFunctionPackageContentOutput {
	s.VnfProvider = &v
	return s
}

// SetVnfdId sets the VnfdId field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetVnfdId(v string) *ValidateSolFunctionPackageContentOutput {
	s.VnfdId = &v
	return s
}

// SetVnfdVersion sets the VnfdVersion field's value.
func (s *ValidateSolFunctionPackageContentOutput) SetVnfdVersion(v string) *ValidateSolFunctionPackageContentOutput {
	s.VnfdVersion = &v
	return s
}

type ValidateSolNetworkPackageContentInput struct {
	_ struct{} `type:"structure" payload:"File"`

	// Network package content type.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"PackageContentType"`

	// Network package file.
	//
	// File is a required field
	File []byte `locationName:"file" type:"blob" required:"true"`

	// Network service descriptor file.
	//
	// NsdInfoId is a required field
	NsdInfoId *string `location:"uri" locationName:"nsdInfoId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateSolNetworkPackageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateSolNetworkPackageContentInput"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.NsdInfoId == nil {
		invalidParams.Add(request.NewErrParamRequired("NsdInfoId"))
	}
	if s.NsdInfoId != nil && len(*s.NsdInfoId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NsdInfoId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ValidateSolNetworkPackageContentInput) SetContentType(v string) *ValidateSolNetworkPackageContentInput {
	s.ContentType = &v
	return s
}

// SetFile sets the File field's value.
func (s *ValidateSolNetworkPackageContentInput) SetFile(v []byte) *ValidateSolNetworkPackageContentInput {
	s.File = v
	return s
}

// SetNsdInfoId sets the NsdInfoId field's value.
func (s *ValidateSolNetworkPackageContentInput) SetNsdInfoId(v string) *ValidateSolNetworkPackageContentInput {
	s.NsdInfoId = &v
	return s
}

// Validates network package content metadata.
//
// A network package is a .zip file in CSAR (Cloud Service Archive) format defines
// the function packages you want to deploy and the Amazon Web Services infrastructure
// you want to deploy them on.
type ValidateSolNetworkPackageContentMetadata struct {
	_ struct{} `type:"structure"`

	// Metadata for network package artifacts.
	//
	// Artifacts are the contents of the package descriptor file and the state of
	// the package.
	Nsd *NetworkArtifactMeta `locationName:"nsd" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentMetadata) GoString() string {
	return s.String()
}

// SetNsd sets the Nsd field's value.
func (s *ValidateSolNetworkPackageContentMetadata) SetNsd(v *NetworkArtifactMeta) *ValidateSolNetworkPackageContentMetadata {
	s.Nsd = v
	return s
}

type ValidateSolNetworkPackageContentOutput struct {
	_ struct{} `type:"structure"`

	// Network package ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Network package ID.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Network package metadata.
	//
	// Metadata is a required field
	Metadata *ValidateSolNetworkPackageContentMetadata `locationName:"metadata" type:"structure" required:"true"`

	// Network service descriptor ID.
	//
	// NsdId is a required field
	NsdId *string `locationName:"nsdId" type:"string" required:"true"`

	// Network service descriptor name.
	//
	// NsdName is a required field
	NsdName *string `locationName:"nsdName" type:"string" required:"true"`

	// Network service descriptor version.
	//
	// NsdVersion is a required field
	NsdVersion *string `locationName:"nsdVersion" type:"string" required:"true"`

	// Function package IDs.
	//
	// VnfPkgIds is a required field
	VnfPkgIds []*string `locationName:"vnfPkgIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateSolNetworkPackageContentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetArn(v string) *ValidateSolNetworkPackageContentOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetId(v string) *ValidateSolNetworkPackageContentOutput {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetMetadata(v *ValidateSolNetworkPackageContentMetadata) *ValidateSolNetworkPackageContentOutput {
	s.Metadata = v
	return s
}

// SetNsdId sets the NsdId field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetNsdId(v string) *ValidateSolNetworkPackageContentOutput {
	s.NsdId = &v
	return s
}

// SetNsdName sets the NsdName field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetNsdName(v string) *ValidateSolNetworkPackageContentOutput {
	s.NsdName = &v
	return s
}

// SetNsdVersion sets the NsdVersion field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetNsdVersion(v string) *ValidateSolNetworkPackageContentOutput {
	s.NsdVersion = &v
	return s
}

// SetVnfPkgIds sets the VnfPkgIds field's value.
func (s *ValidateSolNetworkPackageContentOutput) SetVnfPkgIds(v []*string) *ValidateSolNetworkPackageContentOutput {
	s.VnfPkgIds = v
	return s
}

// Unable to process the request because the client provided input failed to
// satisfy request constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DescriptorContentTypeTextPlain is a DescriptorContentType enum value
	DescriptorContentTypeTextPlain = "text/plain"
)

// DescriptorContentType_Values returns all elements of the DescriptorContentType enum
func DescriptorContentType_Values() []string {
	return []string{
		DescriptorContentTypeTextPlain,
	}
}

const (
	// LcmOperationTypeInstantiate is a LcmOperationType enum value
	LcmOperationTypeInstantiate = "INSTANTIATE"

	// LcmOperationTypeUpdate is a LcmOperationType enum value
	LcmOperationTypeUpdate = "UPDATE"

	// LcmOperationTypeTerminate is a LcmOperationType enum value
	LcmOperationTypeTerminate = "TERMINATE"
)

// LcmOperationType_Values returns all elements of the LcmOperationType enum
func LcmOperationType_Values() []string {
	return []string{
		LcmOperationTypeInstantiate,
		LcmOperationTypeUpdate,
		LcmOperationTypeTerminate,
	}
}

const (
	// NsLcmOperationStateProcessing is a NsLcmOperationState enum value
	NsLcmOperationStateProcessing = "PROCESSING"

	// NsLcmOperationStateCompleted is a NsLcmOperationState enum value
	NsLcmOperationStateCompleted = "COMPLETED"

	// NsLcmOperationStateFailed is a NsLcmOperationState enum value
	NsLcmOperationStateFailed = "FAILED"

	// NsLcmOperationStateCancelling is a NsLcmOperationState enum value
	NsLcmOperationStateCancelling = "CANCELLING"

	// NsLcmOperationStateCancelled is a NsLcmOperationState enum value
	NsLcmOperationStateCancelled = "CANCELLED"
)

// NsLcmOperationState_Values returns all elements of the NsLcmOperationState enum
func NsLcmOperationState_Values() []string {
	return []string{
		NsLcmOperationStateProcessing,
		NsLcmOperationStateCompleted,
		NsLcmOperationStateFailed,
		NsLcmOperationStateCancelling,
		NsLcmOperationStateCancelled,
	}
}

const (
	// NsStateInstantiated is a NsState enum value
	NsStateInstantiated = "INSTANTIATED"

	// NsStateNotInstantiated is a NsState enum value
	NsStateNotInstantiated = "NOT_INSTANTIATED"

	// NsStateImpaired is a NsState enum value
	NsStateImpaired = "IMPAIRED"

	// NsStateStopped is a NsState enum value
	NsStateStopped = "STOPPED"

	// NsStateDeleted is a NsState enum value
	NsStateDeleted = "DELETED"

	// NsStateInstantiateInProgress is a NsState enum value
	NsStateInstantiateInProgress = "INSTANTIATE_IN_PROGRESS"

	// NsStateUpdateInProgress is a NsState enum value
	NsStateUpdateInProgress = "UPDATE_IN_PROGRESS"

	// NsStateTerminateInProgress is a NsState enum value
	NsStateTerminateInProgress = "TERMINATE_IN_PROGRESS"
)

// NsState_Values returns all elements of the NsState enum
func NsState_Values() []string {
	return []string{
		NsStateInstantiated,
		NsStateNotInstantiated,
		NsStateImpaired,
		NsStateStopped,
		NsStateDeleted,
		NsStateInstantiateInProgress,
		NsStateUpdateInProgress,
		NsStateTerminateInProgress,
	}
}

const (
	// NsdOnboardingStateCreated is a NsdOnboardingState enum value
	NsdOnboardingStateCreated = "CREATED"

	// NsdOnboardingStateOnboarded is a NsdOnboardingState enum value
	NsdOnboardingStateOnboarded = "ONBOARDED"

	// NsdOnboardingStateError is a NsdOnboardingState enum value
	NsdOnboardingStateError = "ERROR"
)

// NsdOnboardingState_Values returns all elements of the NsdOnboardingState enum
func NsdOnboardingState_Values() []string {
	return []string{
		NsdOnboardingStateCreated,
		NsdOnboardingStateOnboarded,
		NsdOnboardingStateError,
	}
}

const (
	// NsdOperationalStateEnabled is a NsdOperationalState enum value
	NsdOperationalStateEnabled = "ENABLED"

	// NsdOperationalStateDisabled is a NsdOperationalState enum value
	NsdOperationalStateDisabled = "DISABLED"
)

// NsdOperationalState_Values returns all elements of the NsdOperationalState enum
func NsdOperationalState_Values() []string {
	return []string{
		NsdOperationalStateEnabled,
		NsdOperationalStateDisabled,
	}
}

const (
	// NsdUsageStateInUse is a NsdUsageState enum value
	NsdUsageStateInUse = "IN_USE"

	// NsdUsageStateNotInUse is a NsdUsageState enum value
	NsdUsageStateNotInUse = "NOT_IN_USE"
)

// NsdUsageState_Values returns all elements of the NsdUsageState enum
func NsdUsageState_Values() []string {
	return []string{
		NsdUsageStateInUse,
		NsdUsageStateNotInUse,
	}
}

const (
	// OnboardingStateCreated is a OnboardingState enum value
	OnboardingStateCreated = "CREATED"

	// OnboardingStateOnboarded is a OnboardingState enum value
	OnboardingStateOnboarded = "ONBOARDED"

	// OnboardingStateError is a OnboardingState enum value
	OnboardingStateError = "ERROR"
)

// OnboardingState_Values returns all elements of the OnboardingState enum
func OnboardingState_Values() []string {
	return []string{
		OnboardingStateCreated,
		OnboardingStateOnboarded,
		OnboardingStateError,
	}
}

const (
	// OperationalStateEnabled is a OperationalState enum value
	OperationalStateEnabled = "ENABLED"

	// OperationalStateDisabled is a OperationalState enum value
	OperationalStateDisabled = "DISABLED"
)

// OperationalState_Values returns all elements of the OperationalState enum
func OperationalState_Values() []string {
	return []string{
		OperationalStateEnabled,
		OperationalStateDisabled,
	}
}

const (
	// PackageContentTypeApplicationZip is a PackageContentType enum value
	PackageContentTypeApplicationZip = "application/zip"
)

// PackageContentType_Values returns all elements of the PackageContentType enum
func PackageContentType_Values() []string {
	return []string{
		PackageContentTypeApplicationZip,
	}
}

const (
	// TaskStatusScheduled is a TaskStatus enum value
	TaskStatusScheduled = "SCHEDULED"

	// TaskStatusStarted is a TaskStatus enum value
	TaskStatusStarted = "STARTED"

	// TaskStatusInProgress is a TaskStatus enum value
	TaskStatusInProgress = "IN_PROGRESS"

	// TaskStatusCompleted is a TaskStatus enum value
	TaskStatusCompleted = "COMPLETED"

	// TaskStatusError is a TaskStatus enum value
	TaskStatusError = "ERROR"

	// TaskStatusSkipped is a TaskStatus enum value
	TaskStatusSkipped = "SKIPPED"

	// TaskStatusCancelled is a TaskStatus enum value
	TaskStatusCancelled = "CANCELLED"
)

// TaskStatus_Values returns all elements of the TaskStatus enum
func TaskStatus_Values() []string {
	return []string{
		TaskStatusScheduled,
		TaskStatusStarted,
		TaskStatusInProgress,
		TaskStatusCompleted,
		TaskStatusError,
		TaskStatusSkipped,
		TaskStatusCancelled,
	}
}

const (
	// UpdateSolNetworkTypeModifyVnfInformation is a UpdateSolNetworkType enum value
	UpdateSolNetworkTypeModifyVnfInformation = "MODIFY_VNF_INFORMATION"
)

// UpdateSolNetworkType_Values returns all elements of the UpdateSolNetworkType enum
func UpdateSolNetworkType_Values() []string {
	return []string{
		UpdateSolNetworkTypeModifyVnfInformation,
	}
}

const (
	// UsageStateInUse is a UsageState enum value
	UsageStateInUse = "IN_USE"

	// UsageStateNotInUse is a UsageState enum value
	UsageStateNotInUse = "NOT_IN_USE"
)

// UsageState_Values returns all elements of the UsageState enum
func UsageState_Values() []string {
	return []string{
		UsageStateInUse,
		UsageStateNotInUse,
	}
}

const (
	// VnfInstantiationStateInstantiated is a VnfInstantiationState enum value
	VnfInstantiationStateInstantiated = "INSTANTIATED"

	// VnfInstantiationStateNotInstantiated is a VnfInstantiationState enum value
	VnfInstantiationStateNotInstantiated = "NOT_INSTANTIATED"
)

// VnfInstantiationState_Values returns all elements of the VnfInstantiationState enum
func VnfInstantiationState_Values() []string {
	return []string{
		VnfInstantiationStateInstantiated,
		VnfInstantiationStateNotInstantiated,
	}
}

const (
	// VnfOperationalStateStarted is a VnfOperationalState enum value
	VnfOperationalStateStarted = "STARTED"

	// VnfOperationalStateStopped is a VnfOperationalState enum value
	VnfOperationalStateStopped = "STOPPED"
)

// VnfOperationalState_Values returns all elements of the VnfOperationalState enum
func VnfOperationalState_Values() []string {
	return []string{
		VnfOperationalStateStarted,
		VnfOperationalStateStopped,
	}
}
