// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2beta1/agent_coaching_instruction.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The event that should trigger this instruction.
type AgentCoachingInstruction_TriggerEvent int32

const (
	// Default value for TriggerEvent.
	AgentCoachingInstruction_TRIGGER_EVENT_UNSPECIFIED AgentCoachingInstruction_TriggerEvent = 0
	// Triggers when each chat message or voice utterance ends.
	AgentCoachingInstruction_END_OF_UTTERANCE AgentCoachingInstruction_TriggerEvent = 1
	// Triggers on the conversation manually by API calls.
	AgentCoachingInstruction_MANUAL_CALL AgentCoachingInstruction_TriggerEvent = 2
	// Triggers after each customer message.
	AgentCoachingInstruction_CUSTOMER_MESSAGE AgentCoachingInstruction_TriggerEvent = 3
	// Triggers after each agent message.
	AgentCoachingInstruction_AGENT_MESSAGE AgentCoachingInstruction_TriggerEvent = 4
	// Triggers on tool call completion.
	AgentCoachingInstruction_TOOL_CALL_COMPLETION AgentCoachingInstruction_TriggerEvent = 5
)

// Enum value maps for AgentCoachingInstruction_TriggerEvent.
var (
	AgentCoachingInstruction_TriggerEvent_name = map[int32]string{
		0: "TRIGGER_EVENT_UNSPECIFIED",
		1: "END_OF_UTTERANCE",
		2: "MANUAL_CALL",
		3: "CUSTOMER_MESSAGE",
		4: "AGENT_MESSAGE",
		5: "TOOL_CALL_COMPLETION",
	}
	AgentCoachingInstruction_TriggerEvent_value = map[string]int32{
		"TRIGGER_EVENT_UNSPECIFIED": 0,
		"END_OF_UTTERANCE":          1,
		"MANUAL_CALL":               2,
		"CUSTOMER_MESSAGE":          3,
		"AGENT_MESSAGE":             4,
		"TOOL_CALL_COMPLETION":      5,
	}
)

func (x AgentCoachingInstruction_TriggerEvent) Enum() *AgentCoachingInstruction_TriggerEvent {
	p := new(AgentCoachingInstruction_TriggerEvent)
	*p = x
	return p
}

func (x AgentCoachingInstruction_TriggerEvent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentCoachingInstruction_TriggerEvent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_enumTypes[0].Descriptor()
}

func (AgentCoachingInstruction_TriggerEvent) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_enumTypes[0]
}

func (x AgentCoachingInstruction_TriggerEvent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentCoachingInstruction_TriggerEvent.Descriptor instead.
func (AgentCoachingInstruction_TriggerEvent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescGZIP(), []int{0, 0}
}

// Agent Coaching instructions that customer can configure.
type AgentCoachingInstruction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Display name for the instruction.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The detailed description of this instruction.
	DisplayDetails string `protobuf:"bytes,2,opt,name=display_details,json=displayDetails,proto3" json:"display_details,omitempty"`
	// Optional. The condition of the instruction. For example, "the customer
	// wants to cancel an order".  If the users want the instruction to be
	// triggered unconditionally, the condition can be empty.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Optional. The action that human agent should take. For example, "apologize
	// for the slow shipping". If the users only want to use agent coaching for
	// intent detection, agent_action can be empty
	AgentAction string `protobuf:"bytes,4,opt,name=agent_action,json=agentAction,proto3" json:"agent_action,omitempty"`
	// Optional. The action that system should take. For example,
	// "call GetOrderTime with order_number={order number provided by the
	// customer}". If the users don't have plugins or don't want to trigger
	// plugins, the system_action can be empty
	SystemAction string `protobuf:"bytes,5,opt,name=system_action,json=systemAction,proto3" json:"system_action,omitempty"`
	// Output only. Duplication check for the AgentCoachingInstruction.
	DuplicateCheckResult *AgentCoachingInstruction_DuplicateCheckResult `protobuf:"bytes,8,opt,name=duplicate_check_result,json=duplicateCheckResult,proto3" json:"duplicate_check_result,omitempty"`
	// Optional. The event that should trigger this instruction.
	// If UNSPECIFIED, the instruction triggering will be same as the generator's
	// trigger_event.
	TriggeringEvent AgentCoachingInstruction_TriggerEvent `protobuf:"varint,10,opt,name=triggering_event,json=triggeringEvent,proto3,enum=google.cloud.dialogflow.v2beta1.AgentCoachingInstruction_TriggerEvent" json:"triggering_event,omitempty"`
}

func (x *AgentCoachingInstruction) Reset() {
	*x = AgentCoachingInstruction{}
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingInstruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingInstruction) ProtoMessage() {}

func (x *AgentCoachingInstruction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingInstruction.ProtoReflect.Descriptor instead.
func (*AgentCoachingInstruction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescGZIP(), []int{0}
}

func (x *AgentCoachingInstruction) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AgentCoachingInstruction) GetDisplayDetails() string {
	if x != nil {
		return x.DisplayDetails
	}
	return ""
}

func (x *AgentCoachingInstruction) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *AgentCoachingInstruction) GetAgentAction() string {
	if x != nil {
		return x.AgentAction
	}
	return ""
}

func (x *AgentCoachingInstruction) GetSystemAction() string {
	if x != nil {
		return x.SystemAction
	}
	return ""
}

func (x *AgentCoachingInstruction) GetDuplicateCheckResult() *AgentCoachingInstruction_DuplicateCheckResult {
	if x != nil {
		return x.DuplicateCheckResult
	}
	return nil
}

func (x *AgentCoachingInstruction) GetTriggeringEvent() AgentCoachingInstruction_TriggerEvent {
	if x != nil {
		return x.TriggeringEvent
	}
	return AgentCoachingInstruction_TRIGGER_EVENT_UNSPECIFIED
}

// Duplication check for the suggestion.
type AgentCoachingInstruction_DuplicateCheckResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The duplicate suggestions.
	DuplicateSuggestions []*AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion `protobuf:"bytes,1,rep,name=duplicate_suggestions,json=duplicateSuggestions,proto3" json:"duplicate_suggestions,omitempty"`
}

func (x *AgentCoachingInstruction_DuplicateCheckResult) Reset() {
	*x = AgentCoachingInstruction_DuplicateCheckResult{}
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingInstruction_DuplicateCheckResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingInstruction_DuplicateCheckResult) ProtoMessage() {}

func (x *AgentCoachingInstruction_DuplicateCheckResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingInstruction_DuplicateCheckResult.ProtoReflect.Descriptor instead.
func (*AgentCoachingInstruction_DuplicateCheckResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AgentCoachingInstruction_DuplicateCheckResult) GetDuplicateSuggestions() []*AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion {
	if x != nil {
		return x.DuplicateSuggestions
	}
	return nil
}

// The duplicate suggestion details.
type AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The answer record id of the past duplicate suggestion.
	AnswerRecord string `protobuf:"bytes,1,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// Output only. The index of the duplicate suggestion in the past
	// suggestion list.
	SuggestionIndex int32 `protobuf:"varint,3,opt,name=suggestion_index,json=suggestionIndex,proto3" json:"suggestion_index,omitempty"`
	// Output only. The similarity score of between the past and current
	// suggestion.
	SimilarityScore float32 `protobuf:"fixed32,4,opt,name=similarity_score,json=similarityScore,proto3" json:"similarity_score,omitempty"`
}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) Reset() {
	*x = AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion{}
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) ProtoMessage() {}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion.ProtoReflect.Descriptor instead.
func (*AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) GetSuggestionIndex() int32 {
	if x != nil {
		return x.SuggestionIndex
	}
	return 0
}

func (x *AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion) GetSimilarityScore() float32 {
	if x != nil {
		return x.SimilarityScore
	}
	return 0
}

var File_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdd, 0x07, 0x0a, 0x18, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x89, 0x01, 0x0a,
	0x16, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x76, 0x0a, 0x10, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x1a, 0xd7, 0x02, 0x0a, 0x14, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x9c, 0x01, 0x0a, 0x15, 0x64, 0x75,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x13, 0x44, 0x75, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x69,
	0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x69, 0x6d, 0x69, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x0c, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x19, 0x54,
	0x52, 0x49, 0x47, 0x47, 0x45, 0x52, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e,
	0x44, 0x5f, 0x4f, 0x46, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x10,
	0x02, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x4d, 0x45,
	0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x47, 0x45, 0x4e, 0x54,
	0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x4f,
	0x4f, 0x4c, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x05, 0x42, 0xb2, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x1d, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_goTypes = []any{
	(AgentCoachingInstruction_TriggerEvent)(0),                                // 0: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.TriggerEvent
	(*AgentCoachingInstruction)(nil),                                          // 1: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction
	(*AgentCoachingInstruction_DuplicateCheckResult)(nil),                     // 2: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.DuplicateCheckResult
	(*AgentCoachingInstruction_DuplicateCheckResult_DuplicateSuggestion)(nil), // 3: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.DuplicateCheckResult.DuplicateSuggestion
}
var file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_depIdxs = []int32{
	2, // 0: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.duplicate_check_result:type_name -> google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.DuplicateCheckResult
	0, // 1: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.triggering_event:type_name -> google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.TriggerEvent
	3, // 2: google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.DuplicateCheckResult.duplicate_suggestions:type_name -> google.cloud.dialogflow.v2beta1.AgentCoachingInstruction.DuplicateCheckResult.DuplicateSuggestion
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_init() }
func file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto = out.File
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_agent_coaching_instruction_proto_depIdxs = nil
}
