// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/eventarc/v1/google_api_source.proto

package eventarcpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A GoogleApiSource represents a subscription of 1P events from a MessageBus.
type GoogleApiSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of the form
	// projects/{project}/locations/{location}/googleApiSources/{google_api_source}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server assigned unique identifier for the channel. The value
	// is a UUID4 string and guaranteed to remain unchanged until the resource is
	// deleted.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields, and might be sent only on update and delete requests to
	// ensure that the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Resource labels.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Resource annotations.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Resource display name.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Destination is the message bus that the GoogleApiSource is
	// delivering to. It must be point to the full resource name of a MessageBus.
	// Format:
	// "projects/{PROJECT_ID}/locations/{region}/messagesBuses/{MESSAGE_BUS_ID)
	Destination string `protobuf:"bytes,9,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt their event data.
	//
	// It must match the pattern
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	CryptoKeyName string `protobuf:"bytes,10,opt,name=crypto_key_name,json=cryptoKeyName,proto3" json:"crypto_key_name,omitempty"`
	// Optional. Config to control Platform logging for the GoogleApiSource.
	LoggingConfig *LoggingConfig `protobuf:"bytes,11,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Config to enabled subscribing to events from other projects in the org.
	//
	// Users need the eventarc.googleApiSource.create permission on the entire org
	// in order to create a resource with these settings.
	//
	// Types that are assignable to WideScopeSubscription:
	//
	//	*GoogleApiSource_OrganizationSubscription_
	//	*GoogleApiSource_ProjectSubscriptions_
	WideScopeSubscription isGoogleApiSource_WideScopeSubscription `protobuf_oneof:"wide_scope_subscription"`
}

func (x *GoogleApiSource) Reset() {
	*x = GoogleApiSource{}
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleApiSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleApiSource) ProtoMessage() {}

func (x *GoogleApiSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleApiSource.ProtoReflect.Descriptor instead.
func (*GoogleApiSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_google_api_source_proto_rawDescGZIP(), []int{0}
}

func (x *GoogleApiSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GoogleApiSource) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *GoogleApiSource) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *GoogleApiSource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GoogleApiSource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GoogleApiSource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GoogleApiSource) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *GoogleApiSource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *GoogleApiSource) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *GoogleApiSource) GetCryptoKeyName() string {
	if x != nil {
		return x.CryptoKeyName
	}
	return ""
}

func (x *GoogleApiSource) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (m *GoogleApiSource) GetWideScopeSubscription() isGoogleApiSource_WideScopeSubscription {
	if m != nil {
		return m.WideScopeSubscription
	}
	return nil
}

func (x *GoogleApiSource) GetOrganizationSubscription() *GoogleApiSource_OrganizationSubscription {
	if x, ok := x.GetWideScopeSubscription().(*GoogleApiSource_OrganizationSubscription_); ok {
		return x.OrganizationSubscription
	}
	return nil
}

func (x *GoogleApiSource) GetProjectSubscriptions() *GoogleApiSource_ProjectSubscriptions {
	if x, ok := x.GetWideScopeSubscription().(*GoogleApiSource_ProjectSubscriptions_); ok {
		return x.ProjectSubscriptions
	}
	return nil
}

type isGoogleApiSource_WideScopeSubscription interface {
	isGoogleApiSource_WideScopeSubscription()
}

type GoogleApiSource_OrganizationSubscription_ struct {
	// Optional. Config to enable subscribing to events from all projects in the
	// GoogleApiSource's org.
	OrganizationSubscription *GoogleApiSource_OrganizationSubscription `protobuf:"bytes,12,opt,name=organization_subscription,json=organizationSubscription,proto3,oneof"`
}

type GoogleApiSource_ProjectSubscriptions_ struct {
	// Optional. Config to enable subscribing to all events from a list of
	// projects.
	//
	// All the projects must be in the same org as the GoogleApiSource.
	ProjectSubscriptions *GoogleApiSource_ProjectSubscriptions `protobuf:"bytes,13,opt,name=project_subscriptions,json=projectSubscriptions,proto3,oneof"`
}

func (*GoogleApiSource_OrganizationSubscription_) isGoogleApiSource_WideScopeSubscription() {}

func (*GoogleApiSource_ProjectSubscriptions_) isGoogleApiSource_WideScopeSubscription() {}

// Config to enable subscribing to all events from a list of projects.
type GoogleApiSource_ProjectSubscriptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of projects to receive events from.
	//
	// All the projects must be in the same org. The listed projects should have
	// the format project/{identifier} where identifier can be either the
	// project id for project number. A single list may contain both formats. At
	// most 100 projects can be listed.
	List []string `protobuf:"bytes,1,rep,name=list,proto3" json:"list,omitempty"`
}

func (x *GoogleApiSource_ProjectSubscriptions) Reset() {
	*x = GoogleApiSource_ProjectSubscriptions{}
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleApiSource_ProjectSubscriptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleApiSource_ProjectSubscriptions) ProtoMessage() {}

func (x *GoogleApiSource_ProjectSubscriptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleApiSource_ProjectSubscriptions.ProtoReflect.Descriptor instead.
func (*GoogleApiSource_ProjectSubscriptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_google_api_source_proto_rawDescGZIP(), []int{0, 0}
}

func (x *GoogleApiSource_ProjectSubscriptions) GetList() []string {
	if x != nil {
		return x.List
	}
	return nil
}

// Config to enabled subscribing to events from other projects in the org.
type GoogleApiSource_OrganizationSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Enable org level subscription.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GoogleApiSource_OrganizationSubscription) Reset() {
	*x = GoogleApiSource_OrganizationSubscription{}
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleApiSource_OrganizationSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleApiSource_OrganizationSubscription) ProtoMessage() {}

func (x *GoogleApiSource_OrganizationSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleApiSource_OrganizationSubscription.ProtoReflect.Descriptor instead.
func (*GoogleApiSource_OrganizationSubscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_google_api_source_proto_rawDescGZIP(), []int{0, 1}
}

func (x *GoogleApiSource_OrganizationSubscription) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_google_cloud_eventarc_v1_google_api_source_proto protoreflect.FileDescriptor

var file_google_cloud_eventarc_v1_google_api_source_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x76, 0x31, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x0a, 0x0a, 0x0f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x61, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x75, 0x73, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0f, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52,
	0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x53,
	0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x86, 0x01, 0x0a, 0x19, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x18, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x15,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x2f, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x1a, 0x39, 0x0a, 0x18, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x9e, 0x01, 0xea, 0x41, 0x9a, 0x01, 0x0a, 0x27, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2a, 0x10, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x32,
	0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x19, 0x0a, 0x17, 0x77, 0x69, 0x64, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xc4, 0x01, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x70, 0x69, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61,
	0x72, 0x63, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x63, 0x70, 0x62, 0x3b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x70, 0x62, 0xaa, 0x02,
	0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x63, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_eventarc_v1_google_api_source_proto_rawDescOnce sync.Once
	file_google_cloud_eventarc_v1_google_api_source_proto_rawDescData = file_google_cloud_eventarc_v1_google_api_source_proto_rawDesc
)

func file_google_cloud_eventarc_v1_google_api_source_proto_rawDescGZIP() []byte {
	file_google_cloud_eventarc_v1_google_api_source_proto_rawDescOnce.Do(func() {
		file_google_cloud_eventarc_v1_google_api_source_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_eventarc_v1_google_api_source_proto_rawDescData)
	})
	return file_google_cloud_eventarc_v1_google_api_source_proto_rawDescData
}

var file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_eventarc_v1_google_api_source_proto_goTypes = []any{
	(*GoogleApiSource)(nil),                          // 0: google.cloud.eventarc.v1.GoogleApiSource
	(*GoogleApiSource_ProjectSubscriptions)(nil),     // 1: google.cloud.eventarc.v1.GoogleApiSource.ProjectSubscriptions
	(*GoogleApiSource_OrganizationSubscription)(nil), // 2: google.cloud.eventarc.v1.GoogleApiSource.OrganizationSubscription
	nil,                           // 3: google.cloud.eventarc.v1.GoogleApiSource.LabelsEntry
	nil,                           // 4: google.cloud.eventarc.v1.GoogleApiSource.AnnotationsEntry
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
	(*LoggingConfig)(nil),         // 6: google.cloud.eventarc.v1.LoggingConfig
}
var file_google_cloud_eventarc_v1_google_api_source_proto_depIdxs = []int32{
	5, // 0: google.cloud.eventarc.v1.GoogleApiSource.create_time:type_name -> google.protobuf.Timestamp
	5, // 1: google.cloud.eventarc.v1.GoogleApiSource.update_time:type_name -> google.protobuf.Timestamp
	3, // 2: google.cloud.eventarc.v1.GoogleApiSource.labels:type_name -> google.cloud.eventarc.v1.GoogleApiSource.LabelsEntry
	4, // 3: google.cloud.eventarc.v1.GoogleApiSource.annotations:type_name -> google.cloud.eventarc.v1.GoogleApiSource.AnnotationsEntry
	6, // 4: google.cloud.eventarc.v1.GoogleApiSource.logging_config:type_name -> google.cloud.eventarc.v1.LoggingConfig
	2, // 5: google.cloud.eventarc.v1.GoogleApiSource.organization_subscription:type_name -> google.cloud.eventarc.v1.GoogleApiSource.OrganizationSubscription
	1, // 6: google.cloud.eventarc.v1.GoogleApiSource.project_subscriptions:type_name -> google.cloud.eventarc.v1.GoogleApiSource.ProjectSubscriptions
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_eventarc_v1_google_api_source_proto_init() }
func file_google_cloud_eventarc_v1_google_api_source_proto_init() {
	if File_google_cloud_eventarc_v1_google_api_source_proto != nil {
		return
	}
	file_google_cloud_eventarc_v1_logging_config_proto_init()
	file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes[0].OneofWrappers = []any{
		(*GoogleApiSource_OrganizationSubscription_)(nil),
		(*GoogleApiSource_ProjectSubscriptions_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_eventarc_v1_google_api_source_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_eventarc_v1_google_api_source_proto_goTypes,
		DependencyIndexes: file_google_cloud_eventarc_v1_google_api_source_proto_depIdxs,
		MessageInfos:      file_google_cloud_eventarc_v1_google_api_source_proto_msgTypes,
	}.Build()
	File_google_cloud_eventarc_v1_google_api_source_proto = out.File
	file_google_cloud_eventarc_v1_google_api_source_proto_rawDesc = nil
	file_google_cloud_eventarc_v1_google_api_source_proto_goTypes = nil
	file_google_cloud_eventarc_v1_google_api_source_proto_depIdxs = nil
}
