// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/playlist_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	PlaylistService_Get_FullMethodName          = "/yandex.cloud.video.v1.PlaylistService/Get"
	PlaylistService_List_FullMethodName         = "/yandex.cloud.video.v1.PlaylistService/List"
	PlaylistService_Create_FullMethodName       = "/yandex.cloud.video.v1.PlaylistService/Create"
	PlaylistService_Update_FullMethodName       = "/yandex.cloud.video.v1.PlaylistService/Update"
	PlaylistService_Delete_FullMethodName       = "/yandex.cloud.video.v1.PlaylistService/Delete"
	PlaylistService_BatchDelete_FullMethodName  = "/yandex.cloud.video.v1.PlaylistService/BatchDelete"
	PlaylistService_GetPlayerURL_FullMethodName = "/yandex.cloud.video.v1.PlaylistService/GetPlayerURL"
)

// PlaylistServiceClient is the client API for PlaylistService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Playlist management service.
// Provides methods for creating, retrieving, updating, and deleting playlists,
// which are collections of videos or episodes that can be played sequentially.
type PlaylistServiceClient interface {
	// Retrieves detailed information about a specific playlist by its ID.
	// Returns all playlist metadata, items, and related information.
	Get(ctx context.Context, in *GetPlaylistRequest, opts ...grpc.CallOption) (*Playlist, error)
	// Lists all playlists in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListPlaylistsRequest, opts ...grpc.CallOption) (*ListPlaylistsResponse, error)
	// Creates a new playlist in the specified channel with the provided items.
	// Playlists can contain videos, episodes, or a mix of both content types.
	Create(ctx context.Context, in *CreatePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates an existing playlist's metadata and items.
	// Only fields specified in the field_mask will be updated.
	Update(ctx context.Context, in *UpdatePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes a specific playlist by its ID.
	// This removes the playlist but does not affect the videos or episodes it contains.
	Delete(ctx context.Context, in *DeletePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes multiple playlists in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several playlists.
	BatchDelete(ctx context.Context, in *BatchDeletePlaylistsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates a player URL for watching the playlist.
	// The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
	GetPlayerURL(ctx context.Context, in *GetPlaylistPlayerURLRequest, opts ...grpc.CallOption) (*GetPlaylistPlayerURLResponse, error)
}

type playlistServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPlaylistServiceClient(cc grpc.ClientConnInterface) PlaylistServiceClient {
	return &playlistServiceClient{cc}
}

func (c *playlistServiceClient) Get(ctx context.Context, in *GetPlaylistRequest, opts ...grpc.CallOption) (*Playlist, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Playlist)
	err := c.cc.Invoke(ctx, PlaylistService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) List(ctx context.Context, in *ListPlaylistsRequest, opts ...grpc.CallOption) (*ListPlaylistsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListPlaylistsResponse)
	err := c.cc.Invoke(ctx, PlaylistService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) Create(ctx context.Context, in *CreatePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, PlaylistService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) Update(ctx context.Context, in *UpdatePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, PlaylistService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) Delete(ctx context.Context, in *DeletePlaylistRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, PlaylistService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) BatchDelete(ctx context.Context, in *BatchDeletePlaylistsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, PlaylistService_BatchDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *playlistServiceClient) GetPlayerURL(ctx context.Context, in *GetPlaylistPlayerURLRequest, opts ...grpc.CallOption) (*GetPlaylistPlayerURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPlaylistPlayerURLResponse)
	err := c.cc.Invoke(ctx, PlaylistService_GetPlayerURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlaylistServiceServer is the server API for PlaylistService service.
// All implementations should embed UnimplementedPlaylistServiceServer
// for forward compatibility.
//
// Playlist management service.
// Provides methods for creating, retrieving, updating, and deleting playlists,
// which are collections of videos or episodes that can be played sequentially.
type PlaylistServiceServer interface {
	// Retrieves detailed information about a specific playlist by its ID.
	// Returns all playlist metadata, items, and related information.
	Get(context.Context, *GetPlaylistRequest) (*Playlist, error)
	// Lists all playlists in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListPlaylistsRequest) (*ListPlaylistsResponse, error)
	// Creates a new playlist in the specified channel with the provided items.
	// Playlists can contain videos, episodes, or a mix of both content types.
	Create(context.Context, *CreatePlaylistRequest) (*operation.Operation, error)
	// Updates an existing playlist's metadata and items.
	// Only fields specified in the field_mask will be updated.
	Update(context.Context, *UpdatePlaylistRequest) (*operation.Operation, error)
	// Deletes a specific playlist by its ID.
	// This removes the playlist but does not affect the videos or episodes it contains.
	Delete(context.Context, *DeletePlaylistRequest) (*operation.Operation, error)
	// Deletes multiple playlists in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several playlists.
	BatchDelete(context.Context, *BatchDeletePlaylistsRequest) (*operation.Operation, error)
	// Generates a player URL for watching the playlist.
	// The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
	GetPlayerURL(context.Context, *GetPlaylistPlayerURLRequest) (*GetPlaylistPlayerURLResponse, error)
}

// UnimplementedPlaylistServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPlaylistServiceServer struct{}

func (UnimplementedPlaylistServiceServer) Get(context.Context, *GetPlaylistRequest) (*Playlist, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedPlaylistServiceServer) List(context.Context, *ListPlaylistsRequest) (*ListPlaylistsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedPlaylistServiceServer) Create(context.Context, *CreatePlaylistRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedPlaylistServiceServer) Update(context.Context, *UpdatePlaylistRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedPlaylistServiceServer) Delete(context.Context, *DeletePlaylistRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedPlaylistServiceServer) BatchDelete(context.Context, *BatchDeletePlaylistsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchDelete not implemented")
}
func (UnimplementedPlaylistServiceServer) GetPlayerURL(context.Context, *GetPlaylistPlayerURLRequest) (*GetPlaylistPlayerURLResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPlayerURL not implemented")
}
func (UnimplementedPlaylistServiceServer) testEmbeddedByValue() {}

// UnsafePlaylistServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PlaylistServiceServer will
// result in compilation errors.
type UnsafePlaylistServiceServer interface {
	mustEmbedUnimplementedPlaylistServiceServer()
}

func RegisterPlaylistServiceServer(s grpc.ServiceRegistrar, srv PlaylistServiceServer) {
	// If the following call panics, it indicates UnimplementedPlaylistServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&PlaylistService_ServiceDesc, srv)
}

func _PlaylistService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaylistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).Get(ctx, req.(*GetPlaylistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlaylistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).List(ctx, req.(*ListPlaylistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePlaylistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).Create(ctx, req.(*CreatePlaylistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePlaylistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).Update(ctx, req.(*UpdatePlaylistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePlaylistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).Delete(ctx, req.(*DeletePlaylistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_BatchDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeletePlaylistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).BatchDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_BatchDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).BatchDelete(ctx, req.(*BatchDeletePlaylistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlaylistService_GetPlayerURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaylistPlayerURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlaylistServiceServer).GetPlayerURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PlaylistService_GetPlayerURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlaylistServiceServer).GetPlayerURL(ctx, req.(*GetPlaylistPlayerURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PlaylistService_ServiceDesc is the grpc.ServiceDesc for PlaylistService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PlaylistService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.PlaylistService",
	HandlerType: (*PlaylistServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _PlaylistService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _PlaylistService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _PlaylistService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _PlaylistService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _PlaylistService_Delete_Handler,
		},
		{
			MethodName: "BatchDelete",
			Handler:    _PlaylistService_BatchDelete_Handler,
		},
		{
			MethodName: "GetPlayerURL",
			Handler:    _PlaylistService_GetPlayerURL_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/playlist_service.proto",
}
