// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/spqr/v1/host.proto

package spqr

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A SPQR Router host.
	Host_ROUTER Host_Type = 2
	// A SPQR Coordinator host.
	Host_COORDINATOR Host_Type = 3
	// A SPQR Infra host (router+coordinator)
	Host_INFRA Host_Type = 4
	// A PostgreSQL host.
	Host_POSTGRESQL Host_Type = 5
	// An External PostgreSQL host.
	Host_EXTERNAL_POSTGRESQL Host_Type = 6
	// A Managed PostgreSQL host
	Host_MDB_POSTGRESQL Host_Type = 7
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		2: "ROUTER",
		3: "COORDINATOR",
		4: "INFRA",
		5: "POSTGRESQL",
		6: "EXTERNAL_POSTGRESQL",
		7: "MDB_POSTGRESQL",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":    0,
		"ROUTER":              2,
		"COORDINATOR":         3,
		"INFRA":               4,
		"POSTGRESQL":          5,
		"EXTERNAL_POSTGRESQL": 6,
		"MDB_POSTGRESQL":      7,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[0].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[0]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary SPQR server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary SPQR server in the cluster.
	Host_SECONDARY Host_Role = 2
	// Host is the master PostgreSQL server in the cluster.
	Host_MASTER Host_Role = 3
	// Host is a replica (standby) PostgreSQL server in the cluster.
	Host_REPLICA Host_Role = 4
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "PRIMARY",
		2: "SECONDARY",
		3: "MASTER",
		4: "REPLICA",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"PRIMARY":      1,
		"SECONDARY":    2,
		"MASTER":       3,
		"REPLICA":      4,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[1].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[1]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[2].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[2]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a SPQR Router.
	Service_ROUTER Service_Type = 2
	// The host is running a SPQR Coordinator.
	Service_COORDINATOR Service_Type = 3
	// The host is running a SPQR router and coordinator
	Service_INFRA Service_Type = 4
	// The host is running a PostgreSQL.
	Service_POSTGRESQL Service_Type = 5
	// The host is running a PostgreSQL.
	Service_EXTERNAL_POSTGRESQL Service_Type = 6
	// The host is running a PostgreSQL
	Service_MDB_POSTGRESQL Service_Type = 7
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		2: "ROUTER",
		3: "COORDINATOR",
		4: "INFRA",
		5: "POSTGRESQL",
		6: "EXTERNAL_POSTGRESQL",
		7: "MDB_POSTGRESQL",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":    0,
		"ROUTER":              2,
		"COORDINATOR":         3,
		"INFRA":               4,
		"POSTGRESQL":          5,
		"EXTERNAL_POSTGRESQL": 6,
		"MDB_POSTGRESQL":      7,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[3].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[3]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{1, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[4].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes[4]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{1, 1}
}

type Host struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the SPQR host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the SPQR cluster that the host belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the SPQR host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the SPQR host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.spqr.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.spqr.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Host type
	Type Host_Type `protobuf:"varint,10,opt,name=type,proto3,enum=yandex.cloud.mdb.spqr.v1.Host_Type" json:"type,omitempty"`
	// link to wall-e (porto only)
	WalleLink string `protobuf:"bytes,11,opt,name=walle_link,json=walleLink,proto3" json:"walle_link,omitempty"`
	// host state reason from cms (porto only)
	StateReason string `protobuf:"bytes,12,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// System metrics
	System *Host_SystemMetrics `protobuf:"bytes,13,opt,name=system,proto3" json:"system,omitempty"`
	// Shard which this host belongs to.
	ShardName     string `protobuf:"bytes,14,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Host) Reset() {
	*x = Host{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *Host) GetWalleLink() string {
	if x != nil {
		return x.WalleLink
	}
	return ""
}

func (x *Host) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *Host) GetSystem() *Host_SystemMetrics {
	if x != nil {
		return x.System
	}
	return nil
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.spqr.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health        Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.spqr.v1.Service_Health" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{1}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type HostSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The network ID is set in the [Cluster.network_id] field.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false - don't assign a public IP to the host.
	// * true - the host should have a public IP address.
	AssignPublicIp bool `protobuf:"varint,3,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Type of the host to be deployed.
	Type Host_Type `protobuf:"varint,4,opt,name=type,proto3,enum=yandex.cloud.mdb.spqr.v1.Host_Type" json:"type,omitempty"`
	// Name of the shard that the host belongs to.
	// If empty, host doesn't belong to any shard
	ShardName     string         `protobuf:"bytes,5,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	MdbPostgresql *MDBPostgreSQL `protobuf:"bytes,6,opt,name=mdb_postgresql,json=mdbPostgresql,proto3" json:"mdb_postgresql,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HostSpec) Reset() {
	*x = HostSpec{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostSpec) ProtoMessage() {}

func (x *HostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostSpec.ProtoReflect.Descriptor instead.
func (*HostSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{2}
}

func (x *HostSpec) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *HostSpec) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *HostSpec) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *HostSpec) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *HostSpec) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

func (x *HostSpec) GetMdbPostgresql() *MDBPostgreSQL {
	if x != nil {
		return x.MdbPostgresql
	}
	return nil
}

type Host_CPUMetric struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Timestamp     int64                  `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Used          float64                `protobuf:"fixed64,2,opt,name=used,proto3" json:"used,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Host_CPUMetric) Reset() {
	*x = Host_CPUMetric{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host_CPUMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_CPUMetric) ProtoMessage() {}

func (x *Host_CPUMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_CPUMetric.ProtoReflect.Descriptor instead.
func (*Host_CPUMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Host_CPUMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_CPUMetric) GetUsed() float64 {
	if x != nil {
		return x.Used
	}
	return 0
}

type Host_MemoryMetric struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Timestamp     int64                  `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Used          int64                  `protobuf:"varint,2,opt,name=used,proto3" json:"used,omitempty"`
	Total         int64                  `protobuf:"varint,3,opt,name=total,proto3" json:"total,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Host_MemoryMetric) Reset() {
	*x = Host_MemoryMetric{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host_MemoryMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_MemoryMetric) ProtoMessage() {}

func (x *Host_MemoryMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_MemoryMetric.ProtoReflect.Descriptor instead.
func (*Host_MemoryMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Host_MemoryMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_MemoryMetric) GetUsed() int64 {
	if x != nil {
		return x.Used
	}
	return 0
}

func (x *Host_MemoryMetric) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

type Host_DiskMetric struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Timestamp     int64                  `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Used          int64                  `protobuf:"varint,2,opt,name=used,proto3" json:"used,omitempty"`
	Total         int64                  `protobuf:"varint,3,opt,name=total,proto3" json:"total,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Host_DiskMetric) Reset() {
	*x = Host_DiskMetric{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host_DiskMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_DiskMetric) ProtoMessage() {}

func (x *Host_DiskMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_DiskMetric.ProtoReflect.Descriptor instead.
func (*Host_DiskMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Host_DiskMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_DiskMetric) GetUsed() int64 {
	if x != nil {
		return x.Used
	}
	return 0
}

func (x *Host_DiskMetric) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

type Host_SystemMetrics struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Cpu           *Host_CPUMetric        `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	Memory        *Host_MemoryMetric     `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	Disk          *Host_DiskMetric       `protobuf:"bytes,3,opt,name=disk,proto3" json:"disk,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Host_SystemMetrics) Reset() {
	*x = Host_SystemMetrics{}
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host_SystemMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_SystemMetrics) ProtoMessage() {}

func (x *Host_SystemMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_SystemMetrics.ProtoReflect.Descriptor instead.
func (*Host_SystemMetrics) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Host_SystemMetrics) GetCpu() *Host_CPUMetric {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *Host_SystemMetrics) GetMemory() *Host_MemoryMetric {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *Host_SystemMetrics) GetDisk() *Host_DiskMetric {
	if x != nil {
		return x.Disk
	}
	return nil
}

var File_yandex_cloud_mdb_spqr_v1_host_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_spqr_v1_host_proto_rawDesc = "" +
	"\n" +
	"#yandex/cloud/mdb/spqr/v1/host.proto\x12\x18yandex.cloud.mdb.spqr.v1\x1a%yandex/cloud/mdb/spqr/v1/config.proto\x1a\x1dyandex/cloud/validation.proto\"\xcc\n" +
	"\n" +
	"\x04Host\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12\x17\n" +
	"\azone_id\x18\x03 \x01(\tR\x06zoneId\x12A\n" +
	"\tresources\x18\x04 \x01(\v2#.yandex.cloud.mdb.spqr.v1.ResourcesR\tresources\x127\n" +
	"\x04role\x18\x05 \x01(\x0e2#.yandex.cloud.mdb.spqr.v1.Host.RoleR\x04role\x12=\n" +
	"\x06health\x18\x06 \x01(\x0e2%.yandex.cloud.mdb.spqr.v1.Host.HealthR\x06health\x12=\n" +
	"\bservices\x18\a \x03(\v2!.yandex.cloud.mdb.spqr.v1.ServiceR\bservices\x12\x1b\n" +
	"\tsubnet_id\x18\b \x01(\tR\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\t \x01(\bR\x0eassignPublicIp\x127\n" +
	"\x04type\x18\n" +
	" \x01(\x0e2#.yandex.cloud.mdb.spqr.v1.Host.TypeR\x04type\x12\x1d\n" +
	"\n" +
	"walle_link\x18\v \x01(\tR\twalleLink\x12!\n" +
	"\fstate_reason\x18\f \x01(\tR\vstateReason\x12D\n" +
	"\x06system\x18\r \x01(\v2,.yandex.cloud.mdb.spqr.v1.Host.SystemMetricsR\x06system\x12\x1d\n" +
	"\n" +
	"shard_name\x18\x0e \x01(\tR\tshardName\x1a=\n" +
	"\tCPUMetric\x12\x1c\n" +
	"\ttimestamp\x18\x01 \x01(\x03R\ttimestamp\x12\x12\n" +
	"\x04used\x18\x02 \x01(\x01R\x04used\x1aV\n" +
	"\fMemoryMetric\x12\x1c\n" +
	"\ttimestamp\x18\x01 \x01(\x03R\ttimestamp\x12\x12\n" +
	"\x04used\x18\x02 \x01(\x03R\x04used\x12\x14\n" +
	"\x05total\x18\x03 \x01(\x03R\x05total\x1aT\n" +
	"\n" +
	"DiskMetric\x12\x1c\n" +
	"\ttimestamp\x18\x01 \x01(\x03R\ttimestamp\x12\x12\n" +
	"\x04used\x18\x02 \x01(\x03R\x04used\x12\x14\n" +
	"\x05total\x18\x03 \x01(\x03R\x05total\x1a\xcf\x01\n" +
	"\rSystemMetrics\x12:\n" +
	"\x03cpu\x18\x01 \x01(\v2(.yandex.cloud.mdb.spqr.v1.Host.CPUMetricR\x03cpu\x12C\n" +
	"\x06memory\x18\x02 \x01(\v2+.yandex.cloud.mdb.spqr.v1.Host.MemoryMetricR\x06memory\x12=\n" +
	"\x04disk\x18\x03 \x01(\v2).yandex.cloud.mdb.spqr.v1.Host.DiskMetricR\x04disk\"\x87\x01\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06ROUTER\x10\x02\x12\x0f\n" +
	"\vCOORDINATOR\x10\x03\x12\t\n" +
	"\x05INFRA\x10\x04\x12\x0e\n" +
	"\n" +
	"POSTGRESQL\x10\x05\x12\x17\n" +
	"\x13EXTERNAL_POSTGRESQL\x10\x06\x12\x12\n" +
	"\x0eMDB_POSTGRESQL\x10\a\"\x04\b\x01\x10\x01\"M\n" +
	"\x04Role\x12\x10\n" +
	"\fROLE_UNKNOWN\x10\x00\x12\v\n" +
	"\aPRIMARY\x10\x01\x12\r\n" +
	"\tSECONDARY\x10\x02\x12\n" +
	"\n" +
	"\x06MASTER\x10\x03\x12\v\n" +
	"\aREPLICA\x10\x04\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"\xc4\x02\n" +
	"\aService\x12:\n" +
	"\x04type\x18\x01 \x01(\x0e2&.yandex.cloud.mdb.spqr.v1.Service.TypeR\x04type\x12@\n" +
	"\x06health\x18\x02 \x01(\x0e2(.yandex.cloud.mdb.spqr.v1.Service.HealthR\x06health\"\x87\x01\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06ROUTER\x10\x02\x12\x0f\n" +
	"\vCOORDINATOR\x10\x03\x12\t\n" +
	"\x05INFRA\x10\x04\x12\x0e\n" +
	"\n" +
	"POSTGRESQL\x10\x05\x12\x17\n" +
	"\x13EXTERNAL_POSTGRESQL\x10\x06\x12\x12\n" +
	"\x0eMDB_POSTGRESQL\x10\a\"\x04\b\x01\x10\x01\"1\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\"\xc8\x02\n" +
	"\bHostSpec\x12!\n" +
	"\azone_id\x18\x01 \x01(\tB\b\x8a\xc81\x04<=50R\x06zoneId\x12%\n" +
	"\tsubnet_id\x18\x02 \x01(\tB\b\x8a\xc81\x04<=50R\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\x03 \x01(\bR\x0eassignPublicIp\x12=\n" +
	"\x04type\x18\x04 \x01(\x0e2#.yandex.cloud.mdb.spqr.v1.Host.TypeB\x04\xe8\xc71\x01R\x04type\x129\n" +
	"\n" +
	"shard_name\x18\x05 \x01(\tB\x1a\xf2\xc71\x0e[a-zA-Z0-9_-]*\x8a\xc81\x04<=63R\tshardName\x12N\n" +
	"\x0emdb_postgresql\x18\x06 \x01(\v2'.yandex.cloud.mdb.spqr.v1.MDBPostgreSQLR\rmdbPostgresqlBa\n" +
	"\x1cyandex.cloud.api.mdb.spqr.v1ZAgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/spqr/v1;spqrb\x06proto3"

var (
	file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_spqr_v1_host_proto_rawDesc), len(file_yandex_cloud_mdb_spqr_v1_host_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_spqr_v1_host_proto_rawDescData
}

var file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_yandex_cloud_mdb_spqr_v1_host_proto_goTypes = []any{
	(Host_Type)(0),             // 0: yandex.cloud.mdb.spqr.v1.Host.Type
	(Host_Role)(0),             // 1: yandex.cloud.mdb.spqr.v1.Host.Role
	(Host_Health)(0),           // 2: yandex.cloud.mdb.spqr.v1.Host.Health
	(Service_Type)(0),          // 3: yandex.cloud.mdb.spqr.v1.Service.Type
	(Service_Health)(0),        // 4: yandex.cloud.mdb.spqr.v1.Service.Health
	(*Host)(nil),               // 5: yandex.cloud.mdb.spqr.v1.Host
	(*Service)(nil),            // 6: yandex.cloud.mdb.spqr.v1.Service
	(*HostSpec)(nil),           // 7: yandex.cloud.mdb.spqr.v1.HostSpec
	(*Host_CPUMetric)(nil),     // 8: yandex.cloud.mdb.spqr.v1.Host.CPUMetric
	(*Host_MemoryMetric)(nil),  // 9: yandex.cloud.mdb.spqr.v1.Host.MemoryMetric
	(*Host_DiskMetric)(nil),    // 10: yandex.cloud.mdb.spqr.v1.Host.DiskMetric
	(*Host_SystemMetrics)(nil), // 11: yandex.cloud.mdb.spqr.v1.Host.SystemMetrics
	(*Resources)(nil),          // 12: yandex.cloud.mdb.spqr.v1.Resources
	(*MDBPostgreSQL)(nil),      // 13: yandex.cloud.mdb.spqr.v1.MDBPostgreSQL
}
var file_yandex_cloud_mdb_spqr_v1_host_proto_depIdxs = []int32{
	12, // 0: yandex.cloud.mdb.spqr.v1.Host.resources:type_name -> yandex.cloud.mdb.spqr.v1.Resources
	1,  // 1: yandex.cloud.mdb.spqr.v1.Host.role:type_name -> yandex.cloud.mdb.spqr.v1.Host.Role
	2,  // 2: yandex.cloud.mdb.spqr.v1.Host.health:type_name -> yandex.cloud.mdb.spqr.v1.Host.Health
	6,  // 3: yandex.cloud.mdb.spqr.v1.Host.services:type_name -> yandex.cloud.mdb.spqr.v1.Service
	0,  // 4: yandex.cloud.mdb.spqr.v1.Host.type:type_name -> yandex.cloud.mdb.spqr.v1.Host.Type
	11, // 5: yandex.cloud.mdb.spqr.v1.Host.system:type_name -> yandex.cloud.mdb.spqr.v1.Host.SystemMetrics
	3,  // 6: yandex.cloud.mdb.spqr.v1.Service.type:type_name -> yandex.cloud.mdb.spqr.v1.Service.Type
	4,  // 7: yandex.cloud.mdb.spqr.v1.Service.health:type_name -> yandex.cloud.mdb.spqr.v1.Service.Health
	0,  // 8: yandex.cloud.mdb.spqr.v1.HostSpec.type:type_name -> yandex.cloud.mdb.spqr.v1.Host.Type
	13, // 9: yandex.cloud.mdb.spqr.v1.HostSpec.mdb_postgresql:type_name -> yandex.cloud.mdb.spqr.v1.MDBPostgreSQL
	8,  // 10: yandex.cloud.mdb.spqr.v1.Host.SystemMetrics.cpu:type_name -> yandex.cloud.mdb.spqr.v1.Host.CPUMetric
	9,  // 11: yandex.cloud.mdb.spqr.v1.Host.SystemMetrics.memory:type_name -> yandex.cloud.mdb.spqr.v1.Host.MemoryMetric
	10, // 12: yandex.cloud.mdb.spqr.v1.Host.SystemMetrics.disk:type_name -> yandex.cloud.mdb.spqr.v1.Host.DiskMetric
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_spqr_v1_host_proto_init() }
func file_yandex_cloud_mdb_spqr_v1_host_proto_init() {
	if File_yandex_cloud_mdb_spqr_v1_host_proto != nil {
		return
	}
	file_yandex_cloud_mdb_spqr_v1_config_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_spqr_v1_host_proto_rawDesc), len(file_yandex_cloud_mdb_spqr_v1_host_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_spqr_v1_host_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_spqr_v1_host_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_spqr_v1_host_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_spqr_v1_host_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_spqr_v1_host_proto = out.File
	file_yandex_cloud_mdb_spqr_v1_host_proto_goTypes = nil
	file_yandex_cloud_mdb_spqr_v1_host_proto_depIdxs = nil
}
