// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/kafka/v1/cluster.proto

package kafka

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/descriptorpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	// Unspecified environment.
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Role int32

const (
	// Role of the host is unspecified. Default value.
	Host_ROLE_UNSPECIFIED Host_Role = 0
	// The host is a Kafka broker.
	Host_KAFKA Host_Role = 1
	// The host is a ZooKeeper server.
	Host_ZOOKEEPER Host_Role = 2
	// The host is a Kafka KRaft controller broker.
	Host_KRAFT Host_Role = 3
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "KAFKA",
		2: "ZOOKEEPER",
		3: "KRAFT",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"KAFKA":            1,
		"ZOOKEEPER":        2,
		"KRAFT":            3,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[3]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{7, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"UNKNOWN":  0,
		"ALIVE":    1,
		"DEAD":     2,
		"DEGRADED": 3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes[4]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{7, 1}
}

// An Apache Kafka® cluster resource.
// For more information, see the [Concepts](/docs/managed-kafka/concepts) section of the documentation.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Apache Kafka® cluster.
	// This ID is assigned at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Apache Kafka® cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Apache Kafka® cluster.
	// The name must be unique within the folder. 1-63 characters long. Value must match the regular expression `[a-zA-Z0-9_-]*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Apache Kafka® cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the Apache Kafka® cluster as `key:value` pairs.
	// A maximum of 64 labels per resource is allowed.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Deployment environment of the Apache Kafka® cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the Apache Kafka® cluster.
	// * The field is ignored for response of List method.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Apache Kafka® cluster.
	// * The field is ignored for response of List method.
	Config *ConfigSpec `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.kafka.v1.Cluster_Status" json:"status,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,13,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Host groups hosting VMs of the cluster.
	HostGroupIds []string `protobuf:"bytes,14,rep,name=host_group_ids,json=hostGroupIds,proto3" json:"host_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,15,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Scheduled maintenance operation.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,17,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// KafkaUI state.
	KafkaUi *Cluster_KafkaUI `protobuf:"bytes,18,opt,name=kafka_ui,json=kafkaUi,proto3" json:"kafka_ui,omitempty"`
	// ID of the key to encrypt cluster disks.
	DiskEncryptionKeyId *wrapperspb.StringValue `protobuf:"bytes,19,opt,name=disk_encryption_key_id,json=diskEncryptionKeyId,proto3" json:"disk_encryption_key_id,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ConfigSpec {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetHostGroupIds() []string {
	if x != nil {
		return x.HostGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetKafkaUi() *Cluster_KafkaUI {
	if x != nil {
		return x.KafkaUi
	}
	return nil
}

func (x *Cluster) GetDiskEncryptionKeyId() *wrapperspb.StringValue {
	if x != nil {
		return x.DiskEncryptionKeyId
	}
	return nil
}

// Metadata of monitoring system.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the Apache Kafka® cluster.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ConfigSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of Apache Kafka® used in the cluster. Possible values: `2.8`, `3.0`, `3.1`, `3.2`, `3.3`, `3.4`, `3.5`, `3.6`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resource allocation for Kafka brokers.
	Kafka *ConfigSpec_Kafka `protobuf:"bytes,2,opt,name=kafka,proto3" json:"kafka,omitempty"`
	// Configuration and resource allocation for ZooKeeper hosts.
	Zookeeper *ConfigSpec_Zookeeper `protobuf:"bytes,3,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// IDs of availability zones where Kafka brokers reside.
	ZoneId []string `protobuf:"bytes,4,rep,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// The number of Kafka brokers deployed in each availability zone.
	BrokersCount *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=brokers_count,json=brokersCount,proto3" json:"brokers_count,omitempty"`
	// The flag that defines whether a public IP address is assigned to the cluster.
	// If the value is `true`, then Apache Kafka® cluster is available on the Internet via it's public IP address.
	AssignPublicIp bool `protobuf:"varint,6,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Allows to manage topics via AdminAPI
	// Deprecated. Feature enabled permanently.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
	UnmanagedTopics bool `protobuf:"varint,7,opt,name=unmanaged_topics,json=unmanagedTopics,proto3" json:"unmanaged_topics,omitempty"`
	// Enables managed schema registry on cluster
	SchemaRegistry bool `protobuf:"varint,8,opt,name=schema_registry,json=schemaRegistry,proto3" json:"schema_registry,omitempty"`
	// Access policy for external services.
	Access *Access `protobuf:"bytes,9,opt,name=access,proto3" json:"access,omitempty"`
	// Configuration of REST API.
	RestApiConfig *ConfigSpec_RestAPIConfig `protobuf:"bytes,10,opt,name=rest_api_config,json=restApiConfig,proto3" json:"rest_api_config,omitempty"`
	// DiskSizeAutoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,11,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	// Configuration and resource allocation for KRaft-controller hosts.
	Kraft *ConfigSpec_KRaft `protobuf:"bytes,12,opt,name=kraft,proto3" json:"kraft,omitempty"`
	// Configuration of Kafka UI.
	KafkaUiConfig *ConfigSpec_KafkaUIConfig `protobuf:"bytes,13,opt,name=kafka_ui_config,json=kafkaUiConfig,proto3" json:"kafka_ui_config,omitempty"`
	// Patch or release version ex. 3.9.1, 4.0.1 etc
	PatchVersion  string `protobuf:"bytes,14,opt,name=patch_version,json=patchVersion,proto3" json:"patch_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec) Reset() {
	*x = ConfigSpec{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec) ProtoMessage() {}

func (x *ConfigSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec.ProtoReflect.Descriptor instead.
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ConfigSpec) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ConfigSpec) GetKafka() *ConfigSpec_Kafka {
	if x != nil {
		return x.Kafka
	}
	return nil
}

func (x *ConfigSpec) GetZookeeper() *ConfigSpec_Zookeeper {
	if x != nil {
		return x.Zookeeper
	}
	return nil
}

func (x *ConfigSpec) GetZoneId() []string {
	if x != nil {
		return x.ZoneId
	}
	return nil
}

func (x *ConfigSpec) GetBrokersCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.BrokersCount
	}
	return nil
}

func (x *ConfigSpec) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
func (x *ConfigSpec) GetUnmanagedTopics() bool {
	if x != nil {
		return x.UnmanagedTopics
	}
	return false
}

func (x *ConfigSpec) GetSchemaRegistry() bool {
	if x != nil {
		return x.SchemaRegistry
	}
	return false
}

func (x *ConfigSpec) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ConfigSpec) GetRestApiConfig() *ConfigSpec_RestAPIConfig {
	if x != nil {
		return x.RestApiConfig
	}
	return nil
}

func (x *ConfigSpec) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

func (x *ConfigSpec) GetKraft() *ConfigSpec_KRaft {
	if x != nil {
		return x.Kraft
	}
	return nil
}

func (x *ConfigSpec) GetKafkaUiConfig() *ConfigSpec_KafkaUIConfig {
	if x != nil {
		return x.KafkaUiConfig
	}
	return nil
}

func (x *ConfigSpec) GetPatchVersion() string {
	if x != nil {
		return x.PatchVersion
	}
	return ""
}

type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources available to a host (CPU, memory, etc.).
	// All available presets are listed in the [documentation](/docs/managed-kafka/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes. Must be greater than 2 * partition segment size in bytes * partitions count, so each partition can have one active segment file and one closed segment file that can be deleted.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	DiskTypeId    string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

// Kafka version 2.8 broker configuration.
type KafkaConfig2_8 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Cluster topics compression type.
	CompressionType CompressionType `protobuf:"varint,1,opt,name=compression_type,json=compressionType,proto3,enum=yandex.cloud.mdb.kafka.v1.CompressionType" json:"compression_type,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_messages] setting.
	LogFlushIntervalMessages *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=log_flush_interval_messages,json=logFlushIntervalMessages,proto3" json:"log_flush_interval_messages,omitempty"`
	// The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
	// If not set, the value of [log_flush_scheduler_interval_ms] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_ms] setting.
	LogFlushIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=log_flush_interval_ms,json=logFlushIntervalMs,proto3" json:"log_flush_interval_ms,omitempty"`
	// The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
	// This check is done by the log flusher.
	LogFlushSchedulerIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=log_flush_scheduler_interval_ms,json=logFlushSchedulerIntervalMs,proto3" json:"log_flush_scheduler_interval_ms,omitempty"`
	// Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig2_8.cleanup_policy] is in effect.
	// This setting is helpful if you need to control the size of a log due to limited disk space.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_bytes] setting.
	LogRetentionBytes *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=log_retention_bytes,json=logRetentionBytes,proto3" json:"log_retention_bytes,omitempty"`
	// The number of hours to keep a log segment file before deleting it.
	LogRetentionHours *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=log_retention_hours,json=logRetentionHours,proto3" json:"log_retention_hours,omitempty"`
	// The number of minutes to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_hours] is used.
	LogRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=log_retention_minutes,json=logRetentionMinutes,proto3" json:"log_retention_minutes,omitempty"`
	// The number of milliseconds to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_minutes] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_ms] setting.
	LogRetentionMs *wrapperspb.Int64Value `protobuf:"bytes,8,opt,name=log_retention_ms,json=logRetentionMs,proto3" json:"log_retention_ms,omitempty"`
	// The maximum size of a single log file.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.segment_bytes] setting.
	LogSegmentBytes *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=log_segment_bytes,json=logSegmentBytes,proto3" json:"log_segment_bytes,omitempty"`
	// Should pre allocate file when create new segment?
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.preallocate] setting.
	// Deprecated. Feature useless for Yandex Cloud.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
	LogPreallocate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=log_preallocate,json=logPreallocate,proto3" json:"log_preallocate,omitempty"`
	// The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketSendBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,11,opt,name=socket_send_buffer_bytes,json=socketSendBufferBytes,proto3" json:"socket_send_buffer_bytes,omitempty"`
	// The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketReceiveBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=socket_receive_buffer_bytes,json=socketReceiveBufferBytes,proto3" json:"socket_receive_buffer_bytes,omitempty"`
	// Enable auto creation of topic on the server
	AutoCreateTopicsEnable *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=auto_create_topics_enable,json=autoCreateTopicsEnable,proto3" json:"auto_create_topics_enable,omitempty"`
	// Default number of partitions per topic on the whole cluster
	NumPartitions *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Default replication factor of the topic on the whole cluster
	DefaultReplicationFactor *wrapperspb.Int64Value `protobuf:"bytes,15,opt,name=default_replication_factor,json=defaultReplicationFactor,proto3" json:"default_replication_factor,omitempty"`
	// The largest record batch size allowed by Kafka. Default value: 1048588.
	MessageMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=message_max_bytes,json=messageMaxBytes,proto3" json:"message_max_bytes,omitempty"`
	// The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576.
	ReplicaFetchMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=replica_fetch_max_bytes,json=replicaFetchMaxBytes,proto3" json:"replica_fetch_max_bytes,omitempty"`
	// A list of cipher suites.
	SslCipherSuites []string `protobuf:"bytes,18,rep,name=ssl_cipher_suites,json=sslCipherSuites,proto3" json:"ssl_cipher_suites,omitempty"`
	// Offset storage time after a consumer group loses all its consumers. Default: 10080.
	OffsetsRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=offsets_retention_minutes,json=offsetsRetentionMinutes,proto3" json:"offsets_retention_minutes,omitempty"`
	// The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512].
	SaslEnabledMechanisms []SaslMechanism `protobuf:"varint,20,rep,packed,name=sasl_enabled_mechanisms,json=saslEnabledMechanisms,proto3,enum=yandex.cloud.mdb.kafka.v1.SaslMechanism" json:"sasl_enabled_mechanisms,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *KafkaConfig2_8) Reset() {
	*x = KafkaConfig2_8{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KafkaConfig2_8) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaConfig2_8) ProtoMessage() {}

func (x *KafkaConfig2_8) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaConfig2_8.ProtoReflect.Descriptor instead.
func (*KafkaConfig2_8) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *KafkaConfig2_8) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *KafkaConfig2_8) GetLogFlushIntervalMessages() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMessages
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogFlushIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogFlushSchedulerIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushSchedulerIntervalMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionHours() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionHours
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogRetentionMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMs
	}
	return nil
}

func (x *KafkaConfig2_8) GetLogSegmentBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogSegmentBytes
	}
	return nil
}

// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
func (x *KafkaConfig2_8) GetLogPreallocate() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogPreallocate
	}
	return nil
}

func (x *KafkaConfig2_8) GetSocketSendBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketSendBufferBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSocketReceiveBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketReceiveBufferBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetAutoCreateTopicsEnable() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoCreateTopicsEnable
	}
	return nil
}

func (x *KafkaConfig2_8) GetNumPartitions() *wrapperspb.Int64Value {
	if x != nil {
		return x.NumPartitions
	}
	return nil
}

func (x *KafkaConfig2_8) GetDefaultReplicationFactor() *wrapperspb.Int64Value {
	if x != nil {
		return x.DefaultReplicationFactor
	}
	return nil
}

func (x *KafkaConfig2_8) GetMessageMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.MessageMaxBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetReplicaFetchMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaFetchMaxBytes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSslCipherSuites() []string {
	if x != nil {
		return x.SslCipherSuites
	}
	return nil
}

func (x *KafkaConfig2_8) GetOffsetsRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.OffsetsRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig2_8) GetSaslEnabledMechanisms() []SaslMechanism {
	if x != nil {
		return x.SaslEnabledMechanisms
	}
	return nil
}

// Kafka version 3.x broker configuration.
type KafkaConfig3 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Cluster topics compression type.
	CompressionType CompressionType `protobuf:"varint,1,opt,name=compression_type,json=compressionType,proto3,enum=yandex.cloud.mdb.kafka.v1.CompressionType" json:"compression_type,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_messages] setting.
	LogFlushIntervalMessages *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=log_flush_interval_messages,json=logFlushIntervalMessages,proto3" json:"log_flush_interval_messages,omitempty"`
	// The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
	// If not set, the value of [log_flush_scheduler_interval_ms] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_ms] setting.
	LogFlushIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=log_flush_interval_ms,json=logFlushIntervalMs,proto3" json:"log_flush_interval_ms,omitempty"`
	// The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
	// This check is done by the log flusher.
	LogFlushSchedulerIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=log_flush_scheduler_interval_ms,json=logFlushSchedulerIntervalMs,proto3" json:"log_flush_scheduler_interval_ms,omitempty"`
	// Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig3.cleanup_policy] is in effect.
	// This setting is helpful if you need to control the size of a log due to limited disk space.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_bytes] setting.
	LogRetentionBytes *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=log_retention_bytes,json=logRetentionBytes,proto3" json:"log_retention_bytes,omitempty"`
	// The number of hours to keep a log segment file before deleting it.
	LogRetentionHours *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=log_retention_hours,json=logRetentionHours,proto3" json:"log_retention_hours,omitempty"`
	// The number of minutes to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_hours] is used.
	LogRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=log_retention_minutes,json=logRetentionMinutes,proto3" json:"log_retention_minutes,omitempty"`
	// The number of milliseconds to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_minutes] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_ms] setting.
	LogRetentionMs *wrapperspb.Int64Value `protobuf:"bytes,8,opt,name=log_retention_ms,json=logRetentionMs,proto3" json:"log_retention_ms,omitempty"`
	// The maximum size of a single log file.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.segment_bytes] setting.
	LogSegmentBytes *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=log_segment_bytes,json=logSegmentBytes,proto3" json:"log_segment_bytes,omitempty"`
	// Should pre allocate file when create new segment?
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.preallocate] setting.
	// Deprecated. Feature useless for Yandex Cloud.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
	LogPreallocate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=log_preallocate,json=logPreallocate,proto3" json:"log_preallocate,omitempty"`
	// The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketSendBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,11,opt,name=socket_send_buffer_bytes,json=socketSendBufferBytes,proto3" json:"socket_send_buffer_bytes,omitempty"`
	// The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketReceiveBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=socket_receive_buffer_bytes,json=socketReceiveBufferBytes,proto3" json:"socket_receive_buffer_bytes,omitempty"`
	// Enable auto creation of topic on the server
	AutoCreateTopicsEnable *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=auto_create_topics_enable,json=autoCreateTopicsEnable,proto3" json:"auto_create_topics_enable,omitempty"`
	// Default number of partitions per topic on the whole cluster
	NumPartitions *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Default replication factor of the topic on the whole cluster
	DefaultReplicationFactor *wrapperspb.Int64Value `protobuf:"bytes,15,opt,name=default_replication_factor,json=defaultReplicationFactor,proto3" json:"default_replication_factor,omitempty"`
	// The largest record batch size allowed by Kafka. Default value: 1048588.
	MessageMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=message_max_bytes,json=messageMaxBytes,proto3" json:"message_max_bytes,omitempty"`
	// The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576.
	ReplicaFetchMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=replica_fetch_max_bytes,json=replicaFetchMaxBytes,proto3" json:"replica_fetch_max_bytes,omitempty"`
	// A list of cipher suites.
	SslCipherSuites []string `protobuf:"bytes,18,rep,name=ssl_cipher_suites,json=sslCipherSuites,proto3" json:"ssl_cipher_suites,omitempty"`
	// Offset storage time after a consumer group loses all its consumers. Default: 10080.
	OffsetsRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=offsets_retention_minutes,json=offsetsRetentionMinutes,proto3" json:"offsets_retention_minutes,omitempty"`
	// The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512].
	SaslEnabledMechanisms []SaslMechanism `protobuf:"varint,20,rep,packed,name=sasl_enabled_mechanisms,json=saslEnabledMechanisms,proto3,enum=yandex.cloud.mdb.kafka.v1.SaslMechanism" json:"sasl_enabled_mechanisms,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *KafkaConfig3) Reset() {
	*x = KafkaConfig3{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KafkaConfig3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaConfig3) ProtoMessage() {}

func (x *KafkaConfig3) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaConfig3.ProtoReflect.Descriptor instead.
func (*KafkaConfig3) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *KafkaConfig3) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *KafkaConfig3) GetLogFlushIntervalMessages() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMessages
	}
	return nil
}

func (x *KafkaConfig3) GetLogFlushIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogFlushSchedulerIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushSchedulerIntervalMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionBytes
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionHours() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionHours
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig3) GetLogRetentionMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMs
	}
	return nil
}

func (x *KafkaConfig3) GetLogSegmentBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogSegmentBytes
	}
	return nil
}

// Deprecated: Marked as deprecated in yandex/cloud/mdb/kafka/v1/cluster.proto.
func (x *KafkaConfig3) GetLogPreallocate() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogPreallocate
	}
	return nil
}

func (x *KafkaConfig3) GetSocketSendBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketSendBufferBytes
	}
	return nil
}

func (x *KafkaConfig3) GetSocketReceiveBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketReceiveBufferBytes
	}
	return nil
}

func (x *KafkaConfig3) GetAutoCreateTopicsEnable() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoCreateTopicsEnable
	}
	return nil
}

func (x *KafkaConfig3) GetNumPartitions() *wrapperspb.Int64Value {
	if x != nil {
		return x.NumPartitions
	}
	return nil
}

func (x *KafkaConfig3) GetDefaultReplicationFactor() *wrapperspb.Int64Value {
	if x != nil {
		return x.DefaultReplicationFactor
	}
	return nil
}

func (x *KafkaConfig3) GetMessageMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.MessageMaxBytes
	}
	return nil
}

func (x *KafkaConfig3) GetReplicaFetchMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaFetchMaxBytes
	}
	return nil
}

func (x *KafkaConfig3) GetSslCipherSuites() []string {
	if x != nil {
		return x.SslCipherSuites
	}
	return nil
}

func (x *KafkaConfig3) GetOffsetsRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.OffsetsRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig3) GetSaslEnabledMechanisms() []SaslMechanism {
	if x != nil {
		return x.SaslEnabledMechanisms
	}
	return nil
}

// Kafka version 4.x broker configuration.
type KafkaConfig4 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Cluster topics compression type.
	CompressionType CompressionType `protobuf:"varint,1,opt,name=compression_type,json=compressionType,proto3,enum=yandex.cloud.mdb.kafka.v1.CompressionType" json:"compression_type,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_messages] setting.
	LogFlushIntervalMessages *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=log_flush_interval_messages,json=logFlushIntervalMessages,proto3" json:"log_flush_interval_messages,omitempty"`
	// The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
	// If not set, the value of [log_flush_scheduler_interval_ms] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig4.flush_ms] setting.
	LogFlushIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=log_flush_interval_ms,json=logFlushIntervalMs,proto3" json:"log_flush_interval_ms,omitempty"`
	// The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
	// This check is done by the log flusher.
	LogFlushSchedulerIntervalMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=log_flush_scheduler_interval_ms,json=logFlushSchedulerIntervalMs,proto3" json:"log_flush_scheduler_interval_ms,omitempty"`
	// Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig4.cleanup_policy] is in effect.
	// This setting is helpful if you need to control the size of a log due to limited disk space.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_bytes] setting.
	LogRetentionBytes *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=log_retention_bytes,json=logRetentionBytes,proto3" json:"log_retention_bytes,omitempty"`
	// The number of hours to keep a log segment file before deleting it.
	LogRetentionHours *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=log_retention_hours,json=logRetentionHours,proto3" json:"log_retention_hours,omitempty"`
	// The number of minutes to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_hours] is used.
	LogRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=log_retention_minutes,json=logRetentionMinutes,proto3" json:"log_retention_minutes,omitempty"`
	// The number of milliseconds to keep a log segment file before deleting it.
	//
	// If not set, the value of [log_retention_minutes] is used.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig4.retention_ms] setting.
	LogRetentionMs *wrapperspb.Int64Value `protobuf:"bytes,8,opt,name=log_retention_ms,json=logRetentionMs,proto3" json:"log_retention_ms,omitempty"`
	// The maximum size of a single log file.
	//
	// This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig4.segment_bytes] setting.
	LogSegmentBytes *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=log_segment_bytes,json=logSegmentBytes,proto3" json:"log_segment_bytes,omitempty"`
	// The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketSendBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,11,opt,name=socket_send_buffer_bytes,json=socketSendBufferBytes,proto3" json:"socket_send_buffer_bytes,omitempty"`
	// The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.
	SocketReceiveBufferBytes *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=socket_receive_buffer_bytes,json=socketReceiveBufferBytes,proto3" json:"socket_receive_buffer_bytes,omitempty"`
	// Enable auto creation of topic on the server
	AutoCreateTopicsEnable *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=auto_create_topics_enable,json=autoCreateTopicsEnable,proto3" json:"auto_create_topics_enable,omitempty"`
	// Default number of partitions per topic on the whole cluster
	NumPartitions *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Default replication factor of the topic on the whole cluster
	DefaultReplicationFactor *wrapperspb.Int64Value `protobuf:"bytes,15,opt,name=default_replication_factor,json=defaultReplicationFactor,proto3" json:"default_replication_factor,omitempty"`
	// The largest record batch size allowed by Kafka. Default value: 1048588.
	MessageMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=message_max_bytes,json=messageMaxBytes,proto3" json:"message_max_bytes,omitempty"`
	// The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576.
	ReplicaFetchMaxBytes *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=replica_fetch_max_bytes,json=replicaFetchMaxBytes,proto3" json:"replica_fetch_max_bytes,omitempty"`
	// A list of cipher suites.
	SslCipherSuites []string `protobuf:"bytes,18,rep,name=ssl_cipher_suites,json=sslCipherSuites,proto3" json:"ssl_cipher_suites,omitempty"`
	// Offset storage time after a consumer group loses all its consumers. Default: 10080.
	OffsetsRetentionMinutes *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=offsets_retention_minutes,json=offsetsRetentionMinutes,proto3" json:"offsets_retention_minutes,omitempty"`
	// The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512].
	SaslEnabledMechanisms []SaslMechanism `protobuf:"varint,20,rep,packed,name=sasl_enabled_mechanisms,json=saslEnabledMechanisms,proto3,enum=yandex.cloud.mdb.kafka.v1.SaslMechanism" json:"sasl_enabled_mechanisms,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *KafkaConfig4) Reset() {
	*x = KafkaConfig4{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KafkaConfig4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaConfig4) ProtoMessage() {}

func (x *KafkaConfig4) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaConfig4.ProtoReflect.Descriptor instead.
func (*KafkaConfig4) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *KafkaConfig4) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *KafkaConfig4) GetLogFlushIntervalMessages() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMessages
	}
	return nil
}

func (x *KafkaConfig4) GetLogFlushIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushIntervalMs
	}
	return nil
}

func (x *KafkaConfig4) GetLogFlushSchedulerIntervalMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogFlushSchedulerIntervalMs
	}
	return nil
}

func (x *KafkaConfig4) GetLogRetentionBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionBytes
	}
	return nil
}

func (x *KafkaConfig4) GetLogRetentionHours() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionHours
	}
	return nil
}

func (x *KafkaConfig4) GetLogRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig4) GetLogRetentionMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogRetentionMs
	}
	return nil
}

func (x *KafkaConfig4) GetLogSegmentBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.LogSegmentBytes
	}
	return nil
}

func (x *KafkaConfig4) GetSocketSendBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketSendBufferBytes
	}
	return nil
}

func (x *KafkaConfig4) GetSocketReceiveBufferBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.SocketReceiveBufferBytes
	}
	return nil
}

func (x *KafkaConfig4) GetAutoCreateTopicsEnable() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoCreateTopicsEnable
	}
	return nil
}

func (x *KafkaConfig4) GetNumPartitions() *wrapperspb.Int64Value {
	if x != nil {
		return x.NumPartitions
	}
	return nil
}

func (x *KafkaConfig4) GetDefaultReplicationFactor() *wrapperspb.Int64Value {
	if x != nil {
		return x.DefaultReplicationFactor
	}
	return nil
}

func (x *KafkaConfig4) GetMessageMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.MessageMaxBytes
	}
	return nil
}

func (x *KafkaConfig4) GetReplicaFetchMaxBytes() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaFetchMaxBytes
	}
	return nil
}

func (x *KafkaConfig4) GetSslCipherSuites() []string {
	if x != nil {
		return x.SslCipherSuites
	}
	return nil
}

func (x *KafkaConfig4) GetOffsetsRetentionMinutes() *wrapperspb.Int64Value {
	if x != nil {
		return x.OffsetsRetentionMinutes
	}
	return nil
}

func (x *KafkaConfig4) GetSaslEnabledMechanisms() []SaslMechanism {
	if x != nil {
		return x.SaslEnabledMechanisms
	}
	return nil
}

// Cluster host metadata.
type Host struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Apache Kafka® cluster.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Host role. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,4,opt,name=role,proto3,enum=yandex.cloud.mdb.kafka.v1.Host_Role" json:"role,omitempty"`
	// Computational resources allocated to the host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Aggregated host health data. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.kafka.v1.Host_Health" json:"health,omitempty"`
	// ID of the subnet the host resides in.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// The flag that defines whether a public IP address is assigned to the node.
	//
	// If the value is `true`, then this node is available on the Internet via it's public IP address.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Host) Reset() {
	*x = Host{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNSPECIFIED
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_UNKNOWN
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

type Access struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allow access for DataTransfer.
	DataTransfer  bool `protobuf:"varint,1,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Access) Reset() {
	*x = Access{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

type DiskSizeAutoscaling struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Threshold of storage usage (in percent) that triggers automatic scaling of the storage during the maintenance window. Zero value means disabled threshold.
	PlannedUsageThreshold int64 `protobuf:"varint,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Threshold of storage usage (in percent) that triggers immediate automatic scaling of the storage. Zero value means disabled threshold.
	EmergencyUsageThreshold int64 `protobuf:"varint,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// New storage size (in bytes) that is set when one of the thresholds is achieved.
	DiskSizeLimit int64 `protobuf:"varint,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() int64 {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() int64 {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return 0
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() int64 {
	if x != nil {
		return x.DiskSizeLimit
	}
	return 0
}

type Cluster_KafkaUI struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL for connection to kafka ui
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Cluster_KafkaUI) Reset() {
	*x = Cluster_KafkaUI{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_KafkaUI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_KafkaUI) ProtoMessage() {}

func (x *Cluster_KafkaUI) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_KafkaUI.ProtoReflect.Descriptor instead.
func (*Cluster_KafkaUI) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Cluster_KafkaUI) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type ConfigSpec_Kafka struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources allocated to Kafka brokers.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Kafka broker configuration.
	//
	// Types that are valid to be assigned to KafkaConfig:
	//
	//	*ConfigSpec_Kafka_KafkaConfig_2_8
	//	*ConfigSpec_Kafka_KafkaConfig_3
	//	*ConfigSpec_Kafka_KafkaConfig_4
	KafkaConfig   isConfigSpec_Kafka_KafkaConfig `protobuf_oneof:"kafka_config"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec_Kafka) Reset() {
	*x = ConfigSpec_Kafka{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec_Kafka) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_Kafka) ProtoMessage() {}

func (x *ConfigSpec_Kafka) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_Kafka.ProtoReflect.Descriptor instead.
func (*ConfigSpec_Kafka) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ConfigSpec_Kafka) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig() isConfigSpec_Kafka_KafkaConfig {
	if x != nil {
		return x.KafkaConfig
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig_2_8() *KafkaConfig2_8 {
	if x != nil {
		if x, ok := x.KafkaConfig.(*ConfigSpec_Kafka_KafkaConfig_2_8); ok {
			return x.KafkaConfig_2_8
		}
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig_3() *KafkaConfig3 {
	if x != nil {
		if x, ok := x.KafkaConfig.(*ConfigSpec_Kafka_KafkaConfig_3); ok {
			return x.KafkaConfig_3
		}
	}
	return nil
}

func (x *ConfigSpec_Kafka) GetKafkaConfig_4() *KafkaConfig4 {
	if x != nil {
		if x, ok := x.KafkaConfig.(*ConfigSpec_Kafka_KafkaConfig_4); ok {
			return x.KafkaConfig_4
		}
	}
	return nil
}

type isConfigSpec_Kafka_KafkaConfig interface {
	isConfigSpec_Kafka_KafkaConfig()
}

type ConfigSpec_Kafka_KafkaConfig_2_8 struct {
	// Configuration of an Apache Kafka® 2.8 broker.
	KafkaConfig_2_8 *KafkaConfig2_8 `protobuf:"bytes,4,opt,name=kafka_config_2_8,json=kafkaConfig_2_8,proto3,oneof"`
}

type ConfigSpec_Kafka_KafkaConfig_3 struct {
	// Configuration of an Apache Kafka® 3.x broker.
	KafkaConfig_3 *KafkaConfig3 `protobuf:"bytes,5,opt,name=kafka_config_3,json=kafkaConfig_3,proto3,oneof"`
}

type ConfigSpec_Kafka_KafkaConfig_4 struct {
	// Configuration of an Apache Kafka® 4.x broker.
	KafkaConfig_4 *KafkaConfig4 `protobuf:"bytes,6,opt,name=kafka_config_4,json=kafkaConfig_4,proto3,oneof"`
}

func (*ConfigSpec_Kafka_KafkaConfig_2_8) isConfigSpec_Kafka_KafkaConfig() {}

func (*ConfigSpec_Kafka_KafkaConfig_3) isConfigSpec_Kafka_KafkaConfig() {}

func (*ConfigSpec_Kafka_KafkaConfig_4) isConfigSpec_Kafka_KafkaConfig() {}

type ConfigSpec_Zookeeper struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources allocated to ZooKeeper hosts.
	Resources     *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec_Zookeeper) Reset() {
	*x = ConfigSpec_Zookeeper{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec_Zookeeper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_Zookeeper) ProtoMessage() {}

func (x *ConfigSpec_Zookeeper) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_Zookeeper.ProtoReflect.Descriptor instead.
func (*ConfigSpec_Zookeeper) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ConfigSpec_Zookeeper) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type ConfigSpec_KRaft struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources allocated to KRaft controller hosts.
	Resources     *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec_KRaft) Reset() {
	*x = ConfigSpec_KRaft{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec_KRaft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_KRaft) ProtoMessage() {}

func (x *ConfigSpec_KRaft) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_KRaft.ProtoReflect.Descriptor instead.
func (*ConfigSpec_KRaft) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ConfigSpec_KRaft) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type ConfigSpec_RestAPIConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Is REST API enabled for this cluster.
	Enabled       bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec_RestAPIConfig) Reset() {
	*x = ConfigSpec_RestAPIConfig{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec_RestAPIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_RestAPIConfig) ProtoMessage() {}

func (x *ConfigSpec_RestAPIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_RestAPIConfig.ProtoReflect.Descriptor instead.
func (*ConfigSpec_RestAPIConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 3}
}

func (x *ConfigSpec_RestAPIConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type ConfigSpec_KafkaUIConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Is Kafka UI enabled for this cluster.
	Enabled       bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigSpec_KafkaUIConfig) Reset() {
	*x = ConfigSpec_KafkaUIConfig{}
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSpec_KafkaUIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSpec_KafkaUIConfig) ProtoMessage() {}

func (x *ConfigSpec_KafkaUIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSpec_KafkaUIConfig.ProtoReflect.Descriptor instead.
func (*ConfigSpec_KafkaUIConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP(), []int{2, 4}
}

func (x *ConfigSpec_KafkaUIConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_yandex_cloud_mdb_kafka_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"'yandex/cloud/mdb/kafka/v1/cluster.proto\x12\x19yandex.cloud.mdb.kafka.v1\x1a google/protobuf/descriptor.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a&yandex/cloud/mdb/kafka/v1/common.proto\x1a+yandex/cloud/mdb/kafka/v1/maintenance.proto\x1a\x1dyandex/cloud/validation.proto\"\xa5\v\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12F\n" +
	"\x06labels\x18\x06 \x03(\v2..yandex.cloud.mdb.kafka.v1.Cluster.LabelsEntryR\x06labels\x12P\n" +
	"\venvironment\x18\a \x01(\x0e2..yandex.cloud.mdb.kafka.v1.Cluster.EnvironmentR\venvironment\x12E\n" +
	"\n" +
	"monitoring\x18\b \x03(\v2%.yandex.cloud.mdb.kafka.v1.MonitoringR\n" +
	"monitoring\x12=\n" +
	"\x06config\x18\t \x01(\v2%.yandex.cloud.mdb.kafka.v1.ConfigSpecR\x06config\x12\x1d\n" +
	"\n" +
	"network_id\x18\n" +
	" \x01(\tR\tnetworkId\x12A\n" +
	"\x06health\x18\v \x01(\x0e2).yandex.cloud.mdb.kafka.v1.Cluster.HealthR\x06health\x12A\n" +
	"\x06status\x18\f \x01(\x0e2).yandex.cloud.mdb.kafka.v1.Cluster.StatusR\x06status\x12,\n" +
	"\x12security_group_ids\x18\r \x03(\tR\x10securityGroupIds\x12$\n" +
	"\x0ehost_group_ids\x18\x0e \x03(\tR\fhostGroupIds\x12/\n" +
	"\x13deletion_protection\x18\x0f \x01(\bR\x12deletionProtection\x12[\n" +
	"\x12maintenance_window\x18\x10 \x01(\v2,.yandex.cloud.mdb.kafka.v1.MaintenanceWindowR\x11maintenanceWindow\x12\\\n" +
	"\x11planned_operation\x18\x11 \x01(\v2/.yandex.cloud.mdb.kafka.v1.MaintenanceOperationR\x10plannedOperation\x12E\n" +
	"\bkafka_ui\x18\x12 \x01(\v2*.yandex.cloud.mdb.kafka.v1.Cluster.KafkaUIR\akafkaUi\x12Q\n" +
	"\x16disk_encryption_key_id\x18\x13 \x01(\v2\x1c.google.protobuf.StringValueR\x13diskEncryptionKeyId\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\x1b\n" +
	"\aKafkaUI\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\"I\n" +
	"\vEnvironment\x12\x1b\n" +
	"\x17ENVIRONMENT_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"PRODUCTION\x10\x01\x12\r\n" +
	"\tPRESTABLE\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bUPDATING\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\a\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\xaa\v\n" +
	"\n" +
	"ConfigSpec\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12A\n" +
	"\x05kafka\x18\x02 \x01(\v2+.yandex.cloud.mdb.kafka.v1.ConfigSpec.KafkaR\x05kafka\x12M\n" +
	"\tzookeeper\x18\x03 \x01(\v2/.yandex.cloud.mdb.kafka.v1.ConfigSpec.ZookeeperR\tzookeeper\x12\x17\n" +
	"\azone_id\x18\x04 \x03(\tR\x06zoneId\x12@\n" +
	"\rbrokers_count\x18\x05 \x01(\v2\x1b.google.protobuf.Int64ValueR\fbrokersCount\x12(\n" +
	"\x10assign_public_ip\x18\x06 \x01(\bR\x0eassignPublicIp\x12-\n" +
	"\x10unmanaged_topics\x18\a \x01(\bB\x02\x18\x01R\x0funmanagedTopics\x12'\n" +
	"\x0fschema_registry\x18\b \x01(\bR\x0eschemaRegistry\x129\n" +
	"\x06access\x18\t \x01(\v2!.yandex.cloud.mdb.kafka.v1.AccessR\x06access\x12[\n" +
	"\x0frest_api_config\x18\n" +
	" \x01(\v23.yandex.cloud.mdb.kafka.v1.ConfigSpec.RestAPIConfigR\rrestApiConfig\x12b\n" +
	"\x15disk_size_autoscaling\x18\v \x01(\v2..yandex.cloud.mdb.kafka.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x12A\n" +
	"\x05kraft\x18\f \x01(\v2+.yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaftR\x05kraft\x12[\n" +
	"\x0fkafka_ui_config\x18\r \x01(\v23.yandex.cloud.mdb.kafka.v1.ConfigSpec.KafkaUIConfigR\rkafkaUiConfig\x12#\n" +
	"\rpatch_version\x18\x0e \x01(\tR\fpatchVersion\x1a\xdd\x02\n" +
	"\x05Kafka\x12B\n" +
	"\tresources\x18\x01 \x01(\v2$.yandex.cloud.mdb.kafka.v1.ResourcesR\tresources\x12V\n" +
	"\x10kafka_config_2_8\x18\x04 \x01(\v2).yandex.cloud.mdb.kafka.v1.KafkaConfig2_8H\x00R\x0fkafkaConfig_2_8\x12P\n" +
	"\x0ekafka_config_3\x18\x05 \x01(\v2'.yandex.cloud.mdb.kafka.v1.KafkaConfig3H\x00R\rkafkaConfig_3\x12P\n" +
	"\x0ekafka_config_4\x18\x06 \x01(\v2'.yandex.cloud.mdb.kafka.v1.KafkaConfig4H\x00R\rkafkaConfig_4B\x0e\n" +
	"\fkafka_configJ\x04\b\x02\x10\x04\x1aO\n" +
	"\tZookeeper\x12B\n" +
	"\tresources\x18\x01 \x01(\v2$.yandex.cloud.mdb.kafka.v1.ResourcesR\tresources\x1aK\n" +
	"\x05KRaft\x12B\n" +
	"\tresources\x18\x01 \x01(\v2$.yandex.cloud.mdb.kafka.v1.ResourcesR\tresources\x1a)\n" +
	"\rRestAPIConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x1a)\n" +
	"\rKafkaUIConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\"x\n" +
	"\tResources\x12,\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tR\x10resourcePresetId\x12\x1b\n" +
	"\tdisk_size\x18\x02 \x01(\x03R\bdiskSize\x12 \n" +
	"\fdisk_type_id\x18\x03 \x01(\tR\n" +
	"diskTypeId\"\xe6\f\n" +
	"\x0eKafkaConfig2_8\x12U\n" +
	"\x10compression_type\x18\x01 \x01(\x0e2*.yandex.cloud.mdb.kafka.v1.CompressionTypeR\x0fcompressionType\x12Z\n" +
	"\x1blog_flush_interval_messages\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x18logFlushIntervalMessages\x12N\n" +
	"\x15log_flush_interval_ms\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x12logFlushIntervalMs\x12a\n" +
	"\x1flog_flush_scheduler_interval_ms\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueR\x1blogFlushSchedulerIntervalMs\x12K\n" +
	"\x13log_retention_bytes\x18\x05 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionBytes\x12K\n" +
	"\x13log_retention_hours\x18\x06 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionHours\x12O\n" +
	"\x15log_retention_minutes\x18\a \x01(\v2\x1b.google.protobuf.Int64ValueR\x13logRetentionMinutes\x12E\n" +
	"\x10log_retention_ms\x18\b \x01(\v2\x1b.google.protobuf.Int64ValueR\x0elogRetentionMs\x12G\n" +
	"\x11log_segment_bytes\x18\t \x01(\v2\x1b.google.protobuf.Int64ValueR\x0flogSegmentBytes\x12G\n" +
	"\x0flog_preallocate\x18\n" +
	" \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\x0elogPreallocate\x12T\n" +
	"\x18socket_send_buffer_bytes\x18\v \x01(\v2\x1b.google.protobuf.Int64ValueR\x15socketSendBufferBytes\x12Z\n" +
	"\x1bsocket_receive_buffer_bytes\x18\f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18socketReceiveBufferBytes\x12U\n" +
	"\x19auto_create_topics_enable\x18\r \x01(\v2\x1a.google.protobuf.BoolValueR\x16autoCreateTopicsEnable\x12B\n" +
	"\x0enum_partitions\x18\x0e \x01(\v2\x1b.google.protobuf.Int64ValueR\rnumPartitions\x12Y\n" +
	"\x1adefault_replication_factor\x18\x0f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18defaultReplicationFactor\x12G\n" +
	"\x11message_max_bytes\x18\x10 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0fmessageMaxBytes\x12R\n" +
	"\x17replica_fetch_max_bytes\x18\x11 \x01(\v2\x1b.google.protobuf.Int64ValueR\x14replicaFetchMaxBytes\x12*\n" +
	"\x11ssl_cipher_suites\x18\x12 \x03(\tR\x0fsslCipherSuites\x12W\n" +
	"\x19offsets_retention_minutes\x18\x13 \x01(\v2\x1b.google.protobuf.Int64ValueR\x17offsetsRetentionMinutes\x12`\n" +
	"\x17sasl_enabled_mechanisms\x18\x14 \x03(\x0e2(.yandex.cloud.mdb.kafka.v1.SaslMechanismR\x15saslEnabledMechanisms\"\xe4\f\n" +
	"\fKafkaConfig3\x12U\n" +
	"\x10compression_type\x18\x01 \x01(\x0e2*.yandex.cloud.mdb.kafka.v1.CompressionTypeR\x0fcompressionType\x12Z\n" +
	"\x1blog_flush_interval_messages\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x18logFlushIntervalMessages\x12N\n" +
	"\x15log_flush_interval_ms\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x12logFlushIntervalMs\x12a\n" +
	"\x1flog_flush_scheduler_interval_ms\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueR\x1blogFlushSchedulerIntervalMs\x12K\n" +
	"\x13log_retention_bytes\x18\x05 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionBytes\x12K\n" +
	"\x13log_retention_hours\x18\x06 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionHours\x12O\n" +
	"\x15log_retention_minutes\x18\a \x01(\v2\x1b.google.protobuf.Int64ValueR\x13logRetentionMinutes\x12E\n" +
	"\x10log_retention_ms\x18\b \x01(\v2\x1b.google.protobuf.Int64ValueR\x0elogRetentionMs\x12G\n" +
	"\x11log_segment_bytes\x18\t \x01(\v2\x1b.google.protobuf.Int64ValueR\x0flogSegmentBytes\x12G\n" +
	"\x0flog_preallocate\x18\n" +
	" \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\x0elogPreallocate\x12T\n" +
	"\x18socket_send_buffer_bytes\x18\v \x01(\v2\x1b.google.protobuf.Int64ValueR\x15socketSendBufferBytes\x12Z\n" +
	"\x1bsocket_receive_buffer_bytes\x18\f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18socketReceiveBufferBytes\x12U\n" +
	"\x19auto_create_topics_enable\x18\r \x01(\v2\x1a.google.protobuf.BoolValueR\x16autoCreateTopicsEnable\x12B\n" +
	"\x0enum_partitions\x18\x0e \x01(\v2\x1b.google.protobuf.Int64ValueR\rnumPartitions\x12Y\n" +
	"\x1adefault_replication_factor\x18\x0f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18defaultReplicationFactor\x12G\n" +
	"\x11message_max_bytes\x18\x10 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0fmessageMaxBytes\x12R\n" +
	"\x17replica_fetch_max_bytes\x18\x11 \x01(\v2\x1b.google.protobuf.Int64ValueR\x14replicaFetchMaxBytes\x12*\n" +
	"\x11ssl_cipher_suites\x18\x12 \x03(\tR\x0fsslCipherSuites\x12W\n" +
	"\x19offsets_retention_minutes\x18\x13 \x01(\v2\x1b.google.protobuf.Int64ValueR\x17offsetsRetentionMinutes\x12`\n" +
	"\x17sasl_enabled_mechanisms\x18\x14 \x03(\x0e2(.yandex.cloud.mdb.kafka.v1.SaslMechanismR\x15saslEnabledMechanisms\"\xa1\f\n" +
	"\fKafkaConfig4\x12U\n" +
	"\x10compression_type\x18\x01 \x01(\x0e2*.yandex.cloud.mdb.kafka.v1.CompressionTypeR\x0fcompressionType\x12Z\n" +
	"\x1blog_flush_interval_messages\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x18logFlushIntervalMessages\x12N\n" +
	"\x15log_flush_interval_ms\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x12logFlushIntervalMs\x12a\n" +
	"\x1flog_flush_scheduler_interval_ms\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueR\x1blogFlushSchedulerIntervalMs\x12K\n" +
	"\x13log_retention_bytes\x18\x05 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionBytes\x12K\n" +
	"\x13log_retention_hours\x18\x06 \x01(\v2\x1b.google.protobuf.Int64ValueR\x11logRetentionHours\x12O\n" +
	"\x15log_retention_minutes\x18\a \x01(\v2\x1b.google.protobuf.Int64ValueR\x13logRetentionMinutes\x12E\n" +
	"\x10log_retention_ms\x18\b \x01(\v2\x1b.google.protobuf.Int64ValueR\x0elogRetentionMs\x12G\n" +
	"\x11log_segment_bytes\x18\t \x01(\v2\x1b.google.protobuf.Int64ValueR\x0flogSegmentBytes\x12T\n" +
	"\x18socket_send_buffer_bytes\x18\v \x01(\v2\x1b.google.protobuf.Int64ValueR\x15socketSendBufferBytes\x12Z\n" +
	"\x1bsocket_receive_buffer_bytes\x18\f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18socketReceiveBufferBytes\x12U\n" +
	"\x19auto_create_topics_enable\x18\r \x01(\v2\x1a.google.protobuf.BoolValueR\x16autoCreateTopicsEnable\x12B\n" +
	"\x0enum_partitions\x18\x0e \x01(\v2\x1b.google.protobuf.Int64ValueR\rnumPartitions\x12Y\n" +
	"\x1adefault_replication_factor\x18\x0f \x01(\v2\x1b.google.protobuf.Int64ValueR\x18defaultReplicationFactor\x12G\n" +
	"\x11message_max_bytes\x18\x10 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0fmessageMaxBytes\x12R\n" +
	"\x17replica_fetch_max_bytes\x18\x11 \x01(\v2\x1b.google.protobuf.Int64ValueR\x14replicaFetchMaxBytes\x12*\n" +
	"\x11ssl_cipher_suites\x18\x12 \x03(\tR\x0fsslCipherSuites\x12W\n" +
	"\x19offsets_retention_minutes\x18\x13 \x01(\v2\x1b.google.protobuf.Int64ValueR\x17offsetsRetentionMinutes\x12`\n" +
	"\x17sasl_enabled_mechanisms\x18\x14 \x03(\x0e2(.yandex.cloud.mdb.kafka.v1.SaslMechanismR\x15saslEnabledMechanismsJ\x04\b\n" +
	"\x10\v\"\xda\x03\n" +
	"\x04Host\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12\x17\n" +
	"\azone_id\x18\x03 \x01(\tR\x06zoneId\x128\n" +
	"\x04role\x18\x04 \x01(\x0e2$.yandex.cloud.mdb.kafka.v1.Host.RoleR\x04role\x12B\n" +
	"\tresources\x18\x05 \x01(\v2$.yandex.cloud.mdb.kafka.v1.ResourcesR\tresources\x12>\n" +
	"\x06health\x18\x06 \x01(\x0e2&.yandex.cloud.mdb.kafka.v1.Host.HealthR\x06health\x12\x1b\n" +
	"\tsubnet_id\x18\b \x01(\tR\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\t \x01(\bR\x0eassignPublicIp\"A\n" +
	"\x04Role\x12\x14\n" +
	"\x10ROLE_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05KAFKA\x10\x01\x12\r\n" +
	"\tZOOKEEPER\x10\x02\x12\t\n" +
	"\x05KRAFT\x10\x03\"8\n" +
	"\x06Health\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03J\x04\b\a\x10\b\"-\n" +
	"\x06Access\x12#\n" +
	"\rdata_transfer\x18\x01 \x01(\bR\fdataTransfer\"\xcf\x01\n" +
	"\x13DiskSizeAutoscaling\x12E\n" +
	"\x17planned_usage_threshold\x18\x01 \x01(\x03B\r\xe8\xc71\x00\xfa\xc71\x050-100R\x15plannedUsageThreshold\x12I\n" +
	"\x19emergency_usage_threshold\x18\x02 \x01(\x03B\r\xe8\xc71\x00\xfa\xc71\x050-100R\x17emergencyUsageThreshold\x12&\n" +
	"\x0fdisk_size_limit\x18\x03 \x01(\x03R\rdiskSizeLimitBd\n" +
	"\x1dyandex.cloud.api.mdb.kafka.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/kafka/v1;kafkab\x06proto3"

var (
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),         // 0: yandex.cloud.mdb.kafka.v1.Cluster.Environment
	(Cluster_Health)(0),              // 1: yandex.cloud.mdb.kafka.v1.Cluster.Health
	(Cluster_Status)(0),              // 2: yandex.cloud.mdb.kafka.v1.Cluster.Status
	(Host_Role)(0),                   // 3: yandex.cloud.mdb.kafka.v1.Host.Role
	(Host_Health)(0),                 // 4: yandex.cloud.mdb.kafka.v1.Host.Health
	(*Cluster)(nil),                  // 5: yandex.cloud.mdb.kafka.v1.Cluster
	(*Monitoring)(nil),               // 6: yandex.cloud.mdb.kafka.v1.Monitoring
	(*ConfigSpec)(nil),               // 7: yandex.cloud.mdb.kafka.v1.ConfigSpec
	(*Resources)(nil),                // 8: yandex.cloud.mdb.kafka.v1.Resources
	(*KafkaConfig2_8)(nil),           // 9: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8
	(*KafkaConfig3)(nil),             // 10: yandex.cloud.mdb.kafka.v1.KafkaConfig3
	(*KafkaConfig4)(nil),             // 11: yandex.cloud.mdb.kafka.v1.KafkaConfig4
	(*Host)(nil),                     // 12: yandex.cloud.mdb.kafka.v1.Host
	(*Access)(nil),                   // 13: yandex.cloud.mdb.kafka.v1.Access
	(*DiskSizeAutoscaling)(nil),      // 14: yandex.cloud.mdb.kafka.v1.DiskSizeAutoscaling
	nil,                              // 15: yandex.cloud.mdb.kafka.v1.Cluster.LabelsEntry
	(*Cluster_KafkaUI)(nil),          // 16: yandex.cloud.mdb.kafka.v1.Cluster.KafkaUI
	(*ConfigSpec_Kafka)(nil),         // 17: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka
	(*ConfigSpec_Zookeeper)(nil),     // 18: yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper
	(*ConfigSpec_KRaft)(nil),         // 19: yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft
	(*ConfigSpec_RestAPIConfig)(nil), // 20: yandex.cloud.mdb.kafka.v1.ConfigSpec.RestAPIConfig
	(*ConfigSpec_KafkaUIConfig)(nil), // 21: yandex.cloud.mdb.kafka.v1.ConfigSpec.KafkaUIConfig
	(*timestamppb.Timestamp)(nil),    // 22: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),        // 23: yandex.cloud.mdb.kafka.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),     // 24: yandex.cloud.mdb.kafka.v1.MaintenanceOperation
	(*wrapperspb.StringValue)(nil),   // 25: google.protobuf.StringValue
	(*wrapperspb.Int64Value)(nil),    // 26: google.protobuf.Int64Value
	(CompressionType)(0),             // 27: yandex.cloud.mdb.kafka.v1.CompressionType
	(*wrapperspb.BoolValue)(nil),     // 28: google.protobuf.BoolValue
	(SaslMechanism)(0),               // 29: yandex.cloud.mdb.kafka.v1.SaslMechanism
}
var file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs = []int32{
	22, // 0: yandex.cloud.mdb.kafka.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	15, // 1: yandex.cloud.mdb.kafka.v1.Cluster.labels:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.kafka.v1.Cluster.environment:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Environment
	6,  // 3: yandex.cloud.mdb.kafka.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.kafka.v1.Monitoring
	7,  // 4: yandex.cloud.mdb.kafka.v1.Cluster.config:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec
	1,  // 5: yandex.cloud.mdb.kafka.v1.Cluster.health:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.kafka.v1.Cluster.status:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.Status
	23, // 7: yandex.cloud.mdb.kafka.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.kafka.v1.MaintenanceWindow
	24, // 8: yandex.cloud.mdb.kafka.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.kafka.v1.MaintenanceOperation
	16, // 9: yandex.cloud.mdb.kafka.v1.Cluster.kafka_ui:type_name -> yandex.cloud.mdb.kafka.v1.Cluster.KafkaUI
	25, // 10: yandex.cloud.mdb.kafka.v1.Cluster.disk_encryption_key_id:type_name -> google.protobuf.StringValue
	17, // 11: yandex.cloud.mdb.kafka.v1.ConfigSpec.kafka:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka
	18, // 12: yandex.cloud.mdb.kafka.v1.ConfigSpec.zookeeper:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper
	26, // 13: yandex.cloud.mdb.kafka.v1.ConfigSpec.brokers_count:type_name -> google.protobuf.Int64Value
	13, // 14: yandex.cloud.mdb.kafka.v1.ConfigSpec.access:type_name -> yandex.cloud.mdb.kafka.v1.Access
	20, // 15: yandex.cloud.mdb.kafka.v1.ConfigSpec.rest_api_config:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.RestAPIConfig
	14, // 16: yandex.cloud.mdb.kafka.v1.ConfigSpec.disk_size_autoscaling:type_name -> yandex.cloud.mdb.kafka.v1.DiskSizeAutoscaling
	19, // 17: yandex.cloud.mdb.kafka.v1.ConfigSpec.kraft:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft
	21, // 18: yandex.cloud.mdb.kafka.v1.ConfigSpec.kafka_ui_config:type_name -> yandex.cloud.mdb.kafka.v1.ConfigSpec.KafkaUIConfig
	27, // 19: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.compression_type:type_name -> yandex.cloud.mdb.kafka.v1.CompressionType
	26, // 20: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_interval_messages:type_name -> google.protobuf.Int64Value
	26, // 21: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 22: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_flush_scheduler_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 23: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_bytes:type_name -> google.protobuf.Int64Value
	26, // 24: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_hours:type_name -> google.protobuf.Int64Value
	26, // 25: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_minutes:type_name -> google.protobuf.Int64Value
	26, // 26: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_retention_ms:type_name -> google.protobuf.Int64Value
	26, // 27: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_segment_bytes:type_name -> google.protobuf.Int64Value
	28, // 28: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.log_preallocate:type_name -> google.protobuf.BoolValue
	26, // 29: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.socket_send_buffer_bytes:type_name -> google.protobuf.Int64Value
	26, // 30: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.socket_receive_buffer_bytes:type_name -> google.protobuf.Int64Value
	28, // 31: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.auto_create_topics_enable:type_name -> google.protobuf.BoolValue
	26, // 32: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.num_partitions:type_name -> google.protobuf.Int64Value
	26, // 33: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.default_replication_factor:type_name -> google.protobuf.Int64Value
	26, // 34: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.message_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 35: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.replica_fetch_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 36: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.offsets_retention_minutes:type_name -> google.protobuf.Int64Value
	29, // 37: yandex.cloud.mdb.kafka.v1.KafkaConfig2_8.sasl_enabled_mechanisms:type_name -> yandex.cloud.mdb.kafka.v1.SaslMechanism
	27, // 38: yandex.cloud.mdb.kafka.v1.KafkaConfig3.compression_type:type_name -> yandex.cloud.mdb.kafka.v1.CompressionType
	26, // 39: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_interval_messages:type_name -> google.protobuf.Int64Value
	26, // 40: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 41: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_flush_scheduler_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 42: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_bytes:type_name -> google.protobuf.Int64Value
	26, // 43: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_hours:type_name -> google.protobuf.Int64Value
	26, // 44: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_minutes:type_name -> google.protobuf.Int64Value
	26, // 45: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_retention_ms:type_name -> google.protobuf.Int64Value
	26, // 46: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_segment_bytes:type_name -> google.protobuf.Int64Value
	28, // 47: yandex.cloud.mdb.kafka.v1.KafkaConfig3.log_preallocate:type_name -> google.protobuf.BoolValue
	26, // 48: yandex.cloud.mdb.kafka.v1.KafkaConfig3.socket_send_buffer_bytes:type_name -> google.protobuf.Int64Value
	26, // 49: yandex.cloud.mdb.kafka.v1.KafkaConfig3.socket_receive_buffer_bytes:type_name -> google.protobuf.Int64Value
	28, // 50: yandex.cloud.mdb.kafka.v1.KafkaConfig3.auto_create_topics_enable:type_name -> google.protobuf.BoolValue
	26, // 51: yandex.cloud.mdb.kafka.v1.KafkaConfig3.num_partitions:type_name -> google.protobuf.Int64Value
	26, // 52: yandex.cloud.mdb.kafka.v1.KafkaConfig3.default_replication_factor:type_name -> google.protobuf.Int64Value
	26, // 53: yandex.cloud.mdb.kafka.v1.KafkaConfig3.message_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 54: yandex.cloud.mdb.kafka.v1.KafkaConfig3.replica_fetch_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 55: yandex.cloud.mdb.kafka.v1.KafkaConfig3.offsets_retention_minutes:type_name -> google.protobuf.Int64Value
	29, // 56: yandex.cloud.mdb.kafka.v1.KafkaConfig3.sasl_enabled_mechanisms:type_name -> yandex.cloud.mdb.kafka.v1.SaslMechanism
	27, // 57: yandex.cloud.mdb.kafka.v1.KafkaConfig4.compression_type:type_name -> yandex.cloud.mdb.kafka.v1.CompressionType
	26, // 58: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_flush_interval_messages:type_name -> google.protobuf.Int64Value
	26, // 59: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_flush_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 60: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_flush_scheduler_interval_ms:type_name -> google.protobuf.Int64Value
	26, // 61: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_retention_bytes:type_name -> google.protobuf.Int64Value
	26, // 62: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_retention_hours:type_name -> google.protobuf.Int64Value
	26, // 63: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_retention_minutes:type_name -> google.protobuf.Int64Value
	26, // 64: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_retention_ms:type_name -> google.protobuf.Int64Value
	26, // 65: yandex.cloud.mdb.kafka.v1.KafkaConfig4.log_segment_bytes:type_name -> google.protobuf.Int64Value
	26, // 66: yandex.cloud.mdb.kafka.v1.KafkaConfig4.socket_send_buffer_bytes:type_name -> google.protobuf.Int64Value
	26, // 67: yandex.cloud.mdb.kafka.v1.KafkaConfig4.socket_receive_buffer_bytes:type_name -> google.protobuf.Int64Value
	28, // 68: yandex.cloud.mdb.kafka.v1.KafkaConfig4.auto_create_topics_enable:type_name -> google.protobuf.BoolValue
	26, // 69: yandex.cloud.mdb.kafka.v1.KafkaConfig4.num_partitions:type_name -> google.protobuf.Int64Value
	26, // 70: yandex.cloud.mdb.kafka.v1.KafkaConfig4.default_replication_factor:type_name -> google.protobuf.Int64Value
	26, // 71: yandex.cloud.mdb.kafka.v1.KafkaConfig4.message_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 72: yandex.cloud.mdb.kafka.v1.KafkaConfig4.replica_fetch_max_bytes:type_name -> google.protobuf.Int64Value
	26, // 73: yandex.cloud.mdb.kafka.v1.KafkaConfig4.offsets_retention_minutes:type_name -> google.protobuf.Int64Value
	29, // 74: yandex.cloud.mdb.kafka.v1.KafkaConfig4.sasl_enabled_mechanisms:type_name -> yandex.cloud.mdb.kafka.v1.SaslMechanism
	3,  // 75: yandex.cloud.mdb.kafka.v1.Host.role:type_name -> yandex.cloud.mdb.kafka.v1.Host.Role
	8,  // 76: yandex.cloud.mdb.kafka.v1.Host.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	4,  // 77: yandex.cloud.mdb.kafka.v1.Host.health:type_name -> yandex.cloud.mdb.kafka.v1.Host.Health
	8,  // 78: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	9,  // 79: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.kafka_config_2_8:type_name -> yandex.cloud.mdb.kafka.v1.KafkaConfig2_8
	10, // 80: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.kafka_config_3:type_name -> yandex.cloud.mdb.kafka.v1.KafkaConfig3
	11, // 81: yandex.cloud.mdb.kafka.v1.ConfigSpec.Kafka.kafka_config_4:type_name -> yandex.cloud.mdb.kafka.v1.KafkaConfig4
	8,  // 82: yandex.cloud.mdb.kafka.v1.ConfigSpec.Zookeeper.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	8,  // 83: yandex.cloud.mdb.kafka.v1.ConfigSpec.KRaft.resources:type_name -> yandex.cloud.mdb.kafka.v1.Resources
	84, // [84:84] is the sub-list for method output_type
	84, // [84:84] is the sub-list for method input_type
	84, // [84:84] is the sub-list for extension type_name
	84, // [84:84] is the sub-list for extension extendee
	0,  // [0:84] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_kafka_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_kafka_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_kafka_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_kafka_v1_common_proto_init()
	file_yandex_cloud_mdb_kafka_v1_maintenance_proto_init()
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes[12].OneofWrappers = []any{
		(*ConfigSpec_Kafka_KafkaConfig_2_8)(nil),
		(*ConfigSpec_Kafka_KafkaConfig_3)(nil),
		(*ConfigSpec_Kafka_KafkaConfig_4)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_kafka_v1_cluster_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_kafka_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_kafka_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_kafka_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_kafka_v1_cluster_proto_depIdxs = nil
}
