// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/ai/assistants/v1/searchindex/search_index_service.proto

package searchindex

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SearchIndexService_Create_FullMethodName = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService/Create"
	SearchIndexService_Get_FullMethodName    = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService/Get"
	SearchIndexService_Update_FullMethodName = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService/Update"
	SearchIndexService_Delete_FullMethodName = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService/Delete"
	SearchIndexService_List_FullMethodName   = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService/List"
)

// SearchIndexServiceClient is the client API for SearchIndexService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// SearchIndexService provides operations for managing search indexes.
type SearchIndexServiceClient interface {
	// Create a new search index in [asynchronous mode](/docs/foundation-models/concepts/#working-mode).
	Create(ctx context.Context, in *CreateSearchIndexRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieve details of a specific search index by its ID.
	Get(ctx context.Context, in *GetSearchIndexRequest, opts ...grpc.CallOption) (*SearchIndex, error)
	// Update an existing search index.
	Update(ctx context.Context, in *UpdateSearchIndexRequest, opts ...grpc.CallOption) (*SearchIndex, error)
	// Delete a search index by its ID.
	Delete(ctx context.Context, in *DeleteSearchIndexRequest, opts ...grpc.CallOption) (*DeleteSearchIndexResponse, error)
	// List search indexes in a specific folder.
	List(ctx context.Context, in *ListSearchIndicesRequest, opts ...grpc.CallOption) (*ListSearchIndicesResponse, error)
}

type searchIndexServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchIndexServiceClient(cc grpc.ClientConnInterface) SearchIndexServiceClient {
	return &searchIndexServiceClient{cc}
}

func (c *searchIndexServiceClient) Create(ctx context.Context, in *CreateSearchIndexRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SearchIndexService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexServiceClient) Get(ctx context.Context, in *GetSearchIndexRequest, opts ...grpc.CallOption) (*SearchIndex, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SearchIndex)
	err := c.cc.Invoke(ctx, SearchIndexService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexServiceClient) Update(ctx context.Context, in *UpdateSearchIndexRequest, opts ...grpc.CallOption) (*SearchIndex, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SearchIndex)
	err := c.cc.Invoke(ctx, SearchIndexService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexServiceClient) Delete(ctx context.Context, in *DeleteSearchIndexRequest, opts ...grpc.CallOption) (*DeleteSearchIndexResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteSearchIndexResponse)
	err := c.cc.Invoke(ctx, SearchIndexService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexServiceClient) List(ctx context.Context, in *ListSearchIndicesRequest, opts ...grpc.CallOption) (*ListSearchIndicesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSearchIndicesResponse)
	err := c.cc.Invoke(ctx, SearchIndexService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchIndexServiceServer is the server API for SearchIndexService service.
// All implementations should embed UnimplementedSearchIndexServiceServer
// for forward compatibility.
//
// SearchIndexService provides operations for managing search indexes.
type SearchIndexServiceServer interface {
	// Create a new search index in [asynchronous mode](/docs/foundation-models/concepts/#working-mode).
	Create(context.Context, *CreateSearchIndexRequest) (*operation.Operation, error)
	// Retrieve details of a specific search index by its ID.
	Get(context.Context, *GetSearchIndexRequest) (*SearchIndex, error)
	// Update an existing search index.
	Update(context.Context, *UpdateSearchIndexRequest) (*SearchIndex, error)
	// Delete a search index by its ID.
	Delete(context.Context, *DeleteSearchIndexRequest) (*DeleteSearchIndexResponse, error)
	// List search indexes in a specific folder.
	List(context.Context, *ListSearchIndicesRequest) (*ListSearchIndicesResponse, error)
}

// UnimplementedSearchIndexServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSearchIndexServiceServer struct{}

func (UnimplementedSearchIndexServiceServer) Create(context.Context, *CreateSearchIndexRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedSearchIndexServiceServer) Get(context.Context, *GetSearchIndexRequest) (*SearchIndex, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSearchIndexServiceServer) Update(context.Context, *UpdateSearchIndexRequest) (*SearchIndex, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedSearchIndexServiceServer) Delete(context.Context, *DeleteSearchIndexRequest) (*DeleteSearchIndexResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedSearchIndexServiceServer) List(context.Context, *ListSearchIndicesRequest) (*ListSearchIndicesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSearchIndexServiceServer) testEmbeddedByValue() {}

// UnsafeSearchIndexServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SearchIndexServiceServer will
// result in compilation errors.
type UnsafeSearchIndexServiceServer interface {
	mustEmbedUnimplementedSearchIndexServiceServer()
}

func RegisterSearchIndexServiceServer(s grpc.ServiceRegistrar, srv SearchIndexServiceServer) {
	// If the following call panics, it indicates UnimplementedSearchIndexServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SearchIndexService_ServiceDesc, srv)
}

func _SearchIndexService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSearchIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexServiceServer).Create(ctx, req.(*CreateSearchIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexServiceServer).Get(ctx, req.(*GetSearchIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSearchIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexServiceServer).Update(ctx, req.(*UpdateSearchIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSearchIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexServiceServer).Delete(ctx, req.(*DeleteSearchIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchIndicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexServiceServer).List(ctx, req.(*ListSearchIndicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SearchIndexService_ServiceDesc is the grpc.ServiceDesc for SearchIndexService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SearchIndexService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.ai.assistants.v1.searchindex.SearchIndexService",
	HandlerType: (*SearchIndexServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _SearchIndexService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SearchIndexService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SearchIndexService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SearchIndexService_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SearchIndexService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/ai/assistants/v1/searchindex/search_index_service.proto",
}
