// © Broadcom. All Rights Reserved.
// The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
// SPDX-License-Identifier: Apache-2.0

package esx

import "github.com/vmware/govmomi/internal"

// TypeInfo generated via `govc host.esxcli.model -dump`
var TypeInfo = internal.DynamicTypeMgrAllTypeInfo{
	ManagedTypeInfo: []internal.DynamicTypeMgrManagedTypeInfo{
		{
			Name:     "vim.EsxCLI.hardware.clock",
			WsdlName: "VimEsxCLIhardwareclock",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLIhardwareclockget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "string",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLIhardwareclockset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "day",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "hour",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "min",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "month",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "sec",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "year",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.hardware.platform",
			WsdlName: "VimEsxCLIhardwareplatform",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLIhardwareplatformget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.hardware.platform.get.PlatformGet",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.iscsi.software",
			WsdlName: "VimEsxCLIiscsisoftware",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLIiscsisoftwareget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLIiscsisoftwareset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "enabled",
							Version:    "vim.version.version5",
							Type:       "boolean",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:    "name",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "string",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.allowedip",
			WsdlName: "VimEsxCLInetworkfirewallrulesetallowedip",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "add",
					WsdlName: "VimEsxCLInetworkfirewallrulesetallowedipadd",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "ipaddress",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "list",
					WsdlName: "VimEsxCLInetworkfirewallrulesetallowediplist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rulesetid",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.firewall.ruleset.allowedip.list.FirewallRulesetAllowedip[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "remove",
					WsdlName: "VimEsxCLInetworkfirewallrulesetallowedipremove",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "ipaddress",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.client",
			WsdlName: "VimEsxCLInetworkfirewallrulesetclient",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "add",
					WsdlName: "VimEsxCLInetworkfirewallrulesetclientadd",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "get",
					WsdlName: "VimEsxCLInetworkfirewallrulesetclientget",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.network.firewall.ruleset.client.get.FirewallRulesetClientGet",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "remove",
					WsdlName: "VimEsxCLInetworkfirewallrulesetclientremove",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.rule",
			WsdlName: "VimEsxCLInetworkfirewallrulesetrule",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "list",
					WsdlName: "VimEsxCLInetworkfirewallrulesetrulelist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rulesetid",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.firewall.ruleset.rule.list.FirewallPortRule[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset",
			WsdlName: "VimEsxCLInetworkfirewallruleset",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "list",
					WsdlName: "VimEsxCLInetworkfirewallrulesetlist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rulesetid",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.firewall.ruleset.list.Ruleset[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLInetworkfirewallrulesetset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "allowedall",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "enabled",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:       "rulesetid",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall",
			WsdlName: "VimEsxCLInetworkfirewall",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLInetworkfirewallget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.network.firewall.get.Firewall",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:          "load",
					WsdlName:      "VimEsxCLInetworkfirewallload",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:          "refresh",
					WsdlName:      "VimEsxCLInetworkfirewallrefresh",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLInetworkfirewallset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "defaultaction",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "enabled",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:          "unload",
					WsdlName:      "VimEsxCLInetworkfirewallunload",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.ip.connection",
			WsdlName: "VimEsxCLInetworkipconnection",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "list",
					WsdlName: "VimEsxCLInetworkipconnectionlist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "netstack",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "type",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.ip.connection.list.IpConnection[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.nic.ring.current",
			WsdlName: "VimEsxCLInetworknicringcurrent",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "get",
					WsdlName: "VimEsxCLInetworknicringcurrentget",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "nicname",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.network.nic.ring.current.get.RingInfo",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLInetworknicringcurrentset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "nicname",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:    "rx",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "rxjumbo",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "rxmini",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "tx",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.nic.ring.preset",
			WsdlName: "VimEsxCLInetworknicringpreset",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "get",
					WsdlName: "VimEsxCLInetworknicringpresetget",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "nicname",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.network.nic.ring.preset.get.RingInfo",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.vm.port",
			WsdlName: "VimEsxCLInetworkvmport",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "list",
					WsdlName: "VimEsxCLInetworkvmportlist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "worldid",
							Version:    "vim.version.version5",
							Type:       "long",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.vm.port.list.Port[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.vm",
			WsdlName: "VimEsxCLInetworkvm",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "list",
					WsdlName:      "VimEsxCLInetworkvmlist",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.network.vm.list.VM[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.signature",
			WsdlName: "VimEsxCLIsoftwarevibsignature",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "verify",
					WsdlName: "VimEsxCLIsoftwarevibsignatureverify",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rebootingimage",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.software.vib.signature.verify.VIBSigVerify[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib",
			WsdlName: "VimEsxCLIsoftwarevib",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "get",
					WsdlName: "VimEsxCLIsoftwarevibget",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rebootingimage",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "vibname",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.software.vib.get.VIBExt[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "install",
					WsdlName: "VimEsxCLIsoftwarevibinstall",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "depot",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "dryrun",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "force",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "maintenancemode",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "noliveinstall",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "nosigcheck",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "proxy",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "vibname",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "viburl",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.software.vib.install.InstallationResult",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "list",
					WsdlName: "VimEsxCLIsoftwareviblist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "rebootingimage",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.software.vib.list.VIBSummaryExt[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "remove",
					WsdlName: "VimEsxCLIsoftwarevibremove",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "dryrun",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "force",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "maintenancemode",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "noliveinstall",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:       "vibname",
							Version:    "vim.version.version5",
							Type:       "string[]",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.software.vib.remove.InstallationResult",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "update",
					WsdlName: "VimEsxCLIsoftwarevibupdate",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "depot",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "dryrun",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "force",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "maintenancemode",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "noliveinstall",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "nosigcheck",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "proxy",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "vibname",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "viburl",
							Version: "vim.version.version5",
							Type:    "string[]",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.software.vib.update.InstallationResult",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.system.hostname",
			WsdlName: "VimEsxCLIsystemhostname",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLIsystemhostnameget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "vim.EsxCLI.system.hostname.get.FullyQualifiedHostName",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLIsystemhostnameset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "domain",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "fqdn",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "host",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.system.settings.advanced",
			WsdlName: "VimEsxCLIsystemsettingsadvanced",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "add",
					WsdlName: "VimEsxCLIsystemsettingsadvancedadd",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "description",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:    "hidden",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "hostspecific",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "impact",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "intdefault",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "max",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "min",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:       "option",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:    "stringdefault",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:       "type",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "list",
					WsdlName: "VimEsxCLIsystemsettingsadvancedlist",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "delta",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "option",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "tree",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.system.settings.advanced.list.SettingsAdvancedOption[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "remove",
					WsdlName: "VimEsxCLIsystemsettingsadvancedremove",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "option",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:     "set",
					WsdlName: "VimEsxCLIsystemsettingsadvancedset",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:    "default",
							Version: "vim.version.version5",
							Type:    "boolean",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:    "intvalue",
							Version: "vim.version.version5",
							Type:    "long",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
						{
							Name:       "option",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:    "stringvalue",
							Version: "vim.version.version5",
							Type:    "string",
							PrivId:  "",
							Annotation: []internal.DynamicTypeMgrAnnotation{
								{
									Name:      "optional",
									Parameter: nil,
								},
							},
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.system.stats.uptime",
			WsdlName: "VimEsxCLIsystemstatsuptime",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:          "get",
					WsdlName:      "VimEsxCLIsystemstatsuptimeget",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "long",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.vm.process",
			WsdlName: "VimEsxCLIvmprocess",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.ManagedObject"},
			Property: nil,
			Method: []internal.DynamicTypeMgrMethodTypeInfo{
				{
					Name:     "kill",
					WsdlName: "VimEsxCLIvmprocesskill",
					Version:  "vim.version.version5",
					ParamTypeInfo: []internal.DynamicTypeMgrParamTypeInfo{
						{
							Name:       "type",
							Version:    "vim.version.version5",
							Type:       "string",
							PrivId:     "",
							Annotation: nil,
						},
						{
							Name:       "worldid",
							Version:    "vim.version.version5",
							Type:       "long",
							PrivId:     "",
							Annotation: nil,
						},
					},
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:       "result",
						Version:    "vim.version.version5",
						Type:       "boolean",
						PrivId:     "",
						Annotation: nil,
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
				{
					Name:          "list",
					WsdlName:      "VimEsxCLIvmprocesslist",
					Version:       "vim.version.version5",
					ParamTypeInfo: nil,
					ReturnTypeInfo: &internal.DynamicTypeMgrParamTypeInfo{
						Name:    "result",
						Version: "vim.version.version5",
						Type:    "vim.EsxCLI.vm.process.list.VirtualMachine[]",
						PrivId:  "",
						Annotation: []internal.DynamicTypeMgrAnnotation{
							{
								Name:      "optional",
								Parameter: nil,
							},
						},
					},
					Fault:      []string{"vim.EsxCLI.CLIFault"},
					PrivId:     "",
					Annotation: nil,
				},
			},
			Annotation: nil,
		},
	},
	EnumTypeInfo: nil,
	DataTypeInfo: []internal.DynamicTypeMgrDataTypeInfo{
		{
			Name:     "vim.EsxCLI.hardware.platform.get.PlatformGet",
			WsdlName: "VimEsxCLIhardwareplatformgetPlatformGet",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "BIOSAssetTag",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "EnclosureSerialNumber",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "IPMISupported",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ProductName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "SerialNumber",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "UUID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VendorName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.get.Firewall",
			WsdlName: "VimEsxCLInetworkfirewallgetFirewall",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DefaultAction",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Enabled",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Loaded",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.allowedip.list.FirewallRulesetAllowedip",
			WsdlName: "VimEsxCLInetworkfirewallrulesetallowediplistFirewallRulesetAllowedip",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "AllowedIPAddresses",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Ruleset",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.client.get.FirewallRulesetClientGet",
			WsdlName: "VimEsxCLInetworkfirewallrulesetclientgetFirewallRulesetClientGet",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "RulesetClientCount",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.list.Ruleset",
			WsdlName: "VimEsxCLInetworkfirewallrulesetlistRuleset",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "Enabled",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Name",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.firewall.ruleset.rule.list.FirewallPortRule",
			WsdlName: "VimEsxCLInetworkfirewallrulesetrulelistFirewallPortRule",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "Direction",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "PortBegin",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "PortEnd",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "PortType",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Protocol",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Ruleset",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.ip.connection.list.IpConnection",
			WsdlName: "VimEsxCLInetworkipconnectionlistIpConnection",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "CCAlgo",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ForeignAddress",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "LocalAddress",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Proto",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RecvQ",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "SendQ",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "State",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "WorldID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "WorldName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.nic.ring.current.get.RingInfo",
			WsdlName: "VimEsxCLInetworknicringcurrentgetRingInfo",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "RX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RXJumbo",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RXMini",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "TX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.nic.ring.preset.get.RingInfo",
			WsdlName: "VimEsxCLInetworknicringpresetgetRingInfo",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "MaxRX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MaxRXJumbo",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MaxRXMini",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MaxTX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RXJumbo",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RXMini",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "TX",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.vm.list.VM",
			WsdlName: "VimEsxCLInetworkvmlistVM",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "Name",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Networks",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "NumPorts",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "WorldID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.network.vm.port.list.Port",
			WsdlName: "VimEsxCLInetworkvmportlistPort",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "ActiveFilters",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "DVPortID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "IPAddress",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MACAddress",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "PortID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Portgroup",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "TeamUplink",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "UplinkPortID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "vSwitch",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.get.VIBExt",
			WsdlName: "VimEsxCLIsoftwarevibgetVIBExt",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "AcceptanceLevel",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Conflicts",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "CreationDate",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Depends",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Description",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "HardwarePlatformsRequired",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "ID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "InstallDate",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "LiveInstallAllowed",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "LiveRemoveAllowed",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MaintenanceModeRequired",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Name",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Overlay",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Payloads",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Platforms",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Provides",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "ReferenceURLs",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Replaces",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "StatelessReady",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Status",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Summary",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Tags",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Type",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Vendor",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Version",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.install.DpuInstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibinstallDpuInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.install.InstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibinstallInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUResults",
					Version:     "vim.version.version5",
					Type:        "vim.EsxCLI.software.vib.install.DpuInstallationResult[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.list.VIBSummaryExt",
			WsdlName: "VimEsxCLIsoftwareviblistVIBSummaryExt",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "AcceptanceLevel",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "CreationDate",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "InstallDate",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Name",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Platforms",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Status",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Vendor",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Version",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.remove.DpuInstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibremoveDpuInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.remove.InstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibremoveInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUResults",
					Version:     "vim.version.version5",
					Type:        "vim.EsxCLI.software.vib.remove.DpuInstallationResult[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.signature.verify.VIBSigVerify",
			WsdlName: "VimEsxCLIsoftwarevibsignatureverifyVIBSigVerify",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "AcceptanceLevel",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Name",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Platforms",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "SignatureVerification",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Vendor",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Version",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.update.DpuInstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibupdateDpuInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.software.vib.update.InstallationResult",
			WsdlName: "VimEsxCLIsoftwarevibupdateInstallationResult",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DPUResults",
					Version:     "vim.version.version5",
					Type:        "vim.EsxCLI.software.vib.update.DpuInstallationResult[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "Message",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "RebootRequired",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VIBsInstalled",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsRemoved",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
				{
					Name:        "VIBsSkipped",
					Version:     "vim.version.version5",
					Type:        "string[]",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation: []internal.DynamicTypeMgrAnnotation{
						{
							Name:      "optional",
							Parameter: nil,
						},
					},
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.system.hostname.get.FullyQualifiedHostName",
			WsdlName: "VimEsxCLIsystemhostnamegetFullyQualifiedHostName",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DomainName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "FullyQualifiedDomainName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "HostName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.system.settings.advanced.list.SettingsAdvancedOption",
			WsdlName: "VimEsxCLIsystemsettingsadvancedlistSettingsAdvancedOption",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "DefaultIntValue",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "DefaultStringValue",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Description",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "HostSpecific",
					Version:     "vim.version.version5",
					Type:        "boolean",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Impact",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "IntValue",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MaxValue",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "MinValue",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Path",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "StringValue",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "Type",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ValidCharacters",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
		{
			Name:     "vim.EsxCLI.vm.process.list.VirtualMachine",
			WsdlName: "VimEsxCLIvmprocesslistVirtualMachine",
			Version:  "vim.version.version5",
			Base:     []string{"vmodl.DynamicData"},
			Property: []internal.DynamicTypeMgrPropertyTypeInfo{
				{
					Name:        "ConfigFile",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "DisplayName",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "ProcessID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "UUID",
					Version:     "vim.version.version5",
					Type:        "string",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "VMXCartelID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
				{
					Name:        "WorldID",
					Version:     "vim.version.version5",
					Type:        "long",
					PrivId:      "",
					MsgIdFormat: "",
					Annotation:  nil,
				},
			},
			Annotation: nil,
		},
	},
}
