/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.udapi;

import com.ubnt.ace.o00O;
import com.ubnt.data.Account;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.Setting;
import com.ubnt.model.api.radius.DynamicRadiusGroupPolicy;
import com.ubnt.model.api.radius.RadiusGroupPolicy;
import com.ubnt.model.api.radius.StaticRadiusGroupPolicy;
import com.ubnt.net.null.super;
import com.ubnt.service.system.jA;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import com.ubnt.udapi.DA;
import com.ubnt.udapi.b;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class X
extends b {
    static final Logger \u00d2\u00d5\u00d6000 = jA.oo0000;
    private Setting doifObject;
    private final boolean \u00d3\u00d5\u00d6000;
    private List<com.ubnt.data.X> \u00d4\u00d5\u00d6000;
    private List<com.ubnt.data.X> O\u00d5\u00d6000;

    public X(Setting setting, List<NetworkConf> list, boolean bl) {
        this.doifObject = setting;
        this.\u00d3\u00d5\u00d6000 = bl;
        this.\u00d4\u00d5\u00d6000 = new ArrayList<com.ubnt.data.X>();
        this.O\u00d5\u00d6000 = new ArrayList<com.ubnt.data.X>();
        for (NetworkConf networkConf : list) {
            if (!networkConf.isLocalSiteNetwork()) continue;
            com.ubnt.data.X x2 = new com.ubnt.data.X("id", "client-" + networkConf.getString("_id"), "address", networkConf.getSubnet(), "secret", setting.getString("x_secret"));
            this.O\u00d5\u00d6000.add((com.ubnt.data.X)x2.makeImmutable());
        }
        this.O\u00d5\u00d6000 = Collections.unmodifiableList(this.O\u00d5\u00d6000);
    }

    public void \u00f40\u00f4000(List<Account> list) {
        for (Account account : list) {
            int n2;
            int n3;
            if (StringUtils.isBlank((CharSequence)account.getPassword()) || StringUtils.isBlank((CharSequence)account.getName())) {
                \u00d2\u00d5\u00d6000.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Skipping invalid RADIUS user {}.", (Object)account.getName());
                continue;
            }
            String string = account.getName();
            String string2 = account.getPassword();
            Optional<StaticRadiusGroupPolicy> optional = account.getGroupPolicy();
            String string3 = account.getString("tunnel_config_type", "custom");
            if ("vpn".equals(string3)) {
                n3 = 0;
                n2 = 0;
            } else if ("802.1x".equals(string3)) {
                n3 = 13;
                n2 = 6;
            } else {
                n3 = account.getInt("tunnel_type", 0);
                n2 = account.getInt("tunnel_medium_type", 0);
            }
            int n4 = account.getInt("vlan", 0);
            this.o0\u00f4000(string, string2, n3, n2, n4, optional.orElseGet(() -> this.newreturnString(account)), account.getFilterIds());
        }
    }

    private StaticRadiusGroupPolicy newreturnString(Account account) {
        String string = account.getName();
        String string2 = account.getPassword();
        boolean bl = super.\u00d600000(string) && StringUtils.equals((CharSequence)string, (CharSequence)string2);
        return bl ? StaticRadiusGroupPolicy.MAC_ACL : StaticRadiusGroupPolicy.GLOBAL;
    }

    public void o0\u00f4000(String string, String string2, int n2, int n3, int n4, @Nullable StaticRadiusGroupPolicy staticRadiusGroupPolicy, List<String> list) {
        com.ubnt.data.X x2 = new com.ubnt.data.X();
        x2.put("username", (Object)string);
        x2.put("password", (Object)string2);
        if (n4 > 0) {
            x2.put("vlan", (Object)n4);
        }
        if (n2 > 0) {
            x2.put("tunnelType", (Object)n2);
        }
        if (n3 > 0) {
            x2.put("tunnelMediumType", (Object)n3);
        }
        x2.putIfNotEmpty("policyGroupNames", this.\u00d80\u00f4000(staticRadiusGroupPolicy, list));
        this.\u00d4\u00d5\u00d6000.add(x2);
    }

    public List<com.ubnt.data.X> O0\u00f4000() {
        return this.O\u00d5\u00d6000;
    }

    @Override
    public com.ubnt.data.X generate() {
        com.ubnt.data.X x2 = new com.ubnt.data.X("enabled", true, "authPort", this.doifObject.getInt("auth_port", 1812), "acctPort", this.doifObject.getInt("acct_port", 1813));
        String string = this.doifObject.getString("server_certificate");
        String string2 = this.doifObject.getString("server_certificate_key");
        String string3 = this.doifObject.getString("ca_certificate");
        boolean bl = StringUtils.isNotEmpty((CharSequence)string);
        boolean bl2 = StringUtils.isNotEmpty((CharSequence)string2);
        boolean bl3 = StringUtils.isNotEmpty((CharSequence)string3);
        if (bl && bl2 && bl3) {
            x2.put("serverCertificate", (Object)new com.ubnt.data.X("crt", string, "key", string2));
            x2.put("caCertificate", (Object)new com.ubnt.data.X("crt", string3));
        } else if (bl || bl2 || bl3) {
            \u00d2\u00d5\u00d6000.warn("RADIUS Server configuration has either server_certificate, server_certificate_key or ca_certificate set, but all of them are mandatory or none of them");
        }
        String string4 = this.doifObject.getString("dh_key");
        if (StringUtils.isNotEmpty((CharSequence)string4)) {
            x2.put("dhKey", (Object)string4);
        }
        if (this.doifObject.containsField("interim_update_interval")) {
            x2.put("acctInterimInterval", (Object)this.doifObject.getInt("interim_update_interval", 600));
        }
        x2.put("tunneledReply", (Object)this.doifObject.is("tunneled_reply", false));
        x2.put("secret", (Object)this.doifObject.getString("x_secret"));
        x2.put("users", this.\u00d4\u00d5\u00d6000);
        x2.put("clients", this.O\u00d5\u00d6000);
        if (this.\u00d3\u00d5\u00d6000) {
            x2.put("policyGroups", this.\u00d40\u00f4000());
        }
        return x2;
    }

    private List<String> \u00d80\u00f4000(@Nullable StaticRadiusGroupPolicy staticRadiusGroupPolicy, List<String> list) {
        if (!this.\u00d3\u00d5\u00d6000) {
            return List.of();
        }
        Stream<String> stream = Optional.ofNullable(staticRadiusGroupPolicy).map(Enum::toString).stream();
        Stream stream2 = list.stream();
        return Stream.concat(stream, stream2).toList();
    }

    private List<com.ubnt.data.X> \u00d40\u00f4000() {
        Stream<StaticRadiusGroupPolicy> stream = Stream.of(StaticRadiusGroupPolicy.values());
        Stream<RadiusGroupPolicy> stream2 = this.\u00d4\u00d5\u00d6000.stream().map(x2 -> x2.getStringList("policyGroupNames")).flatMap(Collection::stream).filter(string -> o00O.\u00d4O0000(StaticRadiusGroupPolicy.class, string).isEmpty()).distinct().map(DynamicRadiusGroupPolicy::new);
        return Stream.concat(stream, stream2).map(radiusGroupPolicy -> new DA(radiusGroupPolicy.name(), radiusGroupPolicy.getFilterIds()).generate()).toList();
    }
}

