/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.network;

import com.ubnt.ace.api.classsuper;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.X;
import com.ubnt.service.network.configuration.Object;
import com.ubnt.service.orchestration.template.TemplateConfigSyncService;
import com.ubnt.service.orchestration.template.TemplateRemoveHandler;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;

public class NetworkTemplateTypeRemoveHandler
implements TemplateRemoveHandler {
    private static final Logger LOGGER = jA.\u00f6\u00d20000;
    private final Object networkConfigService;
    private final TemplateConfigSyncService templateConfigSyncService;
    private final classsuper referencesRemoveExecutor;

    @Override
    public void remove(String string, String string2) {
        this.templateConfigSyncService.writeInLock(() -> this.dropConfigs(string, string2), NetworkConf.class);
    }

    public void dropConfigs(String string, String string2) {
        try {
            List<NetworkConf> list = this.networkConfigService.\u00d4o0000(string, networkConf -> Objects.equals(networkConf.getCloudOrchestrationId(), string2));
            if (list.isEmpty()) {
                LOGGER.warn("No Network configurations found for orchestrationId: {} in siteId: {}", (java.lang.Object)string2, (java.lang.Object)string);
            } else {
                list.forEach(networkConf -> this.referencesRemoveExecutor.\u00d800000(string, NetworkConf.class, (X)networkConf, true));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to remove Network configurations for orchestrationId: {} in siteId: {} due to exception: {}", new java.lang.Object[]{string2, string, exception.getMessage(), exception});
        }
    }

    @Override
    public TemplateType getType() {
        return TemplateType.NETWORK;
    }

    @ConstructorProperties(value={"networkConfigService", "templateConfigSyncService", "referencesRemoveExecutor"})
    @Generated
    public NetworkTemplateTypeRemoveHandler(Object object, TemplateConfigSyncService templateConfigSyncService, classsuper classsuper2) {
        this.networkConfigService = object;
        this.templateConfigSyncService = templateConfigSyncService;
        this.referencesRemoveExecutor = classsuper2;
    }
}

