/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.config.ubios.ospf;

import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.ospf.OspfAuthenticationType;
import com.ubnt.net.return.H;
import com.ubnt.service.ospf.OspfRouterDocument;
import com.ubnt.service.system.jA;
import com.ubnt.udapi.L.C.oOoO;
import com.ubnt.udapi.O;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class do {
    private static final Logger o00000 = jA.oo0000;

    public List<oOoO> \u00d600000(OspfRouterDocument ospfRouterDocument, List<NetworkConf> list) {
        return ospfRouterDocument.getAreas().stream().map(ospfAreaDocumentPart -> oOoO.\u00f8o\u00d6000().new(ospfAreaDocumentPart.getAreaId()).o00000(ospfAreaDocumentPart.getAreaType()).\u00d400000(OspfAuthenticationType.OFF).\u00d300000(ospfAreaDocumentPart.getNetworkIds().stream().flatMap(string -> this.class((String)string, list).stream()).flatMap(this::\u00f600000).toList()).\u00f500000()).filter(oOoO2 -> !oOoO2.O\u00d2\u00d6000().isEmpty()).toList();
    }

    private Optional<NetworkConf> class(String string, List<NetworkConf> list) {
        return list.stream().filter(networkConf -> StringUtils.equals((CharSequence)string, (CharSequence)networkConf.getId())).findAny().or(() -> {
            o00000.warn("Missing network '{}' assigned to an OSPF Area", (Object)string);
            return Optional.empty();
        });
    }

    private Stream<O> \u00f600000(NetworkConf networkConf) {
        if (networkConf.isLocalSiteNetwork() || networkConf.isOpenVpnServer() || networkConf.isWireguardClientOrServer()) {
            return Stream.of(O.\u00d300000(networkConf.getSubnet()));
        }
        if (networkConf.isWanNetwork() && networkConf.isStaticWan()) {
            return Stream.concat(do.int(networkConf).stream(), networkConf.getWanIpAliases().stream()).flatMap(this::\u00f800000).distinct().map(O::\u00d300000);
        }
        if (networkConf.isOpenVpnClientNetwork()) {
            return Optional.ofNullable(networkConf.getIpSubnetOrNull()).map(O::\u00d300000).or(() -> {
                o00000.warn("OpenVPN Client '{}' configured to be used in OSPF Area, but IP is missing. OpenVPN Client Client needs to establish successful connection first", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        if (this.\u00d400000(networkConf)) {
            return networkConf.getIpsecTunnelIp().map(H::o00000).map(O::\u00d300000).or(() -> {
                o00000.warn("IPSec Site to Site VPN '{}' configured to be used in OSPF Area, but Tunnel IP is missing", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        o00000.warn("Cannot build OSPF Area for network '{}', purpose: '{}'", (Object)networkConf.getId(), (Object)networkConf.getNetworkPurpose());
        return Stream.empty();
    }

    private static Optional<String> int(NetworkConf networkConf) {
        return networkConf.getWanIp().flatMap(string -> {
            String string2 = networkConf.getWanNetmask().orElse("255.255.255.0");
            return H.oO0000(string, string2);
        }).or(() -> {
            o00000.warn("Cannot build OSPF Area for WAN network: '{}', ip: '{}', netmask: '{}'", new Object[]{networkConf.getId(), networkConf.getWanIp().orElse(null), networkConf.getWanNetmask().orElse(null)});
            return Optional.empty();
        });
    }

    private boolean \u00d400000(NetworkConf networkConf) {
        return networkConf.isSiteIpsecVpnNetwork() && networkConf.isIpsecDynamicRouting() && networkConf.isIpsecTunnelIpEnabled() && networkConf.isRemoteVpnDynamicSubnetsEnabled();
    }

    private Stream<String> \u00f800000(String string) {
        try {
            return Stream.of(H.o00000(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            o00000.warn("Cannot build OSPF area for subnet '{}'", (Object)string);
            return Stream.empty();
        }
    }
}

