/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.object.oriented.network;

import com.ubnt.ace.U;
import com.ubnt.ace.ooOO;
import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.IpVersion;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkConfigDto;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkSecureMode;
import com.ubnt.model.api.trafficroute.TrafficRouteMatchingTarget;
import com.ubnt.model.schedule.ScheduleDocumentPart;
import com.ubnt.model.schedule.ScheduleDto;
import com.ubnt.net.null.super;
import com.ubnt.net.v2.object.oriented.network.ObjectOrientedNetworkDocumentConverter;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigField;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigState;
import com.ubnt.service.firewall.Object;
import com.ubnt.service.firewall.o0OO;
import com.ubnt.service.firewall.policy.OO0O;
import com.ubnt.service.firewall.policy.a;
import com.ubnt.service.firewall.policy.zone.A;
import com.ubnt.service.firewall.qos.A.J;
import com.ubnt.service.firewall.qos.A.OooO;
import com.ubnt.service.firewall.qos.B;
import com.ubnt.service.firewall.qos.G;
import com.ubnt.service.firewall.qos.destination.FirewallQosDestinationWebDocumentPart;
import com.ubnt.service.firewall.qos.int;
import com.ubnt.service.firewall.qos.public;
import com.ubnt.service.object.oriented.network.ObjectOrientedNetworkConfigDocument;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.R;
import com.ubnt.service.switchacl.super.K;
import com.ubnt.service.switchacl.super.oo0O;
import com.ubnt.service.system.jA;
import com.ubnt.service.traffic.C;
import com.ubnt.service.traffic.TrafficDomainDocumentPart;
import com.ubnt.service.traffic.TrafficIpDocumentPart;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectOrientedNetworkConfigValidator {
    private static final Logger OO0000 = jA.oo0000;
    public static final int IPSET_MAX_SIZE = 10000;
    public static final int APPS_MAX_SIZE = 100;
    private final com.ubnt.service.firewall.policy.Object \u00d600000;
    private final Object \u00d300000;
    private final a do;
    private final A int;
    private final com.ubnt.service.trafficroute.Object \u00f600000;
    private final C class;
    private final G \u00f400000;
    private final B \u00d400000;
    private final R super;
    private final com.ubnt.service.object.oriented.network.String \u00f800000;
    private final o0OO \u00d800000;
    private final com.ubnt.service.network.configuration.Object \u00d200000;

    public void validate(String string, ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        this.returnsuper(objectOrientedNetworkConfigDto);
        this.newsuper(string, objectOrientedNetworkConfigDto.qos());
        this.\u00d2O0000(string, objectOrientedNetworkConfigDto.route());
        this.for(string, objectOrientedNetworkConfigDto.secure());
        this.\u00d300000(ObjectOrientedNetworkDocumentConverter.toDocument(string, objectOrientedNetworkConfigDto));
    }

    private void returnsuper(ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        List<String> list = objectOrientedNetworkConfigDto.targets();
        switch (objectOrientedNetworkConfigDto.targetType()) {
            case CLIENTS: {
                if (!list.stream().anyMatch(string -> !com.ubnt.net.null.super.\u00d200000(string, false))) break;
                throw new InvalidObjectOrientedNetworkConfigField("Not all clients are valid mac in 'targets'", "targets");
            }
        }
    }

    private void newsuper(String string, @Nullable ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        if (qosDto == null || !qosDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)qosDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d500000(qosDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(qosDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.oO0000(qosDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(qosDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d500000(qosDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(qosDto.domains()) || ObjectOrientedNetworkConfigValidator.oO0000(qosDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(qosDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for qos");
        }
        this.\u00d8O0000("qos.domains", string, qosDto.domains());
        this.\u00f800000(qosDto, string);
        this.o00000(qosDto);
        this.\u00d3O0000("qos.apps", qosDto.apps());
        this.\u00d2o0000("qos.regions", qosDto.regions());
        this.\u00f6O0000("qos.ip_addresses", qosDto.ipAddresses());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(qosDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d800000.return(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.schedule' field", "qos.schedule");
            }
        }
    }

    private void \u00d2O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        if (routeDto == null || !routeDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d500000(routeDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.oO0000(routeDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d500000(routeDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.domains()) || ObjectOrientedNetworkConfigValidator.oO0000(routeDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for route");
        }
        NetworkConf networkConf = this.\u00d800000(routeDto, string);
        this.private("route.domains", string, routeDto.domains());
        this.\u00d5O0000("route.ip_addresses", networkConf, routeDto);
        this.\u00d2o0000("route.regions", routeDto.regions());
        ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList = routeDto.apps();
        if (integerValuesList != null && integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Route doesn't support applications", "route.apps");
        }
    }

    private void for(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto secureDto) {
        if (secureDto == null || !secureDto.enabled().booleanValue()) {
            return;
        }
        this.\u00d6O0000(secureDto.internet());
        this.null(string, secureDto.local());
    }

    private void \u00d300000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        if (objectOrientedNetworkConfigDocument.isSecureEnabled()) {
            this.\u00d200000(objectOrientedNetworkConfigDocument);
        }
    }

    private void \u00d200000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        List<NetworkConf> list = this.\u00d200000.int(objectOrientedNetworkConfigDocument.siteId());
        List<AclRuleDocument> list2 = this.\u00f800000.o00000(objectOrientedNetworkConfigDocument, list);
        try {
            this.super.\u00d4O0000(objectOrientedNetworkConfigDocument.siteId(), objectOrientedNetworkConfigDocument, list2, list);
        }
        catch (K k2) {
            throw oo0O.\u00d800000(k2);
        }
    }

    private void \u00d6O0000(@Nullable ObjectOrientedNetworkConfigDto.SecureDto.InternetSectionDto internetSectionDto) {
        if (internetSectionDto == null) {
            return;
        }
        switch (internetSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case TURN_OFF_INTERNET: {
                break;
            }
            default: {
                String string = "secure.internet.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = internetSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.TURN_OFF_INTERNET) {
            if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.\u00d500000(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.oO0000(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'TURN_OFF_INTERNET' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d500000(internetSectionDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.apps cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.domains cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.oO0000(internetSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.regions cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d500000(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.oO0000(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(internetSectionDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.internet");
        }
        this.\u00d3O0000("secure.internet.apps", internetSectionDto.apps());
        this.\u00f600000("secure.internet.domains", internetSectionDto.domains());
        this.\u00f6O0000("secure.internet.ip_addresses", internetSectionDto.ipAddresses());
        this.\u00d2o0000("secure.internet.regions", internetSectionDto.regions());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(internetSectionDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d800000.return(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'internet.schedule' field", "internet.schedule");
            }
        }
    }

    private void null(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto.LocalSectionDto localSectionDto) {
        if (localSectionDto == null) {
            return;
        }
        switch (localSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case QUARANTINE: {
                break;
            }
            default: {
                String string2 = "secure.local.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = localSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.QUARANTINE) {
            if (BooleanUtils.isTrue((Boolean)localSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.String(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.oO0000(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.String(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'QUARANTINE' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)localSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.String(localSectionDto.devices())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.devices cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(localSectionDto.networks())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.networks cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.oO0000(localSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.String(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.mac_addresses cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.String(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.\u00f5O0000(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.oO0000(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.String(localSectionDto.macAddresses()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.local");
        }
        this.\u00d600000("secure.local.devices", localSectionDto.devices());
        this.\u00d8o0000("secure.local.networks", string, localSectionDto.networks());
        this.\u00f6O0000("secure.local.ip_addresses", localSectionDto.ipAddresses());
    }

    private void \u00f6O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.new(list, com.ubnt.service.firewall.B.Object, com.ubnt.service.firewall.policy.R.class);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void \u00d5O0000(String string, NetworkConf networkConf, ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList = routeDto.ipAddresses();
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            List<TrafficIpDocumentPart> list2 = ObjectOrientedNetworkConfigValidator.oo0000(list);
            try {
                this.\u00f600000.OO0000(networkConf, list2, List.of(), TrafficRouteMatchingTarget.IP);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void \u00d2o0000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.class.dosuper(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d8O0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            FirewallQosDestinationWebDocumentPart firewallQosDestinationWebDocumentPart = FirewallQosDestinationWebDocumentPart.builder().String(list).for(com.ubnt.service.firewall.qos.int.return).\u00d300000(OO0O.String).null();
            try {
                this.\u00d400000.\u00f800000(firewallQosDestinationWebDocumentPart, string2);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00f800000(ObjectOrientedNetworkConfigDto.QosDto qosDto, String string) {
        String string2 = qosDto.networkId();
        try {
            this.\u00f400000.\u00d3O0000(string2, string);
        }
        catch (OooO oooO2) {
            OO0000.warn(oooO2.getMessage(), (Throwable)oooO2);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.network_id'", "qos.network_id");
        }
    }

    private void o00000(ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        public public_ = qosDto.mode().qosRuleObjective();
        Integer n2 = U.\u00f8O0000(qosDto.downloadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        Integer n3 = U.\u00f8O0000(qosDto.uploadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        try {
            this.\u00f400000.\u00d200000(public_, n2, n3);
        }
        catch (J j2) {
            OO0000.warn(j2.getMessage(), (Throwable)j2);
            throw new InvalidObjectOrientedNetworkConfigField(j2.getMessage(), "qos.download_limit|qos.upload_limit");
        }
    }

    private void private(String string2, String string3, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string2), string2);
            }
            List<TrafficDomainDocumentPart> list2 = list.stream().map(string -> TrafficDomainDocumentPart.builder().OO0000((String)string).return()).toList();
            try {
                this.class.\u00d4o0000(string3, list2);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string2), string2);
        }
    }

    private void \u00f600000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.OO0000(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d3O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        if (integerValuesList == null) {
            return;
        }
        List<Integer> list = integerValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 100) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many apps in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.\u00f4O0000(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d8o0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            List<com.ubnt.service.firewall.policy.zone.C> list2 = this.int.\u00d500000(this.\u00d600000.\u00d3O0000(string2));
            if (list2.isEmpty()) {
                throw new InvalidObjectOrientedNetworkConfigState("No any available firewall zones to configure networks");
            }
            HashMap<com.ubnt.service.firewall.policy.zone.C, Set> hashMap = new HashMap<com.ubnt.service.firewall.policy.zone.C, Set>();
            for (String object : list) {
                com.ubnt.service.firewall.policy.zone.C c3 = list2.stream().filter(c2 -> c2.\u00d600000().contains(object)).findFirst().orElseThrow(() -> new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string));
                hashMap.computeIfAbsent(c3, c2 -> new HashSet()).add(object);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                try {
                    this.do.null((Set)entry.getValue(), (com.ubnt.service.firewall.policy.zone.C)entry.getKey());
                }
                catch (RuntimeException runtimeException) {
                    OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                    throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
                }
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d600000(String string, @Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        if (macAddressesValuesList == null) {
            return;
        }
        List<String> list = macAddressesValuesList.values();
        if (macAddressesValuesList.enabled().booleanValue() && list.isEmpty()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private NetworkConf \u00d800000(ObjectOrientedNetworkConfigDto.RouteDto routeDto, String string) {
        String string2 = "route.network_id";
        String string3 = routeDto.networkId();
        if (StringUtils.isBlank((CharSequence)string3)) {
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
        Set<TrafficRouteMatchingTarget> set = ObjectOrientedNetworkConfigValidator.ifsuper(routeDto);
        try {
            return this.\u00f600000.\u00d600000(string, string3, set);
        }
        catch (RuntimeException runtimeException) {
            OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
    }

    private static boolean \u00f5O0000(@Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        return stringValuesList != null && stringValuesList.enabled() != false;
    }

    private static boolean oO0000(@Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        return ipAddressesValuesList != null && ipAddressesValuesList.enabled() != false;
    }

    private static boolean String(@Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        return macAddressesValuesList != null && macAddressesValuesList.enabled() != false;
    }

    private static boolean \u00d500000(@Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        return integerValuesList != null && integerValuesList.enabled() != false;
    }

    private static Set<TrafficRouteMatchingTarget> ifsuper(ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        HashSet<TrafficRouteMatchingTarget> hashSet = new HashSet<TrafficRouteMatchingTarget>();
        if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.domains())) {
            hashSet.add(TrafficRouteMatchingTarget.DOMAIN);
        }
        if (ObjectOrientedNetworkConfigValidator.oO0000(routeDto.ipAddresses())) {
            hashSet.add(TrafficRouteMatchingTarget.IP);
        }
        if (ObjectOrientedNetworkConfigValidator.\u00f5O0000(routeDto.regions())) {
            hashSet.add(TrafficRouteMatchingTarget.REGION);
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            hashSet.add(TrafficRouteMatchingTarget.INTERNET);
        }
        return hashSet;
    }

    private static List<TrafficIpDocumentPart> oo0000(List<String> list) {
        return list.stream().map(string -> TrafficIpDocumentPart.builder().\u00d200000(ooOO.\u00f8\u00d40000(string) || ooOO.class(string) ? IpVersion.V6 : IpVersion.V4).\u00d300000((String)string).class()).toList();
    }

    @ConstructorProperties(value={"firewallPolicyValidator", "firewallSourceDestinationValidationUtils", "firewallPolicySourceDestinationValidationUtils", "firewallZoneMatchingTargetUtils", "trafficRouteValidator", "trafficValidator", "qosRuleValidator", "destinationQosValidator", "aclRuleValidator", "objectOrientedNetworkAclRulesFactory", "firewallScheduleValidator", "networkConfigService"})
    @Generated
    public ObjectOrientedNetworkConfigValidator(com.ubnt.service.firewall.policy.Object object, Object object2, a a2, A a3, com.ubnt.service.trafficroute.Object object3, C c2, G g2, B b2, R r2, com.ubnt.service.object.oriented.network.String string, o0OO o0OO2, com.ubnt.service.network.configuration.Object object4) {
        this.\u00d600000 = object;
        this.\u00d300000 = object2;
        this.do = a2;
        this.int = a3;
        this.\u00f600000 = object3;
        this.class = c2;
        this.\u00f400000 = g2;
        this.\u00d400000 = b2;
        this.super = r2;
        this.\u00f800000 = string;
        this.\u00d800000 = o0OO2;
        this.\u00d200000 = object4;
    }
}

