/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.notification;

import com.ubnt.data.Site;
import com.ubnt.model.api.notification.NotificationDto;
import com.ubnt.net.security.G;
import com.ubnt.net.security.role.B;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.net.v2.notification.MissingPrincipalCredentials;
import com.ubnt.service.notification.NotificationDocument;
import com.ubnt.service.notification.Object;
import com.ubnt.service.notification.String;
import com.ubnt.service.notification.oOOO;
import com.ubnt.service.system.O00Oo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Notifications")
public class NotificationController {
    private static final java.lang.String \u00d500000 = "admin_id";
    private final oOOO String;
    private final G \u00d200000;
    private final B \u00d300000;
    private final O00Oo o00000;

    public NotificationController(oOOO oOOO2, G g2, B b2, O00Oo o00Oo2) {
        this.String = oOOO2;
        this.\u00d200000 = g2;
        this.\u00d300000 = b2;
        this.o00000 = o00Oo2;
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/site/{siteName}/notifications"})
    @Operation(summary="Get all  site and controller scope notifications for admin")
    public List<NotificationDto> getAdminNotificationsByScope(@PathVariable(value="siteName") Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        java.lang.String string = this.null(httpServletRequest, httpServletResponse);
        boolean bl = this.\u00d300000.\u00d200000(httpServletRequest, httpServletResponse, site.getId());
        return this.String.\u00d600000(string).stream().filter(notificationDocument -> com.ubnt.service.notification.String.\u00d200000 == notificationDocument.getScope() || site.getId().equals(notificationDocument.getSiteId())).map(NotificationDto::fromDocument).filter(notificationDto -> this.\u00d200000(bl, (NotificationDto)notificationDto)).collect(Collectors.toList());
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/notifications/{name}"})
    @Operation(summary="Find one notification for admin by notification name, scope and site id")
    public NotificationDto getAdminNotification(@PathVariable java.lang.String string, @RequestParam(value="scope") String string2, @RequestParam(value="site_name", required=false) Site site, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        java.lang.String string3 = this.null(httpServletRequest, httpServletResponse);
        java.lang.String string4 = site == null ? null : site.getId();
        Object object = new Object().\u00d200000(string).\u00d800000(string3).o00000(string2).\u00d600000(string4);
        NotificationDocument notificationDocument = this.String.class(object);
        return NotificationDto.fromDocument(notificationDocument);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PostMapping(value={"/api/notifications"})
    @Operation(summary="Create a notification for admin")
    public NotificationDto createNotification(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        java.lang.String string = this.null(httpServletRequest, httpServletResponse);
        java.lang.String string2 = this.\u00d300000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).\u00f500000().\u00d600000();
        NotificationDocument notificationDocument2 = this.String.super(notificationDocument);
        return NotificationDto.fromDocument(notificationDocument2);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PutMapping(value={"/api/notifications"})
    @Operation(summary="Update admins notification")
    public NotificationDto updateNotification(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        java.lang.String string = this.null(httpServletRequest, httpServletResponse);
        java.lang.String string2 = this.\u00d300000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).\u00d600000();
        NotificationDocument notificationDocument2 = this.String.\u00d400000(notificationDocument);
        return NotificationDto.fromDocument(notificationDocument2);
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @PostMapping(value={"/api/notifications/dismiss-global"})
    @Operation(summary="Dismiss all related notifications")
    public List<NotificationDto> dismissRelatedNotifications(@Valid @RequestBody NotificationDto notificationDto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        java.lang.String string = this.null(httpServletRequest, httpServletResponse);
        java.lang.String string2 = this.\u00d300000(notificationDto);
        NotificationDocument notificationDocument = notificationDto.toDocumentBuilder(string, string2).\u00f500000().\u00d600000();
        List<NotificationDocument> list = this.String.\u00f400000(notificationDocument);
        return list.stream().map(NotificationDto::fromDocument).collect(Collectors.toList());
    }

    private java.lang.String null(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.\u00d200000.o00000(httpServletRequest, httpServletResponse).map(x2 -> x2.getString(\u00d500000)).orElseThrow(() -> new MissingPrincipalCredentials(new java.lang.String[]{\u00d500000}));
    }

    private java.lang.String \u00d300000(NotificationDto notificationDto) {
        return notificationDto.getSiteId().orElseGet(this.String(notificationDto));
    }

    private Supplier<java.lang.String> String(NotificationDto notificationDto) {
        return () -> notificationDto.getSiteName().map(this.o00000::newsuper).orElse(null);
    }

    private boolean \u00d200000(boolean bl, NotificationDto notificationDto) {
        return BooleanUtils.isNotTrue((Boolean)notificationDto.isGlobal()) || bl;
    }
}

