/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.lan;

import com.ubnt.data.Site;
import com.ubnt.model.api.lan.EnableLteFailoverRequest;
import com.ubnt.model.api.lan.EnrichedLanConfiguration;
import com.ubnt.model.api.lan.LanConfigurationDto;
import com.ubnt.model.api.lan.MigrateNetworkToLayer3Request;
import com.ubnt.model.api.lan.MulticastDnsServiceDto;
import com.ubnt.net.security.role.B;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.lan.configuration.o0OO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Validated
@V2RestController
@Tag(name="LAN Configuration")
public class LanConfigurationController {
    private final com.ubnt.service.lan.configuration.B \u00d300000;
    private final B super;
    private final o0OO \u00d200000;

    public LanConfigurationController(com.ubnt.service.lan.configuration.B b2, B b3, o0OO o0OO2) {
        this.\u00d300000 = b2;
        this.super = b3;
        this.\u00d200000 = o0OO2;
    }

    @Operation(summary="Get default LAN Network settings", description="Since 6.6.31")
    @GetMapping(value={"/api/site/{siteName}/lan/defaults"})
    public LanConfigurationDto getDefaults(@PathVariable(value="siteName") Site site) {
        return LanConfigurationDto.ofLegacy(this.\u00d300000.\u00d500000());
    }

    @Operation(summary="Get pre-defined Multicast DNS services list")
    @GetMapping(value={"/api/site/{siteName}/lan/mdns"})
    public List<MulticastDnsServiceDto> getPredefineMulticastDnsServices(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.o00000().stream().map(MulticastDnsServiceDto::from).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/lan/enriched-configuration"})
    public List<EnrichedLanConfiguration> getConfigurations(@PathVariable(value="siteName") Site site) {
        return this.\u00d300000.void(site.getId());
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Batch enable LTE failover for LANs, disable for other LANs")
    @PutMapping(value={"/api/site/{siteName}/lan/enable-lte-failover"})
    public void enableLteFailoverForNetworks(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @RequestBody @Valid EnableLteFailoverRequest enableLteFailoverRequest) {
        this.super.\u00d600000(httpServletRequest, httpServletResponse, site.getId());
        this.\u00d300000.\u00d400000(site.getId(), enableLteFailoverRequest.networkIds());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Migrate Local Network to Layer3 Network", description="Since 7.2.45")
    @PostMapping(value={"/api/site/{siteName}/lan/migrate-to-layer3/{networkConfId}"})
    public EnrichedLanConfiguration migrateNetworkToLayer3(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @PathVariable(value="networkConfId") String string, @RequestBody @Valid MigrateNetworkToLayer3Request migrateNetworkToLayer3Request) {
        this.super.\u00d600000(httpServletRequest, httpServletResponse, site.getId());
        return this.\u00d300000.float(site.getId(), string, migrateNetworkToLayer3Request.gatewayDevice());
    }
}

