/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.ucore;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OOoO.B;
import com.ubnt.model.ucore.ImmutableUcoreDiscoveredDeviceDto;
import com.ubnt.model.ucore.UcoreDiscoveredDeviceAddressDto;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableUcoreDiscoveredDeviceDto.Builder.class)
@B
@Value.Immutable
public interface UcoreDiscoveredDeviceDto {
    @JsonProperty(value="discoveredIp")
    public String discoveredIp();

    @JsonProperty(value="discoveryVersion")
    public Integer discoveryVersion();

    @JsonProperty(value="mac")
    public Optional<String> mac();

    @JsonProperty(value="ip")
    public Optional<String> ip();

    @JsonProperty(value="ethMac")
    public Optional<String> ethMac();

    @JsonProperty(value="firmware")
    public Optional<String> firmware();

    @JsonProperty(value="platform")
    public Optional<String> platform();

    @JsonProperty(value="model")
    public Optional<String> model();

    @JsonProperty(value="hostname")
    public Optional<String> hostname();

    @JsonProperty(value="essId")
    public Optional<String> essId();

    @JsonProperty(value="wmode")
    public Optional<Integer> wmode();

    @JsonProperty(value="uptime")
    public Optional<Integer> uptime();

    @JsonProperty(value="swVersion")
    public Optional<String> swVersion();

    @JsonProperty(value="isManaged")
    public Optional<Boolean> isManaged();

    @JsonProperty(value="isLocating")
    public Optional<Boolean> isLocating();

    @JsonProperty(value="isUsingDhcpc")
    public Optional<Boolean> isUsingDhcpc();

    @JsonProperty(value="isDhcpcBound")
    public Optional<Boolean> isDhcpcBound();

    @JsonProperty(value="sysid")
    public Optional<String> sysIdString();

    @JsonProperty(value="seq")
    public Optional<Integer> seq();

    @JsonProperty(value="requiredFwVersion")
    public Optional<String> requiredFwVersion();

    @JsonProperty(value="src_macid")
    public Optional<String> srcMacId();

    @JsonProperty(value="dev_hashid")
    public Optional<String> hashId();

    @JsonProperty(value="dev_anonid")
    public Optional<String> anonymousId();

    @JsonProperty(value="guid")
    public Optional<String> guid();

    @JsonProperty(value="netmask")
    public List<String> netmask();

    @JsonProperty(value="deviceDefaultCredentials")
    public Optional<Integer> deviceDefaultCredentials();

    @JsonProperty(value="adoptMethod")
    public Optional<Integer> adoptMethod();

    @JsonProperty(value="addresses")
    public List<UcoreDiscoveredDeviceAddressDto> addresses();

    @JsonProperty(value="lteIccid")
    public Optional<String> lteIccId();

    @JsonProperty(value="lteImei")
    public Optional<String> lteImei();

    @JsonProperty(value="lteRadio")
    public Optional<String> lteRadio();

    @JsonProperty(value="lteSimPinTriesLeft")
    public Optional<Integer> lteSimPinTriesLeft();

    @JsonProperty(value="lteIsSimPinRequired")
    public Optional<Boolean> lteIsSimPinRequired();

    @JsonProperty(value="ubbBssid")
    public Optional<String> ubbBssid();

    @JsonProperty(value="ubbPairId")
    public Optional<String> ubbPairId();

    @JsonProperty(value="ubbIsAp")
    public Optional<Boolean> ubbIsAp();

    @JsonIgnore
    default public Integer sysId() {
        return Integer.parseInt(this.sysIdString().orElse("0x0").substring(2), 16);
    }

    public static ImmutableUcoreDiscoveredDeviceDto.Builder builder() {
        return ImmutableUcoreDiscoveredDeviceDto.builder();
    }
}

