/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficstats;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.OOoO.Object;
import com.ubnt.model.api.trafficstats.ImmutableAppTrafficDto;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@Object
public abstract class AppTrafficDto
implements Comparable<AppTrafficDto> {
    @JsonProperty(value="application")
    public abstract int application();

    @JsonProperty(value="category")
    public abstract int category();

    @JsonProperty(value="bytes_received")
    public abstract long bytesReceived();

    @JsonProperty(value="bytes_transmitted")
    public abstract long bytesTransmitted();

    @JsonProperty(value="total_bytes")
    @Value.Lazy
    public long totalBytes() {
        return this.bytesReceived() + this.bytesTransmitted();
    }

    @JsonProperty(value="client_count")
    public abstract Optional<Integer> clientCount();

    @JsonProperty(value="activity_seconds")
    public abstract Optional<Long> activitySeconds();

    @Override
    public int compareTo(@Nonnull AppTrafficDto appTrafficDto) {
        return Comparator.comparingLong(AppTrafficDto::totalBytes).thenComparingLong(AppTrafficDto::bytesReceived).thenComparingLong(AppTrafficDto::bytesTransmitted).reversed().compare(this, appTrafficDto);
    }

    public AppTrafficDto summarize(AppTrafficDto appTrafficDto) {
        return ImmutableAppTrafficDto.builder().application(this.application()).category(this.category()).bytesReceived(this.bytesReceived() + appTrafficDto.bytesReceived()).bytesTransmitted(this.bytesTransmitted() + appTrafficDto.bytesTransmitted()).clientCount(this.clientCount().orElse(0) + appTrafficDto.clientCount().orElse(0)).build();
    }

    public static AppTrafficDto forSingleClient(AppTrafficDto appTrafficDto) {
        return ImmutableAppTrafficDto.builder().from(appTrafficDto).activitySeconds(Optional.empty()).clientCount(1).build();
    }

    public static AppTrafficDto add(AppTrafficDto appTrafficDto, AppTrafficDto appTrafficDto2) {
        return ImmutableAppTrafficDto.builder().application(appTrafficDto2.application()).category(appTrafficDto2.category()).bytesReceived(appTrafficDto.bytesReceived() + appTrafficDto2.bytesReceived()).bytesTransmitted(appTrafficDto.bytesTransmitted() + appTrafficDto2.bytesTransmitted()).build();
    }

    public static AppTrafficDto empty() {
        return ImmutableAppTrafficDto.builder().application(0).category(0).bytesReceived(0L).bytesTransmitted(0L).build();
    }

    public static AppTrafficDto ofClientStats(int n2, int n3, long l2, long l3, long l4) {
        ImmutableAppTrafficDto.Builder builder = ImmutableAppTrafficDto.builder();
        builder.application(n2).category(n3).bytesReceived(l2).bytesTransmitted(l3);
        if (l4 != 0L) {
            builder.activitySeconds(l4);
        }
        return builder.build();
    }
}

