/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.port;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.OOoO.Object;
import com.ubnt.data.Dot1XControl;
import com.ubnt.data.PoeMode;
import com.ubnt.data.PortConf;
import com.ubnt.data.PortOpMode;
import com.ubnt.model.api.port.ImmutablePortProfileDto;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
@Object
public abstract class PortProfileDto {
    @JsonProperty(value="op_mode")
    public abstract PortOpMode opMode();

    @JsonProperty(value="autoneg")
    public abstract boolean autoNegotiateLinkSpeedEnabled();

    @JsonProperty(value="dot1x_ctrl")
    public abstract Optional<Dot1XControl> dot1XControl();

    @JsonProperty(value="isolation")
    public abstract boolean portIsolationEnabled();

    @JsonProperty(value="poe_mode")
    public abstract Optional<PoeMode> poeMode();

    @JsonProperty(value="stormctrl_ucast_enabled")
    public abstract boolean stormControlUnknownUnicastEnabled();

    @JsonProperty(value="stormctrl_ucast_rate")
    @Value.Default
    public int stormControlUnknownUnicastRate() {
        return 100;
    }

    @JsonProperty(value="stormctrl_mcast_enabled")
    public abstract boolean stormControlMulticastEnabled();

    @JsonProperty(value="stormctrl_mcast_rate")
    @Value.Default
    public int stormControlMulticastRate() {
        return 100;
    }

    @JsonProperty(value="stormctrl_bcast_enabled")
    public abstract boolean stormControlBroadcastEnabled();

    @JsonProperty(value="stormctrl_bcast_rate")
    @Value.Default
    public int stormControlBroadcastRate() {
        return 100;
    }

    @JsonProperty(value="stp_port_mode")
    public abstract boolean spanningTreeProtocolEnabled();

    @JsonProperty(value="port_keepalive_enabled")
    public abstract boolean keepaliveLoopProtectionEnabled();

    @JsonProperty(value="lldpmed_enabled")
    public abstract boolean lldpMedEnabled();

    @JsonProperty(value="lldpmed_notify_enabled")
    public abstract boolean topologyChangeNotificationEnabled();

    @JsonProperty(value="egress_rate_limit_kbps_enabled")
    public abstract boolean egressKbpsLimitEnabled();

    @JsonProperty(value="flow_control_enabled")
    public abstract boolean flowControlEnabled();

    @JsonProperty(value="egress_rate_limit_kbps")
    @Value.Default
    public int egressKbpsLimit() {
        return 100;
    }

    @JsonProperty(value="voice_networkconf_id")
    public abstract Optional<String> voiceNetworkConfId();

    @JsonProperty(value="tagged_vlan_mgmt")
    public abstract String taggedVlanMgmt();

    public static PortProfileDto of(PortConf portConf) {
        return ImmutablePortProfileDto.builder().opMode(portConf.getOpMode()).dot1XControl(portConf.getDot1xCtrl().map(Dot1XControl::ofStringValue)).autoNegotiateLinkSpeedEnabled(portConf.isAutoNegotiateLinkSpeedEnabled()).portIsolationEnabled(portConf.isPortIsolationEnabled()).poeMode(portConf.getPoeMode().map(PoeMode::ofStringValue)).stormControlUnknownUnicastEnabled(portConf.isStormControlUnknownUnicastEnabled()).stormControlMulticastEnabled(portConf.isStormControlBroadcastEnabled()).stormControlBroadcastEnabled(portConf.isStormControlMulticastEnabled()).spanningTreeProtocolEnabled(portConf.isStpPortModeEnabled()).keepaliveLoopProtectionEnabled(portConf.isKeepaliveLoopProtectionEnabled()).lldpMedEnabled(portConf.isLldpMedEnabled()).topologyChangeNotificationEnabled(portConf.isTopologyChangeNotificationEnabled()).egressKbpsLimitEnabled(portConf.isEgressRateLimitKbpsEnabled()).voiceNetworkConfId(portConf.getVoiceNetworkConfId()).flowControlEnabled(portConf.isFlowControlEnabled()).taggedVlanMgmt(portConf.getTaggedVlanMgmtOption().toString()).build();
    }
}

