/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.floorplan.shape;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.OOoO.return;
import com.ubnt.model.api.floorplan.FloorPlanShapeType;
import com.ubnt.model.api.floorplan.shape.FloorPlanPositionDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanShapeDto;
import com.ubnt.model.api.floorplan.shape.ImmutableFloorPlanScaleDto;
import com.ubnt.service.floorplan.FloorPlanScaleDocumentPart;
import com.ubnt.service.floorplan.FloorPlanShapeDocument;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ImmutableFloorPlanScaleDto.Builder.class)
@JsonTypeName(value="scale")
@Value.Immutable
@return
public interface FloorPlanScaleDto
extends FloorPlanShapeDto {
    @Positive
    @JsonProperty(value="height")
    public double height();

    @Positive
    @JsonProperty(value="scale")
    public int scale();

    @JsonProperty(value="default_scale")
    public boolean defaultScale();

    @JsonProperty(value="default_height")
    public boolean defaultHeight();

    @JsonProperty(value="position")
    @Size(min=2, max=2)
    public @Size(min=2, max=2) List<@Valid FloorPlanPositionDto> position();

    @Override
    default public FloorPlanShapeType type() {
        return FloorPlanShapeType.SCALE;
    }

    @Override
    default public FloorPlanShapeDocument toDocument(String string, String string2) {
        return FloorPlanShapeDocument.builder().\u00f600000(string2).\u00d200000(string).o00000(this.planId()).\u00f500000(this.status()).\u00d600000(this.uuid()).\u00f400000(this.type()).Object(FloorPlanScaleDocumentPart.builder().o00000(this.height()).\u00d500000(this.scale()).return(this.defaultHeight()).\u00d400000(this.defaultScale()).\u00d800000(this.position().stream().map(FloorPlanPositionDto::toDocument).toList()).new()).\u00d500000();
    }

    public static ImmutableFloorPlanScaleDto.Builder builder() {
        return ImmutableFloorPlanScaleDto.builder();
    }

    public static FloorPlanScaleDto ofDocument(FloorPlanShapeDocument floorPlanShapeDocument) {
        return floorPlanShapeDocument.getScale().map(floorPlanScaleDocumentPart -> FloorPlanScaleDto.builder().id(floorPlanShapeDocument.getId()).planId(floorPlanShapeDocument.getPlanId()).status(floorPlanShapeDocument.getStatus()).uuid(floorPlanShapeDocument.getUuid()).height(floorPlanScaleDocumentPart.getHeight()).scale(floorPlanScaleDocumentPart.getScale()).defaultHeight(floorPlanScaleDocumentPart.isDefaultHeight()).defaultScale(floorPlanScaleDocumentPart.isDefaultScale()).position(floorPlanScaleDocumentPart.getPosition().stream().map(FloorPlanPositionDto::ofDocument).toList()).build()).orElse(null);
    }
}

