/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.feature;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.feature.FeatureDescriptionDto;
import com.ubnt.model.api.feature.FeatureLimitationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Schema(name="Feature with description")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="FeatureDescriptionDto", generator="Immutables")
public final class ImmutableFeatureDescriptionDto
extends FeatureDescriptionDto {
    private final String name;
    private final boolean featureExists;
    @Nullable
    private final Boolean featureEnabled;
    private final List<FeatureLimitationDto> limitations;

    private ImmutableFeatureDescriptionDto(Builder builder) {
        this.name = builder.name;
        this.featureExists = builder.featureExists;
        this.featureEnabled = builder.featureEnabled;
        this.limitations = ImmutableFeatureDescriptionDto.\u00d200000(true, builder.limitations);
    }

    @Override
    @Schema(name="Feature name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String name() {
        return this.name;
    }

    @Override
    @Schema(name="Feature exists", requiredMode=Schema.RequiredMode.REQUIRED)
    public boolean featureExists() {
        return this.featureExists;
    }

    @Override
    @Schema(name="Feature enabled")
    public Optional<Boolean> featureEnabled() {
        return Optional.ofNullable(this.featureEnabled);
    }

    @Override
    @Schema(name="Feature limitations")
    public List<FeatureLimitationDto> limitations() {
        return this.limitations;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableFeatureDescriptionDto && this.\u00d400000(0, (ImmutableFeatureDescriptionDto)object);
    }

    private boolean \u00d400000(int n2, ImmutableFeatureDescriptionDto immutableFeatureDescriptionDto) {
        return Objects.equals(this.name, immutableFeatureDescriptionDto.name) && this.featureExists == immutableFeatureDescriptionDto.featureExists && Objects.equals(this.featureEnabled, immutableFeatureDescriptionDto.featureEnabled) && this.limitations.equals(immutableFeatureDescriptionDto.limitations);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.name);
        n2 += (n2 << 5) + Boolean.hashCode(this.featureExists);
        n2 += (n2 << 5) + Objects.hashCode(this.featureEnabled);
        n2 += (n2 << 5) + this.limitations.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FeatureDescriptionDto{");
        if (this.name != null) {
            stringBuilder.append("name=").append(this.name);
        }
        if (stringBuilder.length() > 22) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("featureExists=").append(this.featureExists);
        if (this.featureEnabled != null) {
            stringBuilder.append(", ");
            stringBuilder.append("featureEnabled=").append(this.featureEnabled);
        }
        stringBuilder.append(", ");
        stringBuilder.append("limitations=").append(this.limitations);
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d300000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> \u00d200000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FeatureDescriptionDto", generator="Immutables")
    public static final class Builder {
        @Nullable
        private String name;
        private boolean featureExists;
        @Nullable
        private Boolean featureEnabled;
        private List<FeatureLimitationDto> limitations = new ArrayList<FeatureLimitationDto>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureDescriptionDto featureDescriptionDto) {
            Objects.requireNonNull(featureDescriptionDto, "instance");
            String string = featureDescriptionDto.name();
            if (string != null) {
                this.name(string);
            }
            this.featureExists(featureDescriptionDto.featureExists());
            Optional<Boolean> optional = featureDescriptionDto.featureEnabled();
            if (optional.isPresent()) {
                this.featureEnabled(optional);
            }
            this.addAllLimitations(featureDescriptionDto.limitations());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String string) {
            this.name = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureExists(boolean bl) {
            this.featureExists = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureEnabled(@Nullable Boolean bl) {
            this.featureEnabled = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureEnabled(Optional<Boolean> optional) {
            this.featureEnabled = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLimitations(@Nullable FeatureLimitationDto featureLimitationDto) {
            this.limitations.add(featureLimitationDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLimitations(FeatureLimitationDto ... featureLimitationDtoArray) {
            for (FeatureLimitationDto featureLimitationDto : featureLimitationDtoArray) {
                this.limitations.add(featureLimitationDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limitations(Iterable<? extends FeatureLimitationDto> iterable) {
            this.limitations.clear();
            return this.addAllLimitations(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLimitations(Iterable<? extends FeatureLimitationDto> iterable) {
            for (FeatureLimitationDto featureLimitationDto : iterable) {
                this.limitations.add(featureLimitationDto);
            }
            return this;
        }

        public ImmutableFeatureDescriptionDto build() {
            return new ImmutableFeatureDescriptionDto(this);
        }
    }
}

