/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.apgroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.HasExternalId;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.apgroup.ApGroupDocument;
import com.ubnt.service.config.OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Access Points Group")
public class ApGroup
implements OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO,
HasExternalId {
    public static final int MAX_WLANCONF = 8;
    public static final int MAX_WLANCONF_WITH_ADOPTION_ENABLED = 7;
    public static final int MAX_WLANCONF_WITH_WIRELESS_UPLINK = 4;
    public static final int MAX_WLANCONF_LIMITED_RESOURCES = 3;
    public static final int MAX_ACL_MAC_FILTER_NUMBER = 512;
    @JsonProperty(value="_id")
    @Schema(example="5e6285ec05938c3d128aaf07", accessMode=Schema.AccessMode.READ_ONLY)
    private String id;
    @Nullable
    @JsonProperty(value="external_id")
    private UUID externalId;
    @JsonIgnore
    private String siteId;
    @JsonProperty(value="attr_hidden_id")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Null
    private String hiddenId;
    @JsonProperty(value="attr_no_delete")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @AssertFalse
    private boolean nonDeletable;
    @JsonProperty(value="name")
    @NotEmpty
    private String name;
    @JsonProperty(value="device_macs")
    @NotNull
    @MacAddress
    @Schema(required=true, name="List of device macs. will be ignored when updating default AP group", example="[\"04:18:d6:a0:bc:52\"]")
    private Set<String> deviceMACs;
    @JsonProperty(value="for_wlanconf")
    @Schema(description="Mark AP Group as dedicated for a single WLAN Conf (Devices view). It will be hidden from list results by default for backward compatibility, but possible to enable optionally")
    private boolean forWlanConf;

    public ApGroup setId(String string) {
        this.id = string;
        return this;
    }

    public ApGroup setSiteId(String string) {
        this.siteId = string;
        return this;
    }

    public ApGroup setExternalId(UUID uUID) {
        this.externalId = uUID;
        return this;
    }

    public Optional<String> getHiddenId() {
        return Optional.ofNullable(this.hiddenId);
    }

    public ApGroup setHiddenId(String string) {
        this.hiddenId = string;
        return this;
    }

    public ApGroup setNonDeletable(boolean bl) {
        this.nonDeletable = bl;
        return this;
    }

    public ApGroup setName(String string) {
        this.name = string;
        return this;
    }

    public ApGroup setDeviceMACs(Set<String> set) {
        this.deviceMACs = set;
        return this;
    }

    @JsonIgnore
    public boolean isDefault() {
        return "default".equals(this.hiddenId);
    }

    public ApGroup setForWlanConf(boolean bl) {
        this.forWlanConf = bl;
        return this;
    }

    public static ApGroup fromDocument(ApGroupDocument apGroupDocument) {
        ApGroup apGroup = new ApGroup();
        apGroup.id = apGroupDocument.getId();
        apGroup.externalId = apGroupDocument.getExternalId();
        apGroup.siteId = apGroupDocument.getSiteId();
        apGroup.name = apGroupDocument.getName();
        apGroup.hiddenId = apGroupDocument.getHiddenId();
        apGroup.nonDeletable = apGroupDocument.isNonDeletable();
        apGroup.forWlanConf = apGroupDocument.isForWlanConf();
        Set<String> set = apGroupDocument.getDeviceMACs();
        if (set != null) {
            apGroup.deviceMACs = Set.copyOf(set);
        }
        return apGroup;
    }

    public ApGroupDocument toDocument(String string) {
        return ApGroupDocument.of(this.id, this.externalId, string, this.hiddenId, this.name, this.nonDeletable, this.deviceMACs, this.forWlanConf);
    }

    @Generated
    public static ApGroupBuilder builder() {
        return new ApGroupBuilder();
    }

    @JsonProperty(value="_id")
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    @JsonProperty(value="external_id")
    @Generated
    public UUID getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @JsonProperty(value="attr_no_delete")
    @Generated
    public boolean isNonDeletable() {
        return this.nonDeletable;
    }

    @JsonProperty(value="name")
    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="device_macs")
    @Generated
    public Set<String> getDeviceMACs() {
        return this.deviceMACs;
    }

    @JsonProperty(value="for_wlanconf")
    @Generated
    public boolean isForWlanConf() {
        return this.forWlanConf;
    }

    @ConstructorProperties(value={"id", "externalId", "siteId", "hiddenId", "nonDeletable", "name", "deviceMACs", "forWlanConf"})
    @Generated
    private ApGroup(@JsonProperty(value="_id") String string, @Nullable @JsonProperty(value="external_id") UUID uUID, String string2, @JsonProperty(value="attr_hidden_id") String string3, @JsonProperty(value="attr_no_delete") boolean bl, @JsonProperty(value="name") String string4, @JsonProperty(value="device_macs") Set<String> set, @JsonProperty(value="for_wlanconf") boolean bl2) {
        this.id = string;
        this.externalId = uUID;
        this.siteId = string2;
        this.hiddenId = string3;
        this.nonDeletable = bl;
        this.name = string4;
        this.deviceMACs = set;
        this.forWlanConf = bl2;
    }

    @Generated
    public ApGroup() {
    }

    @Generated
    public static class ApGroupBuilder {
        @Generated
        private String id;
        @Generated
        private UUID externalId;
        @Generated
        private String siteId;
        @Generated
        private String hiddenId;
        @Generated
        private boolean nonDeletable;
        @Generated
        private String name;
        @Generated
        private Set<String> deviceMACs;
        @Generated
        private boolean forWlanConf;

        @Generated
        ApGroupBuilder() {
        }

        @JsonProperty(value="_id")
        @Generated
        public ApGroupBuilder id(@JsonProperty(value="_id") String string) {
            this.id = string;
            return this;
        }

        @JsonProperty(value="external_id")
        @Generated
        public ApGroupBuilder externalId(@Nullable @JsonProperty(value="external_id") UUID uUID) {
            this.externalId = uUID;
            return this;
        }

        @JsonIgnore
        @Generated
        public ApGroupBuilder siteId(String string) {
            this.siteId = string;
            return this;
        }

        @JsonProperty(value="attr_hidden_id")
        @Generated
        public ApGroupBuilder hiddenId(@JsonProperty(value="attr_hidden_id") String string) {
            this.hiddenId = string;
            return this;
        }

        @JsonProperty(value="attr_no_delete")
        @Generated
        public ApGroupBuilder nonDeletable(@JsonProperty(value="attr_no_delete") boolean bl) {
            this.nonDeletable = bl;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public ApGroupBuilder name(@JsonProperty(value="name") String string) {
            this.name = string;
            return this;
        }

        @JsonProperty(value="device_macs")
        @Generated
        public ApGroupBuilder deviceMACs(@JsonProperty(value="device_macs") Set<String> set) {
            this.deviceMACs = set;
            return this;
        }

        @JsonProperty(value="for_wlanconf")
        @Generated
        public ApGroupBuilder forWlanConf(@JsonProperty(value="for_wlanconf") boolean bl) {
            this.forWlanConf = bl;
            return this;
        }

        @Generated
        public ApGroup build() {
            return new ApGroup(this.id, this.externalId, this.siteId, this.hiddenId, this.nonDeletable, this.name, this.deviceMACs, this.forWlanConf);
        }

        @Generated
        public String toString() {
            return "ApGroup.ApGroupBuilder(id=" + this.id + ", externalId=" + String.valueOf(this.externalId) + ", siteId=" + this.siteId + ", hiddenId=" + this.hiddenId + ", nonDeletable=" + this.nonDeletable + ", name=" + this.name + ", deviceMACs=" + String.valueOf(this.deviceMACs) + ", forWlanConf=" + this.forWlanConf + ")";
        }
    }
}

