/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.Subgraph;

public class DirectedSubgraph<V, E>
extends Subgraph<V, E, DirectedGraph<V, E>>
implements DirectedGraph<V, E> {
    private static final long serialVersionUID = 3616445700507054133L;

    public DirectedSubgraph(DirectedGraph<V, E> base, Set<? extends V> vertexSubset, Set<? extends E> edgeSubset) {
        super(base, vertexSubset, edgeSubset);
    }

    public DirectedSubgraph(DirectedGraph<V, E> base, Set<? extends V> vertexSubset) {
        this((DirectedGraph<? extends V, E>)base, vertexSubset, (Set<E>)null);
    }

    public DirectedSubgraph(DirectedGraph<V, E> base) {
        this(base, (Set<V>)null, (Set<E>)null);
    }

    @Override
    public int inDegreeOf(V vertex) {
        return this.incomingEdgesOf(vertex).size();
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return ((DirectedGraph)this.base).incomingEdgesOf(vertex).stream().filter(e -> this.edgeSet.contains(e)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Override
    public int outDegreeOf(V vertex) {
        return this.outgoingEdgesOf(vertex).size();
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return ((DirectedGraph)this.base).outgoingEdgesOf(vertex).stream().filter(e -> this.edgeSet.contains(e)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }
}

