/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.generate.RingGraphGenerator;

public class WheelGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String HUB_VERTEX = "Hub Vertex";
    private boolean inwardSpokes;
    private int size;

    public WheelGraphGenerator(int size) {
        this(size, true);
    }

    public WheelGraphGenerator(int size, boolean inwardSpokes) {
        if (size < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = size;
        this.inwardSpokes = inwardSpokes;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.size < 1) {
            return;
        }
        ArrayList rim = new ArrayList();
        VertexFactory<Object> rimVertexFactory = () -> {
            Object vertex = vertexFactory.createVertex();
            rim.add(vertex);
            return vertex;
        };
        RingGraphGenerator<Object, E> ringGenerator = new RingGraphGenerator<Object, E>(this.size - 1);
        ringGenerator.generateGraph((Graph<Object, E>)target, rimVertexFactory, (Map<String, Object>)resultMap);
        V hubVertex = vertexFactory.createVertex();
        target.addVertex(hubVertex);
        if (resultMap != null) {
            resultMap.put(HUB_VERTEX, hubVertex);
        }
        for (Object rimVertex : rim) {
            if (this.inwardSpokes) {
                target.addEdge(rimVertex, hubVertex);
                continue;
            }
            target.addEdge(hubVertex, rimVertex);
        }
    }
}

