/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.BidirectionalDijkstraShortestPath;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

@Deprecated
public final class BidirectionalDijkstraShortestPath<V, E> {
    private final GraphPath<V, E> path;

    public BidirectionalDijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY);
    }

    public BidirectionalDijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex, double radius) {
        if (graph == null) {
            throw new IllegalArgumentException("Input graph cannot be null");
        }
        if (startVertex == null || !graph.containsVertex(startVertex)) {
            throw new IllegalArgumentException("Invalid graph vertex as source");
        }
        if (endVertex == null || !graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("Invalid graph vertex as target");
        }
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.path = new AlgorithmDetails(graph, startVertex, endVertex, radius).run();
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        return new BidirectionalDijkstraShortestPath<V, E>(graph, startVertex, endVertex).getPathEdgeList();
    }

    class AlgorithmDetails {
        private final org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.SearchFrontier forwardFrontier;
        private final org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.SearchFrontier backwardFrontier;
        private final V source;
        private final V target;
        private final double radius;

        public AlgorithmDetails(Graph<V, E> graph, V source, V target, double radius) {
            this.forwardFrontier = new SearchFrontier(graph);
            this.backwardFrontier = graph instanceof DirectedGraph ? new SearchFrontier(new EdgeReversedGraph((DirectedGraph)graph)) : new SearchFrontier(graph);
            this.source = source;
            this.target = target;
            this.radius = radius;
        }

        public GraphPath<V, E> run() {
            if (this.source.equals(this.target)) {
                return new GraphWalk(this.forwardFrontier.graph, this.source, this.target, Collections.singletonList(this.source), Collections.emptyList(), 0.0);
            }
            assert (!this.source.equals(this.target));
            this.forwardFrontier.updateDistance(this.source, null, 0.0);
            this.backwardFrontier.updateDistance(this.target, null, 0.0);
            double bestPath = Double.POSITIVE_INFINITY;
            Object bestPathCommonVertex = null;
            org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.SearchFrontier frontier = this.forwardFrontier;
            org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.SearchFrontier otherFrontier = this.backwardFrontier;
            while (!(frontier.heap.isEmpty() || otherFrontier.heap.isEmpty() || frontier.heap.min().getKey() + otherFrontier.heap.min().getKey() >= bestPath)) {
                FibonacciHeapNode<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry> node = frontier.heap.removeMin();
                Object v = ((QueueEntry)node.getData()).v;
                double vDistance = node.getKey();
                for (Object e : frontier.specifics.edgesOf(v)) {
                    Object u = Graphs.getOppositeVertex(frontier.graph, e, v);
                    double eWeight = frontier.graph.getEdgeWeight(e);
                    frontier.updateDistance(u, e, vDistance + eWeight);
                    double pathDistance = vDistance + eWeight + otherFrontier.getDistance(u);
                    if (!(pathDistance < bestPath)) continue;
                    bestPath = pathDistance;
                    bestPathCommonVertex = u;
                }
                org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.SearchFrontier tmpFrontier = frontier;
                frontier = otherFrontier;
                otherFrontier = tmpFrontier;
            }
            if (Double.isFinite(bestPath) && bestPath <= this.radius) {
                return this.createPath(bestPath, bestPathCommonVertex);
            }
            return null;
        }

        private GraphPath<V, E> createPath(double weight, V commonVertex) {
            Object e;
            LinkedList edgeList = new LinkedList();
            LinkedList vertexList = new LinkedList();
            vertexList.add(commonVertex);
            Object v = commonVertex;
            while ((e = this.forwardFrontier.getTreeEdge(v)) != null) {
                edgeList.addFirst(e);
                v = Graphs.getOppositeVertex(this.forwardFrontier.graph, e, v);
                vertexList.addFirst(v);
            }
            v = commonVertex;
            while ((e = this.backwardFrontier.getTreeEdge(v)) != null) {
                edgeList.addLast(e);
                v = Graphs.getOppositeVertex(this.backwardFrontier.graph, e, v);
                vertexList.addLast(v);
            }
            return new GraphWalk(this.forwardFrontier.graph, this.source, this.target, vertexList, edgeList, weight);
        }

        class QueueEntry {
            E e;
            V v;

            public QueueEntry(E e, V v) {
                this.e = e;
                this.v = v;
            }
        }

        /*
         * Signature claims super is org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.Specifics, not org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails$Specifics - discarding signature.
         */
        class UndirectedSpecifics
        extends Specifics {
            private Graph<V, E> graph;

            public UndirectedSpecifics(Graph<V, E> g) {
                this.graph = g;
            }

            public Set<E> edgesOf(V vertex) {
                return this.graph.edgesOf(vertex);
            }
        }

        /*
         * Signature claims super is org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.Specifics, not org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails$Specifics - discarding signature.
         */
        class DirectedSpecifics
        extends Specifics {
            private DirectedGraph<V, E> graph;

            public DirectedSpecifics(DirectedGraph<V, E> g) {
                this.graph = g;
            }

            @Override
            public Set<? extends E> edgesOf(V vertex) {
                return this.graph.outgoingEdgesOf(vertex);
            }
        }

        abstract class Specifics {
            Specifics() {
            }

            public abstract Set<? extends E> edgesOf(V var1);
        }

        class SearchFrontier {
            final Graph<V, E> graph;
            final org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.Specifics specifics;
            final FibonacciHeap<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry> heap;
            final Map<V, FibonacciHeapNode<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry>> seen;

            public SearchFrontier(Graph<V, E> graph) {
                this.graph = graph;
                this.specifics = graph instanceof DirectedGraph ? new DirectedSpecifics((DirectedGraph)graph) : new UndirectedSpecifics(graph);
                this.heap = new FibonacciHeap();
                this.seen = new HashMap();
            }

            public void updateDistance(V v, E e, double distance) {
                FibonacciHeapNode<Object> node = this.seen.get(v);
                if (node == null) {
                    node = new FibonacciHeapNode<QueueEntry>(new QueueEntry(e, v));
                    this.heap.insert(node, distance);
                    this.seen.put((FibonacciHeapNode<Object>)v, (FibonacciHeapNode<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry>)node);
                } else if (distance < node.getKey()) {
                    this.heap.decreaseKey(node, distance);
                    ((QueueEntry)node.getData()).e = e;
                }
            }

            public double getDistance(V v) {
                FibonacciHeapNode<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry> node = this.seen.get(v);
                if (node == null) {
                    return Double.POSITIVE_INFINITY;
                }
                return node.getKey();
            }

            public E getTreeEdge(V v) {
                FibonacciHeapNode<org.jgrapht.alg.BidirectionalDijkstraShortestPath$AlgorithmDetails.QueueEntry> node = this.seen.get(v);
                if (node == null) {
                    return null;
                }
                return ((QueueEntry)node.getData()).e;
            }
        }
    }
}

