// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/chromeos/moblab/v1beta1/build_service.proto

package moblab

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for finding the most stable build.
// -- NEXT_TAG: 3 --
type FindMostStableBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The full resource name of the build target.
	// For example,
	// 'buildTargets/octopus'.
	BuildTarget string `protobuf:"bytes,1,opt,name=build_target,json=buildTarget,proto3" json:"build_target,omitempty"`
	// Optional. The full resource name of the build target or model.
	// For example,
	// 'buildTargets/octopus/models/bobba'.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *FindMostStableBuildRequest) Reset() {
	*x = FindMostStableBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FindMostStableBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindMostStableBuildRequest) ProtoMessage() {}

func (x *FindMostStableBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindMostStableBuildRequest.ProtoReflect.Descriptor instead.
func (*FindMostStableBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{0}
}

func (x *FindMostStableBuildRequest) GetBuildTarget() string {
	if x != nil {
		return x.BuildTarget
	}
	return ""
}

func (x *FindMostStableBuildRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Response message for finding the most stable build.
// -- NEXT_TAG: 2 --
type FindMostStableBuildResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The most stable build.
	Build *Build `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
}

func (x *FindMostStableBuildResponse) Reset() {
	*x = FindMostStableBuildResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FindMostStableBuildResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindMostStableBuildResponse) ProtoMessage() {}

func (x *FindMostStableBuildResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindMostStableBuildResponse.ProtoReflect.Descriptor instead.
func (*FindMostStableBuildResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{1}
}

func (x *FindMostStableBuildResponse) GetBuild() *Build {
	if x != nil {
		return x.Build
	}
	return nil
}

// Request message for listing build targets.
// -- NEXT_TAG: 4 --
type ListBuildTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of build targets to return in a page.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListBuildTargets` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example,
	// the filter can be set as "filter='model=modelName'" to only select build
	// targets associated with the given model.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListBuildTargetsRequest) Reset() {
	*x = ListBuildTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildTargetsRequest) ProtoMessage() {}

func (x *ListBuildTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListBuildTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListBuildTargetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBuildTargetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBuildTargetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for listing build targets.
// -- NEXT_TAG: 4 --
type ListBuildTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of build targets.
	BuildTargets []*BuildTarget `protobuf:"bytes,1,rep,name=build_targets,json=buildTargets,proto3" json:"build_targets,omitempty"`
	// Token to retrieve the next page of build targets. If this field is omitted,
	// there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of build targets.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListBuildTargetsResponse) Reset() {
	*x = ListBuildTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildTargetsResponse) ProtoMessage() {}

func (x *ListBuildTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListBuildTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListBuildTargetsResponse) GetBuildTargets() []*BuildTarget {
	if x != nil {
		return x.BuildTargets
	}
	return nil
}

func (x *ListBuildTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBuildTargetsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing models.
// -- NEXT_TAG: 4 --
type ListModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of build target.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of models to return in a page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListModels` call. Provide
	// this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModelsRequest) Reset() {
	*x = ListModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsRequest) ProtoMessage() {}

func (x *ListModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsRequest.ProtoReflect.Descriptor instead.
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListModelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing models.
// -- NEXT_TAG: 4 --
type ListModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of models.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// Token to retrieve the next page of models. If this field is omitted, there
	// are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of models.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListModelsResponse) Reset() {
	*x = ListModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsResponse) ProtoMessage() {}

func (x *ListModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsResponse.ProtoReflect.Descriptor instead.
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListModelsResponse) GetModels() []*Model {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *ListModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListModelsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing builds.
// -- NEXT_TAG: 7 --
type ListBuildsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the model. The model id is the same as
	// the build target id for non-unified builds.
	// For example,
	// 'buildTargets/octopus/models/bobba'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of builds to return in a page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListBuilds` call. Provide
	// this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example,
	// the filter can be set as "filter='milestone=milestones/80'" to only select
	// builds in milestone 80.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Read mask that specifies which Build fields to return. If empty,
	// all Build fields will be returned. Valid fields: name, milestone,
	// build_version. For example, if the read_mask is set as
	// "read_mask='milestone'", the ListBuilds will return a list of Builds object
	// with only the milestone field.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// Optional. The operation that groups by all the Build fields specified in
	// the read mask. The group_by field should be the same as the read_mask field
	// in convention of SQL.
	GroupBy *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
}

func (x *ListBuildsRequest) Reset() {
	*x = ListBuildsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildsRequest) ProtoMessage() {}

func (x *ListBuildsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildsRequest.ProtoReflect.Descriptor instead.
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListBuildsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBuildsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBuildsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBuildsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBuildsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListBuildsRequest) GetGroupBy() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.GroupBy
	}
	return nil
}

// Response message for listing builds.
// -- NEXT_TAG: 4 --
type ListBuildsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of builds.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to retrieve the next page of builds. If this field is omitted, there
	// are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of builds.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListBuildsResponse) Reset() {
	*x = ListBuildsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildsResponse) ProtoMessage() {}

func (x *ListBuildsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildsResponse.ProtoReflect.Descriptor instead.
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListBuildsResponse) GetBuilds() []*Build {
	if x != nil {
		return x.Builds
	}
	return nil
}

func (x *ListBuildsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBuildsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for checking if the build artifact is staged.
// -- NEXT_TAG: 3 --
type CheckBuildStageStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example,
	// the filter can be set as "filter='type=release'" to only check the release
	// builds.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *CheckBuildStageStatusRequest) Reset() {
	*x = CheckBuildStageStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckBuildStageStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckBuildStageStatusRequest) ProtoMessage() {}

func (x *CheckBuildStageStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckBuildStageStatusRequest.ProtoReflect.Descriptor instead.
func (*CheckBuildStageStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{8}
}

func (x *CheckBuildStageStatusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CheckBuildStageStatusRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for checking the stage status of a build artifact.
// -- NEXT_TAG: 5 --
type CheckBuildStageStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status to represent if the build is staged or not.
	IsBuildStaged bool `protobuf:"varint,1,opt,name=is_build_staged,json=isBuildStaged,proto3" json:"is_build_staged,omitempty"`
	// The staged build artifact in the destination bucket.
	StagedBuildArtifact *BuildArtifact `protobuf:"bytes,2,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	// The source build artifact in the source bucket.
	SourceBuildArtifact *BuildArtifact `protobuf:"bytes,3,opt,name=source_build_artifact,json=sourceBuildArtifact,proto3" json:"source_build_artifact,omitempty"`
	// Optional. The cloud build if the build id is provided.
	CloudBuild *CloudBuild `protobuf:"bytes,4,opt,name=cloud_build,json=cloudBuild,proto3" json:"cloud_build,omitempty"`
}

func (x *CheckBuildStageStatusResponse) Reset() {
	*x = CheckBuildStageStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckBuildStageStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckBuildStageStatusResponse) ProtoMessage() {}

func (x *CheckBuildStageStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckBuildStageStatusResponse.ProtoReflect.Descriptor instead.
func (*CheckBuildStageStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{9}
}

func (x *CheckBuildStageStatusResponse) GetIsBuildStaged() bool {
	if x != nil {
		return x.IsBuildStaged
	}
	return false
}

func (x *CheckBuildStageStatusResponse) GetStagedBuildArtifact() *BuildArtifact {
	if x != nil {
		return x.StagedBuildArtifact
	}
	return nil
}

func (x *CheckBuildStageStatusResponse) GetSourceBuildArtifact() *BuildArtifact {
	if x != nil {
		return x.SourceBuildArtifact
	}
	return nil
}

func (x *CheckBuildStageStatusResponse) GetCloudBuild() *CloudBuild {
	if x != nil {
		return x.CloudBuild
	}
	return nil
}

// Request message for staging a build artifact.
// -- NEXT_TAG: 6 --
type StageBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example,
	// the filter can be set as "filter='type=release'" to only check the release
	// builds.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The source location of the artifact, defaults to
	// `chromeos-image-archive` if missing.
	SourceBucketId string `protobuf:"bytes,3,opt,name=source_bucket_id,json=sourceBucketId,proto3" json:"source_bucket_id,omitempty"`
	// Optional. The branch directory in the source_bucket_id where the artifact
	// is located, such as `firmware-ec-R143-16463.2.B`. If unspecified, the build
	// will be found in goldeneye by version number.
	Branch string `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	// Optional. The name of the artifact to stage, such as
	// `karis.EC.16463.2.6.tar.bz2` or `rex/firmware_from_source.tar.bz2` If
	// unspecified, the default artifacts will be staged. This only makes sense
	// for firmware artifacts.
	Artifact string `protobuf:"bytes,5,opt,name=artifact,proto3" json:"artifact,omitempty"`
}

func (x *StageBuildRequest) Reset() {
	*x = StageBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StageBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StageBuildRequest) ProtoMessage() {}

func (x *StageBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StageBuildRequest.ProtoReflect.Descriptor instead.
func (*StageBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{10}
}

func (x *StageBuildRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StageBuildRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *StageBuildRequest) GetSourceBucketId() string {
	if x != nil {
		return x.SourceBucketId
	}
	return ""
}

func (x *StageBuildRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *StageBuildRequest) GetArtifact() string {
	if x != nil {
		return x.Artifact
	}
	return ""
}

// Response message for staging a build artifact.
// -- NEXT_TAG: 3 --
type StageBuildResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The staged build in the destination bucket.
	StagedBuildArtifact *BuildArtifact `protobuf:"bytes,1,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	// The cloud build id of the build artifacts.
	//
	// Deprecated: Do not use.
	CloudBuild *CloudBuild `protobuf:"bytes,2,opt,name=cloud_build,json=cloudBuild,proto3" json:"cloud_build,omitempty"`
}

func (x *StageBuildResponse) Reset() {
	*x = StageBuildResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StageBuildResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StageBuildResponse) ProtoMessage() {}

func (x *StageBuildResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StageBuildResponse.ProtoReflect.Descriptor instead.
func (*StageBuildResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{11}
}

func (x *StageBuildResponse) GetStagedBuildArtifact() *BuildArtifact {
	if x != nil {
		return x.StagedBuildArtifact
	}
	return nil
}

// Deprecated: Do not use.
func (x *StageBuildResponse) GetCloudBuild() *CloudBuild {
	if x != nil {
		return x.CloudBuild
	}
	return nil
}

// Metadata message for staging a build artifact.
// -- NEXT_TAG: 5 --
type StageBuildMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approximate percentage of progress, e.g. "50" means 50%.
	ProgressPercent float32 `protobuf:"fixed32,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Build stage start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Build stage end time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The cloud build of the build artifacts.
	CloudBuild *CloudBuild `protobuf:"bytes,4,opt,name=cloud_build,json=cloudBuild,proto3" json:"cloud_build,omitempty"`
}

func (x *StageBuildMetadata) Reset() {
	*x = StageBuildMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StageBuildMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StageBuildMetadata) ProtoMessage() {}

func (x *StageBuildMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StageBuildMetadata.ProtoReflect.Descriptor instead.
func (*StageBuildMetadata) Descriptor() ([]byte, []int) {
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP(), []int{12}
}

func (x *StageBuildMetadata) GetProgressPercent() float32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *StageBuildMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *StageBuildMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *StageBuildMetadata) GetCloudBuild() *CloudBuild {
	if x != nil {
		return x.CloudBuild
	}
	return nil
}

var File_google_chromeos_moblab_v1beta1_build_service_proto protoreflect.FileDescriptor

var file_google_chromeos_moblab_v1beta1_build_service_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2f, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72,
	0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65,
	0x6f, 0x73, 0x2f, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x46, 0x69,
	0x6e, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x41,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d,
	0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x5a, 0x0a, 0x1b, 0x46, 0x69, 0x6e, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3b, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x7c, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb3, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x0c, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a,
	0x65, 0x22, 0xa4, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb5, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d, 0x6f, 0x62,
	0x6c, 0x61, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x3a, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x22, 0x9a, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x06, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x1c, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d, 0x6f, 0x62, 0x6c, 0x61,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0xdf, 0x02, 0x0a, 0x1d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x69, 0x73, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x67, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x15, 0x73,
	0x74, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62,
	0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x13, 0x73, 0x74, 0x61, 0x67, 0x65,
	0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x61,
	0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e,
	0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x13, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x12, 0x50, 0x0a, 0x0b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x22, 0xe6, 0x01, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x2d, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x1f, 0x0a, 0x08, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0xc8, 0x01, 0x0a,
	0x12, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x15, 0x73, 0x74, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x13, 0x73, 0x74, 0x61, 0x67, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f,
	0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x22, 0xfe, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29,
	0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65,
	0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x0a, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x32, 0xbc, 0x0b, 0x0a, 0x0c, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa4, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x1d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x12, 0xad, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x38, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x12, 0xb6, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x15, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72,
	0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53,
	0x74, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12,
	0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x12, 0xdf, 0x01, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x28, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x53,
	0x74, 0x61, 0x67, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61,
	0x67, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x81, 0x03, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x64, 0x4d, 0x6f,
	0x73, 0x74, 0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e,
	0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x6d, 0x6f, 0x62, 0x6c,
	0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x4d,
	0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf0, 0x01, 0xda, 0x41, 0x0c, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x12, 0x3a,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x5a, 0x3e, 0x12, 0x3c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x64, 0x4d, 0x6f, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x59,
	0x12, 0x2d, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x1d, 0x7b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x28, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x3d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4c, 0xca, 0x41, 0x1d, 0x63, 0x68,
	0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x29, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6d, 0x6f,
	0x62, 0x6c, 0x61, 0x62, 0x61, 0x70, 0x69, 0x42, 0x81, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e,
	0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x11,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x48, 0x01, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x68, 0x72,
	0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2f, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3b, 0x6d, 0x6f, 0x62, 0x6c, 0x61, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescOnce sync.Once
	file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescData = file_google_chromeos_moblab_v1beta1_build_service_proto_rawDesc
)

func file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescGZIP() []byte {
	file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescOnce.Do(func() {
		file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescData)
	})
	return file_google_chromeos_moblab_v1beta1_build_service_proto_rawDescData
}

var file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_chromeos_moblab_v1beta1_build_service_proto_goTypes = []interface{}{
	(*FindMostStableBuildRequest)(nil),    // 0: google.chromeos.moblab.v1beta1.FindMostStableBuildRequest
	(*FindMostStableBuildResponse)(nil),   // 1: google.chromeos.moblab.v1beta1.FindMostStableBuildResponse
	(*ListBuildTargetsRequest)(nil),       // 2: google.chromeos.moblab.v1beta1.ListBuildTargetsRequest
	(*ListBuildTargetsResponse)(nil),      // 3: google.chromeos.moblab.v1beta1.ListBuildTargetsResponse
	(*ListModelsRequest)(nil),             // 4: google.chromeos.moblab.v1beta1.ListModelsRequest
	(*ListModelsResponse)(nil),            // 5: google.chromeos.moblab.v1beta1.ListModelsResponse
	(*ListBuildsRequest)(nil),             // 6: google.chromeos.moblab.v1beta1.ListBuildsRequest
	(*ListBuildsResponse)(nil),            // 7: google.chromeos.moblab.v1beta1.ListBuildsResponse
	(*CheckBuildStageStatusRequest)(nil),  // 8: google.chromeos.moblab.v1beta1.CheckBuildStageStatusRequest
	(*CheckBuildStageStatusResponse)(nil), // 9: google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse
	(*StageBuildRequest)(nil),             // 10: google.chromeos.moblab.v1beta1.StageBuildRequest
	(*StageBuildResponse)(nil),            // 11: google.chromeos.moblab.v1beta1.StageBuildResponse
	(*StageBuildMetadata)(nil),            // 12: google.chromeos.moblab.v1beta1.StageBuildMetadata
	(*Build)(nil),                         // 13: google.chromeos.moblab.v1beta1.Build
	(*BuildTarget)(nil),                   // 14: google.chromeos.moblab.v1beta1.BuildTarget
	(*Model)(nil),                         // 15: google.chromeos.moblab.v1beta1.Model
	(*fieldmaskpb.FieldMask)(nil),         // 16: google.protobuf.FieldMask
	(*BuildArtifact)(nil),                 // 17: google.chromeos.moblab.v1beta1.BuildArtifact
	(*CloudBuild)(nil),                    // 18: google.chromeos.moblab.v1beta1.CloudBuild
	(*timestamppb.Timestamp)(nil),         // 19: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),       // 20: google.longrunning.Operation
}
var file_google_chromeos_moblab_v1beta1_build_service_proto_depIdxs = []int32{
	13, // 0: google.chromeos.moblab.v1beta1.FindMostStableBuildResponse.build:type_name -> google.chromeos.moblab.v1beta1.Build
	14, // 1: google.chromeos.moblab.v1beta1.ListBuildTargetsResponse.build_targets:type_name -> google.chromeos.moblab.v1beta1.BuildTarget
	15, // 2: google.chromeos.moblab.v1beta1.ListModelsResponse.models:type_name -> google.chromeos.moblab.v1beta1.Model
	16, // 3: google.chromeos.moblab.v1beta1.ListBuildsRequest.read_mask:type_name -> google.protobuf.FieldMask
	16, // 4: google.chromeos.moblab.v1beta1.ListBuildsRequest.group_by:type_name -> google.protobuf.FieldMask
	13, // 5: google.chromeos.moblab.v1beta1.ListBuildsResponse.builds:type_name -> google.chromeos.moblab.v1beta1.Build
	17, // 6: google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse.staged_build_artifact:type_name -> google.chromeos.moblab.v1beta1.BuildArtifact
	17, // 7: google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse.source_build_artifact:type_name -> google.chromeos.moblab.v1beta1.BuildArtifact
	18, // 8: google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse.cloud_build:type_name -> google.chromeos.moblab.v1beta1.CloudBuild
	17, // 9: google.chromeos.moblab.v1beta1.StageBuildResponse.staged_build_artifact:type_name -> google.chromeos.moblab.v1beta1.BuildArtifact
	18, // 10: google.chromeos.moblab.v1beta1.StageBuildResponse.cloud_build:type_name -> google.chromeos.moblab.v1beta1.CloudBuild
	19, // 11: google.chromeos.moblab.v1beta1.StageBuildMetadata.start_time:type_name -> google.protobuf.Timestamp
	19, // 12: google.chromeos.moblab.v1beta1.StageBuildMetadata.end_time:type_name -> google.protobuf.Timestamp
	18, // 13: google.chromeos.moblab.v1beta1.StageBuildMetadata.cloud_build:type_name -> google.chromeos.moblab.v1beta1.CloudBuild
	2,  // 14: google.chromeos.moblab.v1beta1.BuildService.ListBuildTargets:input_type -> google.chromeos.moblab.v1beta1.ListBuildTargetsRequest
	4,  // 15: google.chromeos.moblab.v1beta1.BuildService.ListModels:input_type -> google.chromeos.moblab.v1beta1.ListModelsRequest
	6,  // 16: google.chromeos.moblab.v1beta1.BuildService.ListBuilds:input_type -> google.chromeos.moblab.v1beta1.ListBuildsRequest
	8,  // 17: google.chromeos.moblab.v1beta1.BuildService.CheckBuildStageStatus:input_type -> google.chromeos.moblab.v1beta1.CheckBuildStageStatusRequest
	10, // 18: google.chromeos.moblab.v1beta1.BuildService.StageBuild:input_type -> google.chromeos.moblab.v1beta1.StageBuildRequest
	0,  // 19: google.chromeos.moblab.v1beta1.BuildService.FindMostStableBuild:input_type -> google.chromeos.moblab.v1beta1.FindMostStableBuildRequest
	3,  // 20: google.chromeos.moblab.v1beta1.BuildService.ListBuildTargets:output_type -> google.chromeos.moblab.v1beta1.ListBuildTargetsResponse
	5,  // 21: google.chromeos.moblab.v1beta1.BuildService.ListModels:output_type -> google.chromeos.moblab.v1beta1.ListModelsResponse
	7,  // 22: google.chromeos.moblab.v1beta1.BuildService.ListBuilds:output_type -> google.chromeos.moblab.v1beta1.ListBuildsResponse
	9,  // 23: google.chromeos.moblab.v1beta1.BuildService.CheckBuildStageStatus:output_type -> google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse
	20, // 24: google.chromeos.moblab.v1beta1.BuildService.StageBuild:output_type -> google.longrunning.Operation
	1,  // 25: google.chromeos.moblab.v1beta1.BuildService.FindMostStableBuild:output_type -> google.chromeos.moblab.v1beta1.FindMostStableBuildResponse
	20, // [20:26] is the sub-list for method output_type
	14, // [14:20] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_chromeos_moblab_v1beta1_build_service_proto_init() }
func file_google_chromeos_moblab_v1beta1_build_service_proto_init() {
	if File_google_chromeos_moblab_v1beta1_build_service_proto != nil {
		return
	}
	file_google_chromeos_moblab_v1beta1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FindMostStableBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FindMostStableBuildResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckBuildStageStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckBuildStageStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StageBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StageBuildResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StageBuildMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chromeos_moblab_v1beta1_build_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_chromeos_moblab_v1beta1_build_service_proto_goTypes,
		DependencyIndexes: file_google_chromeos_moblab_v1beta1_build_service_proto_depIdxs,
		MessageInfos:      file_google_chromeos_moblab_v1beta1_build_service_proto_msgTypes,
	}.Build()
	File_google_chromeos_moblab_v1beta1_build_service_proto = out.File
	file_google_chromeos_moblab_v1beta1_build_service_proto_rawDesc = nil
	file_google_chromeos_moblab_v1beta1_build_service_proto_goTypes = nil
	file_google_chromeos_moblab_v1beta1_build_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BuildServiceClient is the client API for BuildService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BuildServiceClient interface {
	// Lists all build targets that a user has access to.
	ListBuildTargets(ctx context.Context, in *ListBuildTargetsRequest, opts ...grpc.CallOption) (*ListBuildTargetsResponse, error)
	// Lists all models for the given build target.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. The stage will be skipped if all
	// the objects in the partner bucket are the same as in the internal bucket.
	// Operation
	// <response:[StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//
	//	 metadata:
	//	[StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Finds the most stable build for the given build target. The definition of
	// the most stable build is determined by evaluating the following rule in
	// order until one is true. If none are true, then there is no stable build
	// and it will return an empty response.
	//
	// Evaluation rules:
	//  1. Stable channel build with label “Live”
	//  2. Beta channel build with label “Live”
	//  3. Dev channel build with label “Live”
	//  4. Most recent stable channel build with build status Pass
	//  5. Most recent beta channel build with build status Pass
	//  6. Most recent dev channel build with build status Pass
	FindMostStableBuild(ctx context.Context, in *FindMostStableBuildRequest, opts ...grpc.CallOption) (*FindMostStableBuildResponse, error)
}

type buildServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBuildServiceClient(cc grpc.ClientConnInterface) BuildServiceClient {
	return &buildServiceClient{cc}
}

func (c *buildServiceClient) ListBuildTargets(ctx context.Context, in *ListBuildTargetsRequest, opts ...grpc.CallOption) (*ListBuildTargetsResponse, error) {
	out := new(ListBuildTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/ListBuildTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error) {
	out := new(CheckBuildStageStatusResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/StageBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) FindMostStableBuild(ctx context.Context, in *FindMostStableBuildRequest, opts ...grpc.CallOption) (*FindMostStableBuildResponse, error) {
	out := new(FindMostStableBuildResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/FindMostStableBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BuildServiceServer is the server API for BuildService service.
type BuildServiceServer interface {
	// Lists all build targets that a user has access to.
	ListBuildTargets(context.Context, *ListBuildTargetsRequest) (*ListBuildTargetsResponse, error)
	// Lists all models for the given build target.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(context.Context, *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. The stage will be skipped if all
	// the objects in the partner bucket are the same as in the internal bucket.
	// Operation
	// <response:[StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//
	//	 metadata:
	//	[StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(context.Context, *StageBuildRequest) (*longrunningpb.Operation, error)
	// Finds the most stable build for the given build target. The definition of
	// the most stable build is determined by evaluating the following rule in
	// order until one is true. If none are true, then there is no stable build
	// and it will return an empty response.
	//
	// Evaluation rules:
	//  1. Stable channel build with label “Live”
	//  2. Beta channel build with label “Live”
	//  3. Dev channel build with label “Live”
	//  4. Most recent stable channel build with build status Pass
	//  5. Most recent beta channel build with build status Pass
	//  6. Most recent dev channel build with build status Pass
	FindMostStableBuild(context.Context, *FindMostStableBuildRequest) (*FindMostStableBuildResponse, error)
}

// UnimplementedBuildServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBuildServiceServer struct {
}

func (*UnimplementedBuildServiceServer) ListBuildTargets(context.Context, *ListBuildTargetsRequest) (*ListBuildTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuildTargets not implemented")
}
func (*UnimplementedBuildServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedBuildServiceServer) ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (*UnimplementedBuildServiceServer) CheckBuildStageStatus(context.Context, *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckBuildStageStatus not implemented")
}
func (*UnimplementedBuildServiceServer) StageBuild(context.Context, *StageBuildRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StageBuild not implemented")
}
func (*UnimplementedBuildServiceServer) FindMostStableBuild(context.Context, *FindMostStableBuildRequest) (*FindMostStableBuildResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindMostStableBuild not implemented")
}

func RegisterBuildServiceServer(s *grpc.Server, srv BuildServiceServer) {
	s.RegisterService(&_BuildService_serviceDesc, srv)
}

func _BuildService_ListBuildTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).ListBuildTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/ListBuildTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).ListBuildTargets(ctx, req.(*ListBuildTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_CheckBuildStageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckBuildStageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, req.(*CheckBuildStageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_StageBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StageBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).StageBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/StageBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).StageBuild(ctx, req.(*StageBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_FindMostStableBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMostStableBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).FindMostStableBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/FindMostStableBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).FindMostStableBuild(ctx, req.(*FindMostStableBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BuildService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.chromeos.moblab.v1beta1.BuildService",
	HandlerType: (*BuildServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBuildTargets",
			Handler:    _BuildService_ListBuildTargets_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _BuildService_ListModels_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _BuildService_ListBuilds_Handler,
		},
		{
			MethodName: "CheckBuildStageStatus",
			Handler:    _BuildService_CheckBuildStageStatus_Handler,
		},
		{
			MethodName: "StageBuild",
			Handler:    _BuildService_StageBuild_Handler,
		},
		{
			MethodName: "FindMostStableBuild",
			Handler:    _BuildService_FindMostStableBuild_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/chromeos/moblab/v1beta1/build_service.proto",
}
