// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/privatecatalog/v1beta1/private_catalog.proto

package privatecatalogpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PrivateCatalog_SearchCatalogs_FullMethodName = "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchCatalogs"
	PrivateCatalog_SearchProducts_FullMethodName = "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchProducts"
	PrivateCatalog_SearchVersions_FullMethodName = "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchVersions"
)

// PrivateCatalogClient is the client API for PrivateCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PrivateCatalogClient interface {
	// Search [Catalog][google.cloud.privatecatalog.v1beta1.Catalog] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchCatalogs(ctx context.Context, in *SearchCatalogsRequest, opts ...grpc.CallOption) (*SearchCatalogsResponse, error)
	// Search [Product][google.cloud.privatecatalog.v1beta1.Product] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchProducts(ctx context.Context, in *SearchProductsRequest, opts ...grpc.CallOption) (*SearchProductsResponse, error)
	// Search [Version][google.cloud.privatecatalog.v1beta1.Version] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchVersions(ctx context.Context, in *SearchVersionsRequest, opts ...grpc.CallOption) (*SearchVersionsResponse, error)
}

type privateCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewPrivateCatalogClient(cc grpc.ClientConnInterface) PrivateCatalogClient {
	return &privateCatalogClient{cc}
}

func (c *privateCatalogClient) SearchCatalogs(ctx context.Context, in *SearchCatalogsRequest, opts ...grpc.CallOption) (*SearchCatalogsResponse, error) {
	out := new(SearchCatalogsResponse)
	err := c.cc.Invoke(ctx, PrivateCatalog_SearchCatalogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privateCatalogClient) SearchProducts(ctx context.Context, in *SearchProductsRequest, opts ...grpc.CallOption) (*SearchProductsResponse, error) {
	out := new(SearchProductsResponse)
	err := c.cc.Invoke(ctx, PrivateCatalog_SearchProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privateCatalogClient) SearchVersions(ctx context.Context, in *SearchVersionsRequest, opts ...grpc.CallOption) (*SearchVersionsResponse, error) {
	out := new(SearchVersionsResponse)
	err := c.cc.Invoke(ctx, PrivateCatalog_SearchVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrivateCatalogServer is the server API for PrivateCatalog service.
// All implementations should embed UnimplementedPrivateCatalogServer
// for forward compatibility
type PrivateCatalogServer interface {
	// Search [Catalog][google.cloud.privatecatalog.v1beta1.Catalog] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchCatalogs(context.Context, *SearchCatalogsRequest) (*SearchCatalogsResponse, error)
	// Search [Product][google.cloud.privatecatalog.v1beta1.Product] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchProducts(context.Context, *SearchProductsRequest) (*SearchProductsResponse, error)
	// Search [Version][google.cloud.privatecatalog.v1beta1.Version] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchVersions(context.Context, *SearchVersionsRequest) (*SearchVersionsResponse, error)
}

// UnimplementedPrivateCatalogServer should be embedded to have forward compatible implementations.
type UnimplementedPrivateCatalogServer struct {
}

func (UnimplementedPrivateCatalogServer) SearchCatalogs(context.Context, *SearchCatalogsRequest) (*SearchCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalogs not implemented")
}
func (UnimplementedPrivateCatalogServer) SearchProducts(context.Context, *SearchProductsRequest) (*SearchProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchProducts not implemented")
}
func (UnimplementedPrivateCatalogServer) SearchVersions(context.Context, *SearchVersionsRequest) (*SearchVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchVersions not implemented")
}

// UnsafePrivateCatalogServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PrivateCatalogServer will
// result in compilation errors.
type UnsafePrivateCatalogServer interface {
	mustEmbedUnimplementedPrivateCatalogServer()
}

func RegisterPrivateCatalogServer(s grpc.ServiceRegistrar, srv PrivateCatalogServer) {
	s.RegisterService(&PrivateCatalog_ServiceDesc, srv)
}

func _PrivateCatalog_SearchCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrivateCatalog_SearchCatalogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchCatalogs(ctx, req.(*SearchCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivateCatalog_SearchProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrivateCatalog_SearchProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchProducts(ctx, req.(*SearchProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivateCatalog_SearchVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PrivateCatalog_SearchVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchVersions(ctx, req.(*SearchVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PrivateCatalog_ServiceDesc is the grpc.ServiceDesc for PrivateCatalog service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PrivateCatalog_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.privatecatalog.v1beta1.PrivateCatalog",
	HandlerType: (*PrivateCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalogs",
			Handler:    _PrivateCatalog_SearchCatalogs_Handler,
		},
		{
			MethodName: "SearchProducts",
			Handler:    _PrivateCatalog_SearchProducts_Handler,
		},
		{
			MethodName: "SearchVersions",
			Handler:    _PrivateCatalog_SearchVersions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/privatecatalog/v1beta1/private_catalog.proto",
}
