package portalapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/portal/mgmt/2019-01-01-preview/portal"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result portal.ResourceProviderOperationListPage, err error)
	ListComplete(ctx context.Context) (result portal.ResourceProviderOperationListIterator, err error)
}

var _ OperationsClientAPI = (*portal.OperationsClient)(nil)

// DashboardsClientAPI contains the set of methods on the DashboardsClient type.
type DashboardsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, dashboardName string, dashboard portal.Dashboard) (result portal.Dashboard, err error)
	Delete(ctx context.Context, resourceGroupName string, dashboardName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, dashboardName string) (result portal.Dashboard, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result portal.DashboardListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result portal.DashboardListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result portal.DashboardListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result portal.DashboardListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, dashboardName string, dashboard portal.PatchableDashboard) (result portal.Dashboard, err error)
}

var _ DashboardsClientAPI = (*portal.DashboardsClient)(nil)

// TenantConfigurationsClientAPI contains the set of methods on the TenantConfigurationsClient type.
type TenantConfigurationsClientAPI interface {
	Create(ctx context.Context, tenantConfiguration portal.Configuration) (result portal.Configuration, err error)
	Delete(ctx context.Context) (result autorest.Response, err error)
	Get(ctx context.Context) (result portal.Configuration, err error)
	List(ctx context.Context) (result portal.ConfigurationList, err error)
}

var _ TenantConfigurationsClientAPI = (*portal.TenantConfigurationsClient)(nil)
