// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func TestCopyOrigEntityRefSlice(t *testing.T) {
	src := []*otlpcommon.EntityRef{}
	dest := []*otlpcommon.EntityRef{}
	// Test CopyTo empty
	dest = CopyOrigEntityRefSlice(dest, src)
	assert.Equal(t, []*otlpcommon.EntityRef{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestEntityRefSlice()
	dest = CopyOrigEntityRefSlice(dest, src)
	assert.Equal(t, GenerateOrigTestEntityRefSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigEntityRefSlice(dest, src)
	assert.Equal(t, GenerateOrigTestEntityRefSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigEntityRefSlice(dest, []*otlpcommon.EntityRef{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigEntityRefSlice(dest, src)
	assert.Equal(t, GenerateOrigTestEntityRefSlice(), dest)
}
