/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketCodec;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketHttpHeaders;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebsocketHandshakeHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttWebSocketInitializer {
    @NotNull
    private static final String HTTP_CODEC_NAME = "http.codec";
    @NotNull
    private static final String HTTP_AGGREGATOR_NAME = "http.aggregator";
    @NotNull
    private final MqttWebSocketCodec mqttWebSocketCodec;

    @Inject
    MqttWebSocketInitializer(@NotNull MqttWebSocketCodec mqttWebSocketCodec) {
        this.mqttWebSocketCodec = mqttWebSocketCodec;
    }

    public void initChannel(@NotNull Channel channel, @NotNull MqttClientConfig clientConfig, @NotNull MqttWebSocketConfigImpl webSocketConfig, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        URI uri;
        try {
            MqttClientTransportConfigImpl transportConfig = clientConfig.getCurrentTransportConfig();
            InetSocketAddress serverAddress = transportConfig.getServerAddress();
            uri = new URI(transportConfig.getRawSslConfig() == null ? "ws" : "wss", null, serverAddress.getHostString(), serverAddress.getPort(), "/" + webSocketConfig.getServerPath(), webSocketConfig.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            onError.accept(channel, e);
            return;
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)webSocketConfig.getSubprotocol(), (boolean)true, null, (int)0x10000004, (boolean)true, (boolean)false);
        channel.pipeline().addLast(HTTP_CODEC_NAME, (ChannelHandler)new HttpClientCodec()).addLast(HTTP_AGGREGATOR_NAME, (ChannelHandler)new HttpObjectAggregator(65535)).addLast("http.headers", (ChannelHandler)new MqttWebSocketHttpHeaders(webSocketConfig.getHttpHeaders())).addLast("ws.handshake", (ChannelHandler)new MqttWebsocketHandshakeHandler(handshaker, webSocketConfig.getHandshakeTimeoutMs(), onSuccess, onError)).addLast("ws.mqtt", (ChannelHandler)this.mqttWebSocketCodec);
    }
}

