/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.Field;
import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.internal.util.LimitedCharArrayIntegerUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;
import java.time.format.DateTimeParseException;

public class ZoneOffsetToken
implements DateTimeToken {
    @Override
    public int read(String text, ParsePosition parsePosition) {
        int idx = parsePosition.getIndex();
        int len = text.length();
        int left = len - idx;
        if (left < 1) {
            return -1;
        }
        char c = text.charAt(idx);
        if (c == 'Z' || c == 'z') {
            parsePosition.setIndex(idx + 1);
            return 0;
        }
        char sign = text.charAt(idx);
        if (sign != '+' && sign != '-') {
            ErrorUtil.raiseUnexpectedCharacter(text, idx, 'Z', 'z', '+', '-');
        }
        if (left < 6) {
            throw new DateTimeParseException(String.format("Invalid timezone offset: %s", text), text, idx);
        }
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(text, idx + 1, idx + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(text, idx + 4, idx + 4 + 2);
        if (sign == '-') {
            hours = -hours;
            minutes = -minutes;
            if (hours == 0 && minutes == 0) {
                throw new DateTimeParseException("Unknown 'Local Offset Convention' date-time not allowed", text, idx);
            }
        }
        parsePosition.setIndex(idx + 6);
        return hours * 3600 + minutes * 60;
    }

    @Override
    public Field getField() {
        return Field.ZONE_OFFSET;
    }
}

