/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFCore$$Lambda$1;
import org.newsclub.net.unix.AFCore$$Lambda$2;
import org.newsclub.net.unix.AFCore$$Lambda$3;
import org.newsclub.net.unix.AFCore$$Lambda$4;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.CleanableState;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketClosedException;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.VirtualThreadPoller;
import org.newsclub.net.unix.pool.MutableHolder;
import org.newsclub.net.unix.pool.ObjectPool;
import org.newsclub.net.unix.pool.ObjectPool$;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AFCore
extends CleanableState {
    private static final ObjectPool<MutableHolder<ByteBuffer>> TL_BUFFER = ObjectPool$.newThreadLocalPool(AFCore$$Lambda$3.lambdaFactory$(), AFCore$$Lambda$4.lambdaFactory$());
    private static final String PROP_TL_BUFFER_MAX_CAPACITY = "org.newsclub.net.unix.thread-local-buffer.max-capacity";
    private static final int TL_BUFFER_MIN_CAPACITY = 8192;
    private static final int TL_BUFFER_MAX_CAPACITY = Integer.parseInt(System.getProperty("org.newsclub.net.unix.thread-local-buffer.max-capacity", Integer.toString(0x100000)));
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final FileDescriptor fd;
    final AncillaryDataSupport ancillaryDataSupport;
    private final boolean datagramMode;
    private final AtomicInteger virtualBlockingLeases = new AtomicInteger(0);
    private volatile boolean blocking = true;
    private boolean cleanFd = true;

    AFCore(Object observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport, boolean datagramMode) {
        super(observed);
        this.datagramMode = datagramMode;
        this.ancillaryDataSupport = ancillaryDataSupport;
        this.fd = fd == null ? new FileDescriptor() : fd;
    }

    AFCore(Object observed, FileDescriptor fd) {
        this(observed, fd, null, false);
    }

    @Override
    protected final void doClean() {
        if (this.fd != null && this.fd.valid() && this.cleanFd) {
            try {
                this.doClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ancillaryDataSupport != null) {
            this.ancillaryDataSupport.close();
        }
    }

    void disableCleanFd() {
        this.cleanFd = false;
    }

    boolean isClosed() {
        return this.closed.get();
    }

    void doClose() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            NativeUnixSocket.close(this.fd);
        }
    }

    FileDescriptor validFdOrException() throws SocketException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc == null) {
            this.closed.set(true);
            throw new SocketClosedException("Not open");
        }
        return fdesc;
    }

    synchronized FileDescriptor validFd() {
        if (this.isClosed()) {
            return null;
        }
        FileDescriptor descriptor = this.fd;
        if (descriptor != null && descriptor.valid()) {
            return descriptor;
        }
        return null;
    }

    int read(ByteBuffer dst, AFSupplier<Integer> timeout) throws IOException {
        return this.read(dst, timeout, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    int read(ByteBuffer dst, AFSupplier<Integer> timeout, ByteBuffer socketAddressBuffer, int options) throws IOException {
        int remaining = dst.remaining();
        if (remaining == 0) {
            return 0;
        }
        FileDescriptor fdesc = this.validFdOrException();
        int dstPos = dst.position();
        boolean direct = dst.isDirect();
        boolean virtualBlocking = ThreadUtil.isVirtualThread() && this.isBlocking() || this.isVirtualBlocking();
        long now = virtualBlocking ? System.currentTimeMillis() : 0L;
        if (virtualBlocking || !this.blocking) {
            options |= 4;
        }
        boolean park = false;
        while (true) {
            int pos;
            ByteBuffer buf;
            if (virtualBlocking) {
                if (park) {
                    VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, timeout, AFCore$$Lambda$1.lambdaFactory$(this));
                }
                this.configureVirtualBlocking(true);
            }
            ObjectPool.Lease<MutableHolder<ByteBuffer>> lease = direct ? null : this.getPrivateDirectByteBuffer(remaining);
            if (direct) {
                buf = dst;
                pos = dstPos;
            } else {
                buf = Objects.requireNonNull(Objects.requireNonNull(lease).get().get());
                remaining = Math.min(remaining, buf.remaining());
                pos = buf.position();
                buf.limit(pos + remaining);
            }
            try {
                int count = NativeUnixSocket.receive(fdesc, buf, pos, remaining, socketAddressBuffer, options, this.ancillaryDataSupport, 0);
                if (count != 0 || !virtualBlocking) break;
                park = true;
                if (lease != null) {
                    lease.close();
                }
                if (!virtualBlocking) continue;
            }
            catch (AsynchronousCloseException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                if (this.isClosed()) {
                    throw e;
                }
                if (!Thread.currentThread().isInterrupted()) throw (AsynchronousCloseException)new AsynchronousCloseException().initCause(e);
                throw (ClosedByInterruptException)new ClosedByInterruptException().initCause(e);
            }
            catch (SocketTimeoutException e) {
                if (!virtualBlocking) throw e;
                park = true;
                continue;
            }
            this.configureVirtualBlocking(false);
        }
    }

    int write(ByteBuffer src, AFSupplier<Integer> timeout) throws IOException {
        return this.write(src, timeout, null, 0);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    int write(ByteBuffer src, AFSupplier<Integer> timeout, SocketAddress target, int options) throws IOException {
        int remaining = src.remaining();
        if (remaining == 0) {
            return 0;
        }
        FileDescriptor fdesc = this.validFdOrException();
        try (ObjectPool.Lease<ByteBuffer> addressToLease = target == null ? null : AFSocketAddress.SOCKETADDRESS_BUFFER_TL.take();){
            int written;
            int addressToLen;
            ByteBuffer addressTo;
            if (addressToLease == null) {
                addressTo = null;
                addressToLen = 0;
            } else {
                addressTo = addressToLease.get();
                addressToLen = AFSocketAddress.unwrapAddressDirectBufferInternal(addressTo, target);
            }
            int pos = src.position();
            boolean isDirect = src.isDirect();
            boolean virtualBlocking = ThreadUtil.isVirtualThread() && this.isBlocking() || this.isVirtualBlocking();
            long now = virtualBlocking ? System.currentTimeMillis() : 0L;
            if (virtualBlocking || !this.blocking) {
                options |= 4;
            }
            if (this.datagramMode) {
                options |= 0x10;
            }
            boolean park = false;
            while (true) {
                if (virtualBlocking) {
                    if (park) {
                        VirtualThreadPoller.INSTANCE.parkThreadUntilReady(fdesc, 4, now, timeout, AFCore$$Lambda$2.lambdaFactory$(this));
                    }
                    this.configureVirtualBlocking(true);
                }
                try {
                    ObjectPool.Lease<MutableHolder<ByteBuffer>> lease = isDirect ? null : this.getPrivateDirectByteBuffer(remaining);
                    try {
                        int bufPos;
                        ByteBuffer buf;
                        if (isDirect) {
                            buf = src;
                            bufPos = pos;
                        } else {
                            buf = Objects.requireNonNull(Objects.requireNonNull(lease).get().get());
                            remaining = Math.min(remaining, buf.remaining());
                            bufPos = buf.position();
                            while (src.hasRemaining() && buf.hasRemaining()) {
                                buf.put(src);
                            }
                            buf.position(bufPos);
                        }
                        written = NativeUnixSocket.send(fdesc, buf, bufPos, remaining, addressTo, addressToLen, options, this.ancillaryDataSupport);
                        if (written != 0 || !virtualBlocking) break;
                        park = true;
                        continue;
                    }
                    finally {
                        if (lease == null) continue;
                        lease.close();
                        continue;
                    }
                }
                catch (SocketTimeoutException e) {
                    if (virtualBlocking) {
                        park = true;
                        continue;
                    }
                    throw e;
                }
                finally {
                    if (!virtualBlocking) continue;
                    this.configureVirtualBlocking(false);
                    continue;
                }
                break;
            }
            src.position(pos + written);
            int n = written;
            return n;
        }
    }

    ObjectPool.Lease<MutableHolder<@NonNull ByteBuffer>> getPrivateDirectByteBuffer(int capacity) {
        ObjectPool.Lease<MutableHolder<ByteBuffer>> lease;
        MutableHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        if (capacity > TL_BUFFER_MAX_CAPACITY && TL_BUFFER_MAX_CAPACITY > 0) {
            return ObjectPool$.unpooledLease(new MutableHolder<ByteBuffer>(ByteBuffer.allocateDirect(capacity)));
        }
        if (capacity < 8192) {
            capacity = 8192;
        }
        if ((buffer = (holder = (lease = TL_BUFFER.take()).get()).get()) == null || capacity > buffer.capacity()) {
            buffer = ByteBuffer.allocateDirect(capacity);
            holder.set(buffer);
        }
        buffer.clear();
        return lease;
    }

    void implConfigureBlocking(boolean block) throws IOException {
        this.blocking = block;
        if (!block || !this.isVirtualBlocking()) {
            NativeUnixSocket.configureBlocking(this.validFdOrException(), block);
        }
    }

    void configureVirtualBlocking(boolean enabled) throws SocketException, IOException {
        if (enabled) {
            int v = this.virtualBlockingLeases.incrementAndGet();
            if (v >= 1 && this.blocking) {
                NativeUnixSocket.configureBlocking(this.validFdOrException(), false);
            }
            if (v >= Integer.MAX_VALUE) {
                throw new IOException("blocking overflow");
            }
        } else {
            int v = this.virtualBlockingLeases.decrementAndGet();
            if (v == 0 && this.blocking) {
                NativeUnixSocket.configureBlocking(this.validFdOrException(), true);
            }
            if (v < 0) {
                throw new IOException("blocking underflow");
            }
        }
    }

    boolean isVirtualBlocking() {
        return this.virtualBlockingLeases.get() > 0;
    }

    boolean isBlocking() {
        return this.blocking;
    }

    static /* synthetic */ boolean lambda$static$1(MutableHolder o) {
        ByteBuffer bb = (ByteBuffer)o.get();
        if (bb != null) {
            bb.clear();
        }
        return true;
    }

    static /* synthetic */ MutableHolder lambda$static$0() {
        return new MutableHolder<Object>(null);
    }
}

