/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.preformance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sun.management.GcInfo;
import com.ubnt.service.trace.api.preformance.MemoryUsageStats;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GcCycleStats {
    private Long durationMillis;
    private Map<String, MemoryUsageStats> memoryPoolUsageBeforeGc;
    private Map<String, MemoryUsageStats> memoryPoolUsageAfterGc;

    public Long getDurationMillis() {
        return this.durationMillis;
    }

    public Map<String, MemoryUsageStats> getMemoryPoolUsageBefore() {
        return this.memoryPoolUsageBeforeGc;
    }

    public Map<String, MemoryUsageStats> getMemoryPoolUsageAfter() {
        return this.memoryPoolUsageAfterGc;
    }

    public static GcCycleStats of(GcInfo gcInfo) {
        if (gcInfo == null) {
            return null;
        }
        GcCycleStats gcCycleStats = new GcCycleStats();
        gcCycleStats.durationMillis = gcInfo.getDuration();
        gcCycleStats.memoryPoolUsageBeforeGc = GcCycleStats.\u00d200000(gcInfo.getMemoryUsageBeforeGc());
        gcCycleStats.memoryPoolUsageAfterGc = GcCycleStats.\u00d200000(gcInfo.getMemoryUsageAfterGc());
        return gcCycleStats;
    }

    private static Map<String, MemoryUsageStats> \u00d200000(Map<String, MemoryUsage> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MemoryUsageStats.of((MemoryUsage)entry.getValue())));
    }
}

