/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.teleport;

import com.ubnt.data.Site;
import com.ubnt.model.api.teleport.ImmutableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.ModifiableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.TeleportAccessRequestDto;
import com.ubnt.model.api.teleport.TeleportAccessResponseDto;
import com.ubnt.model.api.teleport.TeleportInvitationDto;
import com.ubnt.model.api.teleport.TeleportInvitationListDto;
import com.ubnt.model.api.teleport.TeleportTokenDto;
import com.ubnt.model.api.teleport.TeleportTokenListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.config.security.annotation.RequireConsoleOwner;
import com.ubnt.net.v2.config.security.annotation.RequireWritePrivileges;
import com.ubnt.service.teleport.J;
import com.ubnt.service.teleport.K;
import com.ubnt.service.teleport.TeleportTokenDocument;
import com.ubnt.service.teleport.c;
import com.ubnt.service.teleport.oOOO;
import com.ubnt.service.teleport.returnsuper;
import com.ubnt.service.teleport.t;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Teleport")
public class TeleportController {
    private static final String \u00d200000 = "https://teleport.ui.link/";
    private static final String \u00d300000 = "********-****-****-****-********";
    private final t super;

    public TeleportController(t t2) {
        this.super = t2;
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/token"})
    @Operation(summary="Create new Teleport short-term token")
    @AllowUCoreLocal
    public Publisher<TeleportTokenDto> createNewToken(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d600000(site.getId()).map(r2 -> {
            String string = this.\u00f400000(r2.\u00d300000());
            return TeleportTokenDto.ofDocument(r2.\u00d200000(), string);
        });
    }

    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @Operation(summary="Return paginated list of Teleport invitation history", description="Since 7.2.67")
    @AllowUCoreLocal
    public TeleportInvitationListDto searchInvitationHistory(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        c c2 = this.new(modifiableTeleportTokenListParameter, site);
        J j2 = this.super.float(c2);
        return TeleportInvitationListDto.builder().totalElementCount(j2.\u00d300000()).totalPageCount(j2.\u00d400000()).pageNumber(j2.o00000()).data(this.\u00f500000(j2.new())).build();
    }

    @RequireWritePrivileges
    @PostMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @Operation(summary="Return paginated list of Teleport invitation history", description="Since 8.0.22")
    @AllowUCoreLocal
    public TeleportInvitationListDto postSearchInvitationHistory(@PathVariable(value="siteName") Site site, @RequestBody @Valid ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        return this.searchInvitationHistory(site, modifiableTeleportTokenListParameter);
    }

    @Deprecated
    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/token"})
    @Operation(summary="Return paginated list of Teleport active short-term tokens", description="Since 7.1.2")
    public TeleportTokenListDto searchActiveShortTermTokens(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        c c2 = this.new(modifiableTeleportTokenListParameter, site);
        oOOO oOOO2 = this.super.\u00f500000(c2);
        return TeleportTokenListDto.builder().totalElementCount(oOOO2.\u00d300000()).totalPageCount(oOOO2.\u00d400000()).pageNumber(oOOO2.o00000()).data(this.return(oOOO2.new())).build();
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/token/{tokenId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Remove Teleport short-term token", description="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> removeShortTermToken(@PathVariable(value="siteName") Site site, @PathVariable(value="tokenId") String string) {
        return this.super.OO0000(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/disconnect-client/{clientId}"})
    @Operation(summary="Disconnect Teleport client", description="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> disconnectClient(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.super.o00000(site.getId(), string).flatMap(teleportClientDocument -> Mono.empty());
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/client/{clientId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Remove client and their token")
    @AllowUCoreLocal
    public Publisher<Void> removeClientAndToken(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.super.\u00d500000(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/access-request"})
    @Operation(summary="Create new Teleport long-term token", description="Since 7.2.6")
    @RequireConsoleOwner
    public Publisher<TeleportAccessResponseDto> createNewLongTermTokenForOwner(@PathVariable(value="siteName") Site site, @Valid @RequestBody TeleportAccessRequestDto teleportAccessRequestDto) {
        return this.super.Object(site.getId(), K.super(teleportAccessRequestDto)).map(TeleportAccessResponseDto::ofDocument);
    }

    private c new(ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter, Site site) {
        ImmutableTeleportTokenListParameter immutableTeleportTokenListParameter = modifiableTeleportTokenListParameter.toImmutable();
        return c.o00000().\u00d800000(site.getId()).\u00d200000(immutableTeleportTokenListParameter.getPageNumber()).String(immutableTeleportTokenListParameter.getPageSize()).\u00d300000();
    }

    private String \u00f400000(String string) {
        return \u00d200000 + string;
    }

    private List<TeleportTokenDto> return(List<TeleportTokenDocument> list) {
        return list.stream().map(this::\u00d800000).collect(Collectors.toList());
    }

    private TeleportTokenDto \u00d800000(TeleportTokenDocument teleportTokenDocument) {
        String string = this.\u00d300000(teleportTokenDocument.getSecretIdentifier());
        return TeleportTokenDto.ofDocument(teleportTokenDocument, string);
    }

    private List<TeleportInvitationDto> \u00f500000(List<returnsuper> list) {
        return list.stream().map(returnsuper2 -> TeleportInvitationDto.builder().client(returnsuper2.\u00f400000()).creationTimestamp(returnsuper2.\u00d600000()).expirationTimestamp(returnsuper2.\u00d400000()).invitationStatus(returnsuper2.\u00d800000()).invitationTokenId(returnsuper2.\u00d300000()).invitationUrl(this.\u00d300000(returnsuper2.super())).tokenId(returnsuper2.class()).build()).collect(Collectors.toList());
    }

    private String \u00d300000(String string) {
        return "https://teleport.ui.link/********-****-****-****-********" + string;
    }
}

