/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.ospf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.F.return;
import com.ubnt.model.api.ospf.ImmutableOspfRouterDto;
import com.ubnt.model.api.ospf.OspfAreaDto;
import com.ubnt.model.api.ospf.OspfInterfaceDto;
import com.ubnt.model.api.ospf.OspfRedistributionMetricType;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.service.ospf.OspfRouterDocument;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Schema(name="OSPF Router")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableOspfRouterDto.class)
@Value.Immutable
@return
public interface OspfRouterDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="router_id")
    @NotEmpty
    @Ip
    public String routerId();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="announce_default_route")
    public boolean announceDefaultRoute();

    @JsonProperty(value="redistribute_static_routes")
    public boolean redistributeStaticRoutes();

    @JsonProperty(value="redistribute_static_routes_metric_type")
    public Optional<OspfRedistributionMetricType> redistributeStaticRoutesMetricType();

    @JsonProperty(value="redistribute_connected_routes")
    public boolean redistributeConnectedRoutes();

    @JsonProperty(value="redistribute_connected_routes_metric_type")
    public Optional<OspfRedistributionMetricType> redistributeConnectedRoutesMetricType();

    @JsonProperty(value="areas")
    @Size(min=1)
    public @Size(min=1) List<@Valid OspfAreaDto> areas();

    @JsonProperty(value="interfaces")
    @Size(min=1)
    public @Size(min=1) List<@Valid OspfInterfaceDto> interfaces();

    public static ImmutableOspfRouterDto.Builder builder() {
        return ImmutableOspfRouterDto.builder();
    }

    public static OspfRouterDto ofDocument(OspfRouterDocument ospfRouterDocument) {
        return OspfRouterDto.builder().id(ospfRouterDocument.getId()).routerId(ospfRouterDocument.getRouterId()).enabled(ospfRouterDocument.isEnabled()).announceDefaultRoute(ospfRouterDocument.isAnnounceDefaultRoute()).redistributeStaticRoutes(ospfRouterDocument.isRedistributeStaticRoutes()).redistributeStaticRoutesMetricType(ospfRouterDocument.getRedistributeStaticRoutesMetricType()).redistributeConnectedRoutes(ospfRouterDocument.isRedistributeConnectedRoutes()).redistributeConnectedRoutesMetricType(ospfRouterDocument.getRedistributeConnectedRoutesMetricType()).areas(ospfRouterDocument.getAreas().stream().map(OspfAreaDto::ofDocument).toList()).interfaces(ospfRouterDocument.getInterfaces().stream().map(OspfInterfaceDto::ofDocument).toList()).build();
    }

    default public OspfRouterDocument toDocument(String string) {
        return OspfRouterDocument.builder().while(string).\u00d400000(this.id()).thissuper(this.routerId()).\u00d4O0000(this.enabled()).\u00f400000(this.announceDefaultRoute()).\u00f500000(this.redistributeStaticRoutes()).\u00d300000(this.redistributeStaticRoutesMetricType().orElse(null)).OO0000(this.redistributeConnectedRoutes()).new(this.redistributeConnectedRoutesMetricType().orElse(null)).o00000(this.areas().stream().map(OspfAreaDto::toDocument).toList()).return(this.interfaces().stream().map(OspfInterfaceDto::toDocument).toList()).\u00d5O0000();
    }

    default public OspfRouterDocument toDocument(String string, String string2) {
        return OspfRouterDocument.builder().while(string2).\u00d400000(string).thissuper(this.routerId()).\u00d4O0000(this.enabled()).\u00f400000(this.announceDefaultRoute()).\u00f500000(this.redistributeStaticRoutes()).\u00d300000(this.redistributeStaticRoutesMetricType().orElse(null)).OO0000(this.redistributeConnectedRoutes()).new(this.redistributeConnectedRoutesMetricType().orElse(null)).o00000(this.areas().stream().map(OspfAreaDto::toDocument).toList()).return(this.interfaces().stream().map(OspfInterfaceDto::toDocument).toList()).\u00d5O0000();
    }
}

