/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.HeapSorter;
import io.jenetics.internal.util.InsertionSorter;
import io.jenetics.internal.util.IntComparator;
import io.jenetics.util.Seq;
import java.util.Comparator;

public abstract class IndexSorter {
    private static final int INSERTION_SORT_THRESHOLD = 80;

    public abstract <T> int[] sort(Seq<? extends T> var1, int[] var2, Comparator<? super T> var3);

    public <C extends Comparable<? super C>> int[] sort(Seq<? extends C> array2, int[] indexes) {
        return this.sort(array2, indexes, Comparator.naturalOrder());
    }

    public abstract <T> int[] sort(T[] var1, int[] var2, Comparator<? super T> var3);

    public <C extends Comparable<? super C>> int[] sort(C[] array2, int[] indexes) {
        return this.sort(array2, indexes, Comparator.naturalOrder());
    }

    public abstract int[] sort(int[] var1, int[] var2, IntComparator var3);

    public int[] sort(int[] array2, int[] indexes) {
        return this.sort(array2, indexes, Integer::compare);
    }

    public abstract int[] sort(long[] var1, int[] var2);

    public abstract int[] sort(double[] var1, int[] var2);

    public static IndexSorter sorter(int length) {
        return length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
    }

    public static <T> int[] sort(Seq<? extends T> array2, Comparator<? super T> comparator) {
        IndexSorter sorter = array2.size() < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.size()), comparator);
    }

    public static <C extends Comparable<? super C>> int[] sort(Seq<? extends C> array2) {
        IndexSorter sorter = array2.size() < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.size()));
    }

    public static <T> int[] sort(T[] array2, Comparator<? super T> comparator) {
        IndexSorter sorter = array2.length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.length), comparator);
    }

    public static <C extends Comparable<? super C>> int[] sort(C[] array2) {
        IndexSorter sorter = array2.length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort((Comparable[])array2, IndexSorter.indexes(array2.length));
    }

    public static int[] sort(int[] array2) {
        IndexSorter sorter = array2.length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.length));
    }

    public static int[] sort(long[] array2) {
        IndexSorter sorter = array2.length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.length));
    }

    public static int[] sort(double[] array2) {
        IndexSorter sorter = array2.length < 80 ? InsertionSorter.INSTANCE : HeapSorter.INSTANCE;
        return sorter.sort(array2, IndexSorter.indexes(array2.length));
    }

    public static int[] indexes(int length) {
        return IndexSorter.init(new int[length]);
    }

    public static int[] init(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

