/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;

public class TournamentSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private final int _sampleSize;

    public TournamentSelector(int sampleSize) {
        if (sampleSize < 2) {
            throw new IllegalArgumentException("Sample size must be greater than one, but was " + sampleSize);
        }
        this._sampleSize = sampleSize;
    }

    public TournamentSelector() {
        this(2);
    }

    @Override
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        Objects.requireNonNull(opt, "Optimization");
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %s", count));
        }
        Random random2 = RandomRegistry.getRandom();
        return population.isEmpty() ? ISeq.empty() : MSeq.ofLength(count).fill(() -> this.select(population, opt, this._sampleSize, random2)).toISeq();
    }

    private Phenotype<G, C> select(Seq<Phenotype<G, C>> population, Optimize opt, int sampleSize, Random random2) {
        int N = population.size();
        return Stream.generate(() -> (Phenotype)population.get(random2.nextInt(N))).limit(sampleSize).max(opt.ascending()).orElseThrow(IllegalStateException::new);
    }

    public int hashCode() {
        return Hash.of(this.getClass()).and(this._sampleSize).value();
    }

    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(s -> this._sampleSize == s._sampleSize);
    }

    public String toString() {
        return String.format("%s[s=%d]", this.getClass().getSimpleName(), this._sampleSize);
    }
}

