// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PublicError PublicError is derived from Error and only contains information
// available to the end user.
//
// swagger:model publicError
type PublicError struct {

	// Extra Additional information about the error
	Extra interface{} `json:"extra,omitempty"`

	// Message A human readable message
	Message string `json:"message,omitempty"`

	// MessageID A unique identifier for the error
	// Required: true
	MessageID *string `json:"messageId"`

	// StatusCode The HTTP status code returned
	// Required: true
	StatusCode *int64 `json:"statusCode"`
}

// Validate validates this public error
func (m *PublicError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessageID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusCode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicError) validateMessageID(formats strfmt.Registry) error {

	if err := validate.Required("messageId", "body", m.MessageID); err != nil {
		return err
	}

	return nil
}

func (m *PublicError) validateStatusCode(formats strfmt.Registry) error {

	if err := validate.Required("statusCode", "body", m.StatusCode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this public error based on context it is used
func (m *PublicError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PublicError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublicError) UnmarshalBinary(b []byte) error {
	var res PublicError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
