// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new users API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for users API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetUserByID(userID int64, opts ...ClientOption) (*GetUserByIDOK, error)
	GetUserByIDWithParams(params *GetUserByIDParams, opts ...ClientOption) (*GetUserByIDOK, error)

	GetUserByLoginOrEmail(loginOrEmail string, opts ...ClientOption) (*GetUserByLoginOrEmailOK, error)
	GetUserByLoginOrEmailWithParams(params *GetUserByLoginOrEmailParams, opts ...ClientOption) (*GetUserByLoginOrEmailOK, error)

	GetUserOrgList(userID int64, opts ...ClientOption) (*GetUserOrgListOK, error)
	GetUserOrgListWithParams(params *GetUserOrgListParams, opts ...ClientOption) (*GetUserOrgListOK, error)

	GetUserTeams(userID int64, opts ...ClientOption) (*GetUserTeamsOK, error)
	GetUserTeamsWithParams(params *GetUserTeamsParams, opts ...ClientOption) (*GetUserTeamsOK, error)

	SearchUsers(params *SearchUsersParams, opts ...ClientOption) (*SearchUsersOK, error)

	SearchUsersWithPaging(opts ...ClientOption) (*SearchUsersWithPagingOK, error)
	SearchUsersWithPagingWithParams(params *SearchUsersWithPagingParams, opts ...ClientOption) (*SearchUsersWithPagingOK, error)

	UpdateUser(userID int64, body *models.UpdateUserCommand, opts ...ClientOption) (*UpdateUserOK, error)
	UpdateUserWithParams(params *UpdateUserParams, opts ...ClientOption) (*UpdateUserOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetUserByID gets user by id
*/
func (a *Client) GetUserByID(userID int64, opts ...ClientOption) (*GetUserByIDOK, error) {
	params := NewGetUserByIDParams().WithUserID(userID)
	return a.GetUserByIDWithParams(params, opts...)
}

func (a *Client) GetUserByIDWithParams(params *GetUserByIDParams, opts ...ClientOption) (*GetUserByIDOK, error) {
	if params == nil {
		params = NewGetUserByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserByID",
		Method:             "GET",
		PathPattern:        "/users/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserByLoginOrEmail gets user by login or email
*/
func (a *Client) GetUserByLoginOrEmail(loginOrEmail string, opts ...ClientOption) (*GetUserByLoginOrEmailOK, error) {
	params := NewGetUserByLoginOrEmailParams().WithLoginOrEmail(loginOrEmail)
	return a.GetUserByLoginOrEmailWithParams(params, opts...)
}

func (a *Client) GetUserByLoginOrEmailWithParams(params *GetUserByLoginOrEmailParams, opts ...ClientOption) (*GetUserByLoginOrEmailOK, error) {
	if params == nil {
		params = NewGetUserByLoginOrEmailParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserByLoginOrEmail",
		Method:             "GET",
		PathPattern:        "/users/lookup",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserByLoginOrEmailReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserByLoginOrEmailOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserByLoginOrEmail: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserOrgList gets organizations for user

Get organizations for user identified by id.
*/
func (a *Client) GetUserOrgList(userID int64, opts ...ClientOption) (*GetUserOrgListOK, error) {
	params := NewGetUserOrgListParams().WithUserID(userID)
	return a.GetUserOrgListWithParams(params, opts...)
}

func (a *Client) GetUserOrgListWithParams(params *GetUserOrgListParams, opts ...ClientOption) (*GetUserOrgListOK, error) {
	if params == nil {
		params = NewGetUserOrgListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserOrgList",
		Method:             "GET",
		PathPattern:        "/users/{user_id}/orgs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserOrgListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserOrgListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserOrgList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserTeams gets teams for user

Get teams for user identified by id.
*/
func (a *Client) GetUserTeams(userID int64, opts ...ClientOption) (*GetUserTeamsOK, error) {
	params := NewGetUserTeamsParams().WithUserID(userID)
	return a.GetUserTeamsWithParams(params, opts...)
}

func (a *Client) GetUserTeamsWithParams(params *GetUserTeamsParams, opts ...ClientOption) (*GetUserTeamsOK, error) {
	if params == nil {
		params = NewGetUserTeamsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserTeams",
		Method:             "GET",
		PathPattern:        "/users/{user_id}/teams",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserTeamsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserTeamsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserTeams: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SearchUsers gets users

Returns all users that the authenticated user has permission to view, admin permission required.
*/

func (a *Client) SearchUsers(params *SearchUsersParams, opts ...ClientOption) (*SearchUsersOK, error) {
	if params == nil {
		params = NewSearchUsersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "searchUsers",
		Method:             "GET",
		PathPattern:        "/users",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchUsersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchUsersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for searchUsers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SearchUsersWithPaging gets users with paging
*/
func (a *Client) SearchUsersWithPaging(opts ...ClientOption) (*SearchUsersWithPagingOK, error) {
	params := NewSearchUsersWithPagingParams()
	return a.SearchUsersWithPagingWithParams(params, opts...)
}

func (a *Client) SearchUsersWithPagingWithParams(params *SearchUsersWithPagingParams, opts ...ClientOption) (*SearchUsersWithPagingOK, error) {
	if params == nil {
		params = NewSearchUsersWithPagingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "searchUsersWithPaging",
		Method:             "GET",
		PathPattern:        "/users/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchUsersWithPagingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchUsersWithPagingOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for searchUsersWithPaging: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateUser updates user

Update the user identified by id.
*/
func (a *Client) UpdateUser(userID int64, body *models.UpdateUserCommand, opts ...ClientOption) (*UpdateUserOK, error) {
	params := NewUpdateUserParams().WithBody(body).WithUserID(userID)
	return a.UpdateUserWithParams(params, opts...)
}

func (a *Client) UpdateUserWithParams(params *UpdateUserParams, opts ...ClientOption) (*UpdateUserOK, error) {
	if params == nil {
		params = NewUpdateUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateUser",
		Method:             "PUT",
		PathPattern:        "/users/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateUser: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
