// Code generated by go-swagger; DO NOT EDIT.

package teams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateTeamReader is a Reader for the CreateTeam structure.
type CreateTeamReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateTeamReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateTeamOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCreateTeamUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateTeamForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateTeamConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateTeamInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /teams] createTeam", response, response.Code())
	}
}

// NewCreateTeamOK creates a CreateTeamOK with default headers values
func NewCreateTeamOK() *CreateTeamOK {
	return &CreateTeamOK{}
}

/*
CreateTeamOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateTeamOK struct {
	Payload *models.CreateTeamOKBody
}

// IsSuccess returns true when this create team Ok response has a 2xx status code
func (o *CreateTeamOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create team Ok response has a 3xx status code
func (o *CreateTeamOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create team Ok response has a 4xx status code
func (o *CreateTeamOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create team Ok response has a 5xx status code
func (o *CreateTeamOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create team Ok response a status code equal to that given
func (o *CreateTeamOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create team Ok response
func (o *CreateTeamOK) Code() int {
	return 200
}

func (o *CreateTeamOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamOk %s", 200, payload)
}

func (o *CreateTeamOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamOk %s", 200, payload)
}

func (o *CreateTeamOK) GetPayload() *models.CreateTeamOKBody {
	return o.Payload
}

func (o *CreateTeamOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CreateTeamOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTeamUnauthorized creates a CreateTeamUnauthorized with default headers values
func NewCreateTeamUnauthorized() *CreateTeamUnauthorized {
	return &CreateTeamUnauthorized{}
}

/*
CreateTeamUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateTeamUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create team unauthorized response has a 2xx status code
func (o *CreateTeamUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create team unauthorized response has a 3xx status code
func (o *CreateTeamUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create team unauthorized response has a 4xx status code
func (o *CreateTeamUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create team unauthorized response has a 5xx status code
func (o *CreateTeamUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create team unauthorized response a status code equal to that given
func (o *CreateTeamUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create team unauthorized response
func (o *CreateTeamUnauthorized) Code() int {
	return 401
}

func (o *CreateTeamUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamUnauthorized %s", 401, payload)
}

func (o *CreateTeamUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamUnauthorized %s", 401, payload)
}

func (o *CreateTeamUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateTeamUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTeamForbidden creates a CreateTeamForbidden with default headers values
func NewCreateTeamForbidden() *CreateTeamForbidden {
	return &CreateTeamForbidden{}
}

/*
CreateTeamForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateTeamForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create team forbidden response has a 2xx status code
func (o *CreateTeamForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create team forbidden response has a 3xx status code
func (o *CreateTeamForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create team forbidden response has a 4xx status code
func (o *CreateTeamForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create team forbidden response has a 5xx status code
func (o *CreateTeamForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create team forbidden response a status code equal to that given
func (o *CreateTeamForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create team forbidden response
func (o *CreateTeamForbidden) Code() int {
	return 403
}

func (o *CreateTeamForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamForbidden %s", 403, payload)
}

func (o *CreateTeamForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamForbidden %s", 403, payload)
}

func (o *CreateTeamForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateTeamForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTeamConflict creates a CreateTeamConflict with default headers values
func NewCreateTeamConflict() *CreateTeamConflict {
	return &CreateTeamConflict{}
}

/*
CreateTeamConflict describes a response with status code 409, with default header values.

ConflictError
*/
type CreateTeamConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create team conflict response has a 2xx status code
func (o *CreateTeamConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create team conflict response has a 3xx status code
func (o *CreateTeamConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create team conflict response has a 4xx status code
func (o *CreateTeamConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this create team conflict response has a 5xx status code
func (o *CreateTeamConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this create team conflict response a status code equal to that given
func (o *CreateTeamConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the create team conflict response
func (o *CreateTeamConflict) Code() int {
	return 409
}

func (o *CreateTeamConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamConflict %s", 409, payload)
}

func (o *CreateTeamConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamConflict %s", 409, payload)
}

func (o *CreateTeamConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateTeamConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTeamInternalServerError creates a CreateTeamInternalServerError with default headers values
func NewCreateTeamInternalServerError() *CreateTeamInternalServerError {
	return &CreateTeamInternalServerError{}
}

/*
CreateTeamInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateTeamInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create team internal server error response has a 2xx status code
func (o *CreateTeamInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create team internal server error response has a 3xx status code
func (o *CreateTeamInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create team internal server error response has a 4xx status code
func (o *CreateTeamInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create team internal server error response has a 5xx status code
func (o *CreateTeamInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create team internal server error response a status code equal to that given
func (o *CreateTeamInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create team internal server error response
func (o *CreateTeamInternalServerError) Code() int {
	return 500
}

func (o *CreateTeamInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamInternalServerError %s", 500, payload)
}

func (o *CreateTeamInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /teams][%d] createTeamInternalServerError %s", 500, payload)
}

func (o *CreateTeamInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateTeamInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
