// Code generated by go-swagger; DO NOT EDIT.

package sso_settings

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetProviderSettingsReader is a Reader for the GetProviderSettings structure.
type GetProviderSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetProviderSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetProviderSettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetProviderSettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetProviderSettingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetProviderSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetProviderSettingsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /v1/sso-settings/{key}] getProviderSettings", response, response.Code())
	}
}

// NewGetProviderSettingsOK creates a GetProviderSettingsOK with default headers values
func NewGetProviderSettingsOK() *GetProviderSettingsOK {
	return &GetProviderSettingsOK{}
}

/*
GetProviderSettingsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetProviderSettingsOK struct {
	Payload *models.GetProviderSettingsOKBody
}

// IsSuccess returns true when this get provider settings Ok response has a 2xx status code
func (o *GetProviderSettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get provider settings Ok response has a 3xx status code
func (o *GetProviderSettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get provider settings Ok response has a 4xx status code
func (o *GetProviderSettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get provider settings Ok response has a 5xx status code
func (o *GetProviderSettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get provider settings Ok response a status code equal to that given
func (o *GetProviderSettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get provider settings Ok response
func (o *GetProviderSettingsOK) Code() int {
	return 200
}

func (o *GetProviderSettingsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsOk %s", 200, payload)
}

func (o *GetProviderSettingsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsOk %s", 200, payload)
}

func (o *GetProviderSettingsOK) GetPayload() *models.GetProviderSettingsOKBody {
	return o.Payload
}

func (o *GetProviderSettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GetProviderSettingsOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetProviderSettingsBadRequest creates a GetProviderSettingsBadRequest with default headers values
func NewGetProviderSettingsBadRequest() *GetProviderSettingsBadRequest {
	return &GetProviderSettingsBadRequest{}
}

/*
GetProviderSettingsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetProviderSettingsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get provider settings bad request response has a 2xx status code
func (o *GetProviderSettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get provider settings bad request response has a 3xx status code
func (o *GetProviderSettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get provider settings bad request response has a 4xx status code
func (o *GetProviderSettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get provider settings bad request response has a 5xx status code
func (o *GetProviderSettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get provider settings bad request response a status code equal to that given
func (o *GetProviderSettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get provider settings bad request response
func (o *GetProviderSettingsBadRequest) Code() int {
	return 400
}

func (o *GetProviderSettingsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsBadRequest %s", 400, payload)
}

func (o *GetProviderSettingsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsBadRequest %s", 400, payload)
}

func (o *GetProviderSettingsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetProviderSettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetProviderSettingsUnauthorized creates a GetProviderSettingsUnauthorized with default headers values
func NewGetProviderSettingsUnauthorized() *GetProviderSettingsUnauthorized {
	return &GetProviderSettingsUnauthorized{}
}

/*
GetProviderSettingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetProviderSettingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get provider settings unauthorized response has a 2xx status code
func (o *GetProviderSettingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get provider settings unauthorized response has a 3xx status code
func (o *GetProviderSettingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get provider settings unauthorized response has a 4xx status code
func (o *GetProviderSettingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get provider settings unauthorized response has a 5xx status code
func (o *GetProviderSettingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get provider settings unauthorized response a status code equal to that given
func (o *GetProviderSettingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get provider settings unauthorized response
func (o *GetProviderSettingsUnauthorized) Code() int {
	return 401
}

func (o *GetProviderSettingsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsUnauthorized %s", 401, payload)
}

func (o *GetProviderSettingsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsUnauthorized %s", 401, payload)
}

func (o *GetProviderSettingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetProviderSettingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetProviderSettingsForbidden creates a GetProviderSettingsForbidden with default headers values
func NewGetProviderSettingsForbidden() *GetProviderSettingsForbidden {
	return &GetProviderSettingsForbidden{}
}

/*
GetProviderSettingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetProviderSettingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get provider settings forbidden response has a 2xx status code
func (o *GetProviderSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get provider settings forbidden response has a 3xx status code
func (o *GetProviderSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get provider settings forbidden response has a 4xx status code
func (o *GetProviderSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get provider settings forbidden response has a 5xx status code
func (o *GetProviderSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get provider settings forbidden response a status code equal to that given
func (o *GetProviderSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get provider settings forbidden response
func (o *GetProviderSettingsForbidden) Code() int {
	return 403
}

func (o *GetProviderSettingsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsForbidden %s", 403, payload)
}

func (o *GetProviderSettingsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsForbidden %s", 403, payload)
}

func (o *GetProviderSettingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetProviderSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetProviderSettingsNotFound creates a GetProviderSettingsNotFound with default headers values
func NewGetProviderSettingsNotFound() *GetProviderSettingsNotFound {
	return &GetProviderSettingsNotFound{}
}

/*
GetProviderSettingsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetProviderSettingsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get provider settings not found response has a 2xx status code
func (o *GetProviderSettingsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get provider settings not found response has a 3xx status code
func (o *GetProviderSettingsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get provider settings not found response has a 4xx status code
func (o *GetProviderSettingsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get provider settings not found response has a 5xx status code
func (o *GetProviderSettingsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get provider settings not found response a status code equal to that given
func (o *GetProviderSettingsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get provider settings not found response
func (o *GetProviderSettingsNotFound) Code() int {
	return 404
}

func (o *GetProviderSettingsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsNotFound %s", 404, payload)
}

func (o *GetProviderSettingsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings/{key}][%d] getProviderSettingsNotFound %s", 404, payload)
}

func (o *GetProviderSettingsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetProviderSettingsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
