// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetUserQuotasReader is a Reader for the GetUserQuotas structure.
type GetUserQuotasReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserQuotasReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserQuotasOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetUserQuotasUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserQuotasForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetUserQuotasNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetUserQuotasInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /user/quotas] getUserQuotas", response, response.Code())
	}
}

// NewGetUserQuotasOK creates a GetUserQuotasOK with default headers values
func NewGetUserQuotasOK() *GetUserQuotasOK {
	return &GetUserQuotasOK{}
}

/*
GetUserQuotasOK describes a response with status code 200, with default header values.

(empty)
*/
type GetUserQuotasOK struct {
	Payload []*models.QuotaDTO
}

// IsSuccess returns true when this get user quotas Ok response has a 2xx status code
func (o *GetUserQuotasOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user quotas Ok response has a 3xx status code
func (o *GetUserQuotasOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user quotas Ok response has a 4xx status code
func (o *GetUserQuotasOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user quotas Ok response has a 5xx status code
func (o *GetUserQuotasOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user quotas Ok response a status code equal to that given
func (o *GetUserQuotasOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user quotas Ok response
func (o *GetUserQuotasOK) Code() int {
	return 200
}

func (o *GetUserQuotasOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasOk %s", 200, payload)
}

func (o *GetUserQuotasOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasOk %s", 200, payload)
}

func (o *GetUserQuotasOK) GetPayload() []*models.QuotaDTO {
	return o.Payload
}

func (o *GetUserQuotasOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserQuotasUnauthorized creates a GetUserQuotasUnauthorized with default headers values
func NewGetUserQuotasUnauthorized() *GetUserQuotasUnauthorized {
	return &GetUserQuotasUnauthorized{}
}

/*
GetUserQuotasUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetUserQuotasUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user quotas unauthorized response has a 2xx status code
func (o *GetUserQuotasUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user quotas unauthorized response has a 3xx status code
func (o *GetUserQuotasUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user quotas unauthorized response has a 4xx status code
func (o *GetUserQuotasUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user quotas unauthorized response has a 5xx status code
func (o *GetUserQuotasUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get user quotas unauthorized response a status code equal to that given
func (o *GetUserQuotasUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get user quotas unauthorized response
func (o *GetUserQuotasUnauthorized) Code() int {
	return 401
}

func (o *GetUserQuotasUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasUnauthorized %s", 401, payload)
}

func (o *GetUserQuotasUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasUnauthorized %s", 401, payload)
}

func (o *GetUserQuotasUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserQuotasUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserQuotasForbidden creates a GetUserQuotasForbidden with default headers values
func NewGetUserQuotasForbidden() *GetUserQuotasForbidden {
	return &GetUserQuotasForbidden{}
}

/*
GetUserQuotasForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetUserQuotasForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user quotas forbidden response has a 2xx status code
func (o *GetUserQuotasForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user quotas forbidden response has a 3xx status code
func (o *GetUserQuotasForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user quotas forbidden response has a 4xx status code
func (o *GetUserQuotasForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user quotas forbidden response has a 5xx status code
func (o *GetUserQuotasForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user quotas forbidden response a status code equal to that given
func (o *GetUserQuotasForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user quotas forbidden response
func (o *GetUserQuotasForbidden) Code() int {
	return 403
}

func (o *GetUserQuotasForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasForbidden %s", 403, payload)
}

func (o *GetUserQuotasForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasForbidden %s", 403, payload)
}

func (o *GetUserQuotasForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserQuotasForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserQuotasNotFound creates a GetUserQuotasNotFound with default headers values
func NewGetUserQuotasNotFound() *GetUserQuotasNotFound {
	return &GetUserQuotasNotFound{}
}

/*
GetUserQuotasNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetUserQuotasNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user quotas not found response has a 2xx status code
func (o *GetUserQuotasNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user quotas not found response has a 3xx status code
func (o *GetUserQuotasNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user quotas not found response has a 4xx status code
func (o *GetUserQuotasNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user quotas not found response has a 5xx status code
func (o *GetUserQuotasNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get user quotas not found response a status code equal to that given
func (o *GetUserQuotasNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get user quotas not found response
func (o *GetUserQuotasNotFound) Code() int {
	return 404
}

func (o *GetUserQuotasNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasNotFound %s", 404, payload)
}

func (o *GetUserQuotasNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasNotFound %s", 404, payload)
}

func (o *GetUserQuotasNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserQuotasNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserQuotasInternalServerError creates a GetUserQuotasInternalServerError with default headers values
func NewGetUserQuotasInternalServerError() *GetUserQuotasInternalServerError {
	return &GetUserQuotasInternalServerError{}
}

/*
GetUserQuotasInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetUserQuotasInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user quotas internal server error response has a 2xx status code
func (o *GetUserQuotasInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user quotas internal server error response has a 3xx status code
func (o *GetUserQuotasInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user quotas internal server error response has a 4xx status code
func (o *GetUserQuotasInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user quotas internal server error response has a 5xx status code
func (o *GetUserQuotasInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get user quotas internal server error response a status code equal to that given
func (o *GetUserQuotasInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get user quotas internal server error response
func (o *GetUserQuotasInternalServerError) Code() int {
	return 500
}

func (o *GetUserQuotasInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasInternalServerError %s", 500, payload)
}

func (o *GetUserQuotasInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /user/quotas][%d] getUserQuotasInternalServerError %s", 500, payload)
}

func (o *GetUserQuotasInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserQuotasInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
