// Code generated by go-swagger; DO NOT EDIT.

package org_preferences

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new org preferences API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for org preferences API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetOrgPreferences(opts ...ClientOption) (*GetOrgPreferencesOK, error)
	GetOrgPreferencesWithParams(params *GetOrgPreferencesParams, opts ...ClientOption) (*GetOrgPreferencesOK, error)

	PatchOrgPreferences(body *models.PatchPrefsCmd, opts ...ClientOption) (*PatchOrgPreferencesOK, error)
	PatchOrgPreferencesWithParams(params *PatchOrgPreferencesParams, opts ...ClientOption) (*PatchOrgPreferencesOK, error)

	UpdateOrgPreferences(body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateOrgPreferencesOK, error)
	UpdateOrgPreferencesWithParams(params *UpdateOrgPreferencesParams, opts ...ClientOption) (*UpdateOrgPreferencesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetOrgPreferences gets current org prefs
*/
func (a *Client) GetOrgPreferences(opts ...ClientOption) (*GetOrgPreferencesOK, error) {
	params := NewGetOrgPreferencesParams()
	return a.GetOrgPreferencesWithParams(params, opts...)
}

func (a *Client) GetOrgPreferencesWithParams(params *GetOrgPreferencesParams, opts ...ClientOption) (*GetOrgPreferencesOK, error) {
	if params == nil {
		params = NewGetOrgPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getOrgPreferences",
		Method:             "GET",
		PathPattern:        "/org/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetOrgPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetOrgPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getOrgPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PatchOrgPreferences patches current org prefs
*/
func (a *Client) PatchOrgPreferences(body *models.PatchPrefsCmd, opts ...ClientOption) (*PatchOrgPreferencesOK, error) {
	params := NewPatchOrgPreferencesParams().WithBody(body)
	return a.PatchOrgPreferencesWithParams(params, opts...)
}

func (a *Client) PatchOrgPreferencesWithParams(params *PatchOrgPreferencesParams, opts ...ClientOption) (*PatchOrgPreferencesOK, error) {
	if params == nil {
		params = NewPatchOrgPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "patchOrgPreferences",
		Method:             "PATCH",
		PathPattern:        "/org/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PatchOrgPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PatchOrgPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for patchOrgPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateOrgPreferences updates current org prefs
*/
func (a *Client) UpdateOrgPreferences(body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateOrgPreferencesOK, error) {
	params := NewUpdateOrgPreferencesParams().WithBody(body)
	return a.UpdateOrgPreferencesWithParams(params, opts...)
}

func (a *Client) UpdateOrgPreferencesWithParams(params *UpdateOrgPreferencesParams, opts ...ClientOption) (*UpdateOrgPreferencesOK, error) {
	if params == nil {
		params = NewUpdateOrgPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateOrgPreferences",
		Method:             "PUT",
		PathPattern:        "/org/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateOrgPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateOrgPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateOrgPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
