// Code generated by go-swagger; DO NOT EDIT.

package org_invites

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new org invites API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for org invites API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddOrgInvite(body *models.AddInviteForm, opts ...ClientOption) (*AddOrgInviteOK, error)
	AddOrgInviteWithParams(params *AddOrgInviteParams, opts ...ClientOption) (*AddOrgInviteOK, error)

	GetPendingOrgInvites(opts ...ClientOption) (*GetPendingOrgInvitesOK, error)
	GetPendingOrgInvitesWithParams(params *GetPendingOrgInvitesParams, opts ...ClientOption) (*GetPendingOrgInvitesOK, error)

	RevokeInvite(invitationCode string, opts ...ClientOption) (*RevokeInviteOK, error)
	RevokeInviteWithParams(params *RevokeInviteParams, opts ...ClientOption) (*RevokeInviteOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddOrgInvite adds invite
*/
func (a *Client) AddOrgInvite(body *models.AddInviteForm, opts ...ClientOption) (*AddOrgInviteOK, error) {
	params := NewAddOrgInviteParams().WithBody(body)
	return a.AddOrgInviteWithParams(params, opts...)
}

func (a *Client) AddOrgInviteWithParams(params *AddOrgInviteParams, opts ...ClientOption) (*AddOrgInviteOK, error) {
	if params == nil {
		params = NewAddOrgInviteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addOrgInvite",
		Method:             "POST",
		PathPattern:        "/org/invites",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddOrgInviteReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddOrgInviteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addOrgInvite: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPendingOrgInvites gets pending invites
*/
func (a *Client) GetPendingOrgInvites(opts ...ClientOption) (*GetPendingOrgInvitesOK, error) {
	params := NewGetPendingOrgInvitesParams()
	return a.GetPendingOrgInvitesWithParams(params, opts...)
}

func (a *Client) GetPendingOrgInvitesWithParams(params *GetPendingOrgInvitesParams, opts ...ClientOption) (*GetPendingOrgInvitesOK, error) {
	if params == nil {
		params = NewGetPendingOrgInvitesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getPendingOrgInvites",
		Method:             "GET",
		PathPattern:        "/org/invites",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPendingOrgInvitesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPendingOrgInvitesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getPendingOrgInvites: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RevokeInvite revokes invite
*/
func (a *Client) RevokeInvite(invitationCode string, opts ...ClientOption) (*RevokeInviteOK, error) {
	params := NewRevokeInviteParams().WithInvitationCode(invitationCode)
	return a.RevokeInviteWithParams(params, opts...)
}

func (a *Client) RevokeInviteWithParams(params *RevokeInviteParams, opts ...ClientOption) (*RevokeInviteOK, error) {
	if params == nil {
		params = NewRevokeInviteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "revokeInvite",
		Method:             "DELETE",
		PathPattern:        "/org/invites/{invitation_code}/revoke",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RevokeInviteReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RevokeInviteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for revokeInvite: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
